/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.google.firebase.messaging.RemoteMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Utils {
    public static boolean haveVideoPlayerSupport = Utils.checkForExoPlayer();
    public static boolean haveDeprecatedFirebaseInstanceId;

    public static boolean containsIgnoreCase(Collection<String> collection, String key) {
        if (collection == null || key == null) {
            return false;
        }
        for (String entry : collection) {
            if (!key.equalsIgnoreCase(entry)) continue;
            return true;
        }
        return false;
    }

    public static HashMap<String, Object> convertBundleObjectToHashMap(@NonNull Bundle b) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String s : b.keySet()) {
            Object o = b.get(s);
            if (o instanceof Bundle) {
                map.putAll(Utils.convertBundleObjectToHashMap((Bundle)o));
                continue;
            }
            map.put(s, b.get(s));
        }
        return map;
    }

    public static ArrayList<HashMap<String, Object>> convertJSONArrayOfJSONObjectsToArrayListOfHashMaps(JSONArray jsonArray) {
        ArrayList<HashMap<String, Object>> hashMapArrayList = new ArrayList<HashMap<String, Object>>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    hashMapArrayList.add(Utils.convertJSONObjectToHashMap(jsonArray.getJSONObject(i)));
                    continue;
                }
                catch (JSONException e) {
                    Logger.v("Could not convert JSONArray of JSONObjects to ArrayList of HashMaps - " + e.getMessage());
                }
            }
        }
        return hashMapArrayList;
    }

    public static ArrayList<String> convertJSONArrayToArrayList(JSONArray array) {
        ArrayList<String> listdata = new ArrayList<String>();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                try {
                    listdata.add(array.getString(i));
                    continue;
                }
                catch (JSONException e) {
                    Logger.v("Could not convert JSONArray to ArrayList - " + e.getMessage());
                }
            }
        }
        return listdata;
    }

    public static HashMap<String, Object> convertJSONObjectToHashMap(JSONObject b) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = b.keys();
        while (keys.hasNext()) {
            try {
                String s = (String)keys.next();
                Object o = b.get(s);
                if (o instanceof JSONObject) {
                    map.putAll(Utils.convertJSONObjectToHashMap((JSONObject)o));
                    continue;
                }
                map.put(s, b.get(s));
            }
            catch (Throwable throwable) {}
        }
        return map;
    }

    public static String convertToTitleCase(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        for (char ch : text.toCharArray()) {
            if (Character.isSpaceChar(ch)) {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
        }
        return converted.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapFromURL(@NonNull String srcUrl) {
        srcUrl = srcUrl.replace("///", "/");
        srcUrl = srcUrl.replace("//", "/");
        srcUrl = srcUrl.replace("http:/", "http://");
        srcUrl = srcUrl.replace("https:/", "https://");
        HttpURLConnection connection = null;
        try {
            URL url = new URL(srcUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
            return bitmap;
        }
        catch (IOException e) {
            Logger.v("Couldn't download the notification icon. URL was: " + srcUrl);
            e.printStackTrace();
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable t) {
                Logger.v("Couldn't close connection!", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapFromURLWithSizeConstraint(String srcUrl, int size) {
        srcUrl = srcUrl.replace("///", "/");
        srcUrl = srcUrl.replace("//", "/");
        srcUrl = srcUrl.replace("http:/", "http://");
        srcUrl = srcUrl.replace("https:/", "https://");
        HttpURLConnection connection = null;
        try {
            int count;
            URL url = new URL(srcUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(true);
            connection.addRequestProperty("Accept-Encoding", "gzip, deflate");
            connection.connect();
            if (connection.getResponseCode() != 200) {
                Logger.d("File not loaded completely not going forward. URL was: " + srcUrl);
                Bitmap bitmap = null;
                return bitmap;
            }
            long fileLength = connection.getContentLength();
            boolean isGZipEncoded = connection.getContentEncoding() != null && connection.getContentEncoding().contains("gzip");
            InputStream input = connection.getInputStream();
            byte[] buffer = new byte[16384];
            ByteArrayOutputStream finalData = new ByteArrayOutputStream();
            Logger.v("Downloading " + srcUrl + "....");
            long total = 0L;
            while ((count = input.read(buffer)) != -1) {
                finalData.write(buffer, 0, count);
                if ((total += (long)count) > (long)size) {
                    Logger.v("Image size is larger than " + size + " bytes. Cancelling download!");
                    Bitmap bitmap = null;
                    return bitmap;
                }
                Logger.v("Downloaded " + total + " bytes");
            }
            byte[] tmpByteArray = new byte[16384];
            long totalDownloaded = total;
            Logger.v("Total download size for bitmap = " + totalDownloaded);
            if (isGZipEncoded) {
                int counter;
                ByteArrayInputStream is = new ByteArrayInputStream(finalData.toByteArray());
                ByteArrayOutputStream decompressedFile = new ByteArrayOutputStream();
                GZIPInputStream gzipInputStream = new GZIPInputStream(is);
                total = 0L;
                while ((counter = gzipInputStream.read(tmpByteArray)) != -1) {
                    total += (long)counter;
                    decompressedFile.write(tmpByteArray, 0, counter);
                }
                Logger.v("Total decompressed download size for bitmap = " + total);
                if (fileLength != -1L && fileLength != totalDownloaded) {
                    Logger.d("File not loaded completely not going forward. URL was: " + srcUrl);
                    Bitmap bitmap = null;
                    return bitmap;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])decompressedFile.toByteArray(), (int)0, (int)((int)total));
                return bitmap;
            }
            if (fileLength != -1L && fileLength != totalDownloaded) {
                Logger.d("File not loaded completely not going forward. URL was: " + srcUrl);
                Bitmap bitmap = null;
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])finalData.toByteArray(), (int)0, (int)((int)totalDownloaded));
            return bitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.v("Couldn't download the file. URL was: " + srcUrl);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable t) {
                Logger.v("Couldn't close connection!", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteArrayFromImageURL(String srcUrl) {
        srcUrl = srcUrl.replace("///", "/");
        srcUrl = srcUrl.replace("//", "/");
        srcUrl = srcUrl.replace("http:/", "http://");
        srcUrl = srcUrl.replace("https:/", "https://");
        HttpURLConnection connection = null;
        try {
            int bytesRead;
            URL url = new URL(srcUrl);
            connection = (HttpsURLConnection)url.openConnection();
            InputStream is = connection.getInputStream();
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            Logger.v("Error processing image bytes from url: " + srcUrl);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable t) {
                Logger.v("Couldn't close connection!", t);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getCurrentNetworkType(Context context) {
        try {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connManager == null) {
                return "Unavailable";
            }
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            if (mWifi != null && mWifi.isConnected()) {
                return "WiFi";
            }
            return Utils.getDeviceNetworkType(context);
        }
        catch (Throwable t) {
            return "Unavailable";
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceNetworkType(@NonNull Context context) {
        TelephonyManager teleMan = (TelephonyManager)context.getSystemService("phone");
        if (teleMan == null) {
            return "Unavailable";
        }
        int networkType = 0;
        if (Build.VERSION.SDK_INT >= 30) {
            if (Utils.hasPermission(context, "android.permission.READ_PHONE_STATE")) {
                try {
                    networkType = teleMan.getDataNetworkType();
                }
                catch (SecurityException se) {
                    Logger.d("Security Exception caught while fetch network type" + se.getMessage());
                }
            } else {
                Logger.d("READ_PHONE_STATE permission not asked by the app or not granted by the user");
            }
        } else {
            networkType = teleMan.getNetworkType();
        }
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: {
                return "4G";
            }
            case 20: {
                return "5G";
            }
        }
        return "Unknown";
    }

    public static long getMemoryConsumption() {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        return total - free;
    }

    public static Bitmap getNotificationBitmap(String icoPath, boolean fallbackToAppIcon, Context context) throws NullPointerException {
        return Utils.getNotificationBitmapWithSizeConstraints(icoPath, fallbackToAppIcon, context, -1);
    }

    public static Bitmap getNotificationBitmapWithSizeConstraints(String icoPath, boolean fallbackToAppIcon, Context context, int size) throws NullPointerException {
        Bitmap ic;
        if (icoPath == null || icoPath.equals("")) {
            return fallbackToAppIcon ? Utils.getAppIcon(context) : null;
        }
        if (!icoPath.startsWith("http")) {
            icoPath = "http://static.wizrocket.com/android/ico//" + icoPath;
        }
        return (ic = size == -1 ? Utils.getBitmapFromURL(icoPath) : Utils.getBitmapFromURLWithSizeConstraint(icoPath, size)) != null ? ic : (fallbackToAppIcon ? Utils.getAppIcon(context) : null);
    }

    public static Bitmap getNotificationBitmapWithTimeoutAndSize(String icoPath, boolean fallbackToAppIcon, Context context, CleverTapInstanceConfig config, long timeoutMillis, int sizeBytes) throws NullPointerException {
        Task<Bitmap> task = CTExecutorFactory.executors(config).ioTask();
        return task.submitAndGetResult("getNotificationBitmap", () -> Utils.getNotificationBitmapWithSizeConstraints(icoPath, fallbackToAppIcon, context, sizeBytes), timeoutMillis);
    }

    public static int getNow() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int getThumbnailImage(Context context, String image) {
        if (context != null) {
            return context.getResources().getIdentifier(image, "drawable", context.getPackageName());
        }
        return -1;
    }

    public static boolean hasPermission(@NonNull Context context, @NonNull String permission2) {
        try {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isActivityDead(Activity activity) {
        if (activity == null) {
            return true;
        }
        boolean isActivityDead = activity.isFinishing();
        if (Build.VERSION.SDK_INT >= 17) {
            isActivityDead = isActivityDead || activity.isDestroyed();
        }
        return isActivityDead;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isServiceAvailable(@NonNull Context context, Class clazz) {
        if (clazz == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        try {
            ServiceInfo[] services;
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 4);
            for (ServiceInfo serviceInfo : services = packageInfo.services) {
                if (!serviceInfo.name.equals(clazz.getName())) continue;
                Logger.v("Service " + serviceInfo.name + " found");
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.d("Intent Service name not found exception - " + e.getLocalizedMessage());
        }
        return false;
    }

    public static String optionalStringKey(JSONObject o, String k) throws JSONException {
        if (o.has(k) && !o.isNull(k)) {
            return o.getString(k);
        }
        return null;
    }

    public static void runOnUiThread(Runnable runnable) {
        if (runnable != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                runnable.run();
            } else {
                Handler mainHandler = new Handler(Looper.getMainLooper());
                mainHandler.post(runnable);
            }
        }
    }

    public static void setPackageNameFromResolveInfoList(Context context, Intent launchIntent) {
        List resolveInfoList = context.getPackageManager().queryIntentActivities(launchIntent, 0);
        if (resolveInfoList != null) {
            String appPackageName = context.getPackageName();
            for (ResolveInfo resolveInfo : resolveInfoList) {
                if (!appPackageName.equals(resolveInfo.activityInfo.packageName)) continue;
                launchIntent.setPackage(appPackageName);
                break;
            }
        }
    }

    public static Bundle stringToBundle(String content) throws JSONException {
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)content)) {
            JSONObject jsonObject = new JSONObject(content);
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = jsonObject.getString(key);
                bundle.putString(key, value);
            }
        }
        return bundle;
    }

    public static boolean validateCTID(String cleverTapID) {
        if (cleverTapID == null) {
            Logger.i("CLEVERTAP_USE_CUSTOM_ID has been set as 1 in AndroidManifest.xml but custom CleverTap ID passed is NULL.");
            return false;
        }
        if (cleverTapID.isEmpty()) {
            Logger.i("CLEVERTAP_USE_CUSTOM_ID has been set as 1 in AndroidManifest.xml but custom CleverTap ID passed is empty.");
            return false;
        }
        if (cleverTapID.length() > 64) {
            Logger.i("Custom CleverTap ID passed is greater than 64 characters. ");
            return false;
        }
        if (!cleverTapID.matches("[A-Za-z0-9()!:$@_-]*")) {
            Logger.i("Custom CleverTap ID cannot contain special characters apart from :,(,),_,!,@,$ and - ");
            return false;
        }
        return true;
    }

    static Bitmap drawableToBitmap(@NonNull Drawable drawable2) throws NullPointerException {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static boolean checkForExoPlayer() {
        boolean exoPlayerPresent = false;
        Class<?> className = null;
        try {
            className = Class.forName("com.google.android.exoplayer2.SimpleExoPlayer");
            className = Class.forName("com.google.android.exoplayer2.source.hls.HlsMediaSource");
            className = Class.forName("com.google.android.exoplayer2.ui.PlayerView");
            Logger.d("ExoPlayer is present");
            exoPlayerPresent = true;
        }
        catch (Throwable t) {
            Logger.d("ExoPlayer library files are missing!!!");
            Logger.d("Please add ExoPlayer dependencies to render InApp or Inbox messages playing video. For more information checkout CleverTap documentation.");
            if (className != null) {
                Logger.d("ExoPlayer classes not found " + className.getName());
            }
            Logger.d("ExoPlayer classes not found");
        }
        return exoPlayerPresent;
    }

    private static Bitmap getAppIcon(Context context) throws NullPointerException {
        try {
            Drawable logo = context.getPackageManager().getApplicationLogo(context.getApplicationInfo());
            if (logo == null) {
                throw new Exception("Logo is null");
            }
            return Utils.drawableToBitmap(logo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Utils.drawableToBitmap(context.getPackageManager().getApplicationIcon(context.getApplicationInfo()));
        }
    }

    public static String getDCDomain(String domain) {
        String[] parts = domain.split("\\.", 2);
        return parts[0] + "." + "auth" + "." + parts[1];
    }

    public static boolean isRenderFallback(RemoteMessage remoteMessage, Context context) {
        boolean renderRateKillSwitch = Boolean.parseBoolean((String)remoteMessage.getData().get("wzrk_tsr_fb"));
        boolean renderRateFallback = Boolean.parseBoolean((String)remoteMessage.getData().get("wzrk_fallback"));
        return !renderRateKillSwitch && renderRateFallback;
    }
}

