/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import android.content.Context;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.login.IdentityRepo;
import com.clevertap.android.sdk.login.IdentitySet;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;

public class ConfigurableIdentityRepo
implements IdentityRepo {
    private static final String TAG = "ConfigurableIdentityRepo";
    private IdentitySet identitySet;
    private final LoginInfoProvider infoProvider;
    private final CleverTapInstanceConfig config;
    private final ValidationResultStack validationResultStack;

    public ConfigurableIdentityRepo(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, ValidationResultStack mValidationResultStack) {
        this.config = config;
        this.infoProvider = new LoginInfoProvider(context, config, deviceInfo);
        this.validationResultStack = mValidationResultStack;
        this.loadIdentitySet();
    }

    @Override
    public IdentitySet getIdentitySet() {
        return this.identitySet;
    }

    @Override
    public boolean hasIdentity(@NonNull String Key) {
        boolean hasIdentity = this.identitySet.contains(Key);
        this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoisIdentity [Key: " + Key + " , Value: " + hasIdentity + "]");
        return hasIdentity;
    }

    void loadIdentitySet() {
        IdentitySet prefKeySet = IdentitySet.from(this.infoProvider.getCachedIdentityKeysForAccount());
        this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoPrefIdentitySet [" + prefKeySet + "]");
        IdentitySet configKeySet = IdentitySet.from(this.config.getIdentityKeys());
        this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoConfigIdentitySet [" + configKeySet + "]");
        this.handleError(prefKeySet, configKeySet);
        if (prefKeySet.isValid()) {
            this.identitySet = prefKeySet;
            this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoIdentity Set activated from Pref[" + this.identitySet + "]");
        } else if (configKeySet.isValid()) {
            this.identitySet = configKeySet;
            this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoIdentity Set activated from Config[" + this.identitySet + "]");
        } else {
            this.identitySet = IdentitySet.getDefault();
            this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoIdentity Set activated from Default[" + this.identitySet + "]");
        }
        boolean isSavedInPref = prefKeySet.isValid();
        if (!isSavedInPref) {
            String storedValue = this.identitySet.toString();
            this.infoProvider.saveIdentityKeysForAccount(storedValue);
            this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoSaving Identity Keys in Pref[" + storedValue + "]");
        }
    }

    private void handleError(IdentitySet prefKeySet, IdentitySet configKeySet) {
        if (prefKeySet.isValid() && configKeySet.isValid() && !prefKeySet.equals(configKeySet)) {
            ValidationResult error = ValidationResultFactory.create(531);
            this.validationResultStack.pushValidationResult(error);
            this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepopushing error due to mismatch [Pref:" + prefKeySet + "], [Config:" + configKeySet + "]");
        } else {
            this.config.log("ON_USER_LOGIN", "ConfigurableIdentityRepoNo error found while comparing [Pref:" + prefKeySet + "], [Config:" + configKeySet + "]");
        }
    }
}

