/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation;

import android.app.Application;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import com.clevertap.android.sdk.ActivityLifecycleCallback;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.pushnotification.CTNotificationIntentService;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationReceiver;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.pushnotification.amp.CTBackgroundIntentService;
import com.clevertap.android.sdk.pushnotification.amp.CTBackgroundJobService;
import java.util.ArrayList;
import java.util.Iterator;
import org.jacoco.agent.rt.internal_28bab1d.Offline;

public final class ManifestValidator {
    private static final String ourApplicationClassName = "com.clevertap.android.sdk.Application";
    private static transient /* synthetic */ boolean[] $jacocoData;

    public ManifestValidator() {
        boolean[] blArray = ManifestValidator.$jacocoInit();
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    public static void validate(Context context, DeviceInfo deviceInfo, PushProviders pushProviders) {
        void pushProviders2;
        void deviceInfo2;
        Context context2;
        boolean[] blArray = ManifestValidator.$jacocoInit();
        if (Utils.hasPermission(context2, "android.permission.INTERNET")) {
            blArray[1] = true;
        } else {
            blArray[2] = true;
            Logger.d("Missing Permission: android.permission.INTERNET");
            blArray[3] = true;
        }
        ManifestValidator.checkSDKVersion((DeviceInfo)deviceInfo2);
        blArray[4] = true;
        ManifestValidator.validationApplicationLifecyleCallback(context2);
        blArray[5] = true;
        ManifestValidator.checkReceiversServices(context2, (PushProviders)pushProviders2);
        blArray[6] = true;
        if (TextUtils.isEmpty((CharSequence)ManifestInfo.getInstance(context2).getFCMSenderId())) {
            blArray[7] = true;
        } else {
            blArray[8] = true;
            Logger.i("We have noticed that your app is using a custom FCM Sender ID, this feature will be DISCONTINUED from the next version of the CleverTap Android SDK. With the next release, CleverTap Android SDK will only fetch the token using the google-services.json. Please reach out to CleverTap Support for any questions.");
            blArray[9] = true;
        }
        blArray[10] = true;
    }

    /*
     * Unable to fully structure code
     */
    private static void checkApplicationClass(Context var0) {
        block4: {
            var1_1 = ManifestValidator.$jacocoInit();
            var2_2 = context.getApplicationInfo().className;
            var1_1[11] = true;
            if (appName != null) break block4;
            var1_1[12] = true;
            ** GOTO lbl10
        }
        if (appName.isEmpty()) {
            var1_1[13] = true;
lbl10:
            // 2 sources

            Logger.i("Unable to determine Application Class");
            var1_1[14] = true;
        } else if (appName.equals("com.clevertap.android.sdk.Application")) {
            var1_1[15] = true;
            Logger.i("AndroidManifest.xml uses the CleverTap Application class, be sure you have properly added the CleverTap Account ID and Token to your AndroidManifest.xml, \nor set them programmatically in the onCreate method of your custom application class prior to calling super.onCreate()");
            var1_1[16] = true;
        } else {
            Logger.i("Application Class is " + (String)appName);
            var1_1[17] = true;
        }
        var1_1[18] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkReceiversServices(Context context, PushProviders pushProviders) {
        void pushProviders2;
        Context context2;
        boolean[] blArray = ManifestValidator.$jacocoInit();
        try {
            blArray[19] = true;
            blArray[20] = true;
            ManifestValidator.validateReceiverInManifest((Application)context2.getApplicationContext(), CTPushNotificationReceiver.class.getName());
            blArray[21] = true;
            blArray[22] = true;
            blArray[23] = true;
            ManifestValidator.validateServiceInManifest((Application)context2.getApplicationContext(), CTNotificationIntentService.class.getName());
            blArray[24] = true;
            ManifestValidator.validateActivityInManifest((Application)context2.getApplicationContext(), InAppNotificationActivity.class);
            blArray[25] = true;
            ManifestValidator.validateActivityInManifest((Application)context2.getApplicationContext(), CTInboxActivity.class);
            blArray[26] = true;
            ManifestValidator.validateReceiverInManifest((Application)context2.getApplicationContext(), "com.clevertap.android.geofence.CTGeofenceReceiver");
            blArray[27] = true;
            ManifestValidator.validateReceiverInManifest((Application)context2.getApplicationContext(), "com.clevertap.android.geofence.CTLocationUpdateReceiver");
            blArray[28] = true;
            ManifestValidator.validateReceiverInManifest((Application)context2.getApplicationContext(), "com.clevertap.android.geofence.CTGeofenceBootReceiver");
            if (Build.VERSION.SDK_INT < 21) {
                blArray[29] = true;
            } else {
                blArray[30] = true;
                blArray[31] = true;
                blArray[32] = true;
                ManifestValidator.validateServiceInManifest((Application)context2.getApplicationContext(), CTBackgroundJobService.class.getName());
                blArray[33] = true;
            }
            blArray[34] = true;
            blArray[35] = true;
            ManifestValidator.validateServiceInManifest((Application)context2.getApplicationContext(), CTBackgroundIntentService.class.getName());
            blArray[36] = true;
        }
        catch (Exception exception) {
            void e;
            blArray[37] = true;
            Logger.v("Receiver/Service issue : " + e.toString());
            blArray[38] = true;
        }
        ArrayList<PushConstants.PushType> enabledPushTypes = pushProviders2.getAvailablePushTypes();
        if (enabledPushTypes == null) {
            blArray[39] = true;
            return;
        }
        Iterator<PushConstants.PushType> iterator = enabledPushTypes.iterator();
        blArray[40] = true;
        while (iterator.hasNext()) {
            PushConstants.PushType pushType = iterator.next();
            if (pushType == PushConstants.PushType.FCM) {
                try {
                    blArray[41] = true;
                    ManifestValidator.validateServiceInManifest((Application)context2.getApplicationContext(), "com.clevertap.android.sdk.pushnotification.fcm.FcmMessageListenerService");
                    blArray[42] = true;
                }
                catch (Exception exception) {
                    void e;
                    blArray[43] = true;
                    Logger.v("Receiver/Service issue : " + e.toString());
                    blArray[44] = true;
                }
                catch (Error e) {
                    void error;
                    blArray[45] = true;
                    Logger.v("FATAL : " + error.getMessage());
                    blArray[46] = true;
                }
            } else if (pushType == PushConstants.PushType.HPS) {
                try {
                    blArray[47] = true;
                    ManifestValidator.validateServiceInManifest((Application)context2.getApplicationContext(), "com.clevertap.android.hms.CTHmsMessageService");
                    blArray[48] = true;
                }
                catch (Exception error) {
                    void e;
                    blArray[49] = true;
                    Logger.v("Receiver/Service issue : " + e.toString());
                    blArray[50] = true;
                }
                catch (Error e) {
                    blArray[51] = true;
                    Logger.v("FATAL : " + error.getMessage());
                    blArray[52] = true;
                }
            } else if (pushType != PushConstants.PushType.XPS) {
                blArray[53] = true;
            } else {
                try {
                    blArray[54] = true;
                    ManifestValidator.validateReceiverInManifest((Application)context2.getApplicationContext(), "com.clevertap.android.xps.XiaomiMessageReceiver");
                    blArray[55] = true;
                }
                catch (Exception error) {
                    void e;
                    blArray[56] = true;
                    Logger.v("Receiver/Service issue : " + e.toString());
                    blArray[57] = true;
                }
                catch (Error e) {
                    blArray[58] = true;
                    Logger.v("FATAL : " + error.getMessage());
                    blArray[59] = true;
                }
            }
            blArray[60] = true;
        }
        blArray[61] = true;
    }

    private static void checkSDKVersion(DeviceInfo deviceInfo) {
        DeviceInfo deviceInfo2;
        boolean[] blArray = ManifestValidator.$jacocoInit();
        Logger.i("SDK Version Code is " + deviceInfo2.getSdkVersion());
        blArray[62] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateActivityInManifest(Application application, Class clazz) throws PackageManager.NameNotFoundException {
        void activities;
        void activityClass;
        void packageName;
        void pm;
        Application application2;
        boolean[] blArray = ManifestValidator.$jacocoInit();
        PackageManager packageManager = application2.getPackageManager();
        blArray[63] = true;
        String string = application2.getPackageName();
        blArray[64] = true;
        PackageInfo packageInfo = pm.getPackageInfo((String)packageName, 1);
        ActivityInfo[] activityInfoArray = packageInfo.activities;
        blArray[65] = true;
        String activityClassName = activityClass.getName();
        void var8_8 = activities;
        int n = ((void)var8_8).length;
        blArray[66] = true;
        for (int i = 0; i < n; ++i) {
            void activityInfo;
            void var11_11 = var8_8[i];
            blArray[67] = true;
            if (activityInfo.name.equals(activityClassName)) {
                blArray[68] = true;
                Logger.i(activityClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
                blArray[69] = true;
                return;
            }
            blArray[70] = true;
        }
        Logger.i(activityClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
        blArray[71] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateReceiverInManifest(Application application, String string) throws PackageManager.NameNotFoundException {
        void receiverClassName;
        ActivityInfo[] receivers;
        void packageName;
        void pm;
        Application application2;
        boolean[] blArray = ManifestValidator.$jacocoInit();
        PackageManager packageManager = application2.getPackageManager();
        blArray[72] = true;
        String string2 = application2.getPackageName();
        blArray[73] = true;
        PackageInfo packageInfo = pm.getPackageInfo((String)packageName, 2);
        ActivityInfo[] activityInfoArray = receivers = packageInfo.receivers;
        int n = activityInfoArray.length;
        blArray[74] = true;
        for (int i = 0; i < n; ++i) {
            void activityInfo;
            ActivityInfo activityInfo2 = activityInfoArray[i];
            blArray[75] = true;
            if (activityInfo.name.equals(receiverClassName)) {
                blArray[76] = true;
                Logger.i(receiverClassName.replaceFirst("com.clevertap.android.", "") + " is present");
                blArray[77] = true;
                return;
            }
            blArray[78] = true;
        }
        Logger.i(receiverClassName.replaceFirst("com.clevertap.android.", "") + " not present");
        blArray[79] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateServiceInManifest(Application application, String string) throws PackageManager.NameNotFoundException {
        void serviceClassName;
        ServiceInfo[] services;
        void packageName;
        void pm;
        Application application2;
        boolean[] blArray = ManifestValidator.$jacocoInit();
        PackageManager packageManager = application2.getPackageManager();
        blArray[80] = true;
        String string2 = application2.getPackageName();
        blArray[81] = true;
        PackageInfo packageInfo = pm.getPackageInfo((String)packageName, 4);
        ServiceInfo[] serviceInfoArray = services = packageInfo.services;
        int n = serviceInfoArray.length;
        blArray[82] = true;
        for (int i = 0; i < n; ++i) {
            void serviceInfo;
            ServiceInfo serviceInfo2 = serviceInfoArray[i];
            blArray[83] = true;
            if (serviceInfo.name.equals(serviceClassName)) {
                blArray[84] = true;
                Logger.i(serviceClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
                blArray[85] = true;
                return;
            }
            blArray[86] = true;
        }
        Logger.i(serviceClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
        blArray[87] = true;
    }

    private static void validationApplicationLifecyleCallback(Context context) {
        boolean[] blArray = ManifestValidator.$jacocoInit();
        if (ActivityLifecycleCallback.registered) {
            blArray[88] = true;
        } else if (CleverTapAPI.isAppForeground()) {
            blArray[89] = true;
        } else {
            Context context2;
            blArray[90] = true;
            Logger.i("Activity Lifecycle Callback not registered. Either set the android:name in your AndroidManifest.xml application tag to com.clevertap.android.sdk.Application, \n or, if you have a custom Application class, call ActivityLifecycleCallback.register(this); before super.onCreate() in your class");
            blArray[91] = true;
            ManifestValidator.checkApplicationClass(context2);
            blArray[92] = true;
        }
        blArray[93] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-8245555095331970160L, (String)"com/clevertap/android/sdk/validation/ManifestValidator", (int)94);
        }
        return blArray;
    }
}

