/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.product_config;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.BaseAnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.product_config.CTProductConfigConstants;
import com.clevertap.android.sdk.product_config.DefaultXmlParser;
import com.clevertap.android.sdk.product_config.ProductConfigSettings;
import com.clevertap.android.sdk.product_config.ProductConfigUtil;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.OnSuccessListener;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.FileUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTProductConfigController {
    final Map<String, String> activatedConfigs;
    final Map<String, String> defaultConfigs;
    AtomicBoolean isInitialized;
    final FileUtils fileUtils;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final AtomicBoolean isFetchAndActivating;
    private final BaseAnalyticsManager analyticsManager;
    private final BaseCallbackManager callbackManager;
    private final CoreMetaData coreMetaData;
    private final ProductConfigSettings settings;
    private final Map<String, String> waitingTobeActivatedConfig;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    CTProductConfigController(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, BaseAnalyticsManager baseAnalyticsManager, CoreMetaData coreMetaData, BaseCallbackManager baseCallbackManager, ProductConfigSettings productConfigSettings, FileUtils fileUtils) {
        void fileUtils2;
        void productConfigSettings2;
        void analyticsManager;
        void callbackManager;
        void coreMetaData2;
        void config;
        void context2;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[0] = true;
        this.activatedConfigs = Collections.synchronizedMap(new HashMap());
        blArray[1] = true;
        this.defaultConfigs = Collections.synchronizedMap(new HashMap());
        blArray[2] = true;
        this.isInitialized = new AtomicBoolean(false);
        blArray[3] = true;
        this.isFetchAndActivating = new AtomicBoolean(false);
        blArray[4] = true;
        blArray[5] = true;
        this.waitingTobeActivatedConfig = Collections.synchronizedMap(new HashMap());
        this.context = context2;
        this.config = config;
        this.coreMetaData = coreMetaData2;
        this.callbackManager = callbackManager;
        this.analyticsManager = analyticsManager;
        this.settings = productConfigSettings2;
        this.fileUtils = fileUtils2;
        blArray[6] = true;
        this.initAsync();
        blArray[7] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void activate() {
        void task;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            blArray[8] = true;
            return;
        }
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[9] = true;
        blArray[10] = true;
        task.addOnSuccessListener(new OnSuccessListener<Void>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void onSuccess(Void void_) {
                boolean[] blArray = 2.$jacocoInit();
                CTProductConfigController.access$300(this.this$0, PROCESSING_STATE.ACTIVATED);
                blArray[1] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-4053086725993509636L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$2", (int)3);
                }
                return blArray;
            }
        }).execute("activateProductConfigs", new Callable<Void>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public Void call() {
                boolean[] blArray = 1.$jacocoInit();
                1 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        try {
                            HashMap toWriteValues;
                            blArray[1] = true;
                            HashMap hashMap = new HashMap();
                            blArray[2] = true;
                            if (!CTProductConfigController.access$000(this.this$0).isEmpty()) {
                                blArray[3] = true;
                                toWriteValues.putAll(CTProductConfigController.access$000(this.this$0));
                                blArray[4] = true;
                                CTProductConfigController.access$000(this.this$0).clear();
                                blArray[5] = true;
                            } else {
                                toWriteValues = CTProductConfigController.access$100(this.this$0, this.this$0.getActivatedFullPath());
                                blArray[6] = true;
                            }
                            this.this$0.activatedConfigs.clear();
                            blArray[7] = true;
                            if (this.this$0.defaultConfigs.isEmpty()) {
                                blArray[8] = true;
                            } else {
                                blArray[9] = true;
                                this.this$0.activatedConfigs.putAll(this.this$0.defaultConfigs);
                                blArray[10] = true;
                            }
                            this.this$0.activatedConfigs.putAll(toWriteValues);
                            blArray[11] = true;
                            CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Activated successfully with configs: " + this.this$0.activatedConfigs);
                            blArray[12] = true;
                        }
                        catch (Exception toWriteValues) {
                            void e;
                            blArray[13] = true;
                            e.printStackTrace();
                            blArray[14] = true;
                            blArray[15] = true;
                            blArray[16] = true;
                            CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Activate failed: " + e.getLocalizedMessage());
                            blArray[17] = true;
                        }
                        blArray[18] = true;
                        return null;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4] lbl43 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[19] = true;
                        throw throwable;
                    }
                }
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)7167422454011176769L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$1", (int)21);
                }
                return blArray;
            }
        });
        blArray[11] = true;
    }

    public void fetch() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.fetch(this.settings.getNextFetchIntervalInSeconds());
        blArray[12] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void fetch(long l) {
        void minimumFetchIntervalInSeconds;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (!this.canRequest((long)minimumFetchIntervalInSeconds)) {
            blArray[13] = true;
        } else {
            blArray[14] = true;
            this.fetchProductConfig();
            blArray[15] = true;
        }
        blArray[16] = true;
    }

    public void fetchAndActivate() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.fetch();
        blArray[17] = true;
        this.isFetchAndActivating.set(true);
        blArray[18] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void fetchProductConfig() {
        void event;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        JSONObject jSONObject = new JSONObject();
        blArray[19] = true;
        JSONObject jSONObject2 = new JSONObject();
        try {
            void notif;
            blArray[20] = true;
            notif.put("t", 0);
            blArray[21] = true;
            event.put("evtName", (Object)"wzrk_fetch");
            blArray[22] = true;
            event.put("evtData", (Object)notif);
            blArray[23] = true;
        }
        catch (JSONException jSONException) {
            void e;
            blArray[24] = true;
            e.printStackTrace();
            blArray[25] = true;
        }
        this.analyticsManager.sendFetchEvent((JSONObject)event);
        blArray[26] = true;
        this.coreMetaData.setProductConfigRequested(true);
        blArray[27] = true;
        blArray[28] = true;
        this.config.getLogger().verbose(this.config.getAccountId(), "Product Config : Fetching product config");
        blArray[29] = true;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean getBoolean(String string) {
        void Key2;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (!this.isInitialized.get()) {
            blArray[30] = true;
        } else if (TextUtils.isEmpty((CharSequence)Key2)) {
            blArray[31] = true;
        } else {
            void value;
            blArray[32] = true;
            String string2 = this.activatedConfigs.get(Key2);
            blArray[33] = true;
            if (TextUtils.isEmpty((CharSequence)value)) {
                blArray[34] = true;
            } else {
                blArray[35] = true;
                blArray[36] = true;
                return Boolean.parseBoolean((String)value);
            }
        }
        blArray[37] = true;
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_BOOLEAN;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Double getDouble(String string) {
        block7: {
            void Key2;
            boolean[] blArray = CTProductConfigController.$jacocoInit();
            if (!this.isInitialized.get()) {
                blArray[38] = true;
            } else if (TextUtils.isEmpty((CharSequence)Key2)) {
                blArray[39] = true;
            } else {
                try {
                    void value;
                    blArray[40] = true;
                    String string2 = this.activatedConfigs.get(Key2);
                    blArray[41] = true;
                    if (!TextUtils.isEmpty((CharSequence)value)) {
                        blArray[42] = true;
                        blArray[43] = true;
                        return Double.parseDouble((String)value);
                    }
                }
                catch (Exception value) {
                    void e;
                    blArray[45] = true;
                    e.printStackTrace();
                    blArray[46] = true;
                    blArray[47] = true;
                    blArray[48] = true;
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Error getting Double for Key-" + (String)Key2 + " " + e.getLocalizedMessage());
                    blArray[49] = true;
                    break block7;
                }
                blArray[44] = true;
            }
        }
        blArray[50] = true;
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_DOUBLE;
    }

    public long getLastFetchTimeStampInMillis() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[51] = true;
        return this.settings.getLastFetchTimeStampInMillis();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getLong(String string) {
        block7: {
            void Key2;
            boolean[] blArray = CTProductConfigController.$jacocoInit();
            if (!this.isInitialized.get()) {
                blArray[52] = true;
            } else if (TextUtils.isEmpty((CharSequence)Key2)) {
                blArray[53] = true;
            } else {
                try {
                    void value;
                    blArray[54] = true;
                    String string2 = this.activatedConfigs.get(Key2);
                    blArray[55] = true;
                    if (!TextUtils.isEmpty((CharSequence)value)) {
                        blArray[56] = true;
                        blArray[57] = true;
                        return Long.parseLong((String)value);
                    }
                }
                catch (Exception value) {
                    void e;
                    blArray[59] = true;
                    e.printStackTrace();
                    blArray[60] = true;
                    blArray[61] = true;
                    blArray[62] = true;
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Error getting Long for Key-" + (String)Key2 + " " + e.getLocalizedMessage());
                    blArray[63] = true;
                    break block7;
                }
                blArray[58] = true;
            }
        }
        blArray[64] = true;
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_LONG;
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String string) {
        void Key2;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (!this.isInitialized.get()) {
            blArray[65] = true;
        } else if (TextUtils.isEmpty((CharSequence)Key2)) {
            blArray[66] = true;
        } else {
            void value;
            blArray[67] = true;
            String string2 = this.activatedConfigs.get(Key2);
            blArray[68] = true;
            if (TextUtils.isEmpty((CharSequence)value)) {
                blArray[69] = true;
            } else {
                blArray[70] = true;
                return value;
            }
        }
        blArray[71] = true;
        return "";
    }

    public boolean isInitialized() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[72] = true;
        return this.isInitialized.get();
    }

    public void onFetchFailed() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.isFetchAndActivating.compareAndSet(true, false);
        blArray[73] = true;
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Fetch Failed");
        blArray[74] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void onFetchSuccess(JSONObject jSONObject) {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            blArray[75] = true;
            return;
        }
        CTProductConfigController cTProductConfigController = this;
        synchronized (cTProductConfigController) {
            try {
                void kvResponse;
                blArray[76] = true;
                if (kvResponse == null) {
                    blArray[77] = true;
                } else {
                    try {
                        void task;
                        blArray[78] = true;
                        this.parseFetchedResponse((JSONObject)kvResponse);
                        blArray[79] = true;
                        this.fileUtils.writeJsonToFile(this.getProductConfigDirName(), "activated.json", new JSONObject(this.waitingTobeActivatedConfig));
                        blArray[80] = true;
                        blArray[81] = true;
                        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Fetch file-[" + this.getActivatedFullPath() + "] write success: " + this.waitingTobeActivatedConfig);
                        blArray[82] = true;
                        Task task2 = CTExecutorFactory.executors(this.config).mainTask();
                        blArray[83] = true;
                        task.execute("sendPCFetchSuccessCallback", new Callable<Void>(this){
                            final /* synthetic */ CTProductConfigController this$0;
                            private static transient /* synthetic */ boolean[] $jacocoData;
                            {
                                void this$0;
                                boolean[] blArray = 3.$jacocoInit();
                                this.this$0 = this$0;
                                blArray[0] = true;
                            }

                            @Override
                            public Void call() {
                                boolean[] blArray = 3.$jacocoInit();
                                blArray[1] = true;
                                CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Product Config: fetch Success");
                                blArray[2] = true;
                                CTProductConfigController.access$300(this.this$0, PROCESSING_STATE.FETCHED);
                                blArray[3] = true;
                                return null;
                            }

                            private static /* synthetic */ boolean[] $jacocoInit() {
                                boolean[] blArray = $jacocoData;
                                if ($jacocoData == null) {
                                    blArray = $jacocoData = Offline.getProbes((long)4608110136354392790L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$3", (int)5);
                                }
                                return blArray;
                            }
                        });
                        blArray[84] = true;
                        if (!this.isFetchAndActivating.getAndSet(false)) {
                            blArray[85] = true;
                        } else {
                            blArray[86] = true;
                            this.activate();
                            blArray[87] = true;
                        }
                        blArray[88] = true;
                    }
                    catch (Exception task) {
                        void e;
                        blArray[89] = true;
                        e.printStackTrace();
                        blArray[90] = true;
                        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: fetch Failed");
                        blArray[91] = true;
                        this.sendCallback(PROCESSING_STATE.FETCHED);
                        blArray[92] = true;
                        this.isFetchAndActivating.compareAndSet(true, false);
                        blArray[93] = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl47 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[94] = true;
                throw throwable;
            }
        }
        blArray[95] = true;
    }

    public void reset() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.defaultConfigs.clear();
        blArray[96] = true;
        this.activatedConfigs.clear();
        blArray[97] = true;
        this.settings.initDefaults();
        blArray[98] = true;
        this.eraseStoredConfigFiles();
        blArray[99] = true;
    }

    public void resetSettings() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.settings.reset(this.fileUtils);
        blArray[100] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setArpValue(JSONObject jSONObject) {
        void arp;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.settings.setARPValue((JSONObject)arp);
        blArray[101] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaults(int n) {
        void resourceID;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.setDefaultsWithXmlParser((int)resourceID, new DefaultXmlParser());
        blArray[102] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaults(HashMap<String, Object> hashMap) {
        void map;
        void task;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[103] = true;
        blArray[104] = true;
        task.addOnSuccessListener(new OnSuccessListener<Void>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 5.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void onSuccess(Void void_) {
                boolean[] blArray = 5.$jacocoInit();
                this.this$0.initAsync();
                blArray[1] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)5629904801996386990L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$5", (int)3);
                }
                return blArray;
            }
        }).execute("ProductConfig#setDefaultsUsingHashMap", new Callable<Void>(this, (HashMap)map){
            final /* synthetic */ HashMap val$map;
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 4.$jacocoInit();
                this.this$0 = this$0;
                this.val$map = hashMap;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public Void call() {
                boolean[] blArray = 4.$jacocoInit();
                4 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        blArray[1] = true;
                        if (this.val$map == null) {
                            blArray[2] = true;
                        } else if (this.val$map.isEmpty()) {
                            blArray[3] = true;
                        } else {
                            blArray[4] = true;
                            Iterator iterator = this.val$map.entrySet().iterator();
                            blArray[5] = true;
                            while (true) {
                                if (!iterator.hasNext()) {
                                    blArray[6] = true;
                                    break;
                                }
                                Map.Entry entry = iterator.next();
                                if (entry == null) {
                                    blArray[7] = true;
                                } else {
                                    void key;
                                    blArray[8] = true;
                                    String string = (String)entry.getKey();
                                    blArray[9] = true;
                                    Object v = entry.getValue();
                                    try {
                                        void value;
                                        blArray[10] = true;
                                        if (TextUtils.isEmpty((CharSequence)key)) {
                                            blArray[11] = true;
                                        } else if (!ProductConfigUtil.isSupportedDataType(value)) {
                                            blArray[12] = true;
                                        } else {
                                            blArray[13] = true;
                                            this.this$0.defaultConfigs.put((String)key, String.valueOf(value));
                                            blArray[14] = true;
                                        }
                                        blArray[15] = true;
                                    }
                                    catch (Exception exception) {
                                        void e;
                                        blArray[16] = true;
                                        blArray[17] = true;
                                        blArray[18] = true;
                                        CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Product Config: setDefaults Failed for Key: " + (String)key + " with Error: " + e.getLocalizedMessage());
                                        blArray[19] = true;
                                    }
                                }
                                blArray[20] = true;
                            }
                        }
                        CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Product Config: setDefaults Completed with: " + this.this$0.defaultConfigs);
                        // MONITOREXIT @DISABLED, blocks:[0, 2] lbl50 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[21] = true;
                        return null;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4] lbl54 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[22] = true;
                        throw throwable;
                    }
                }
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)6543188475759157595L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$4", (int)24);
                }
                return blArray;
            }
        });
        blArray[105] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setGuidAndInit(String string) {
        void cleverTapID;
        block4: {
            block3: {
                block2: {
                    boolean[] blArray = CTProductConfigController.$jacocoInit();
                    if (!this.isInitialized()) break block2;
                    blArray[106] = true;
                    break block3;
                }
                if (!TextUtils.isEmpty((CharSequence)cleverTapID)) break block4;
                blArray[107] = true;
            }
            blArray[108] = true;
            return;
        }
        this.settings.setGuid((String)cleverTapID);
        blArray[109] = true;
        this.initAsync();
        blArray[110] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinimumFetchIntervalInSeconds(long l) {
        void fetchIntervalInSeconds;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        this.settings.setMinimumFetchIntervalInSeconds((long)fetchIntervalInSeconds);
        blArray[111] = true;
    }

    /*
     * WARNING - void declaration
     */
    void eraseStoredConfigFiles() {
        void task;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[112] = true;
        task.execute("eraseStoredConfigs", new Callable<Void>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 6.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public Void call() {
                boolean[] blArray = 6.$jacocoInit();
                6 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        try {
                            void dirName;
                            blArray[1] = true;
                            String string = this.this$0.getProductConfigDirName();
                            blArray[2] = true;
                            this.this$0.fileUtils.deleteDirectory((String)dirName);
                            blArray[3] = true;
                            blArray[4] = true;
                            CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Reset Deleted Dir: " + (String)dirName);
                            blArray[5] = true;
                        }
                        catch (Exception dirName) {
                            void e;
                            blArray[6] = true;
                            e.printStackTrace();
                            blArray[7] = true;
                            blArray[8] = true;
                            blArray[9] = true;
                            CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Reset failed: " + e.getLocalizedMessage());
                            blArray[10] = true;
                        }
                        blArray[11] = true;
                        return null;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4] lbl27 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[12] = true;
                        throw throwable;
                    }
                }
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)2945363249657921551L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$6", (int)14);
                }
                return blArray;
            }
        });
        blArray[113] = true;
    }

    String getActivatedFullPath() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[114] = true;
        return this.getProductConfigDirName() + "/" + "activated.json";
    }

    BaseAnalyticsManager getAnalyticsManager() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[115] = true;
        return this.analyticsManager;
    }

    BaseCallbackManager getCallbackManager() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[116] = true;
        return this.callbackManager;
    }

    CleverTapInstanceConfig getConfig() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[117] = true;
        return this.config;
    }

    CoreMetaData getCoreMetaData() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[118] = true;
        return this.coreMetaData;
    }

    String getProductConfigDirName() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[119] = true;
        return "Product_Config_" + this.config.getAccountId() + "_" + this.settings.getGuid();
    }

    public ProductConfigSettings getSettings() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[120] = true;
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    void initAsync() {
        void task;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            blArray[121] = true;
            return;
        }
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[122] = true;
        blArray[123] = true;
        task.addOnSuccessListener(new OnSuccessListener<Boolean>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 8.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void onSuccess(Boolean bl) {
                boolean[] blArray = 8.$jacocoInit();
                CTProductConfigController.access$300(this.this$0, PROCESSING_STATE.INIT);
                blArray[1] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-6428355734513330138L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$8", (int)3);
                }
                return blArray;
            }
        }).execute("ProductConfig#initAsync", new Callable<Boolean>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 7.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public Boolean call() {
                boolean[] blArray = 7.$jacocoInit();
                7 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        try {
                            void storedConfig;
                            blArray[1] = true;
                            if (this.this$0.defaultConfigs.isEmpty()) {
                                blArray[2] = true;
                            } else {
                                blArray[3] = true;
                                this.this$0.activatedConfigs.putAll(this.this$0.defaultConfigs);
                                blArray[4] = true;
                            }
                            HashMap hashMap = CTProductConfigController.access$100(this.this$0, this.this$0.getActivatedFullPath());
                            blArray[5] = true;
                            if (storedConfig.isEmpty()) {
                                blArray[6] = true;
                            } else {
                                blArray[7] = true;
                                CTProductConfigController.access$000(this.this$0).putAll(storedConfig);
                                blArray[8] = true;
                            }
                            blArray[9] = true;
                            blArray[10] = true;
                            CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Loaded configs ready to be applied: " + CTProductConfigController.access$000(this.this$0));
                            blArray[11] = true;
                            CTProductConfigController.access$400(this.this$0).loadSettings(this.this$0.fileUtils);
                            blArray[12] = true;
                            this.this$0.isInitialized.set(true);
                            blArray[13] = true;
                        }
                        catch (Exception storedConfig) {
                            void e;
                            blArray[14] = true;
                            e.printStackTrace();
                            blArray[15] = true;
                            blArray[16] = true;
                            blArray[17] = true;
                            CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "InitAsync failed - " + e.getLocalizedMessage());
                            blArray[18] = true;
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl38 : MonitorExitStatement: MONITOREXIT : var2_2
                            blArray[19] = true;
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[3, 5] lbl46 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[21] = true;
                        throw throwable;
                    }
                    // MONITOREXIT @DISABLED, blocks:[2, 3] lbl42 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[20] = true;
                    return true;
                }
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-3863219138919994890L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$7", (int)23);
                }
                return blArray;
            }
        });
        blArray[124] = true;
    }

    boolean isFetchAndActivating() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[125] = true;
        return this.isFetchAndActivating.get();
    }

    /*
     * WARNING - void declaration
     */
    void setDefaultsWithXmlParser(int n, @NonNull DefaultXmlParser defaultXmlParser) {
        void resourceID;
        void xmlParser;
        void task;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[126] = true;
        blArray[127] = true;
        task.addOnSuccessListener(new OnSuccessListener<Void>(this){
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 10.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void onSuccess(Void void_) {
                boolean[] blArray = 10.$jacocoInit();
                this.this$0.initAsync();
                blArray[1] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)2513241386776569135L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$10", (int)3);
                }
                return blArray;
            }
        }).execute("PCController#setDefaultsWithXmlParser", new Callable<Void>(this, (DefaultXmlParser)xmlParser, (int)resourceID){
            final /* synthetic */ DefaultXmlParser val$xmlParser;
            final /* synthetic */ int val$resourceID;
            final /* synthetic */ CTProductConfigController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 9.$jacocoInit();
                this.this$0 = this$0;
                this.val$xmlParser = defaultXmlParser;
                this.val$resourceID = n;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                boolean[] blArray = 9.$jacocoInit();
                9 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        blArray[1] = true;
                        this.this$0.defaultConfigs.putAll(this.val$xmlParser.getDefaultsFromXml(CTProductConfigController.access$500(this.this$0), this.val$resourceID));
                        blArray[2] = true;
                        CTProductConfigController.access$200(this.this$0).getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.access$200(this.this$0)), "Product Config: setDefaults Completed with: " + this.this$0.defaultConfigs);
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[3] = true;
                        return null;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[4] = true;
                        throw throwable;
                    }
                }
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)3484283697103268483L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$9", (int)6);
                }
                return blArray;
            }
        });
        blArray[128] = true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean canRequest(long l) {
        boolean bl;
        void minimumFetchIntervalInSeconds;
        void lastRequestTime;
        boolean bl2;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (!TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            bl2 = blArray[129] = true;
        } else {
            bl2 = false;
            blArray[130] = true;
        }
        boolean validGuid = bl2;
        if (!validGuid) {
            blArray[131] = true;
            blArray[132] = true;
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: Throttled due to empty Guid");
            blArray[133] = true;
            return false;
        }
        long l2 = this.settings.getLastFetchTimeStampInMillis();
        blArray[134] = true;
        blArray[135] = true;
        long timeDifference = System.currentTimeMillis() - lastRequestTime - TimeUnit.SECONDS.toMillis((long)minimumFetchIntervalInSeconds);
        if (timeDifference > 0L) {
            bl = blArray[136] = true;
        } else {
            bl = false;
            blArray[137] = true;
        }
        boolean isTimeExpired = bl;
        if (!isTimeExpired) {
            blArray[138] = true;
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Throttled since you made frequent request- [Last Request Time-" + new Date((long)lastRequestTime) + "], Try again in " + -timeDifference / 1000L + " seconds");
            blArray[139] = true;
            return false;
        }
        blArray[140] = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> convertServerJsonToMap(JSONObject jSONObject) {
        void map;
        JSONArray kvArray;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        HashMap hashMap = new HashMap();
        try {
            void jsonObject;
            blArray[141] = true;
            kvArray = jsonObject.getJSONArray("kv");
        }
        catch (JSONException jSONException) {
            void e;
            blArray[142] = true;
            e.printStackTrace();
            blArray[143] = true;
            blArray[144] = true;
            blArray[145] = true;
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ConvertServerJsonToMap failed - " + e.getLocalizedMessage());
            blArray[146] = true;
            return map;
        }
        if (kvArray == null) {
            blArray[147] = true;
        } else if (kvArray.length() <= 0) {
            blArray[148] = true;
        } else {
            blArray[149] = true;
            boolean e = false;
            blArray[150] = true;
            while (true) {
                void i;
                if (i >= kvArray.length()) {
                    blArray[151] = true;
                    break;
                }
                try {
                    blArray[152] = true;
                    JSONObject object = (JSONObject)kvArray.get((int)i);
                    if (object == null) {
                        blArray[153] = true;
                    } else {
                        void Key2;
                        blArray[154] = true;
                        String string = object.getString("n");
                        blArray[155] = true;
                        String string2 = object.getString("v");
                        blArray[156] = true;
                        if (TextUtils.isEmpty((CharSequence)Key2)) {
                            blArray[157] = true;
                        } else {
                            void Value;
                            blArray[158] = true;
                            map.put(Key2, Value);
                            blArray[159] = true;
                        }
                    }
                    blArray[160] = true;
                }
                catch (Exception Key2) {
                    void e2;
                    blArray[161] = true;
                    e2.printStackTrace();
                    blArray[162] = true;
                    blArray[163] = true;
                    blArray[164] = true;
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ConvertServerJsonToMap failed: " + e2.getLocalizedMessage());
                    blArray[165] = true;
                }
                ++i;
                blArray[166] = true;
            }
        }
        blArray[167] = true;
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> getStoredValues(String string) {
        void map;
        void content;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        HashMap hashMap = new HashMap();
        try {
            void fullFilePath;
            blArray[168] = true;
            String string2 = this.fileUtils.readFromFile((String)fullFilePath);
            blArray[169] = true;
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues reading file success:[ " + (String)fullFilePath + "]--[Content]" + (String)content);
        }
        catch (Exception exception) {
            void e;
            blArray[170] = true;
            e.printStackTrace();
            blArray[171] = true;
            blArray[172] = true;
            blArray[173] = true;
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues reading file failed: " + e.getLocalizedMessage());
            blArray[174] = true;
            return map;
        }
        if (TextUtils.isEmpty((CharSequence)content)) {
            blArray[175] = true;
        } else {
            JSONObject jsonObject;
            try {
                blArray[176] = true;
                jsonObject = new JSONObject((String)content);
            }
            catch (Exception exception) {
                void e;
                blArray[177] = true;
                e.printStackTrace();
                blArray[178] = true;
                blArray[179] = true;
                blArray[180] = true;
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues failed due to malformed json: " + e.getLocalizedMessage());
                blArray[181] = true;
                return map;
            }
            Iterator e = jsonObject.keys();
            blArray[182] = true;
            while (true) {
                void key;
                void iterator;
                if (!iterator.hasNext()) {
                    blArray[183] = true;
                    break;
                }
                blArray[184] = true;
                String string3 = (String)iterator.next();
                blArray[185] = true;
                if (TextUtils.isEmpty((CharSequence)key)) {
                    blArray[186] = true;
                } else {
                    String value;
                    try {
                        blArray[187] = true;
                        value = String.valueOf(jsonObject.get((String)key));
                    }
                    catch (Exception exception) {
                        void e2;
                        blArray[188] = true;
                        e2.printStackTrace();
                        blArray[189] = true;
                        blArray[190] = true;
                        blArray[191] = true;
                        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues for key " + (String)key + " while parsing json: " + e2.getLocalizedMessage());
                        blArray[192] = true;
                        continue;
                    }
                    if (TextUtils.isEmpty((CharSequence)value)) {
                        blArray[193] = true;
                    } else {
                        blArray[194] = true;
                        map.put(key, value);
                        blArray[195] = true;
                    }
                }
                blArray[196] = true;
            }
        }
        blArray[197] = true;
        return map;
    }

    private void onActivated() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (this.callbackManager.getProductConfigListener() == null) {
            blArray[198] = true;
        } else {
            blArray[199] = true;
            this.callbackManager.getProductConfigListener().onActivated();
            blArray[200] = true;
        }
        blArray[201] = true;
    }

    private void onFetched() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (this.callbackManager.getProductConfigListener() == null) {
            blArray[202] = true;
        } else {
            blArray[203] = true;
            this.callbackManager.getProductConfigListener().onFetched();
            blArray[204] = true;
        }
        blArray[205] = true;
    }

    private void onInit() {
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (this.callbackManager.getProductConfigListener() == null) {
            blArray[206] = true;
        } else {
            blArray[207] = true;
            this.config.getLogger().verbose(this.config.getAccountId(), "Product Config initialized");
            blArray[208] = true;
            this.callbackManager.getProductConfigListener().onInit();
            blArray[209] = true;
        }
        blArray[210] = true;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void parseFetchedResponse(JSONObject jSONObject) {
        Integer timestamp;
        void map;
        void jsonObject;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        HashMap<String, String> hashMap = this.convertServerJsonToMap((JSONObject)jsonObject);
        blArray[211] = true;
        this.waitingTobeActivatedConfig.clear();
        blArray[212] = true;
        this.waitingTobeActivatedConfig.putAll((Map<String, String>)map);
        blArray[213] = true;
        blArray[214] = true;
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: Fetched response:" + jsonObject);
        Object var4_4 = null;
        try {
            blArray[215] = true;
            timestamp = (Integer)jsonObject.get("ts");
            blArray[216] = true;
        }
        catch (Exception exception) {
            void e;
            blArray[217] = true;
            e.printStackTrace();
            blArray[218] = true;
            blArray[219] = true;
            blArray[220] = true;
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ParseFetchedResponse failed: " + e.getLocalizedMessage());
            blArray[221] = true;
        }
        if (timestamp == null) {
            blArray[222] = true;
        } else {
            blArray[223] = true;
            this.settings.setLastFetchTimeStampInMillis((long)timestamp.intValue() * 1000L);
            blArray[224] = true;
        }
        blArray[225] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void sendCallback(PROCESSING_STATE pROCESSING_STATE) {
        void state;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        if (state == null) {
            blArray[226] = true;
        } else {
            blArray[227] = true;
            switch (11.$SwitchMap$com$clevertap$android$sdk$product_config$CTProductConfigController$PROCESSING_STATE[state.ordinal()]) {
                default: {
                    blArray[228] = true;
                    break;
                }
                case 1: {
                    this.onInit();
                    blArray[229] = true;
                    break;
                }
                case 2: {
                    this.onFetched();
                    blArray[230] = true;
                    break;
                }
                case 3: {
                    this.onActivated();
                    blArray[231] = true;
                }
            }
        }
        blArray[232] = true;
    }

    static /* synthetic */ Map access$000(CTProductConfigController cTProductConfigController) {
        CTProductConfigController x0;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[233] = true;
        return x0.waitingTobeActivatedConfig;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HashMap access$100(CTProductConfigController cTProductConfigController, String string) {
        void x1;
        CTProductConfigController x0;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[234] = true;
        return x0.getStoredValues((String)x1);
    }

    static /* synthetic */ CleverTapInstanceConfig access$200(CTProductConfigController cTProductConfigController) {
        CTProductConfigController x0;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[235] = true;
        return x0.config;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(CTProductConfigController cTProductConfigController, PROCESSING_STATE pROCESSING_STATE) {
        void x1;
        CTProductConfigController x0;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        x0.sendCallback((PROCESSING_STATE)x1);
        blArray[236] = true;
    }

    static /* synthetic */ ProductConfigSettings access$400(CTProductConfigController cTProductConfigController) {
        CTProductConfigController x0;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[237] = true;
        return x0.settings;
    }

    static /* synthetic */ Context access$500(CTProductConfigController cTProductConfigController) {
        CTProductConfigController x0;
        boolean[] blArray = CTProductConfigController.$jacocoInit();
        blArray[238] = true;
        return x0.context;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)8419239641404769797L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController", (int)239);
        }
        return blArray;
    }

    private static final class PROCESSING_STATE
    extends Enum<PROCESSING_STATE> {
        public static final /* enum */ PROCESSING_STATE INIT;
        public static final /* enum */ PROCESSING_STATE FETCHED;
        public static final /* enum */ PROCESSING_STATE ACTIVATED;
        private static final /* synthetic */ PROCESSING_STATE[] $VALUES;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public static PROCESSING_STATE[] values() {
            boolean[] blArray = PROCESSING_STATE.$jacocoInit();
            blArray[0] = true;
            return (PROCESSING_STATE[])$VALUES.clone();
        }

        public static PROCESSING_STATE valueOf(String string) {
            String name;
            boolean[] blArray = PROCESSING_STATE.$jacocoInit();
            blArray[1] = true;
            return Enum.valueOf(PROCESSING_STATE.class, name);
        }

        private PROCESSING_STATE() {
            boolean[] blArray = PROCESSING_STATE.$jacocoInit();
            blArray[2] = true;
        }

        static {
            boolean[] blArray = PROCESSING_STATE.$jacocoInit();
            INIT = new PROCESSING_STATE();
            blArray[3] = true;
            FETCHED = new PROCESSING_STATE();
            blArray[4] = true;
            ACTIVATED = new PROCESSING_STATE();
            $VALUES = new PROCESSING_STATE[]{INIT, FETCHED, ACTIVATED};
            blArray[5] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-556684161555545515L, (String)"com/clevertap/android/sdk/product_config/CTProductConfigController$PROCESSING_STATE", (int)6);
            }
            return blArray;
        }
    }
}

