/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.QueueCursor;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.network.BaseNetworkManager;
import com.clevertap.android.sdk.network.SSLContextBuilder;
import com.clevertap.android.sdk.response.ARPResponse;
import com.clevertap.android.sdk.response.BaseResponse;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.response.CleverTapResponseHelper;
import com.clevertap.android.sdk.response.ConsoleResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.FeatureFlagResponse;
import com.clevertap.android.sdk.response.GeofenceResponse;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.response.MetadataResponse;
import com.clevertap.android.sdk.response.ProductConfigResponse;
import com.clevertap.android.sdk.response.PushAmpResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NetworkManager
extends BaseNetworkManager {
    private static SSLSocketFactory sslSocketFactory;
    private static SSLContext sslContext;
    private final BaseCallbackManager callbackManager;
    private CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private int currentRequestTimestamp;
    private final BaseDatabaseManager databaseManager;
    private final DeviceInfo deviceInfo;
    private final Logger logger;
    private int networkRetryCount;
    private final ValidationResultStack validationResultStack;
    private int responseFailureCount;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * Unable to fully structure code
     */
    public static boolean isNetworkOnline(Context var0) {
        block7: {
            block6: {
                var1_1 = NetworkManager.$jacocoInit();
                try {
                    var1_1[0] = true;
                    cm = (ConnectivityManager)context.getSystemService("connectivity");
                    if (cm != null) {
                        var1_1[1] = true;
                        break block6;
                    }
                    var1_1[2] = true;
                    return var1_1[2];
                }
                catch (Throwable ignore) {
                    var1_1[9] = true;
                    return true;
                }
            }
            var3_4 = cm.getActiveNetworkInfo();
            var1_1[3] = true;
            if (netInfo != null) break block7;
            var1_1[4] = true;
            ** GOTO lbl25
        }
        if (netInfo.isConnected()) {
            v0 = var1_1[6] = true;
        } else {
            var1_1[5] = true;
lbl25:
            // 2 sources

            v0 = false;
            var1_1[7] = true;
        }
        var1_1[8] = true;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public NetworkManager(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, DeviceInfo deviceInfo, CoreMetaData coreMetaData, ValidationResultStack validationResultStack, ControllerManager controllerManager, BaseDatabaseManager baseDatabaseManager, BaseCallbackManager baseCallbackManager, CTLockManager cTLockManager, Validator validator, LocalDataStore localDataStore) {
        void localDataStore2;
        void validator2;
        void ctLockManager;
        CleverTapResponseDecorator cleverTapResponse;
        void baseDatabaseManager2;
        void controllerManager2;
        void validationResultStack2;
        void coreMetaData2;
        void callbackManager;
        void deviceInfo2;
        void config;
        void context2;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.currentRequestTimestamp = 0;
        this.networkRetryCount = 0;
        this.responseFailureCount = 0;
        this.context = context2;
        this.config = config;
        this.deviceInfo = deviceInfo2;
        this.callbackManager = callbackManager;
        blArray[10] = true;
        this.logger = this.config.getLogger();
        this.coreMetaData = coreMetaData2;
        this.validationResultStack = validationResultStack2;
        this.controllerManager = controllerManager2;
        this.databaseManager = baseDatabaseManager2;
        blArray[11] = true;
        CleverTapResponseHelper cleverTapResponseHelper = new CleverTapResponseHelper();
        blArray[12] = true;
        cleverTapResponse = new GeofenceResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (BaseCallbackManager)callbackManager);
        blArray[13] = true;
        cleverTapResponse = new ProductConfigResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (CoreMetaData)coreMetaData2, (ControllerManager)controllerManager2);
        blArray[14] = true;
        cleverTapResponse = new FeatureFlagResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (ControllerManager)controllerManager2);
        blArray[15] = true;
        cleverTapResponse = new DisplayUnitResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (BaseCallbackManager)callbackManager, (ControllerManager)controllerManager2);
        blArray[16] = true;
        cleverTapResponse = new PushAmpResponse(cleverTapResponse, (Context)context2, (CleverTapInstanceConfig)config, (BaseDatabaseManager)baseDatabaseManager2, (BaseCallbackManager)callbackManager, (ControllerManager)controllerManager2);
        blArray[17] = true;
        cleverTapResponse = new InboxResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (CTLockManager)ctLockManager, (BaseCallbackManager)callbackManager, (ControllerManager)controllerManager2);
        blArray[18] = true;
        cleverTapResponse = new ConsoleResponse(cleverTapResponse, (CleverTapInstanceConfig)config);
        blArray[19] = true;
        cleverTapResponse = new ARPResponse(cleverTapResponse, (CleverTapInstanceConfig)config, this, (Validator)validator2, (ControllerManager)controllerManager2);
        blArray[20] = true;
        cleverTapResponse = new MetadataResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (DeviceInfo)deviceInfo2, this);
        blArray[21] = true;
        cleverTapResponse = new InAppResponse(cleverTapResponse, (CleverTapInstanceConfig)config, (ControllerManager)controllerManager2, false);
        blArray[22] = true;
        cleverTapResponse = new BaseResponse((Context)context2, (CleverTapInstanceConfig)config, (DeviceInfo)deviceInfo2, this, (LocalDataStore)localDataStore2, cleverTapResponse);
        blArray[23] = true;
        this.setCleverTapResponse(cleverTapResponse);
        blArray[24] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flushDBQueue(Context context, EventGroup eventGroup) {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[25] = true;
        this.config.getLogger().verbose(this.config.getAccountId(), "Somebody has invoked me to send the queue to CleverTap servers");
        QueueCursor previousCursor = null;
        boolean bl = true;
        blArray[26] = true;
        while (true) {
            void queue;
            void eventGroup2;
            void context2;
            boolean loadMore;
            block13: {
                block12: {
                    block11: {
                        void cursor;
                        block10: {
                            block9: {
                                block8: {
                                    if (!loadMore) {
                                        blArray[27] = true;
                                        break;
                                    }
                                    blArray[28] = true;
                                    QueueCursor queueCursor = this.databaseManager.getQueuedEvents((Context)context2, 50, previousCursor, (EventGroup)eventGroup2);
                                    blArray[29] = true;
                                    if (cursor != null) break block8;
                                    blArray[30] = true;
                                    break block9;
                                }
                                if (!cursor.isEmpty().booleanValue()) break block10;
                                blArray[31] = true;
                            }
                            this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                            blArray[32] = true;
                            break;
                        }
                        previousCursor = cursor;
                        blArray[33] = true;
                        JSONArray jSONArray = cursor.getData();
                        blArray[34] = true;
                        if (queue != null) break block11;
                        blArray[35] = true;
                        break block12;
                    }
                    if (queue.length() > 0) break block13;
                    blArray[36] = true;
                }
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                blArray[37] = true;
                break;
            }
            loadMore = this.sendQueue((Context)context2, (EventGroup)eventGroup2, (JSONArray)queue);
            blArray[38] = true;
        }
        blArray[39] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getDelayFrequency() {
        void randomGen;
        int minDelayFrequency;
        boolean[] blArray = NetworkManager.$jacocoInit();
        boolean bl = false;
        blArray[40] = true;
        this.logger.debug(this.config.getAccountId(), "Network retry #" + this.networkRetryCount);
        if (this.networkRetryCount < 10) {
            blArray[41] = true;
            this.logger.debug(this.config.getAccountId(), "Failure count is " + this.networkRetryCount + ". Setting delay frequency to 1s");
            minDelayFrequency = 1000;
            blArray[42] = true;
            return minDelayFrequency;
        }
        if (this.config.getAccountRegion() == null) {
            blArray[43] = true;
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to 1s");
            blArray[44] = true;
            return 1000;
        }
        SecureRandom secureRandom = new SecureRandom();
        blArray[45] = true;
        int randomDelay = (randomGen.nextInt(10) + 1) * 1000;
        if ((minDelayFrequency += randomDelay) < 600000) {
            blArray[46] = true;
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + minDelayFrequency);
            blArray[47] = true;
            return minDelayFrequency;
        }
        minDelayFrequency = 1000;
        blArray[48] = true;
        this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + minDelayFrequency);
        blArray[49] = true;
        return minDelayFrequency;
    }

    public String getNewNamespaceARPKey() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            blArray[50] = true;
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "New ARP Key = ARP:" + accountId + ":" + this.deviceInfo.getDeviceID());
        blArray[51] = true;
        blArray[52] = true;
        return "ARP:" + accountId + ":" + this.deviceInfo.getDeviceID();
    }

    public void incrementResponseFailureCount() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        ++this.responseFailureCount;
        blArray[53] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initHandshake(EventGroup eventGroup, Runnable runnable) {
        void handshakeSuccessCallback;
        void eventGroup2;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.responseFailureCount = 0;
        blArray[54] = true;
        this.performHandshakeForDomain(this.context, (EventGroup)eventGroup2, (Runnable)handshakeSuccessCallback);
        blArray[55] = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean needsHandshakeForDomain(EventGroup var1_1) {
        block6: {
            var2_2 = NetworkManager.$jacocoInit();
            domain = this.getDomainFromPrefsOrMetadata((EventGroup)eventGroup);
            if (this.responseFailureCount > 5) {
                v0 = var2_2[56] = true;
            } else {
                v0 = false;
                var2_2[57] = true;
            }
            needHandshakeDueToFailure = v0;
            if (!needHandshakeDueToFailure) {
                var2_2[58] = true;
            } else {
                var2_2[59] = true;
                this.setDomain(this.context, null);
                var2_2[60] = true;
            }
            if (domain != null) break block6;
            var2_2[61] = true;
            ** GOTO lbl21
        }
        if (needHandshakeDueToFailure) {
            var2_2[62] = true;
lbl21:
            // 2 sources

            v1 = var2_2[63] = true;
        } else {
            v1 = false;
            var2_2[64] = true;
        }
        var2_2[65] = true;
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"CommitPrefEdits"})
    public void setI(Context context, long l) {
        void i;
        void editor;
        void prefs;
        void context2;
        boolean[] blArray = NetworkManager.$jacocoInit();
        SharedPreferences sharedPreferences = StorageHelper.getPreferences((Context)context2, "IJ");
        blArray[66] = true;
        SharedPreferences.Editor editor2 = prefs.edit();
        blArray[67] = true;
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_i"), (long)i);
        blArray[68] = true;
        StorageHelper.persist((SharedPreferences.Editor)editor);
        blArray[69] = true;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"CommitPrefEdits"})
    public void setJ(Context context, long l) {
        void j;
        void editor;
        void prefs;
        void context2;
        boolean[] blArray = NetworkManager.$jacocoInit();
        SharedPreferences sharedPreferences = StorageHelper.getPreferences((Context)context2, "IJ");
        blArray[70] = true;
        SharedPreferences.Editor editor2 = prefs.edit();
        blArray[71] = true;
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_j"), (long)j);
        blArray[72] = true;
        StorageHelper.persist((SharedPreferences.Editor)editor);
        blArray[73] = true;
    }

    /*
     * WARNING - void declaration
     */
    HttpsURLConnection buildHttpsURLConnection(String string) throws IOException {
        void conn;
        void url;
        void endpoint;
        boolean[] blArray = NetworkManager.$jacocoInit();
        URL uRL = new URL((String)endpoint);
        blArray[74] = true;
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
        blArray[75] = true;
        conn.setConnectTimeout(10000);
        blArray[76] = true;
        conn.setReadTimeout(10000);
        blArray[77] = true;
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        blArray[78] = true;
        conn.setRequestProperty("X-CleverTap-Account-ID", this.config.getAccountId());
        blArray[79] = true;
        conn.setRequestProperty("X-CleverTap-Token", this.config.getAccountToken());
        blArray[80] = true;
        conn.setInstanceFollowRedirects(false);
        blArray[81] = true;
        if (!this.config.isSslPinningEnabled()) {
            blArray[82] = true;
        } else {
            blArray[83] = true;
            SSLContext _sslContext = NetworkManager.getSSLContext();
            if (_sslContext == null) {
                blArray[84] = true;
            } else {
                blArray[85] = true;
                conn.setSSLSocketFactory(NetworkManager.getPinnedCertsSslSocketfactory(_sslContext));
                blArray[86] = true;
            }
        }
        blArray[87] = true;
        return conn;
    }

    CleverTapResponse getCleverTapResponse() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[88] = true;
        return this.cleverTapResponse;
    }

    /*
     * WARNING - void declaration
     */
    void setCleverTapResponse(CleverTapResponse cleverTapResponse) {
        void cleverTapResponse2;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.cleverTapResponse = cleverTapResponse2;
        blArray[89] = true;
    }

    int getCurrentRequestTimestamp() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[90] = true;
        return this.currentRequestTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    void setCurrentRequestTimestamp(int n) {
        void currentRequestTimestamp;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.currentRequestTimestamp = currentRequestTimestamp;
        blArray[91] = true;
    }

    /*
     * Unable to fully structure code
     */
    String getDomain(boolean var1_1, EventGroup var2_2) {
        block8: {
            var3_3 = NetworkManager.$jacocoInit();
            var4_4 = this.getDomainFromPrefsOrMetadata((EventGroup)eventGroup);
            var3_3[92] = true;
            if (domain != null) break block8;
            var3_3[93] = true;
            ** GOTO lbl10
        }
        if (domain.trim().length() == 0) {
            var3_3[94] = true;
lbl10:
            // 2 sources

            v0 = var3_3[95] = true;
        } else {
            v0 = false;
            var3_3[96] = true;
        }
        emptyDomain = v0;
        if (!emptyDomain) {
            var3_3[97] = true;
        } else if (defaultToHandshakeURL != false) {
            var3_3[98] = true;
        } else {
            var3_3[99] = true;
            return null;
        }
        if (emptyDomain) {
            domain = "wzrkt.com/hello";
            var3_3[100] = true;
        } else {
            domain = domain + "/a1";
            var3_3[101] = true;
        }
        var3_3[102] = true;
        return domain;
    }

    /*
     * WARNING - void declaration
     */
    public String getDomainFromPrefsOrMetadata(EventGroup eventGroup) {
        void eventGroup2;
        block7: {
            void region;
            block8: {
                boolean[] blArray = NetworkManager.$jacocoInit();
                String string = this.config.getAccountRegion();
                blArray[103] = true;
                if (region == null) {
                    blArray[104] = true;
                    break block7;
                }
                if (region.trim().length() <= 0) {
                    blArray[105] = true;
                    break block7;
                }
                blArray[106] = true;
                this.setResponseFailureCount(0);
                blArray[107] = true;
                if (!eventGroup2.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED)) {
                    blArray[108] = true;
                    break block8;
                }
                blArray[109] = true;
                blArray[110] = true;
                return region.trim().toLowerCase() + eventGroup2.httpResource + "." + "wzrkt.com";
            }
            try {
                blArray[111] = true;
                return region.trim().toLowerCase() + "." + "wzrkt.com";
            }
            catch (Throwable throwable) {
                blArray[113] = true;
            }
        }
        blArray[112] = true;
        if (eventGroup2.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED)) {
            blArray[114] = true;
            blArray[115] = true;
            return StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn_spiky", null);
        }
        blArray[116] = true;
        return StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
    }

    /*
     * WARNING - void declaration
     */
    String getEndpoint(boolean bl, EventGroup eventGroup) {
        String endpoint;
        void eventGroup2;
        void defaultToHandshakeURL;
        boolean[] blArray = NetworkManager.$jacocoInit();
        String domain = this.getDomain((boolean)defaultToHandshakeURL, (EventGroup)eventGroup2);
        if (domain == null) {
            blArray[117] = true;
            this.logger.verbose(this.config.getAccountId(), "Unable to configure endpoint, domain is null");
            blArray[118] = true;
            return null;
        }
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            blArray[119] = true;
            this.logger.verbose(this.config.getAccountId(), "Unable to configure endpoint, accountID is null");
            blArray[120] = true;
            return null;
        }
        String string = "https://" + domain + "?os=Android&t=" + this.deviceInfo.getSdkVersion();
        blArray[121] = true;
        endpoint = endpoint + "&z=" + accountId;
        blArray[122] = true;
        boolean needsHandshake = this.needsHandshakeForDomain((EventGroup)eventGroup2);
        if (needsHandshake) {
            blArray[123] = true;
            return endpoint;
        }
        this.currentRequestTimestamp = (int)(System.currentTimeMillis() / 1000L);
        blArray[124] = true;
        endpoint = endpoint + "&ts=" + this.getCurrentRequestTimestamp();
        blArray[125] = true;
        return endpoint;
    }

    int getFirstRequestTimestamp() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[126] = true;
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_first_ts", 0);
    }

    int getLastRequestTimestamp() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[127] = true;
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_last_ts", 0);
    }

    /*
     * WARNING - void declaration
     */
    void setLastRequestTimestamp(int n) {
        void ts;
        boolean[] blArray = NetworkManager.$jacocoInit();
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), (int)ts);
        blArray[128] = true;
    }

    int getResponseFailureCount() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[129] = true;
        return this.responseFailureCount;
    }

    /*
     * WARNING - void declaration
     */
    void setResponseFailureCount(int n) {
        void responseFailureCount;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.responseFailureCount = responseFailureCount;
        blArray[130] = true;
    }

    /*
     * WARNING - void declaration
     */
    boolean hasDomainChanged(String string) {
        boolean bl;
        void oldDomain;
        void newDomain;
        boolean[] blArray = NetworkManager.$jacocoInit();
        String string2 = StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
        blArray[131] = true;
        if (!newDomain.equals(oldDomain)) {
            bl = blArray[132] = true;
        } else {
            bl = false;
            blArray[133] = true;
        }
        blArray[134] = true;
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    String insertHeader(Context var1_1, JSONArray var2_2) {
        block42: {
            block40: {
                var3_3 = NetworkManager.$jacocoInit();
                try {
                    block41: {
                        var4_4 = new JSONObject();
                        var3_3[135] = true;
                        var5_6 = this.deviceInfo.getDeviceID();
                        var3_3[136] = true;
                        if (deviceId != null) break block41;
                        var3_3[137] = true;
                        ** GOTO lbl18
                    }
                    if (!deviceId.equals("")) {
                        var3_3[139] = true;
                        header.put("g", (Object)deviceId);
                        var3_3[140] = true;
                    } else {
                        var3_3[138] = true;
lbl18:
                        // 2 sources

                        this.logger.verbose(this.config.getAccountId(), "CRITICAL: Couldn't finalise on a device ID! Using error device ID instead!");
                        var3_3[141] = true;
                    }
                    header.put("type", (Object)"meta");
                    var3_3[142] = true;
                    var6_7 = this.deviceInfo.getAppLaunchedFields();
                    var3_3[143] = true;
                    header.put("af", (Object)appFields);
                    var3_3[144] = true;
                    i = this.getI();
                    if (i <= 0L) {
                        var3_3[145] = true;
                    } else {
                        var3_3[146] = true;
                        header.put("_i", i);
                        var3_3[147] = true;
                    }
                    j = this.getJ();
                    if (j <= 0L) {
                        var3_3[148] = true;
                    } else {
                        var3_3[149] = true;
                        header.put("_j", j);
                        var3_3[150] = true;
                    }
                    var11_10 = this.config.getAccountId();
                    var3_3[151] = true;
                    token = this.config.getAccountToken();
                    if (accountId == null) {
                        var3_3[152] = true;
                    } else {
                        if (token != null) {
                            var3_3[153] = true;
                            break block40;
                        }
                        var3_3[154] = true;
                    }
                    var3_3[155] = true;
                    this.logger.debug(this.config.getAccountId(), "Account ID/token not found, unable to configure queue request");
                    var3_3[156] = true;
                    return null;
                }
                catch (Throwable header) {
                    var3_3[215] = true;
                    this.logger.verbose(this.config.getAccountId(), "CommsManager: Failed to attach header", (Throwable)t);
                    var3_3[216] = true;
                    var3_3[217] = true;
                    return arr.toString();
                }
            }
            header.put("id", (Object)accountId);
            var3_3[157] = true;
            header.put("tk", (Object)token);
            var3_3[158] = true;
            header.put("l_ts", this.getLastRequestTimestamp());
            var3_3[159] = true;
            header.put("f_ts", this.getFirstRequestTimestamp());
            var3_3[160] = true;
            var3_3[161] = true;
            var3_3[162] = true;
            header.put("ct_pi", (Object)IdentityRepoFactory.getRepo(this.context, this.config, this.deviceInfo, this.validationResultStack).getIdentitySet().toString());
            var3_3[163] = true;
            if (this.deviceInfo.getNotificationsEnabledForUser()) break block42;
            var3_3[164] = true;
            ** GOTO lbl90
        }
        var3_3[165] = true;
        if (!this.controllerManager.getPushProviders().isNotificationSupported()) {
            var3_3[166] = true;
lbl90:
            // 2 sources

            v0 = var3_3[167] = true;
        } else {
            v0 = false;
            var3_3[168] = true;
        }
        header.put("ddnd", v0);
        var3_3[169] = true;
        if (!this.coreMetaData.isBgPing()) {
            var3_3[170] = true;
        } else {
            var3_3[171] = true;
            header.put("bk", 1);
            var3_3[172] = true;
            this.coreMetaData.setBgPing(false);
            var3_3[173] = true;
        }
        header.put("rtl", (Object)CTJsonConverter.getRenderedTargetList(this.databaseManager.loadDBAdapter(this.context)));
        var3_3[174] = true;
        if (this.coreMetaData.isInstallReferrerDataSent()) {
            var3_3[175] = true;
        } else {
            var3_3[176] = true;
            header.put("rct", this.coreMetaData.getReferrerClickTime());
            var3_3[177] = true;
            header.put("ait", this.coreMetaData.getAppInstallTime());
            var3_3[178] = true;
        }
        header.put("frs", this.coreMetaData.isFirstRequestInSession());
        var3_3[179] = true;
        this.coreMetaData.setFirstRequestInSession(false);
        try {
            var3_3[180] = true;
            var13_12 = this.getARP();
            var3_3[181] = true;
            if (arp == null) {
                var3_3[182] = true;
            } else if (arp.length() <= 0) {
                var3_3[183] = true;
            } else {
                var3_3[184] = true;
                header.put("arp", (Object)arp);
                var3_3[185] = true;
            }
            var3_3[186] = true;
        }
        catch (Throwable arp) {
            var3_3[187] = true;
            this.logger.verbose(this.config.getAccountId(), "Failed to attach ARP", (Throwable)t);
            var3_3[188] = true;
        }
        t = new JSONObject();
        try {
            var3_3[189] = true;
            utmSource = this.coreMetaData.getSource();
            if (utmSource == null) {
                var3_3[190] = true;
            } else {
                var3_3[191] = true;
                ref.put("us", (Object)utmSource);
                var3_3[192] = true;
            }
            utmMedium = this.coreMetaData.getMedium();
            if (utmMedium == null) {
                var3_3[193] = true;
            } else {
                var3_3[194] = true;
                ref.put("um", (Object)utmMedium);
                var3_3[195] = true;
            }
            utmCampaign = this.coreMetaData.getCampaign();
            if (utmCampaign == null) {
                var3_3[196] = true;
            } else {
                var3_3[197] = true;
                ref.put("uc", (Object)utmCampaign);
                var3_3[198] = true;
            }
            if (ref.length() <= 0) {
                var3_3[199] = true;
            } else {
                var3_3[200] = true;
                header.put("ref", (Object)ref);
                var3_3[201] = true;
            }
            var3_3[202] = true;
        }
        catch (Throwable utmSource) {
            var3_3[203] = true;
            this.logger.verbose(this.config.getAccountId(), "Failed to attach ref", (Throwable)t);
            var3_3[204] = true;
        }
        t = this.coreMetaData.getWzrkParams();
        var3_3[205] = true;
        if (wzrkParams == null) {
            var3_3[206] = true;
        } else if (wzrkParams.length() <= 0) {
            var3_3[207] = true;
        } else {
            var3_3[208] = true;
            header.put("wzrk_ref", (Object)wzrkParams);
            var3_3[209] = true;
        }
        if (this.controllerManager.getInAppFCManager() != null) {
            var3_3[210] = true;
            Logger.v("Attaching InAppFC to Header");
            var3_3[211] = true;
            this.controllerManager.getInAppFCManager().attachToHeader((Context)context, (JSONObject)header);
            var3_3[212] = true;
        } else {
            this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Attaching InAppFC to Header");
            var3_3[213] = true;
        }
        var3_3[214] = true;
        return "[" + header.toString() + ", " + arr.toString().substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    void performHandshakeForDomain(Context context, EventGroup eventGroup, Runnable runnable) {
        block25: {
            HttpsURLConnection conn;
            block23: {
                void context2;
                block20: {
                    block22: {
                        block21: {
                            void eventGroup2;
                            boolean[] blArray = NetworkManager.$jacocoInit();
                            String endpoint = this.getEndpoint(true, (EventGroup)eventGroup2);
                            if (endpoint != null) {
                                blArray[218] = true;
                            } else {
                                blArray[219] = true;
                                this.logger.verbose(this.config.getAccountId(), "Unable to perform handshake, endpoint is null");
                                blArray[220] = true;
                            }
                            this.logger.verbose(this.config.getAccountId(), "Performing handshake with " + endpoint);
                            Object var6_6 = null;
                            blArray[221] = true;
                            conn = this.buildHttpsURLConnection(endpoint);
                            blArray[222] = true;
                            int responseCode = conn.getResponseCode();
                            if (responseCode == 200) {
                                blArray[223] = true;
                                break block20;
                            }
                            blArray[224] = true;
                            this.logger.verbose(this.config.getAccountId(), "Invalid HTTP status code received for handshake - " + responseCode);
                            if (conn != null) break block21;
                            blArray[225] = true;
                            break block22;
                        }
                        try {
                            blArray[226] = true;
                            conn.getInputStream().close();
                            blArray[227] = true;
                            conn.disconnect();
                            blArray[228] = true;
                        }
                        catch (Throwable throwable) {
                            blArray[229] = true;
                        }
                    }
                    blArray[230] = true;
                    return;
                }
                this.logger.verbose(this.config.getAccountId(), "Received success from handshake :)");
                blArray[231] = true;
                if (!this.processIncomingHeaders((Context)context2, conn)) {
                    blArray[232] = true;
                } else {
                    void handshakeSuccessCallback;
                    blArray[233] = true;
                    this.logger.verbose(this.config.getAccountId(), "We are not muted");
                    blArray[234] = true;
                    handshakeSuccessCallback.run();
                    blArray[235] = true;
                }
                if (conn != null) break block23;
                blArray[236] = true;
            }
            try {
                blArray[237] = true;
                conn.getInputStream().close();
                blArray[238] = true;
                conn.disconnect();
                blArray[239] = true;
            }
            catch (Throwable responseCode) {
                blArray[240] = true;
            }
            break block25;
            catch (Throwable responseCode) {
                block24: {
                    try {
                        void t;
                        blArray[241] = true;
                        this.logger.verbose(this.config.getAccountId(), "Failed to perform handshake!", (Throwable)t);
                        if (conn != null) break block24;
                        blArray[242] = true;
                    }
                    catch (Throwable throwable) {
                        if (conn == null) {
                            blArray[247] = true;
                        } else {
                            try {
                                blArray[248] = true;
                                conn.getInputStream().close();
                                blArray[249] = true;
                                conn.disconnect();
                                blArray[250] = true;
                            }
                            catch (Throwable throwable2) {
                                blArray[251] = true;
                            }
                        }
                        blArray[252] = true;
                        throw throwable;
                    }
                }
                try {
                    blArray[243] = true;
                    conn.getInputStream().close();
                    blArray[244] = true;
                    conn.disconnect();
                    blArray[245] = true;
                }
                catch (Throwable throwable) {
                    blArray[246] = true;
                }
            }
        }
        blArray[253] = true;
    }

    /*
     * WARNING - void declaration
     */
    boolean processIncomingHeaders(Context context, HttpsURLConnection httpsURLConnection) {
        void spikyDomainName;
        void domainName;
        void context2;
        void conn;
        block12: {
            block11: {
                block10: {
                    void muteCommand;
                    boolean[] blArray = NetworkManager.$jacocoInit();
                    String string = conn.getHeaderField("X-WZRK-MUTE");
                    blArray[254] = true;
                    if (muteCommand == null) {
                        blArray[255] = true;
                    } else if (muteCommand.trim().length() <= 0) {
                        blArray[256] = true;
                    } else {
                        blArray[257] = true;
                        if (muteCommand.equals("true")) {
                            blArray[258] = true;
                            this.setMuted((Context)context2, true);
                            blArray[259] = true;
                            return false;
                        }
                        this.setMuted((Context)context2, false);
                        blArray[260] = true;
                    }
                    String string2 = conn.getHeaderField("X-WZRK-RD");
                    blArray[261] = true;
                    Logger.v("Getting domain from header - " + (String)domainName);
                    blArray[262] = true;
                    if (domainName != null) break block10;
                    blArray[263] = true;
                    break block11;
                }
                if (domainName.trim().length() != 0) break block12;
                blArray[264] = true;
            }
            blArray[265] = true;
            return true;
        }
        String string = conn.getHeaderField("X-WZRK-SPIKY-RD");
        blArray[266] = true;
        Logger.v("Getting spiky domain from header - " + (String)spikyDomainName);
        blArray[267] = true;
        this.setMuted((Context)context2, false);
        blArray[268] = true;
        this.setDomain((Context)context2, (String)domainName);
        blArray[269] = true;
        Logger.v("Setting spiky domain from header as -" + (String)spikyDomainName);
        if (spikyDomainName == null) {
            blArray[270] = true;
            this.setSpikyDomain((Context)context2, (String)domainName);
            blArray[271] = true;
        } else {
            this.setSpikyDomain((Context)context2, (String)spikyDomainName);
            blArray[272] = true;
        }
        blArray[273] = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    boolean sendQueue(Context context, EventGroup eventGroup, JSONArray jSONArray) {
        boolean bl;
        void context2;
        HttpsURLConnection conn;
        block45: {
            block44: {
                block41: {
                    boolean bl2;
                    block43: {
                        block42: {
                            void newDomain;
                            String req;
                            String endpoint;
                            void queue;
                            block38: {
                                boolean bl3;
                                block40: {
                                    block39: {
                                        block35: {
                                            boolean bl4;
                                            block37: {
                                                block36: {
                                                    void eventGroup2;
                                                    block50: {
                                                        block49: {
                                                            block48: {
                                                                boolean[] blArray = NetworkManager.$jacocoInit();
                                                                if (queue != null) break block48;
                                                                blArray[274] = true;
                                                                break block49;
                                                            }
                                                            if (queue.length() > 0) break block50;
                                                            blArray[275] = true;
                                                        }
                                                        blArray[276] = true;
                                                        return false;
                                                    }
                                                    if (this.deviceInfo.getDeviceID() == null) {
                                                        blArray[277] = true;
                                                        this.logger.debug(this.config.getAccountId(), "CleverTap Id not finalized, unable to send queue");
                                                        blArray[278] = true;
                                                        return false;
                                                    }
                                                    Object var5_5 = null;
                                                    blArray[279] = true;
                                                    endpoint = this.getEndpoint(false, (EventGroup)eventGroup2);
                                                    if (endpoint != null) {
                                                        blArray[280] = true;
                                                        break block35;
                                                    }
                                                    blArray[281] = true;
                                                    this.logger.debug(this.config.getAccountId(), "Problem configuring queue endpoint, unable to send queue");
                                                    bl4 = false;
                                                    if (conn != null) break block36;
                                                    blArray[282] = true;
                                                    break block37;
                                                }
                                                try {
                                                    blArray[283] = true;
                                                    conn.getInputStream().close();
                                                    blArray[284] = true;
                                                    conn.disconnect();
                                                    blArray[285] = true;
                                                }
                                                catch (Throwable throwable) {
                                                    blArray[286] = true;
                                                }
                                            }
                                            blArray[287] = true;
                                            return bl4;
                                        }
                                        conn = this.buildHttpsURLConnection(endpoint);
                                        blArray[288] = true;
                                        req = this.insertHeader((Context)context2, (JSONArray)queue);
                                        if (req != null) {
                                            blArray[289] = true;
                                            break block38;
                                        }
                                        blArray[290] = true;
                                        this.logger.debug(this.config.getAccountId(), "Problem configuring queue request, unable to send queue");
                                        bl3 = false;
                                        if (conn != null) break block39;
                                        blArray[291] = true;
                                        break block40;
                                    }
                                    try {
                                        blArray[292] = true;
                                        conn.getInputStream().close();
                                        blArray[293] = true;
                                        conn.disconnect();
                                        blArray[294] = true;
                                    }
                                    catch (Throwable throwable) {
                                        blArray[295] = true;
                                    }
                                }
                                blArray[296] = true;
                                return bl3;
                            }
                            this.logger.debug(this.config.getAccountId(), "Send queue contains " + queue.length() + " items: " + req);
                            blArray[297] = true;
                            this.logger.debug(this.config.getAccountId(), "Sending queue to: " + endpoint);
                            blArray[298] = true;
                            conn.setDoOutput(true);
                            blArray[299] = true;
                            conn.getOutputStream().write(req.getBytes("UTF-8"));
                            blArray[300] = true;
                            int responseCode = conn.getResponseCode();
                            if (responseCode != 200) {
                                blArray[301] = true;
                                blArray[302] = true;
                                throw new IOException("Response code is not 200. It is " + responseCode);
                            }
                            String string = conn.getHeaderField("X-WZRK-RD");
                            blArray[303] = true;
                            if (newDomain == null) {
                                blArray[304] = true;
                                break block41;
                            }
                            if (newDomain.trim().length() <= 0) {
                                blArray[305] = true;
                                break block41;
                            }
                            blArray[306] = true;
                            if (!this.hasDomainChanged((String)newDomain)) {
                                blArray[307] = true;
                                break block41;
                            }
                            blArray[308] = true;
                            this.setDomain((Context)context2, (String)newDomain);
                            blArray[309] = true;
                            this.logger.debug(this.config.getAccountId(), "The domain has changed to " + (String)newDomain + ". The request will be retried shortly.");
                            bl2 = false;
                            if (conn != null) break block42;
                            blArray[310] = true;
                            break block43;
                        }
                        try {
                            blArray[311] = true;
                            conn.getInputStream().close();
                            blArray[312] = true;
                            conn.disconnect();
                            blArray[313] = true;
                        }
                        catch (Throwable throwable) {
                            blArray[314] = true;
                        }
                    }
                    blArray[315] = true;
                    return bl2;
                }
                if (!this.processIncomingHeaders((Context)context2, conn)) {
                    blArray[316] = true;
                } else {
                    void body;
                    void sb;
                    void br;
                    String line;
                    blArray[317] = true;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                    blArray[318] = true;
                    StringBuilder stringBuilder = new StringBuilder();
                    blArray[319] = true;
                    while ((line = br.readLine()) != null) {
                        blArray[320] = true;
                        sb.append(line);
                        blArray[321] = true;
                    }
                    String string = sb.toString();
                    blArray[322] = true;
                    this.getCleverTapResponse().processResponse(null, (String)body, this.context);
                    blArray[323] = true;
                }
                this.setLastRequestTimestamp(this.getCurrentRequestTimestamp());
                blArray[324] = true;
                this.setFirstRequestTimestampIfNeeded(this.getCurrentRequestTimestamp());
                blArray[325] = true;
                this.logger.debug(this.config.getAccountId(), "Queue sent successfully");
                this.responseFailureCount = 0;
                this.networkRetryCount = 0;
                bl = true;
                if (conn != null) break block44;
                blArray[326] = true;
                break block45;
            }
            try {
                blArray[327] = true;
                conn.getInputStream().close();
                blArray[328] = true;
                conn.disconnect();
                blArray[329] = true;
            }
            catch (Throwable throwable) {
                blArray[330] = true;
            }
        }
        blArray[331] = true;
        return bl;
        catch (Throwable endpoint) {
            boolean bl5;
            block47: {
                block46: {
                    try {
                        void e;
                        blArray[332] = true;
                        this.logger.debug(this.config.getAccountId(), "An exception occurred while sending the queue, will retry: ", (Throwable)e);
                        ++this.responseFailureCount;
                        ++this.networkRetryCount;
                        blArray[333] = true;
                        this.callbackManager.getFailureFlushListener().failureFlush((Context)context2);
                        bl5 = false;
                        if (conn != null) break block46;
                        blArray[334] = true;
                        break block47;
                    }
                    catch (Throwable throwable) {
                        if (conn == null) {
                            blArray[340] = true;
                        } else {
                            try {
                                blArray[341] = true;
                                conn.getInputStream().close();
                                blArray[342] = true;
                                conn.disconnect();
                                blArray[343] = true;
                            }
                            catch (Throwable throwable2) {
                                blArray[344] = true;
                            }
                        }
                        blArray[345] = true;
                        throw throwable;
                    }
                }
                try {
                    blArray[335] = true;
                    conn.getInputStream().close();
                    blArray[336] = true;
                    conn.disconnect();
                    blArray[337] = true;
                }
                catch (Throwable throwable) {
                    blArray[338] = true;
                }
            }
            blArray[339] = true;
            return bl5;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDomain(Context context, String string) {
        void context2;
        void domainName;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.logger.verbose(this.config.getAccountId(), "Setting domain to " + (String)domainName);
        blArray[346] = true;
        StorageHelper.putString((Context)context2, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn"), (String)domainName);
        blArray[347] = true;
        if (this.callbackManager.getDCDomainCallback() == null) {
            blArray[348] = true;
        } else if (domainName != null) {
            blArray[349] = true;
            this.callbackManager.getDCDomainCallback().onDCDomainAvailable(Utils.getDCDomain((String)domainName));
            blArray[350] = true;
        } else {
            this.callbackManager.getDCDomainCallback().onDCDomainUnavailable();
            blArray[351] = true;
        }
        blArray[352] = true;
    }

    /*
     * WARNING - void declaration
     */
    void setFirstRequestTimestampIfNeeded(int n) {
        void ts;
        boolean[] blArray = NetworkManager.$jacocoInit();
        if (this.getFirstRequestTimestamp() > 0) {
            blArray[353] = true;
            return;
        }
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), (int)ts);
        blArray[354] = true;
    }

    /*
     * WARNING - void declaration
     */
    void setSpikyDomain(Context context, String string) {
        void context2;
        void spikyDomainName;
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.logger.verbose(this.config.getAccountId(), "Setting spiky domain to " + (String)spikyDomainName);
        blArray[355] = true;
        StorageHelper.putString((Context)context2, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn_spiky"), (String)spikyDomainName);
        blArray[356] = true;
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject getARP() {
        String nameSpaceKey2;
        block11: {
            boolean[] blArray = NetworkManager.$jacocoInit();
            nameSpaceKey2 = this.getNewNamespaceARPKey();
            if (nameSpaceKey2 != null) {
                blArray[357] = true;
                break block11;
            }
            blArray[358] = true;
            return null;
        }
        try {
            void ret;
            JSONObject kv;
            void iter;
            void all;
            SharedPreferences prefs;
            if (!StorageHelper.getPreferences(this.context, nameSpaceKey2).getAll().isEmpty()) {
                blArray[359] = true;
                prefs = StorageHelper.getPreferences(this.context, nameSpaceKey2);
                blArray[360] = true;
            } else {
                prefs = this.migrateARPToNewNameSpace(nameSpaceKey2, this.getNamespaceARPKey());
                blArray[361] = true;
            }
            Map map = prefs.getAll();
            blArray[362] = true;
            Iterator iterator = all.entrySet().iterator();
            blArray[363] = true;
            while (iter.hasNext()) {
                void o;
                blArray[364] = true;
                Map.Entry entry = (Map.Entry)iter.next();
                blArray[365] = true;
                Object v = kv.getValue();
                blArray[366] = true;
                if (!(o instanceof Number)) {
                    blArray[367] = true;
                } else if (((Number)o).intValue() != -1) {
                    blArray[368] = true;
                } else {
                    blArray[369] = true;
                    iter.remove();
                    blArray[370] = true;
                }
                blArray[371] = true;
            }
            kv = new JSONObject((Map)all);
            blArray[372] = true;
            blArray[373] = true;
            blArray[374] = true;
            this.logger.verbose(this.config.getAccountId(), "Fetched ARP for namespace key: " + nameSpaceKey2 + " values: " + all.toString());
            blArray[375] = true;
            return ret;
        }
        catch (Throwable nameSpaceKey2) {
            void t;
            blArray[376] = true;
            this.logger.verbose(this.config.getAccountId(), "Failed to construct ARP object", (Throwable)t);
            blArray[377] = true;
            return null;
        }
    }

    private long getI() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[378] = true;
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_i", 0, "IJ");
    }

    private long getJ() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[379] = true;
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_j", 0, "IJ");
    }

    private String getNamespaceARPKey() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            blArray[380] = true;
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "Old ARP Key = ARP:" + accountId);
        blArray[381] = true;
        blArray[382] = true;
        return "ARP:" + accountId;
    }

    /*
     * WARNING - void declaration
     */
    private SharedPreferences migrateARPToNewNameSpace(String string, String string2) {
        void editor;
        void all;
        void oldPrefs;
        void newPrefs;
        void newKey;
        void oldKey;
        boolean[] blArray = NetworkManager.$jacocoInit();
        SharedPreferences sharedPreferences = StorageHelper.getPreferences(this.context, (String)oldKey);
        blArray[383] = true;
        SharedPreferences sharedPreferences2 = StorageHelper.getPreferences(this.context, (String)newKey);
        blArray[384] = true;
        SharedPreferences.Editor editor2 = newPrefs.edit();
        blArray[385] = true;
        Map map = oldPrefs.getAll();
        blArray[386] = true;
        Iterator iterator = all.entrySet().iterator();
        blArray[387] = true;
        while (iterator.hasNext()) {
            void kv;
            Map.Entry entry = iterator.next();
            blArray[388] = true;
            Object o = kv.getValue();
            if (o instanceof Number) {
                void update;
                blArray[389] = true;
                int n = ((Number)o).intValue();
                blArray[390] = true;
                editor.putInt((String)kv.getKey(), (int)update);
                blArray[391] = true;
            } else if (o instanceof String) {
                blArray[392] = true;
                if (((String)o).length() < 100) {
                    blArray[393] = true;
                    editor.putString((String)kv.getKey(), (String)o);
                    blArray[394] = true;
                } else {
                    blArray[395] = true;
                    blArray[396] = true;
                    this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (string value too long)");
                    blArray[397] = true;
                }
            } else if (o instanceof Boolean) {
                blArray[398] = true;
                editor.putBoolean((String)kv.getKey(), ((Boolean)o).booleanValue());
                blArray[399] = true;
            } else {
                blArray[400] = true;
                blArray[401] = true;
                this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (invalid data type)");
                blArray[402] = true;
            }
            blArray[403] = true;
        }
        this.logger.verbose(this.config.getAccountId(), "Completed ARP update for namespace key: " + (String)newKey + "");
        blArray[404] = true;
        StorageHelper.persist((SharedPreferences.Editor)editor);
        blArray[405] = true;
        oldPrefs.edit().clear().apply();
        blArray[406] = true;
        return newPrefs;
    }

    /*
     * WARNING - void declaration
     */
    private void setMuted(Context context, boolean bl) {
        void context2;
        void mute;
        boolean[] blArray = NetworkManager.$jacocoInit();
        if (mute != false) {
            void task;
            void now;
            blArray[407] = true;
            int n = (int)(System.currentTimeMillis() / 1000L);
            blArray[408] = true;
            StorageHelper.putInt((Context)context2, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), (int)now);
            blArray[409] = true;
            this.setDomain((Context)context2, null);
            blArray[410] = true;
            Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            blArray[411] = true;
            task.execute("CommsManager#setMuted", new Callable<Void>(this, (Context)context2){
                final /* synthetic */ Context val$context;
                final /* synthetic */ NetworkManager this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 1.$jacocoInit();
                    this.this$0 = this$0;
                    this.val$context = context;
                    blArray[0] = true;
                }

                @Override
                public Void call() {
                    boolean[] blArray = 1.$jacocoInit();
                    NetworkManager.access$000(this.this$0).clearQueues(this.val$context);
                    blArray[1] = true;
                    return null;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-6775358489690331468L, (String)"com/clevertap/android/sdk/network/NetworkManager$1", (int)3);
                    }
                    return blArray;
                }
            });
            blArray[412] = true;
        } else {
            StorageHelper.putInt((Context)context2, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), 0);
            blArray[413] = true;
        }
        blArray[414] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static SSLSocketFactory getPinnedCertsSslSocketfactory(SSLContext sSLContext) {
        SSLContext sslContext;
        boolean[] blArray = NetworkManager.$jacocoInit();
        if (sslContext == null) {
            blArray[415] = true;
            return null;
        }
        if (sslSocketFactory != null) {
            blArray[416] = true;
        } else {
            try {
                blArray[417] = true;
                sslSocketFactory = sslContext.getSocketFactory();
                blArray[418] = true;
                Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
                blArray[419] = true;
            }
            catch (Throwable throwable) {
                void e;
                blArray[420] = true;
                Logger.d("Issue in pinning SSL,", (Throwable)e);
                blArray[421] = true;
            }
        }
        blArray[422] = true;
        return sslSocketFactory;
    }

    private static synchronized SSLContext getSSLContext() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        if (sslContext != null) {
            blArray[423] = true;
        } else {
            blArray[424] = true;
            sslContext = new SSLContextBuilder().build();
            blArray[425] = true;
        }
        blArray[426] = true;
        return sslContext;
    }

    static /* synthetic */ BaseDatabaseManager access$000(NetworkManager networkManager) {
        NetworkManager x0;
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[427] = true;
        return x0.databaseManager;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-7143733442792077475L, (String)"com/clevertap/android/sdk/network/NetworkManager", (int)428);
        }
        return blArray;
    }
}

