/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.customviews.MediaPlayerRecyclerView;
import com.clevertap.android.sdk.customviews.VerticalSpaceItemDecoration;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTInboxMessageAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxListViewFragment
extends Fragment {
    CleverTapInstanceConfig config;
    boolean haveVideoPlayerSupport;
    ArrayList<CTInboxMessage> inboxMessages;
    LinearLayout linearLayout;
    MediaPlayerRecyclerView mediaRecyclerView;
    RecyclerView recyclerView;
    CTInboxStyleConfig styleConfig;
    private boolean firstTime;
    private WeakReference<InboxListener> listenerWeakReference;
    private int tabPosition;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public CTInboxListViewFragment() {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        this.haveVideoPlayerSupport = Utils.haveVideoPlayerSupport;
        blArray[0] = true;
        this.inboxMessages = new ArrayList();
        this.firstTime = true;
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onAttach(@NonNull Context context) {
        void context2;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        super.onAttach((Context)context2);
        blArray[2] = true;
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            blArray[3] = true;
        } else {
            blArray[4] = true;
            this.config = (CleverTapInstanceConfig)bundle.getParcelable("config");
            blArray[5] = true;
            this.styleConfig = (CTInboxStyleConfig)bundle.getParcelable("styleConfig");
            blArray[6] = true;
            this.tabPosition = bundle.getInt("position", -1);
            blArray[7] = true;
            String filter = bundle.getString("filter", null);
            if (!(context2 instanceof CTInboxActivity)) {
                blArray[8] = true;
            } else {
                blArray[9] = true;
                this.setListener((InboxListener)this.getActivity());
                blArray[10] = true;
            }
            CleverTapAPI cleverTapAPI = CleverTapAPI.instanceWithConfig((Context)this.getActivity(), this.config);
            if (cleverTapAPI == null) {
                blArray[11] = true;
            } else {
                ArrayList<CTInboxMessage> arrayList;
                void allMessages;
                blArray[12] = true;
                ArrayList<CTInboxMessage> arrayList2 = cleverTapAPI.getAllInboxMessages();
                blArray[13] = true;
                if (filter != null) {
                    arrayList = this.filterMessages((ArrayList<CTInboxMessage>)allMessages, filter);
                    blArray[14] = true;
                } else {
                    arrayList = allMessages;
                    blArray[15] = true;
                }
                this.inboxMessages = arrayList;
                blArray[16] = true;
            }
        }
        blArray[17] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        void linearLayoutManager;
        void noMessageView;
        void allView;
        void container;
        void inflater;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        View view = inflater.inflate(R.layout.inbox_list_view, (ViewGroup)container, false);
        blArray[18] = true;
        this.linearLayout = (LinearLayout)allView.findViewById(R.id.list_view_linear_layout);
        blArray[19] = true;
        this.linearLayout.setBackgroundColor(Color.parseColor((String)this.styleConfig.getInboxBackgroundColor()));
        blArray[20] = true;
        TextView textView = (TextView)allView.findViewById(R.id.list_view_no_message_view);
        blArray[21] = true;
        if (this.inboxMessages.size() <= 0) {
            blArray[22] = true;
            noMessageView.setVisibility(0);
            blArray[23] = true;
            noMessageView.setText((CharSequence)this.styleConfig.getNoMessageViewText());
            blArray[24] = true;
            noMessageView.setTextColor(Color.parseColor((String)this.styleConfig.getNoMessageViewTextColor()));
            blArray[25] = true;
            return allView;
        }
        noMessageView.setVisibility(8);
        blArray[26] = true;
        LinearLayoutManager linearLayoutManager2 = new LinearLayoutManager((Context)this.getActivity());
        blArray[27] = true;
        CTInboxMessageAdapter inboxMessageAdapter = new CTInboxMessageAdapter(this.inboxMessages, this);
        if (this.haveVideoPlayerSupport) {
            blArray[28] = true;
            this.mediaRecyclerView = new MediaPlayerRecyclerView((Context)this.getActivity());
            blArray[29] = true;
            this.setMediaRecyclerView(this.mediaRecyclerView);
            blArray[30] = true;
            this.mediaRecyclerView.setVisibility(0);
            blArray[31] = true;
            this.mediaRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
            blArray[32] = true;
            this.mediaRecyclerView.addItemDecoration(new VerticalSpaceItemDecoration(18));
            blArray[33] = true;
            this.mediaRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            blArray[34] = true;
            this.mediaRecyclerView.setAdapter(inboxMessageAdapter);
            blArray[35] = true;
            inboxMessageAdapter.notifyDataSetChanged();
            blArray[36] = true;
            this.linearLayout.addView((View)this.mediaRecyclerView);
            blArray[37] = true;
            if (!this.firstTime) {
                blArray[38] = true;
            } else if (!this.shouldAutoPlayOnFirstLaunch()) {
                blArray[39] = true;
            } else {
                blArray[40] = true;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this){
                    final /* synthetic */ CTInboxListViewFragment this$0;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$0;
                        boolean[] blArray = 1.$jacocoInit();
                        this.this$0 = this$0;
                        blArray[0] = true;
                    }

                    @Override
                    public void run() {
                        boolean[] blArray = 1.$jacocoInit();
                        this.this$0.mediaRecyclerView.playVideo();
                        blArray[1] = true;
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)-2813084810623033576L, (String)"com/clevertap/android/sdk/inbox/CTInboxListViewFragment$1", (int)2);
                        }
                        return blArray;
                    }
                }, 1000L);
                this.firstTime = false;
                blArray[41] = true;
            }
        } else {
            this.recyclerView = (RecyclerView)allView.findViewById(R.id.list_view_recycler_view);
            blArray[42] = true;
            this.recyclerView.setVisibility(0);
            blArray[43] = true;
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
            blArray[44] = true;
            this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new VerticalSpaceItemDecoration(18));
            blArray[45] = true;
            this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            blArray[46] = true;
            this.recyclerView.setAdapter((RecyclerView.Adapter)inboxMessageAdapter);
            blArray[47] = true;
            inboxMessageAdapter.notifyDataSetChanged();
            blArray[48] = true;
        }
        blArray[49] = true;
        return allView;
    }

    /*
     * WARNING - void declaration
     */
    public void onViewStateRestored(@Nullable Bundle bundle) {
        void savedInstanceState;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        super.onViewStateRestored((Bundle)savedInstanceState);
        if (savedInstanceState == null) {
            blArray[50] = true;
        } else {
            blArray[51] = true;
            Parcelable savedRecyclerLayoutState = savedInstanceState.getParcelable("recyclerLayoutState");
            if (this.mediaRecyclerView == null) {
                blArray[52] = true;
            } else {
                blArray[53] = true;
                if (this.mediaRecyclerView.getLayoutManager() == null) {
                    blArray[54] = true;
                } else {
                    blArray[55] = true;
                    this.mediaRecyclerView.getLayoutManager().onRestoreInstanceState(savedRecyclerLayoutState);
                    blArray[56] = true;
                }
            }
            if (this.recyclerView == null) {
                blArray[57] = true;
            } else {
                blArray[58] = true;
                if (this.recyclerView.getLayoutManager() == null) {
                    blArray[59] = true;
                } else {
                    blArray[60] = true;
                    this.recyclerView.getLayoutManager().onRestoreInstanceState(savedRecyclerLayoutState);
                    blArray[61] = true;
                }
            }
        }
        blArray[62] = true;
    }

    public void onResume() {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        super.onResume();
        if (this.mediaRecyclerView == null) {
            blArray[63] = true;
        } else {
            blArray[64] = true;
            this.mediaRecyclerView.onRestartPlayer();
            blArray[65] = true;
        }
        blArray[66] = true;
    }

    public void onPause() {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        super.onPause();
        if (this.mediaRecyclerView == null) {
            blArray[67] = true;
        } else {
            blArray[68] = true;
            this.mediaRecyclerView.onPausePlayer();
            blArray[69] = true;
        }
        blArray[70] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onSaveInstanceState(@NonNull Bundle bundle) {
        void outState;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        super.onSaveInstanceState((Bundle)outState);
        if (this.mediaRecyclerView == null) {
            blArray[71] = true;
        } else {
            blArray[72] = true;
            if (this.mediaRecyclerView.getLayoutManager() == null) {
                blArray[73] = true;
            } else {
                blArray[74] = true;
                blArray[75] = true;
                outState.putParcelable("recyclerLayoutState", this.mediaRecyclerView.getLayoutManager().onSaveInstanceState());
                blArray[76] = true;
            }
        }
        if (this.recyclerView == null) {
            blArray[77] = true;
        } else {
            blArray[78] = true;
            if (this.recyclerView.getLayoutManager() == null) {
                blArray[79] = true;
            } else {
                blArray[80] = true;
                outState.putParcelable("recyclerLayoutState", this.recyclerView.getLayoutManager().onSaveInstanceState());
                blArray[81] = true;
            }
        }
        blArray[82] = true;
    }

    public void onDestroy() {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        super.onDestroy();
        if (this.mediaRecyclerView == null) {
            blArray[83] = true;
        } else {
            blArray[84] = true;
            this.mediaRecyclerView.release();
            blArray[85] = true;
        }
        blArray[86] = true;
    }

    /*
     * WARNING - void declaration
     */
    void didClick(Bundle bundle, int n, HashMap<String, String> hashMap) {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        InboxListener listener = this.getListener();
        if (listener == null) {
            blArray[87] = true;
        } else {
            void keyValuePayload;
            void data;
            void position;
            blArray[88] = true;
            listener.messageDidClick(this.getActivity().getBaseContext(), this.inboxMessages.get((int)position), (Bundle)data, (HashMap<String, String>)keyValuePayload);
            blArray[89] = true;
        }
        blArray[90] = true;
    }

    /*
     * WARNING - void declaration
     */
    void didShow(Bundle bundle, int n) {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        InboxListener listener = this.getListener();
        if (listener == null) {
            blArray[91] = true;
        } else {
            void data;
            void position;
            blArray[92] = true;
            listener.messageDidShow(this.getActivity().getBaseContext(), this.inboxMessages.get((int)position), (Bundle)data);
            blArray[93] = true;
        }
        blArray[94] = true;
    }

    /*
     * WARNING - void declaration
     */
    void fireUrlThroughIntent(String string) {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        try {
            void intent;
            void url;
            Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)url.replace("\n", "").replace("\r", "")));
            blArray[95] = true;
            if (this.getActivity() == null) {
                blArray[96] = true;
            } else {
                blArray[97] = true;
                Utils.setPackageNameFromResolveInfoList((Context)this.getActivity(), (Intent)intent);
                blArray[98] = true;
            }
            this.startActivity((Intent)intent);
            blArray[99] = true;
        }
        catch (Throwable throwable) {
            blArray[100] = true;
        }
        blArray[101] = true;
    }

    InboxListener getListener() {
        InboxListener listener;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        Object var2_2 = null;
        try {
            blArray[102] = true;
            listener = (InboxListener)this.listenerWeakReference.get();
            blArray[103] = true;
        }
        catch (Throwable throwable) {
            blArray[104] = true;
        }
        if (listener != null) {
            blArray[105] = true;
        } else {
            blArray[106] = true;
            Logger.v("InboxListener is null for messages");
            blArray[107] = true;
        }
        blArray[108] = true;
        return listener;
    }

    /*
     * WARNING - void declaration
     */
    void setListener(InboxListener inboxListener) {
        void listener;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        this.listenerWeakReference = new WeakReference<void>(listener);
        blArray[109] = true;
    }

    MediaPlayerRecyclerView getMediaRecyclerView() {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        blArray[110] = true;
        return this.mediaRecyclerView;
    }

    /*
     * WARNING - void declaration
     */
    void setMediaRecyclerView(MediaPlayerRecyclerView mediaPlayerRecyclerView) {
        void mediaRecyclerView;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        this.mediaRecyclerView = mediaRecyclerView;
        blArray[111] = true;
    }

    /*
     * Unable to fully structure code
     */
    void handleClick(int var1_1, String var2_2, JSONObject var3_3, HashMap<String, String> var4_4) {
        block19: {
            block20: {
                var5_5 = CTInboxListViewFragment.$jacocoInit();
                var6_6 = new Bundle();
                var5_5[112] = true;
                var7_8 = this.inboxMessages.get((int)position).getWzrkParams();
                var5_5[113] = true;
                var8_9 = wzrkParams.keys();
                var5_5[114] = true;
                while (iterator.hasNext()) {
                    var5_5[115] = true;
                    var9_10 = (String)iterator.next();
                    var5_5[116] = true;
                    if (!keyName.startsWith("wzrk_")) {
                        var5_5[117] = true;
                    } else {
                        var5_5[118] = true;
                        data.putString((String)keyName, wzrkParams.getString((String)keyName));
                        var5_5[119] = true;
                    }
                    var5_5[120] = true;
                }
                if (buttonText == null) {
                    var5_5[121] = true;
                } else if (buttonText.isEmpty()) {
                    var5_5[122] = true;
                } else {
                    var5_5[123] = true;
                    data.putString("wzrk_c2a", (String)buttonText);
                    var5_5[124] = true;
                }
                this.didClick((Bundle)data, (int)position, (HashMap<String, String>)keyValuePayload);
                var5_5[125] = true;
                if (keyValuePayload != null) break block20;
                var5_5[126] = true;
                ** GOTO lbl40
            }
            if (!keyValuePayload.isEmpty()) {
                v0 = var5_5[128] = true;
            } else {
                var5_5[127] = true;
lbl40:
                // 2 sources

                v0 = false;
                var5_5[129] = true;
            }
            isKVButton = v0;
            if (jsonObject == null) ** GOTO lbl67
            var5_5[130] = true;
            if (isKVButton) {
                var5_5[131] = true;
            } else {
                var5_5[132] = true;
                if (!this.inboxMessages.get((int)position).getInboxMessageContents().get(0).getLinktype((JSONObject)jsonObject).equalsIgnoreCase("copy")) {
                    var5_5[133] = true;
                    break block19;
                }
                var5_5[134] = true;
            }
            var5_5[135] = true;
            return;
        }
        try {
            block21: {
                var5_5[136] = true;
                actionUrl = this.inboxMessages.get((int)position).getInboxMessageContents().get(0).getLinkUrl((JSONObject)jsonObject);
                if (actionUrl == null) {
                    var5_5[137] = true;
                } else {
                    var5_5[138] = true;
                    this.fireUrlThroughIntent(actionUrl);
                    var5_5[139] = true;
                }
                var5_5[140] = true;
                break block21;
lbl67:
                // 1 sources

                actionUrl = this.inboxMessages.get((int)position).getInboxMessageContents().get(0).getActionUrl();
                if (actionUrl == null) {
                    var5_5[141] = true;
                } else {
                    var5_5[142] = true;
                    this.fireUrlThroughIntent(actionUrl);
                    var5_5[143] = true;
                }
            }
            var5_5[144] = true;
        }
        catch (Throwable data) {
            var5_5[145] = true;
            Logger.d("Error handling notification button click: " + t.getCause());
            var5_5[146] = true;
        }
        var5_5[147] = true;
    }

    /*
     * WARNING - void declaration
     */
    void handleViewPagerClick(int n, int n2) {
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        try {
            void actionUrl;
            void viewPagerPosition;
            void data;
            String keyName;
            void iterator;
            void wzrkParams;
            void position;
            Bundle bundle = new Bundle();
            blArray[148] = true;
            JSONObject jSONObject = this.inboxMessages.get((int)position).getWzrkParams();
            blArray[149] = true;
            Iterator iterator2 = wzrkParams.keys();
            blArray[150] = true;
            while (iterator.hasNext()) {
                blArray[151] = true;
                String string = (String)iterator.next();
                blArray[152] = true;
                if (!keyName.startsWith("wzrk_")) {
                    blArray[153] = true;
                } else {
                    blArray[154] = true;
                    data.putString(keyName, wzrkParams.getString(keyName));
                    blArray[155] = true;
                }
                blArray[156] = true;
            }
            this.didClick((Bundle)data, (int)position, null);
            blArray[157] = true;
            blArray[158] = true;
            keyName = this.inboxMessages.get((int)position).getInboxMessageContents().get((int)viewPagerPosition).getActionUrl();
            blArray[159] = true;
            this.fireUrlThroughIntent((String)actionUrl);
            blArray[160] = true;
        }
        catch (Throwable data) {
            void t;
            blArray[161] = true;
            Logger.d("Error handling notification button click: " + t.getCause());
            blArray[162] = true;
        }
        blArray[163] = true;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<CTInboxMessage> filterMessages(ArrayList<CTInboxMessage> arrayList, String string) {
        void filteredMessages;
        void messages;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        ArrayList arrayList2 = new ArrayList();
        blArray[164] = true;
        Iterator iterator = messages.iterator();
        blArray[165] = true;
        while (iterator.hasNext()) {
            void inboxMessage;
            CTInboxMessage cTInboxMessage = (CTInboxMessage)iterator.next();
            blArray[166] = true;
            if (inboxMessage.getTags() == null) {
                blArray[167] = true;
            } else if (inboxMessage.getTags().size() <= 0) {
                blArray[168] = true;
            } else {
                blArray[169] = true;
                Iterator<String> iterator2 = inboxMessage.getTags().iterator();
                blArray[170] = true;
                while (true) {
                    void filter;
                    void stringTag;
                    if (!iterator2.hasNext()) {
                        blArray[171] = true;
                        break;
                    }
                    String string2 = iterator2.next();
                    blArray[172] = true;
                    if (!stringTag.equalsIgnoreCase((String)filter)) {
                        blArray[173] = true;
                    } else {
                        blArray[174] = true;
                        filteredMessages.add(inboxMessage);
                        blArray[175] = true;
                    }
                    blArray[176] = true;
                }
            }
            blArray[177] = true;
        }
        blArray[178] = true;
        return filteredMessages;
    }

    private boolean shouldAutoPlayOnFirstLaunch() {
        boolean bl;
        boolean[] blArray = CTInboxListViewFragment.$jacocoInit();
        if (this.tabPosition <= 0) {
            bl = blArray[179] = true;
        } else {
            bl = false;
            blArray[180] = true;
        }
        blArray[181] = true;
        return bl;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)3664543209837484487L, (String)"com/clevertap/android/sdk/inbox/CTInboxListViewFragment", (int)182);
        }
        return blArray;
    }

    static interface InboxListener {
        public void messageDidClick(Context var1, CTInboxMessage var2, Bundle var3, HashMap<String, String> var4);

        public void messageDidShow(Context var1, CTInboxMessage var2, Bundle var3);
    }
}

