/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import androidx.annotation.AnyThread;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxController {
    private final DBAdapter dbAdapter;
    private ArrayList<CTMessageDAO> messages;
    private final Object messagesLock;
    private final String userId;
    private final boolean videoSupported;
    private final CTLockManager ctLockManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public CTInboxController(CleverTapInstanceConfig cleverTapInstanceConfig, String string, DBAdapter dBAdapter, CTLockManager cTLockManager, BaseCallbackManager baseCallbackManager, boolean bl) {
        void config;
        void callbackManager;
        void ctLockManager;
        void videoSupported;
        void adapter;
        void guid;
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[0] = true;
        this.messagesLock = new Object();
        this.userId = guid;
        this.dbAdapter = adapter;
        blArray[1] = true;
        this.messages = this.dbAdapter.getMessages(this.userId);
        this.videoSupported = videoSupported;
        this.ctLockManager = ctLockManager;
        this.callbackManager = callbackManager;
        this.config = config;
        blArray[2] = true;
    }

    public int count() {
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[3] = true;
        return this.getMessages().size();
    }

    /*
     * WARNING - void declaration
     */
    @AnyThread
    public void deleteInboxMessage(CTInboxMessage cTInboxMessage) {
        void message;
        void task;
        boolean[] blArray = CTInboxController.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        blArray[4] = true;
        task.execute("deleteInboxMessage", new Callable<Void>(this, (CTInboxMessage)message){
            final /* synthetic */ CTInboxMessage val$message;
            final /* synthetic */ CTInboxController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                this.val$message = cTInboxMessage;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                boolean[] blArray = 1.$jacocoInit();
                Object object = CTInboxController.access$000(this.this$0).getInboxControllerLock();
                synchronized (object) {
                    try {
                        blArray[1] = true;
                        boolean update = this.this$0._deleteMessageWithId(this.val$message.getMessageId());
                        if (!update) {
                            blArray[2] = true;
                        } else {
                            blArray[3] = true;
                            CTInboxController.access$100(this.this$0)._notifyInboxMessagesDidUpdate();
                            blArray[4] = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[5] = true;
                        throw throwable;
                    }
                }
                blArray[6] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-3694342129867216471L, (String)"com/clevertap/android/sdk/inbox/CTInboxController$1", (int)8);
                }
                return blArray;
            }
        });
        blArray[5] = true;
    }

    /*
     * WARNING - void declaration
     */
    @AnyThread
    public CTMessageDAO getMessageForId(String string) {
        void messageId;
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[6] = true;
        return this.findMessageById((String)messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public ArrayList<CTMessageDAO> getMessages() {
        boolean[] blArray = CTInboxController.$jacocoInit();
        Object object = this.messagesLock;
        synchronized (object) {
            try {
                blArray[7] = true;
                this.trimMessages();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[8] = true;
                return this.messages;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[9] = true;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @AnyThread
    public ArrayList<CTMessageDAO> getUnreadMessages() {
        boolean[] blArray = CTInboxController.$jacocoInit();
        ArrayList<CTMessageDAO> unread = new ArrayList<CTMessageDAO>();
        Object object = this.messagesLock;
        synchronized (object) {
            try {
                void messages;
                blArray[10] = true;
                ArrayList<CTMessageDAO> arrayList = this.getMessages();
                blArray[11] = true;
                Iterator iterator = messages.iterator();
                blArray[12] = true;
                while (iterator.hasNext()) {
                    void message;
                    CTMessageDAO cTMessageDAO = (CTMessageDAO)iterator.next();
                    blArray[13] = true;
                    if (message.isRead() != 0) {
                        blArray[14] = true;
                    } else {
                        blArray[15] = true;
                        unread.add((CTMessageDAO)message);
                        blArray[16] = true;
                    }
                    blArray[17] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl26 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[18] = true;
                throw throwable;
            }
        }
        blArray[19] = true;
        return unread;
    }

    /*
     * WARNING - void declaration
     */
    @AnyThread
    public void markReadInboxMessage(CTInboxMessage cTInboxMessage) {
        void message;
        void task;
        boolean[] blArray = CTInboxController.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        blArray[20] = true;
        task.execute("markReadInboxMessage", new Callable<Void>(this, (CTInboxMessage)message){
            final /* synthetic */ CTInboxMessage val$message;
            final /* synthetic */ CTInboxController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                this.val$message = cTInboxMessage;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                boolean[] blArray = 2.$jacocoInit();
                Object object = CTInboxController.access$000(this.this$0).getInboxControllerLock();
                synchronized (object) {
                    try {
                        blArray[1] = true;
                        boolean read = this.this$0._markReadForMessageWithId(this.val$message.getMessageId());
                        if (!read) {
                            blArray[2] = true;
                        } else {
                            blArray[3] = true;
                            CTInboxController.access$100(this.this$0)._notifyInboxMessagesDidUpdate();
                            blArray[4] = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[5] = true;
                        throw throwable;
                    }
                }
                blArray[6] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)3896454897275908387L, (String)"com/clevertap/android/sdk/inbox/CTInboxController$2", (int)8);
                }
                return blArray;
            }
        });
        blArray[21] = true;
    }

    @AnyThread
    public int unreadCount() {
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[22] = true;
        return this.getUnreadMessages().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    public boolean updateMessages(JSONArray jSONArray) {
        boolean haveUpdates;
        void newMessages;
        void inboxMessages;
        void i;
        boolean[] blArray = CTInboxController.$jacocoInit();
        boolean bl = false;
        blArray[23] = true;
        ArrayList arrayList = new ArrayList();
        blArray[24] = true;
        boolean bl2 = false;
        blArray[25] = true;
        while (i < inboxMessages.length()) {
            block13: {
                CTMessageDAO messageDAO2;
                block14: {
                    blArray[26] = true;
                    messageDAO2 = CTMessageDAO.initWithJSON(inboxMessages.getJSONObject((int)i), this.userId);
                    if (messageDAO2 == null) {
                        blArray[28] = true;
                        break block13;
                    }
                    blArray[27] = true;
                    if (this.videoSupported) {
                        blArray[29] = true;
                        break block14;
                    }
                    if (messageDAO2.containsVideoOrAudio()) {
                        blArray[31] = true;
                        Logger.d("Dropping inbox message containing video/audio as app does not support video. For more information checkout CleverTap documentation.");
                        blArray[32] = true;
                        break block13;
                    }
                    blArray[30] = true;
                }
                try {
                    newMessages.add(messageDAO2);
                    blArray[33] = true;
                    Logger.v("Inbox Message for message id - " + messageDAO2.getId() + " added");
                    blArray[34] = true;
                }
                catch (JSONException messageDAO2) {
                    void e;
                    blArray[35] = true;
                    Logger.d("Unable to update notification inbox messages - " + e.getLocalizedMessage());
                    blArray[36] = true;
                }
            }
            ++i;
            blArray[37] = true;
        }
        if (newMessages.size() <= 0) {
            blArray[38] = true;
        } else {
            blArray[39] = true;
            this.dbAdapter.upsertMessages((ArrayList<CTMessageDAO>)newMessages);
            haveUpdates = true;
            blArray[40] = true;
            Logger.v("New Notification Inbox messages added");
            Object object = this.messagesLock;
            synchronized (object) {
                try {
                    blArray[41] = true;
                    this.messages = this.dbAdapter.getMessages(this.userId);
                    blArray[42] = true;
                    this.trimMessages();
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 8] lbl55 : MonitorExitStatement: MONITOREXIT : var5_6
                    blArray[43] = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 8] lbl59 : MonitorExitStatement: MONITOREXIT : var5_6
                    blArray[44] = true;
                    throw throwable;
                }
            }
        }
        blArray[45] = true;
        return haveUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @AnyThread
    boolean _deleteMessageWithId(String string) {
        void task;
        void messageId;
        boolean[] blArray = CTInboxController.$jacocoInit();
        CTMessageDAO messageDAO = this.findMessageById((String)messageId);
        if (messageDAO == null) {
            blArray[46] = true;
            return false;
        }
        Task task2 = this.messagesLock;
        synchronized (task2) {
            try {
                blArray[47] = true;
                this.messages.remove(messageDAO);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                blArray[48] = true;
                throw throwable;
            }
        }
        task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        blArray[49] = true;
        task.execute("RunDeleteMessage", new Callable<Void>(this, (String)messageId){
            final /* synthetic */ String val$messageId;
            final /* synthetic */ CTInboxController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 3.$jacocoInit();
                this.this$0 = this$0;
                this.val$messageId = string;
                blArray[0] = true;
            }

            @Override
            @WorkerThread
            public Void call() {
                boolean[] blArray = 3.$jacocoInit();
                CTInboxController.access$300(this.this$0).deleteMessageForId(this.val$messageId, CTInboxController.access$200(this.this$0));
                blArray[1] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-419978236292307936L, (String)"com/clevertap/android/sdk/inbox/CTInboxController$3", (int)3);
                }
                return blArray;
            }
        });
        blArray[50] = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @AnyThread
    boolean _markReadForMessageWithId(String string) {
        void task;
        void messageId;
        boolean[] blArray = CTInboxController.$jacocoInit();
        CTMessageDAO messageDAO = this.findMessageById((String)messageId);
        if (messageDAO == null) {
            blArray[51] = true;
            return false;
        }
        Task task2 = this.messagesLock;
        synchronized (task2) {
            try {
                blArray[52] = true;
                messageDAO.setRead(1);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                blArray[53] = true;
                throw throwable;
            }
        }
        task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        blArray[54] = true;
        task.execute("RunMarkMessageRead", new Callable<Void>(this, (String)messageId){
            final /* synthetic */ String val$messageId;
            final /* synthetic */ CTInboxController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 4.$jacocoInit();
                this.this$0 = this$0;
                this.val$messageId = string;
                blArray[0] = true;
            }

            @Override
            @WorkerThread
            public Void call() {
                boolean[] blArray = 4.$jacocoInit();
                CTInboxController.access$300(this.this$0).markReadMessageForId(this.val$messageId, CTInboxController.access$200(this.this$0));
                blArray[1] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-4356036573472099940L, (String)"com/clevertap/android/sdk/inbox/CTInboxController$4", (int)3);
                }
                return blArray;
            }
        });
        blArray[55] = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AnyThread
    private CTMessageDAO findMessageById(String string) {
        void id2;
        boolean[] blArray = CTInboxController.$jacocoInit();
        Object object = this.messagesLock;
        synchronized (object) {
            try {
                blArray[56] = true;
                Iterator<CTMessageDAO> iterator = this.messages.iterator();
                blArray[57] = true;
                while (iterator.hasNext()) {
                    void message;
                    CTMessageDAO cTMessageDAO = iterator.next();
                    blArray[58] = true;
                    if (message.getId().equals(id2)) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                        blArray[60] = true;
                        return message;
                    }
                    blArray[59] = true;
                    blArray[61] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[62] = true;
                throw throwable;
            }
        }
        Logger.v("Inbox Message for message id - " + (String)id2 + " not found");
        blArray[63] = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @AnyThread
    private void trimMessages() {
        var1_1 = CTInboxController.$jacocoInit();
        toDelete = new ArrayList<CTMessageDAO>();
        var3_3 = this.messagesLock;
        synchronized (var3_3) {
            var1_1[64] = true;
            var4_4 = this.messages.iterator();
            var1_1[65] = true;
            while (var4_4.hasNext()) {
                block15: {
                    var5_5 = var4_4.next();
                    var1_1[66] = true;
                    if (this.videoSupported) {
                        var1_1[67] = true;
                    } else if (!message.containsVideoOrAudio()) {
                        var1_1[68] = true;
                    } else {
                        var1_1[69] = true;
                        Logger.d("Removing inbox message containing video/audio as app does not support video. For more information checkout CleverTap documentation.");
                        var1_1[70] = true;
                        toDelete.add(message);
                        var1_1[71] = true;
                        continue;
                    }
                    var6_6 = message.getExpires();
                    var1_1[72] = true;
                    if (expires > 0L) break block15;
                    var1_1[73] = true;
                    ** GOTO lbl35
                }
                if (System.currentTimeMillis() / 1000L > expires) {
                    v0 = var1_1[75] = true;
                } else {
                    var1_1[74] = true;
lbl35:
                    // 2 sources

                    v0 = false;
                    var1_1[76] = true;
                }
                expired = v0;
                if (!expired) {
                    var1_1[77] = true;
                } else {
                    var1_1[78] = true;
                    Logger.v("Inbox Message: " + message.getId() + " is expired - removing");
                    var1_1[79] = true;
                    toDelete.add(message);
                    var1_1[80] = true;
                }
                var1_1[81] = true;
            }
            if (toDelete.size() <= 0) {
                // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl49 : MonitorExitStatement: MONITOREXIT : var3_3
                var1_1[83] = true;
                return;
            }
            var1_1[82] = true;
            try {
                var4_4 = toDelete.iterator();
                var1_1[84] = true;
                while (var4_4.hasNext()) {
                    message = var4_4.next();
                    var1_1[85] = true;
                    this._deleteMessageWithId(message.getId());
                    var1_1[86] = true;
                }
            }
            catch (Throwable var9_8) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl66 : MonitorExitStatement: MONITOREXIT : var3_3
                var1_1[87] = true;
                throw var9_8;
            }
        }
        var1_1[88] = true;
    }

    static /* synthetic */ CTLockManager access$000(CTInboxController cTInboxController) {
        CTInboxController x0;
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[89] = true;
        return x0.ctLockManager;
    }

    static /* synthetic */ BaseCallbackManager access$100(CTInboxController cTInboxController) {
        CTInboxController x0;
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[90] = true;
        return x0.callbackManager;
    }

    static /* synthetic */ String access$200(CTInboxController cTInboxController) {
        CTInboxController x0;
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[91] = true;
        return x0.userId;
    }

    static /* synthetic */ DBAdapter access$300(CTInboxController cTInboxController) {
        CTInboxController x0;
        boolean[] blArray = CTInboxController.$jacocoInit();
        blArray[92] = true;
        return x0.dbAdapter;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)130124677473116633L, (String)"com/clevertap/android/sdk/inbox/CTInboxController", (int)93);
        }
        return blArray;
    }
}

