/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.CTInAppBasePartialFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlFooterFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlHeaderFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeFooterFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHeaderFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.MainLooperHandler;
import com.clevertap.android.sdk.task.Task;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONObject;

public class InAppController
implements CTInAppNotification.CTInAppNotificationListener,
InAppListener {
    private static CTInAppNotification currentlyDisplayingInApp;
    private static final List<CTInAppNotification> pendingNotifications;
    private final AnalyticsManager analyticsManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private InAppState inAppState;
    private HashSet<String> inappActivityExclude;
    private final Logger logger;
    private final MainLooperHandler mainLooperHandler;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public InAppController(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, MainLooperHandler mainLooperHandler, ControllerManager controllerManager, BaseCallbackManager baseCallbackManager, AnalyticsManager analyticsManager, CoreMetaData coreMetaData) {
        void coreMetaData2;
        void analyticsManager2;
        void callbackManager;
        void controllerManager2;
        void mainLooperHandler2;
        void config;
        void context2;
        boolean[] blArray = InAppController.$jacocoInit();
        this.inappActivityExclude = null;
        this.context = context2;
        this.config = config;
        blArray[0] = true;
        this.logger = this.config.getLogger();
        this.mainLooperHandler = mainLooperHandler2;
        this.controllerManager = controllerManager2;
        this.callbackManager = callbackManager;
        this.analyticsManager = analyticsManager2;
        this.coreMetaData = coreMetaData2;
        this.inAppState = InAppState.RESUMED;
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void checkExistingInAppNotifications(Activity activity) {
        boolean[] blArray = InAppController.$jacocoInit();
        boolean canShow = this.canShowInAppOnActivity();
        if (!canShow) {
            blArray[2] = true;
        } else {
            blArray[3] = true;
            if (currentlyDisplayingInApp == null) {
                blArray[4] = true;
            } else {
                blArray[5] = true;
                if (System.currentTimeMillis() / 1000L >= currentlyDisplayingInApp.getTimeToLive()) {
                    blArray[6] = true;
                } else {
                    void inAppFragment;
                    void activity2;
                    blArray[7] = true;
                    blArray[8] = true;
                    Fragment fragment = ((FragmentActivity)activity2).getSupportFragmentManager().getFragment(new Bundle(), currentlyDisplayingInApp.getType());
                    blArray[9] = true;
                    if (CoreMetaData.getCurrentActivity() == null) {
                        blArray[10] = true;
                    } else if (inAppFragment == null) {
                        blArray[11] = true;
                    } else {
                        void fragmentTransaction;
                        void bundle;
                        blArray[12] = true;
                        blArray[13] = true;
                        FragmentTransaction fragmentTransaction2 = ((FragmentActivity)activity2).getSupportFragmentManager().beginTransaction();
                        blArray[14] = true;
                        Bundle bundle2 = new Bundle();
                        blArray[15] = true;
                        bundle.putParcelable("inApp", (Parcelable)currentlyDisplayingInApp);
                        blArray[16] = true;
                        bundle.putParcelable("config", (Parcelable)this.config);
                        blArray[17] = true;
                        inAppFragment.setArguments((Bundle)bundle);
                        blArray[18] = true;
                        fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                        blArray[19] = true;
                        fragmentTransaction.add(0x1020002, (Fragment)inAppFragment, currentlyDisplayingInApp.getType());
                        blArray[20] = true;
                        blArray[21] = true;
                        blArray[22] = true;
                        Logger.v(this.config.getAccountId(), "calling InAppFragment " + currentlyDisplayingInApp.getCampaignId());
                        blArray[23] = true;
                        fragmentTransaction.commit();
                        blArray[24] = true;
                    }
                }
            }
        }
        blArray[25] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void checkPendingInAppNotifications(Activity activity) {
        boolean[] blArray = InAppController.$jacocoInit();
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow) {
            blArray[26] = true;
            if (this.mainLooperHandler.getPendingRunnable() != null) {
                blArray[27] = true;
                this.logger.verbose(this.config.getAccountId(), "Found a pending inapp runnable. Scheduling it");
                blArray[28] = true;
                this.mainLooperHandler.postDelayed(this.mainLooperHandler.getPendingRunnable(), 200L);
                blArray[29] = true;
                this.mainLooperHandler.setPendingRunnable(null);
                blArray[30] = true;
            } else {
                this.showNotificationIfAvailable(this.context);
                blArray[31] = true;
            }
        } else {
            String string;
            void activity2;
            StringBuilder stringBuilder = new StringBuilder().append("In-app notifications will not be shown for this activity (");
            blArray[32] = true;
            if (activity2 != null) {
                string = activity2.getLocalClassName();
                blArray[33] = true;
            } else {
                string = "";
                blArray[34] = true;
            }
            blArray[35] = true;
            Logger.d(stringBuilder.append(string).append(")").toString());
            blArray[36] = true;
        }
        blArray[37] = true;
    }

    public void discardInApps() {
        boolean[] blArray = InAppController.$jacocoInit();
        this.inAppState = InAppState.DISCARDED;
        blArray[38] = true;
        this.logger.verbose(this.config.getAccountId(), "InAppState is DISCARDED");
        blArray[39] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inAppNotificationDidClick(CTInAppNotification cTInAppNotification, Bundle bundle, HashMap<String, String> hashMap) {
        void keyValueMap;
        void formData;
        void inAppNotification;
        boolean[] blArray = InAppController.$jacocoInit();
        this.analyticsManager.pushInAppNotificationStateEvent(true, (CTInAppNotification)inAppNotification, (Bundle)formData);
        blArray[40] = true;
        if (keyValueMap == null) {
            blArray[41] = true;
        } else if (keyValueMap.isEmpty()) {
            blArray[42] = true;
        } else {
            blArray[43] = true;
            if (this.callbackManager.getInAppNotificationButtonListener() == null) {
                blArray[44] = true;
            } else {
                blArray[45] = true;
                this.callbackManager.getInAppNotificationButtonListener().onInAppButtonClick((HashMap<String, String>)keyValueMap);
                blArray[46] = true;
            }
        }
        blArray[47] = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void inAppNotificationDidDismiss(Context var1_1, CTInAppNotification var2_2, Bundle var3_3) {
        block8: {
            var4_4 = InAppController.$jacocoInit();
            inAppNotification.didDismiss();
            var4_4[48] = true;
            if (this.controllerManager.getInAppFCManager() == null) break block8;
            var4_4[49] = true;
            this.controllerManager.getInAppFCManager().didDismiss((CTInAppNotification)inAppNotification);
            var4_4[50] = true;
            this.logger.verbose(this.config.getAccountId(), "InApp Dismissed: " + inAppNotification.getCampaignId());
            var4_4[51] = true;
            ** GOTO lbl15
        }
        this.logger.verbose(this.config.getAccountId(), "Not calling InApp Dismissed: " + inAppNotification.getCampaignId() + " because InAppFCManager is null");
        try {
            var4_4[52] = true;
lbl15:
            // 2 sources

            listener = this.callbackManager.getInAppNotificationListener();
            if (listener == null) {
                var4_4[53] = true;
            } else {
                var4_4[54] = true;
                if (inAppNotification.getCustomExtras() != null) {
                    var4_4[55] = true;
                    notifKVS = Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras());
                    var4_4[56] = true;
                } else {
                    notifKVS = new HashMap<K, V>();
                    var4_4[57] = true;
                }
                Logger.v("Calling the in-app listener on behalf of " + this.coreMetaData.getSource());
                if (formData != null) {
                    var4_4[58] = true;
                    listener.onDismissed(notifKVS, Utils.convertBundleObjectToHashMap((Bundle)formData));
                    var4_4[59] = true;
                } else {
                    listener.onDismissed(notifKVS, null);
                    var4_4[60] = true;
                }
            }
            var4_4[61] = true;
        }
        catch (Throwable listener) {
            var4_4[62] = true;
            this.logger.verbose(this.config.getAccountId(), "Failed to call the in-app notification listener", (Throwable)t);
            var4_4[63] = true;
        }
        t = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        var4_4[64] = true;
        task.execute("InappController#inAppNotificationDidDismiss", new Callable<Void>(this, (Context)context, (CTInAppNotification)inAppNotification){
            final /* synthetic */ Context val$context;
            final /* synthetic */ CTInAppNotification val$inAppNotification;
            final /* synthetic */ InAppController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                this.val$context = context;
                this.val$inAppNotification = cTInAppNotification;
                blArray[0] = true;
            }

            @Override
            public Void call() {
                boolean[] blArray = 1.$jacocoInit();
                InAppController.access$200(this.val$context, InAppController.access$000(this.this$0), this.val$inAppNotification, this.this$0);
                blArray[1] = true;
                InAppController.access$300(this.this$0, this.val$context);
                blArray[2] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)4870264208137495979L, (String)"com/clevertap/android/sdk/inapp/InAppController$1", (int)4);
                }
                return blArray;
            }
        });
        var4_4[65] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inAppNotificationDidShow(CTInAppNotification cTInAppNotification, Bundle bundle) {
        void formData;
        void inAppNotification;
        boolean[] blArray = InAppController.$jacocoInit();
        this.analyticsManager.pushInAppNotificationStateEvent(false, (CTInAppNotification)inAppNotification, (Bundle)formData);
        blArray[66] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void notificationReady(CTInAppNotification cTInAppNotification) {
        void inAppNotification;
        boolean[] blArray = InAppController.$jacocoInit();
        if (Looper.myLooper() != Looper.getMainLooper()) {
            blArray[67] = true;
            this.mainLooperHandler.post(new Runnable(this, (CTInAppNotification)inAppNotification){
                final /* synthetic */ CTInAppNotification val$inAppNotification;
                final /* synthetic */ InAppController this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 2.$jacocoInit();
                    this.this$0 = this$0;
                    this.val$inAppNotification = cTInAppNotification;
                    blArray[0] = true;
                }

                @Override
                public void run() {
                    boolean[] blArray = 2.$jacocoInit();
                    this.this$0.notificationReady(this.val$inAppNotification);
                    blArray[1] = true;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)6666634790365735707L, (String)"com/clevertap/android/sdk/inapp/InAppController$2", (int)2);
                    }
                    return blArray;
                }
            });
            blArray[68] = true;
            return;
        }
        if (inAppNotification.getError() != null) {
            blArray[69] = true;
            blArray[70] = true;
            blArray[71] = true;
            this.logger.debug(this.config.getAccountId(), "Unable to process inapp notification " + inAppNotification.getError());
            blArray[72] = true;
            return;
        }
        this.logger.debug(this.config.getAccountId(), "Notification ready: " + inAppNotification.getJsonDescription());
        blArray[73] = true;
        this.displayNotification((CTInAppNotification)inAppNotification);
        blArray[74] = true;
    }

    public void resumeInApps() {
        boolean[] blArray = InAppController.$jacocoInit();
        this.inAppState = InAppState.RESUMED;
        blArray[75] = true;
        this.logger.verbose(this.config.getAccountId(), "InAppState is RESUMED");
        blArray[76] = true;
        this.logger.verbose(this.config.getAccountId(), "Resuming InApps by calling showInAppNotificationIfAny()");
        blArray[77] = true;
        this.showInAppNotificationIfAny();
        blArray[78] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void showNotificationIfAvailable(Context context) {
        boolean[] blArray = InAppController.$jacocoInit();
        if (this.config.isAnalyticsOnly()) {
            blArray[79] = true;
        } else {
            void context2;
            void task;
            blArray[80] = true;
            Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            blArray[81] = true;
            task.execute("InappController#showNotificationIfAvailable", new Callable<Void>(this, (Context)context2){
                final /* synthetic */ Context val$context;
                final /* synthetic */ InAppController this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 3.$jacocoInit();
                    this.this$0 = this$0;
                    this.val$context = context;
                    blArray[0] = true;
                }

                @Override
                public Void call() {
                    boolean[] blArray = 3.$jacocoInit();
                    InAppController.access$300(this.this$0, this.val$context);
                    blArray[1] = true;
                    return null;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)9052639027458621892L, (String)"com/clevertap/android/sdk/inapp/InAppController$3", (int)3);
                    }
                    return blArray;
                }
            });
            blArray[82] = true;
        }
        blArray[83] = true;
    }

    public void suspendInApps() {
        boolean[] blArray = InAppController.$jacocoInit();
        this.inAppState = InAppState.SUSPENDED;
        blArray[84] = true;
        this.logger.verbose(this.config.getAccountId(), "InAppState is SUSPENDED");
        blArray[85] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void _showNotificationIfAvailable(Context context) {
        void inapps22;
        void context2;
        boolean[] blArray = InAppController.$jacocoInit();
        SharedPreferences sharedPreferences = StorageHelper.getPreferences((Context)context2);
        blArray[86] = true;
        if (!this.canShowInAppOnActivity()) {
            blArray[88] = true;
            Logger.v("Not showing notification on blacklisted activity");
            blArray[89] = true;
            return;
        }
        blArray[87] = true;
        if (this.inAppState == InAppState.SUSPENDED) {
            blArray[91] = true;
            this.logger.debug(this.config.getAccountId(), "InApp Notifications are set to be suspended, not showing the InApp Notification");
            blArray[92] = true;
            return;
        }
        blArray[90] = true;
        InAppController.checkPendingNotifications((Context)context2, this.config, this);
        blArray[93] = true;
        JSONArray jSONArray = new JSONArray(StorageHelper.getStringFromPrefs((Context)context2, this.config, "inApp", "[]"));
        blArray[94] = true;
        if (inapps22.length() < 1) {
            blArray[96] = true;
            return;
        }
        blArray[95] = true;
        try {
            void editor;
            void prefs;
            void inappsUpdated;
            void i22;
            JSONArray inapp;
            if (this.inAppState != InAppState.DISCARDED) {
                blArray[97] = true;
                JSONObject jSONObject = inapps22.getJSONObject(0);
                blArray[98] = true;
                this.prepareNotificationForDisplay((JSONObject)inapp);
                blArray[99] = true;
            } else {
                this.logger.debug(this.config.getAccountId(), "InApp Notifications are set to be discarded, dropping the InApp Notification");
                blArray[100] = true;
            }
            inapp = new JSONArray();
            blArray[101] = true;
            boolean bl = false;
            blArray[102] = true;
            while (i22 < inapps22.length()) {
                if (i22 == false) {
                    blArray[103] = true;
                } else {
                    inappsUpdated.put(inapps22.get((int)i22));
                    blArray[104] = true;
                }
                ++i22;
                blArray[105] = true;
            }
            blArray[106] = true;
            blArray[107] = true;
            blArray[108] = true;
            SharedPreferences.Editor i22 = prefs.edit().putString(StorageHelper.storageKeyWithSuffix(this.config, "inApp"), inappsUpdated.toString());
            blArray[109] = true;
            StorageHelper.persist((SharedPreferences.Editor)editor);
            blArray[110] = true;
        }
        catch (Throwable inapps22) {
            void t;
            blArray[111] = true;
            this.logger.verbose(this.config.getAccountId(), "InApp: Couldn't parse JSON array string from prefs", (Throwable)t);
            blArray[112] = true;
        }
        blArray[113] = true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean canShowInAppOnActivity() {
        boolean[] blArray = InAppController.$jacocoInit();
        this.updateBlacklistedActivitySet();
        blArray[114] = true;
        Iterator<String> iterator = this.inappActivityExclude.iterator();
        blArray[115] = true;
        while (iterator.hasNext()) {
            void blacklistedActivity;
            void currentActivityName;
            String string = iterator.next();
            blArray[116] = true;
            String string2 = CoreMetaData.getCurrentActivityName();
            blArray[117] = true;
            if (currentActivityName == null) {
                blArray[118] = true;
            } else if (!currentActivityName.contains((CharSequence)blacklistedActivity)) {
                blArray[119] = true;
            } else {
                blArray[120] = true;
                return false;
            }
            blArray[121] = true;
        }
        blArray[122] = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void displayNotification(CTInAppNotification cTInAppNotification) {
        boolean goFromListener;
        void inAppNotification;
        boolean[] blArray = InAppController.$jacocoInit();
        if (Looper.myLooper() != Looper.getMainLooper()) {
            blArray[123] = true;
            this.mainLooperHandler.post(new Runnable(this, (CTInAppNotification)inAppNotification){
                final /* synthetic */ CTInAppNotification val$inAppNotification;
                final /* synthetic */ InAppController this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 4.$jacocoInit();
                    this.this$0 = this$0;
                    this.val$inAppNotification = cTInAppNotification;
                    blArray[0] = true;
                }

                @Override
                public void run() {
                    boolean[] blArray = 4.$jacocoInit();
                    InAppController.access$400(this.this$0, this.val$inAppNotification);
                    blArray[1] = true;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-8160555132944362365L, (String)"com/clevertap/android/sdk/inapp/InAppController$4", (int)2);
                    }
                    return blArray;
                }
            });
            blArray[124] = true;
            return;
        }
        if (this.controllerManager.getInAppFCManager() != null) {
            blArray[125] = true;
            if (!this.controllerManager.getInAppFCManager().canShow((CTInAppNotification)inAppNotification)) {
                blArray[126] = true;
                blArray[127] = true;
                blArray[128] = true;
                this.logger.verbose(this.config.getAccountId(), "InApp has been rejected by FC, not showing " + inAppNotification.getCampaignId());
                blArray[129] = true;
                this.showInAppNotificationIfAny();
                blArray[130] = true;
                return;
            }
        } else {
            blArray[131] = true;
            blArray[132] = true;
            this.logger.verbose(this.config.getAccountId(), "getCoreState().getInAppFCManager() is NULL, not showing " + inAppNotification.getCampaignId());
            blArray[133] = true;
            return;
        }
        this.controllerManager.getInAppFCManager().didShow(this.context, (CTInAppNotification)inAppNotification);
        InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
        if (listener != null) {
            HashMap<String, Object> kvs;
            blArray[134] = true;
            if (inAppNotification.getCustomExtras() != null) {
                blArray[135] = true;
                kvs = Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras());
                blArray[136] = true;
            } else {
                kvs = new HashMap();
                blArray[137] = true;
            }
            goFromListener = listener.beforeShow(kvs);
            blArray[138] = true;
        } else {
            goFromListener = true;
            blArray[139] = true;
        }
        if (!goFromListener) {
            blArray[140] = true;
            blArray[141] = true;
            blArray[142] = true;
            this.logger.verbose(this.config.getAccountId(), "Application has decided to not show this in-app notification: " + inAppNotification.getCampaignId());
            blArray[143] = true;
            this.showInAppNotificationIfAny();
            blArray[144] = true;
            return;
        }
        InAppController.showInApp(this.context, (CTInAppNotification)inAppNotification, this.config, this);
        blArray[145] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareNotificationForDisplay(JSONObject jSONObject) {
        void task;
        void jsonObject;
        boolean[] blArray = InAppController.$jacocoInit();
        this.logger.debug(this.config.getAccountId(), "Preparing In-App for display: " + jsonObject.toString());
        blArray[146] = true;
        Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        blArray[147] = true;
        task.execute("InappController#prepareNotificationForDisplay", new Callable<Void>(this, (JSONObject)jsonObject){
            final /* synthetic */ JSONObject val$jsonObject;
            final /* synthetic */ InAppController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 5.$jacocoInit();
                this.this$0 = this$0;
                this.val$jsonObject = jSONObject;
                blArray[0] = true;
            }

            @Override
            public Void call() {
                boolean[] blArray = 5.$jacocoInit();
                new NotificationPrepareRunnable(this.this$0, this.this$0, this.val$jsonObject).run();
                blArray[1] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)2681110919188797510L, (String)"com/clevertap/android/sdk/inapp/InAppController$5", (int)3);
                }
                return blArray;
            }
        });
        blArray[148] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void showInAppNotificationIfAny() {
        boolean[] blArray = InAppController.$jacocoInit();
        if (this.config.isAnalyticsOnly()) {
            blArray[149] = true;
        } else {
            void task;
            blArray[150] = true;
            Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            blArray[151] = true;
            task.execute("InAppController#showInAppNotificationIfAny", new Callable<Void>(this){
                final /* synthetic */ InAppController this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 6.$jacocoInit();
                    this.this$0 = this$0;
                    blArray[0] = true;
                }

                @Override
                public Void call() {
                    boolean[] blArray = 6.$jacocoInit();
                    InAppController.access$300(this.this$0, InAppController.access$500(this.this$0));
                    blArray[1] = true;
                    return null;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)8492160429648438622L, (String)"com/clevertap/android/sdk/inapp/InAppController$6", (int)3);
                    }
                    return blArray;
                }
            });
            blArray[152] = true;
        }
        blArray[153] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void updateBlacklistedActivitySet() {
        boolean[] blArray = InAppController.$jacocoInit();
        if (this.inappActivityExclude != null) {
            blArray[154] = true;
        } else {
            blArray[155] = true;
            this.inappActivityExclude = new HashSet();
            try {
                blArray[156] = true;
                String activities = ManifestInfo.getInstance(this.context).getExcludedActivities();
                if (activities == null) {
                    blArray[157] = true;
                } else {
                    String[] split;
                    blArray[158] = true;
                    String[] stringArray = split = activities.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    blArray[159] = true;
                    while (true) {
                        void a;
                        if (n2 >= n) {
                            blArray[160] = true;
                            break;
                        }
                        String string = stringArray[n2];
                        blArray[161] = true;
                        this.inappActivityExclude.add(a.trim());
                        ++n2;
                        blArray[162] = true;
                    }
                }
                blArray[163] = true;
            }
            catch (Throwable throwable) {
                blArray[164] = true;
            }
            blArray[165] = true;
            blArray[166] = true;
            this.logger.debug(this.config.getAccountId(), "In-app notifications will not be shown on " + Arrays.toString(this.inappActivityExclude.toArray()));
            blArray[167] = true;
        }
        blArray[168] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkPendingNotifications(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, InAppController inAppController) {
        void config;
        boolean[] blArray = InAppController.$jacocoInit();
        Logger.v(config.getAccountId(), "checking Pending Notifications");
        blArray[169] = true;
        if (pendingNotifications == null) {
            blArray[170] = true;
        } else if (pendingNotifications.isEmpty()) {
            blArray[171] = true;
        } else {
            try {
                void inAppController2;
                void notification;
                Context context2;
                void mainHandler;
                blArray[172] = true;
                CTInAppNotification cTInAppNotification = pendingNotifications.get(0);
                blArray[173] = true;
                pendingNotifications.remove(0);
                blArray[174] = true;
                MainLooperHandler mainLooperHandler = new MainLooperHandler();
                blArray[175] = true;
                mainHandler.post(new Runnable(context2, (CTInAppNotification)notification, (CleverTapInstanceConfig)config, (InAppController)inAppController2){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ CTInAppNotification val$notification;
                    final /* synthetic */ CleverTapInstanceConfig val$config;
                    final /* synthetic */ InAppController val$inAppController;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        boolean[] blArray = 7.$jacocoInit();
                        this.val$context = context;
                        this.val$notification = cTInAppNotification;
                        this.val$config = cleverTapInstanceConfig;
                        this.val$inAppController = inAppController;
                        blArray[0] = true;
                    }

                    @Override
                    public void run() {
                        boolean[] blArray = 7.$jacocoInit();
                        InAppController.access$600(this.val$context, this.val$notification, this.val$config, this.val$inAppController);
                        blArray[1] = true;
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)2944065835423490340L, (String)"com/clevertap/android/sdk/inapp/InAppController$7", (int)2);
                        }
                        return blArray;
                    }
                });
                blArray[176] = true;
            }
            catch (Throwable throwable) {
                blArray[177] = true;
            }
        }
        blArray[178] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void inAppDidDismiss(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, CTInAppNotification cTInAppNotification, InAppController inAppController) {
        void config;
        boolean[] blArray = InAppController.$jacocoInit();
        Logger.v(config.getAccountId(), "Running inAppDidDismiss");
        blArray[179] = true;
        if (currentlyDisplayingInApp == null) {
            blArray[180] = true;
        } else {
            void inAppNotification;
            blArray[181] = true;
            if (!currentlyDisplayingInApp.getCampaignId().equals(inAppNotification.getCampaignId())) {
                blArray[182] = true;
            } else {
                void inAppController2;
                Context context2;
                currentlyDisplayingInApp = null;
                blArray[183] = true;
                InAppController.checkPendingNotifications(context2, (CleverTapInstanceConfig)config, (InAppController)inAppController2);
                blArray[184] = true;
            }
        }
        blArray[185] = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void showInApp(Context context, CTInAppNotification cTInAppNotification, CleverTapInstanceConfig cleverTapInstanceConfig, InAppController inAppController) {
        block18: {
            CTInAppBasePartialFragment inAppFragment;
            Bundle configBundle;
            FragmentTransaction intent;
            void type;
            void inAppNotification;
            void config;
            boolean[] blArray = InAppController.$jacocoInit();
            Logger.v(config.getAccountId(), "Attempting to show next In-App");
            blArray[186] = true;
            if (!CoreMetaData.isAppForeground()) {
                blArray[187] = true;
                pendingNotifications.add((CTInAppNotification)inAppNotification);
                blArray[188] = true;
                Logger.v(config.getAccountId(), "Not in foreground, queueing this In App");
                blArray[189] = true;
                return;
            }
            if (currentlyDisplayingInApp != null) {
                blArray[190] = true;
                pendingNotifications.add((CTInAppNotification)inAppNotification);
                blArray[191] = true;
                Logger.v(config.getAccountId(), "In App already displaying, queueing this In App");
                blArray[192] = true;
                return;
            }
            if (System.currentTimeMillis() / 1000L > inAppNotification.getTimeToLive()) {
                blArray[193] = true;
                Logger.d("InApp has elapsed its time to live, not showing the InApp");
                blArray[194] = true;
                return;
            }
            currentlyDisplayingInApp = inAppNotification;
            Object var5_5 = null;
            blArray[195] = true;
            CTInAppType cTInAppType = inAppNotification.getInAppType();
            blArray[196] = true;
            switch (8.$SwitchMap$com$clevertap$android$sdk$inapp$CTInAppType[type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    Context context2;
                    Intent intent2 = new Intent(context2, InAppNotificationActivity.class);
                    blArray[197] = true;
                    intent.putExtra("inApp", (Parcelable)inAppNotification);
                    blArray[198] = true;
                    Bundle bundle = new Bundle();
                    blArray[199] = true;
                    configBundle.putParcelable("config", (Parcelable)config);
                    blArray[200] = true;
                    intent.putExtra("configBundle", configBundle);
                    try {
                        blArray[201] = true;
                        Activity currentActivity = CoreMetaData.getCurrentActivity();
                        if (currentActivity == null) {
                            blArray[202] = true;
                            blArray[203] = true;
                            throw new IllegalStateException("Current activity reference not found");
                        }
                        blArray[204] = true;
                        blArray[205] = true;
                        config.getLogger().verbose(config.getAccountId(), "calling InAppActivity for notification: " + inAppNotification.getJsonDescription());
                        blArray[206] = true;
                        currentActivity.startActivity((Intent)intent);
                        blArray[207] = true;
                        Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                        blArray[208] = true;
                    }
                    catch (Throwable currentActivity) {
                        void t;
                        blArray[209] = true;
                        Logger.v("Please verify the integration of your app. It is not setup to support in-app notifications yet.", (Throwable)t);
                        blArray[210] = true;
                    }
                    break;
                }
                case 11: {
                    inAppFragment = new CTInAppHtmlFooterFragment();
                    blArray[211] = true;
                    break;
                }
                case 12: {
                    inAppFragment = new CTInAppHtmlHeaderFragment();
                    blArray[212] = true;
                    break;
                }
                case 13: {
                    inAppFragment = new CTInAppNativeFooterFragment();
                    blArray[213] = true;
                    break;
                }
                case 14: {
                    inAppFragment = new CTInAppNativeHeaderFragment();
                    blArray[214] = true;
                    break;
                }
                default: {
                    Logger.d(config.getAccountId(), "Unknown InApp Type found: " + type);
                    currentlyDisplayingInApp = null;
                    blArray[215] = true;
                    return;
                }
            }
            if (inAppFragment == null) {
                blArray[216] = true;
            } else {
                blArray[217] = true;
                Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                try {
                    void fragmentTransaction;
                    void bundle;
                    blArray[218] = true;
                    blArray[219] = true;
                    blArray[220] = true;
                    intent = ((FragmentActivity)CoreMetaData.getCurrentActivity()).getSupportFragmentManager().beginTransaction();
                    blArray[221] = true;
                    configBundle = new Bundle();
                    blArray[222] = true;
                    bundle.putParcelable("inApp", (Parcelable)inAppNotification);
                    blArray[223] = true;
                    bundle.putParcelable("config", (Parcelable)config);
                    blArray[224] = true;
                    inAppFragment.setArguments((Bundle)bundle);
                    blArray[225] = true;
                    fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                    blArray[226] = true;
                    fragmentTransaction.add(0x1020002, (Fragment)inAppFragment, inAppNotification.getType());
                    blArray[227] = true;
                    Logger.v(config.getAccountId(), "calling InAppFragment " + inAppNotification.getCampaignId());
                    blArray[228] = true;
                    fragmentTransaction.commit();
                }
                catch (ClassCastException fragmentTransaction) {
                    void e;
                    blArray[230] = true;
                    blArray[231] = true;
                    blArray[232] = true;
                    Logger.v(config.getAccountId(), "Fragment not able to render, please ensure your Activity is an instance of AppCompatActivity" + e.getMessage());
                    blArray[233] = true;
                    break block18;
                }
                catch (Throwable e) {
                    void t;
                    blArray[234] = true;
                    Logger.v(config.getAccountId(), "Fragment not able to render", (Throwable)t);
                    blArray[235] = true;
                    break block18;
                }
                blArray[229] = true;
            }
        }
        blArray[236] = true;
    }

    static /* synthetic */ CleverTapInstanceConfig access$000(InAppController inAppController) {
        InAppController x0;
        boolean[] blArray = InAppController.$jacocoInit();
        blArray[237] = true;
        return x0.config;
    }

    static /* synthetic */ Logger access$100(InAppController inAppController) {
        InAppController x0;
        boolean[] blArray = InAppController.$jacocoInit();
        blArray[238] = true;
        return x0.logger;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, CTInAppNotification cTInAppNotification, InAppController inAppController) {
        void x3;
        void x2;
        void x1;
        Context x0;
        boolean[] blArray = InAppController.$jacocoInit();
        InAppController.inAppDidDismiss(x0, (CleverTapInstanceConfig)x1, (CTInAppNotification)x2, (InAppController)x3);
        blArray[239] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(InAppController inAppController, Context context) {
        void x1;
        InAppController x0;
        boolean[] blArray = InAppController.$jacocoInit();
        x0._showNotificationIfAvailable((Context)x1);
        blArray[240] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(InAppController inAppController, CTInAppNotification cTInAppNotification) {
        void x1;
        InAppController x0;
        boolean[] blArray = InAppController.$jacocoInit();
        x0.displayNotification((CTInAppNotification)x1);
        blArray[241] = true;
    }

    static /* synthetic */ Context access$500(InAppController inAppController) {
        InAppController x0;
        boolean[] blArray = InAppController.$jacocoInit();
        blArray[242] = true;
        return x0.context;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(Context context, CTInAppNotification cTInAppNotification, CleverTapInstanceConfig cleverTapInstanceConfig, InAppController inAppController) {
        void x3;
        void x2;
        void x1;
        Context x0;
        boolean[] blArray = InAppController.$jacocoInit();
        InAppController.showInApp(x0, (CTInAppNotification)x1, (CleverTapInstanceConfig)x2, (InAppController)x3);
        blArray[243] = true;
    }

    static {
        boolean[] blArray = InAppController.$jacocoInit();
        currentlyDisplayingInApp = null;
        blArray[244] = true;
        blArray[245] = true;
        pendingNotifications = Collections.synchronizedList(new ArrayList());
        blArray[246] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-7220166973989538460L, (String)"com/clevertap/android/sdk/inapp/InAppController", (int)247);
        }
        return blArray;
    }

    private static final class InAppState
    extends Enum<InAppState> {
        public static final /* enum */ InAppState DISCARDED;
        public static final /* enum */ InAppState SUSPENDED;
        public static final /* enum */ InAppState RESUMED;
        final int state;
        private static final /* synthetic */ InAppState[] $VALUES;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public static InAppState[] values() {
            boolean[] blArray = InAppState.$jacocoInit();
            blArray[0] = true;
            return (InAppState[])$VALUES.clone();
        }

        public static InAppState valueOf(String string) {
            String name;
            boolean[] blArray = InAppState.$jacocoInit();
            blArray[1] = true;
            return Enum.valueOf(InAppState.class, name);
        }

        /*
         * WARNING - void declaration
         */
        private InAppState(int n2) {
            void inAppState;
            boolean[] blArray = InAppState.$jacocoInit();
            this.state = inAppState;
            blArray[2] = true;
        }

        int intValue() {
            boolean[] blArray = InAppState.$jacocoInit();
            blArray[3] = true;
            return this.state;
        }

        static {
            boolean[] blArray = InAppState.$jacocoInit();
            DISCARDED = new InAppState(-1);
            blArray[4] = true;
            SUSPENDED = new InAppState(0);
            blArray[5] = true;
            RESUMED = new InAppState(1);
            $VALUES = new InAppState[]{DISCARDED, SUSPENDED, RESUMED};
            blArray[6] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-9017131273340222286L, (String)"com/clevertap/android/sdk/inapp/InAppController$InAppState", (int)7);
            }
            return blArray;
        }
    }

    private final class NotificationPrepareRunnable
    implements Runnable {
        private final WeakReference<InAppController> inAppControllerWeakReference;
        private final JSONObject jsonObject;
        private final boolean videoSupport;
        final /* synthetic */ InAppController this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        NotificationPrepareRunnable(InAppController inAppController, InAppController inAppController2, JSONObject jSONObject) {
            void jsonObject;
            void inAppController3;
            boolean[] blArray = NotificationPrepareRunnable.$jacocoInit();
            this.this$0 = inAppController;
            this.videoSupport = Utils.haveVideoPlayerSupport;
            blArray[0] = true;
            this.inAppControllerWeakReference = new WeakReference<void>(inAppController3);
            this.jsonObject = jsonObject;
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void inAppNotification;
            boolean[] blArray = NotificationPrepareRunnable.$jacocoInit();
            blArray[2] = true;
            CTInAppNotification cTInAppNotification = new CTInAppNotification().initWithJSON(this.jsonObject, this.videoSupport);
            blArray[3] = true;
            if (inAppNotification.getError() != null) {
                blArray[4] = true;
                blArray[5] = true;
                blArray[6] = true;
                blArray[7] = true;
                InAppController.access$100(this.this$0).debug(InAppController.access$000(this.this$0).getAccountId(), "Unable to parse inapp notification " + inAppNotification.getError());
                blArray[8] = true;
                return;
            }
            inAppNotification.listener = (CTInAppNotification.CTInAppNotificationListener)this.inAppControllerWeakReference.get();
            blArray[9] = true;
            inAppNotification.prepareForDisplay();
            blArray[10] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-3597024759297382926L, (String)"com/clevertap/android/sdk/inapp/InAppController$NotificationPrepareRunnable", (int)11);
            }
            return blArray;
        }
    }
}

