/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.gif;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.gif.GifFrame;
import com.clevertap.android.sdk.gif.GifHeader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jacoco.agent.rt.internal_28bab1d.Offline;

class GifHeaderParser {
    private static final String TAG = "GifHeaderParser";
    private static final int MIN_FRAME_DELAY = 2;
    private static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    private final byte[] block;
    private int blockSize;
    private GifHeader header;
    private ByteBuffer rawData;
    private static transient /* synthetic */ boolean[] $jacocoData;

    GifHeaderParser() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.block = new byte[256];
        this.blockSize = 0;
        blArray[0] = true;
    }

    public void clear() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.rawData = null;
        this.header = null;
        blArray[1] = true;
    }

    public boolean isAnimated() {
        boolean bl;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.readHeader();
        blArray[2] = true;
        if (this.err()) {
            blArray[3] = true;
        } else {
            blArray[4] = true;
            this.readContents(2);
            blArray[5] = true;
        }
        if (this.header.frameCount > 1) {
            bl = blArray[6] = true;
        } else {
            bl = false;
            blArray[7] = true;
        }
        blArray[8] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public GifHeaderParser setData(ByteBuffer byteBuffer) {
        void data;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.reset();
        blArray[9] = true;
        this.rawData = data.asReadOnlyBuffer();
        blArray[10] = true;
        this.rawData.position(0);
        blArray[11] = true;
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        blArray[12] = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GifHeaderParser setData(byte[] byArray) {
        void data;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        if (data != null) {
            blArray[13] = true;
            this.setData(ByteBuffer.wrap((byte[])data));
            blArray[14] = true;
        } else {
            this.rawData = null;
            this.header.status = 2;
            blArray[15] = true;
        }
        blArray[16] = true;
        return this;
    }

    GifHeader parseHeader() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        if (this.rawData == null) {
            blArray[17] = true;
            blArray[18] = true;
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            blArray[19] = true;
            return this.header;
        }
        this.readHeader();
        blArray[20] = true;
        if (this.err()) {
            blArray[21] = true;
        } else {
            blArray[22] = true;
            this.readContents();
            if (this.header.frameCount >= 0) {
                blArray[23] = true;
            } else {
                this.header.status = 1;
                blArray[24] = true;
            }
        }
        blArray[25] = true;
        return this.header;
    }

    private boolean err() {
        boolean bl;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        if (this.header.status != 0) {
            bl = blArray[26] = true;
        } else {
            bl = false;
            blArray[27] = true;
        }
        blArray[28] = true;
        return bl;
    }

    private int read() {
        int curByte;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        boolean bl = false;
        try {
            blArray[29] = true;
            curByte = this.rawData.get() & 0xFF;
            blArray[30] = true;
        }
        catch (Exception e) {
            this.header.status = 1;
            blArray[31] = true;
        }
        blArray[32] = true;
        return curByte;
    }

    /*
     * WARNING - void declaration
     */
    private void readBitmap() {
        void lctFlag;
        boolean bl;
        boolean bl2;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.header.currentFrame.ix = this.readShort();
        blArray[33] = true;
        this.header.currentFrame.iy = this.readShort();
        blArray[34] = true;
        this.header.currentFrame.iw = this.readShort();
        blArray[35] = true;
        this.header.currentFrame.ih = this.readShort();
        blArray[36] = true;
        int packed = this.read();
        if ((packed & 0x80) != 0) {
            bl2 = blArray[37] = true;
        } else {
            bl2 = false;
            blArray[38] = true;
        }
        boolean bl3 = bl2;
        blArray[39] = true;
        int lctSize = (int)Math.pow(2.0, (packed & 7) + 1);
        GifFrame gifFrame = this.header.currentFrame;
        if ((packed & 0x40) != 0) {
            bl = blArray[40] = true;
        } else {
            bl = false;
            blArray[41] = true;
        }
        gifFrame.interlace = bl;
        if (lctFlag != false) {
            blArray[42] = true;
            this.header.currentFrame.lct = this.readColorTable(lctSize);
            blArray[43] = true;
        } else {
            this.header.currentFrame.lct = null;
            blArray[44] = true;
        }
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        blArray[45] = true;
        this.skipImageData();
        blArray[46] = true;
        if (this.err()) {
            blArray[47] = true;
            return;
        }
        ++this.header.frameCount;
        blArray[48] = true;
        this.header.frames.add(this.header.currentFrame);
        blArray[49] = true;
    }

    /*
     * WARNING - void declaration
     */
    private int readBlock() {
        int n;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.blockSize = this.read();
        if (this.blockSize <= 0) {
            blArray[50] = true;
        } else {
            try {
                void count;
                blArray[51] = true;
                for (n = 0; n < this.blockSize; n += count) {
                    int n2 = this.blockSize - n;
                    blArray[52] = true;
                    this.rawData.get(this.block, n, (int)count);
                    blArray[53] = true;
                }
                blArray[54] = true;
            }
            catch (Exception e) {
                this.header.status = 1;
                blArray[55] = true;
            }
        }
        blArray[56] = true;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int[] readColorTable(int n) {
        void ncolors;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] byArray = new byte[nbytes];
        try {
            void c;
            blArray[57] = true;
            this.rawData.get((byte[])c);
            tab = new int[256];
            int i = 0;
            boolean bl = false;
            blArray[58] = true;
            while (i < ncolors) {
                void j;
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
                blArray[59] = true;
            }
        }
        catch (BufferUnderflowException i) {
            void e;
            blArray[61] = true;
            Logger.d(TAG, "Format Error Reading Color Table", (Throwable)e);
            this.header.status = 1;
            blArray[62] = true;
        }
        blArray[60] = true;
        blArray[63] = true;
        return tab;
    }

    private void readContents() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.readContents(Integer.MAX_VALUE);
        blArray[64] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void readContents(int n) {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        boolean bl = false;
        blArray[65] = true;
        while (true) {
            void maxFrames;
            boolean done;
            if (done) {
                blArray[66] = true;
                break;
            }
            if (this.err()) {
                blArray[67] = true;
                break;
            }
            if (this.header.frameCount > maxFrames) {
                blArray[68] = true;
                break;
            }
            blArray[69] = true;
            int code = this.read();
            block0 : switch (code) {
                case 44: {
                    if (this.header.currentFrame != null) {
                        blArray[70] = true;
                    } else {
                        blArray[71] = true;
                        this.header.currentFrame = new GifFrame();
                        blArray[72] = true;
                    }
                    this.readBitmap();
                    blArray[73] = true;
                    break;
                }
                case 33: {
                    code = this.read();
                    switch (code) {
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            blArray[74] = true;
                            this.readGraphicControlExt();
                            blArray[75] = true;
                            break block0;
                        }
                        case 255: {
                            void i;
                            this.readBlock();
                            String app = "";
                            boolean bl2 = false;
                            blArray[76] = true;
                            while (i < 11) {
                                blArray[77] = true;
                                app = app + (char)this.block[i];
                                ++i;
                                blArray[78] = true;
                            }
                            if (app.equals("NETSCAPE2.0")) {
                                blArray[79] = true;
                                this.readNetscapeExt();
                                blArray[80] = true;
                                break block0;
                            }
                            this.skip();
                            blArray[81] = true;
                            break block0;
                        }
                        case 254: {
                            this.skip();
                            blArray[82] = true;
                            break block0;
                        }
                        case 1: {
                            this.skip();
                            blArray[83] = true;
                            break block0;
                        }
                    }
                    this.skip();
                    blArray[84] = true;
                    break;
                }
                case 59: {
                    done = true;
                    blArray[85] = true;
                    break;
                }
                default: {
                    this.header.status = 1;
                    blArray[86] = true;
                }
            }
            blArray[87] = true;
        }
        blArray[88] = true;
    }

    private void readGraphicControlExt() {
        boolean bl;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.read();
        blArray[89] = true;
        int packed = this.read();
        this.header.currentFrame.dispose = (packed & 0x1C) >> 2;
        if (this.header.currentFrame.dispose != 0) {
            blArray[90] = true;
        } else {
            this.header.currentFrame.dispose = 1;
            blArray[91] = true;
        }
        GifFrame gifFrame = this.header.currentFrame;
        if ((packed & 1) != 0) {
            bl = blArray[92] = true;
        } else {
            bl = false;
            blArray[93] = true;
        }
        gifFrame.transparency = bl;
        blArray[94] = true;
        int delayInHundredthsOfASecond = this.readShort();
        if (delayInHundredthsOfASecond >= 2) {
            blArray[95] = true;
        } else {
            delayInHundredthsOfASecond = 10;
            blArray[96] = true;
        }
        this.header.currentFrame.delay = delayInHundredthsOfASecond * 10;
        blArray[97] = true;
        this.header.currentFrame.transIndex = this.read();
        blArray[98] = true;
        this.read();
        blArray[99] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void readHeader() {
        void i;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        String id2 = "";
        boolean bl = false;
        blArray[100] = true;
        while (i < 6) {
            blArray[101] = true;
            id2 = id2 + (char)this.read();
            ++i;
            blArray[102] = true;
        }
        if (!id2.startsWith("GIF")) {
            this.header.status = 1;
            blArray[103] = true;
            return;
        }
        this.readLSD();
        blArray[104] = true;
        if (!this.header.gctFlag) {
            blArray[105] = true;
        } else if (this.err()) {
            blArray[106] = true;
        } else {
            blArray[107] = true;
            this.header.gct = this.readColorTable(this.header.gctSize);
            this.header.bgColor = this.header.gct[this.header.bgIndex];
            blArray[108] = true;
        }
        blArray[109] = true;
    }

    private void readLSD() {
        boolean bl;
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.header.width = this.readShort();
        blArray[110] = true;
        this.header.height = this.readShort();
        blArray[111] = true;
        int packed = this.read();
        if ((packed & 0x80) != 0) {
            bl = blArray[112] = true;
        } else {
            bl = false;
            blArray[113] = true;
        }
        this.header.gctFlag = bl;
        this.header.gctSize = 2 << (packed & 7);
        blArray[114] = true;
        this.header.bgIndex = this.read();
        blArray[115] = true;
        this.header.pixelAspect = this.read();
        blArray[116] = true;
    }

    private void readNetscapeExt() {
        block6: {
            boolean[] blArray = GifHeaderParser.$jacocoInit();
            while (true) {
                this.readBlock();
                if (this.block[0] != 1) {
                    blArray[117] = true;
                } else {
                    int b1 = this.block[1] & 0xFF;
                    int b2 = this.block[2] & 0xFF;
                    this.header.loopCount = b2 << 8 | b1;
                    if (this.header.loopCount != 0) {
                        blArray[118] = true;
                    } else {
                        this.header.loopCount = -1;
                        blArray[119] = true;
                    }
                }
                if (this.blockSize <= 0) {
                    blArray[120] = true;
                    break block6;
                }
                if (this.err()) break;
                blArray[121] = true;
            }
            blArray[122] = true;
        }
        blArray[123] = true;
    }

    private int readShort() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        blArray[124] = true;
        return this.rawData.getShort();
    }

    private void reset() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.rawData = null;
        blArray[125] = true;
        Arrays.fill(this.block, (byte)0);
        blArray[126] = true;
        this.header = new GifHeader();
        this.blockSize = 0;
        blArray[127] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void skip() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        try {
            while (true) {
                void blockSize;
                int n = this.read();
                blArray[128] = true;
                this.rawData.position(this.rawData.position() + blockSize);
                if (blockSize <= 0) break;
                blArray[129] = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            blArray[131] = true;
        }
        blArray[130] = true;
        blArray[132] = true;
    }

    private void skipImageData() {
        boolean[] blArray = GifHeaderParser.$jacocoInit();
        this.read();
        blArray[133] = true;
        this.skip();
        blArray[134] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)6893007626114929796L, (String)"com/clevertap/android/sdk/gif/GifHeaderParser", (int)135);
        }
        return blArray;
    }
}

