/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DBAdapter {
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String KEY_DATA = "data";
    private static final String KEY_CREATED_AT = "created_at";
    private static final long DATA_EXPIRATION = 432000000L;
    private static final String _ID = "_id";
    private static final String IS_READ = "isRead";
    private static final String EXPIRES = "expires";
    private static final String TAGS = "tags";
    private static final String USER_ID = "messageUser";
    private static final String CAMPAIGN = "campaignId";
    private static final String WZRKPARAMS = "wzrkParams";
    private static final int DB_UPDATE_ERROR = -1;
    private static final int DB_OUT_OF_MEMORY_ERROR = -2;
    private static final String DATABASE_NAME = "clevertap";
    private static final int DATABASE_VERSION = 3;
    private static final String CREATE_EVENTS_TABLE;
    private static final String CREATE_PROFILE_EVENTS_TABLE;
    private static final String CREATE_USER_PROFILES_TABLE;
    private static final String CREATE_INBOX_MESSAGES_TABLE;
    private static final String INBOX_MESSAGES_COMP_ID_USERID_INDEX;
    private static final String EVENTS_TIME_INDEX;
    private static final String PROFILE_EVENTS_TIME_INDEX;
    private static final String CREATE_PUSH_NOTIFICATIONS_TABLE;
    private static final String PUSH_NOTIFICATIONS_TIME_INDEX;
    private static final String CREATE_UNINSTALL_TS_TABLE;
    private static final String UNINSTALL_TS_INDEX;
    private static final String CREATE_NOTIFICATION_VIEWED_TABLE;
    private static final String NOTIFICATION_VIEWED_INDEX;
    private static final String DROP_TABLE_UNINSTALL_TS;
    private static final String DROP_TABLE_INBOX_MESSAGES;
    private static final String DROP_TABLE_PUSH_NOTIFICATION_VIEWED;
    private CleverTapInstanceConfig config;
    private final DatabaseHelper dbHelper;
    private boolean rtlDirtyFlag;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public DBAdapter(Context context, CleverTapInstanceConfig cleverTapInstanceConfig) {
        void config;
        void context2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        this((Context)context2, DBAdapter.getDatabaseName((CleverTapInstanceConfig)config));
        this.config = config;
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    private DBAdapter(Context context, String string) {
        void dbName;
        void context2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        this.rtlDirtyFlag = true;
        blArray[1] = true;
        this.dbHelper = new DatabaseHelper((Context)context2, (String)dbName);
        blArray[2] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    public synchronized boolean deleteMessageForId(String string, String string2) {
        boolean bl;
        void tName;
        void userId;
        void messageId;
        block8: {
            block7: {
                block6: {
                    boolean[] blArray = DBAdapter.$jacocoInit();
                    if (messageId != null) break block6;
                    blArray[3] = true;
                    break block7;
                }
                if (userId != null) break block8;
                blArray[4] = true;
            }
            blArray[5] = true;
            return false;
        }
        String string3 = Table.INBOX_MESSAGES.getName();
        try {
            void db;
            blArray[6] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[7] = true;
            db.delete((String)tName, "_id = ? AND messageUser = ?", new String[]{messageId, userId});
            bl = true;
            blArray[8] = true;
        }
        catch (SQLiteException db) {
            boolean bl2;
            try {
                void e;
                blArray[10] = true;
                this.getConfigLogger().verbose("Error removing stale records from " + (String)tName, (Throwable)e);
                bl2 = false;
                blArray[11] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[13] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[12] = true;
            return bl2;
        }
        this.dbHelper.close();
        blArray[9] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean doesPushNotificationIdExist(String string) {
        void id2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[14] = true;
        return id2.equals(this.fetchPushNotificationId((String)id2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized String[] fetchPushNotificationIds() {
        void pushIds;
        Cursor cursor;
        block13: {
            boolean[] blArray = DBAdapter.$jacocoInit();
            if (!this.rtlDirtyFlag) {
                blArray[15] = true;
                return new String[0];
            }
            String tName = Table.PUSH_NOTIFICATIONS.getName();
            Object var3_3 = null;
            blArray[16] = true;
            ArrayList arrayList = new ArrayList();
            try {
                void db;
                blArray[17] = true;
                SQLiteDatabase sQLiteDatabase = this.dbHelper.getReadableDatabase();
                blArray[18] = true;
                cursor = db.query(tName, null, "isRead =?", new String[]{"0"}, null, null, null);
                if (cursor == null) {
                    blArray[19] = true;
                    break block13;
                }
                blArray[20] = true;
                while (cursor.moveToNext()) {
                    blArray[21] = true;
                    Logger.v("Fetching PID - " + cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    blArray[22] = true;
                    pushIds.add(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    blArray[23] = true;
                }
                cursor.close();
                blArray[24] = true;
            }
            catch (SQLiteException db) {
                try {
                    void e;
                    blArray[28] = true;
                    this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", (Throwable)e);
                    blArray[29] = true;
                }
                catch (Throwable throwable) {
                    this.dbHelper.close();
                    if (cursor == null) {
                        blArray[33] = true;
                    } else {
                        blArray[34] = true;
                        cursor.close();
                        blArray[35] = true;
                    }
                    blArray[36] = true;
                    throw throwable;
                }
                this.dbHelper.close();
                if (cursor == null) {
                    blArray[30] = true;
                } else {
                    blArray[31] = true;
                    cursor.close();
                    blArray[32] = true;
                }
            }
        }
        this.dbHelper.close();
        if (cursor == null) {
            blArray[25] = true;
        } else {
            blArray[26] = true;
            cursor.close();
            blArray[27] = true;
        }
        blArray[37] = true;
        return pushIds.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized JSONObject fetchUserProfileById(String string) {
        Cursor cursor;
        JSONObject profile;
        block15: {
            void id2;
            boolean[] blArray = DBAdapter.$jacocoInit();
            if (id2 == null) {
                blArray[38] = true;
                return null;
            }
            String tName = Table.USER_PROFILES.getName();
            profile = null;
            Object var5_5 = null;
            try {
                void db;
                blArray[39] = true;
                SQLiteDatabase sQLiteDatabase = this.dbHelper.getReadableDatabase();
                blArray[40] = true;
                cursor = db.query(tName, null, "_id =?", new String[]{id2}, null, null, null);
                blArray[41] = true;
                if (cursor == null) {
                    blArray[42] = true;
                    break block15;
                }
                if (!cursor.moveToFirst()) {
                    blArray[43] = true;
                    break block15;
                }
                try {
                    blArray[44] = true;
                    profile = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    blArray[45] = true;
                }
                catch (JSONException jSONException) {
                    blArray[46] = true;
                }
            }
            catch (SQLiteException db) {
                try {
                    void e;
                    blArray[50] = true;
                    this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", (Throwable)e);
                    blArray[51] = true;
                }
                catch (Throwable throwable) {
                    this.dbHelper.close();
                    if (cursor == null) {
                        blArray[55] = true;
                    } else {
                        blArray[56] = true;
                        cursor.close();
                        blArray[57] = true;
                    }
                    blArray[58] = true;
                    throw throwable;
                }
                this.dbHelper.close();
                if (cursor == null) {
                    blArray[52] = true;
                } else {
                    blArray[53] = true;
                    cursor.close();
                    blArray[54] = true;
                }
            }
        }
        this.dbHelper.close();
        if (cursor == null) {
            blArray[47] = true;
        } else {
            blArray[48] = true;
            cursor.close();
            blArray[49] = true;
        }
        blArray[59] = true;
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized long getLastUninstallTimestamp() {
        long timestamp;
        Cursor cursor;
        block12: {
            boolean[] blArray = DBAdapter.$jacocoInit();
            String tName = Table.UNINSTALL_TS.getName();
            cursor = null;
            long l = 0L;
            try {
                void db;
                blArray[60] = true;
                SQLiteDatabase sQLiteDatabase = this.dbHelper.getReadableDatabase();
                blArray[61] = true;
                cursor = db.query(tName, null, null, null, null, null, "created_at DESC", "1");
                blArray[62] = true;
                if (cursor == null) {
                    blArray[63] = true;
                    break block12;
                }
                if (!cursor.moveToFirst()) {
                    blArray[64] = true;
                    break block12;
                }
                blArray[65] = true;
                timestamp = cursor.getLong(cursor.getColumnIndex(KEY_CREATED_AT));
                blArray[66] = true;
            }
            catch (SQLiteException db) {
                try {
                    void e;
                    blArray[70] = true;
                    this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", (Throwable)e);
                    blArray[71] = true;
                }
                catch (Throwable throwable) {
                    this.dbHelper.close();
                    if (cursor == null) {
                        blArray[75] = true;
                    } else {
                        blArray[76] = true;
                        cursor.close();
                        blArray[77] = true;
                    }
                    blArray[78] = true;
                    throw throwable;
                }
                this.dbHelper.close();
                if (cursor == null) {
                    blArray[72] = true;
                } else {
                    blArray[73] = true;
                    cursor.close();
                    blArray[74] = true;
                }
            }
        }
        this.dbHelper.close();
        if (cursor == null) {
            blArray[67] = true;
        } else {
            blArray[68] = true;
            cursor.close();
            blArray[69] = true;
        }
        blArray[79] = true;
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @WorkerThread
    public synchronized ArrayList<CTMessageDAO> getMessages(String string) {
        CTMessageDAO cTMessageDAO;
        void tName;
        boolean[] blArray = DBAdapter.$jacocoInit();
        String string2 = Table.INBOX_MESSAGES.getName();
        blArray[80] = true;
        ArrayList arrayList = new ArrayList();
        try {
            void messageDAOArrayList;
            void userId;
            blArray[81] = true;
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            blArray[82] = true;
            Cursor cursor = db.query((String)tName, null, "messageUser =?", new String[]{userId}, null, null, "created_at DESC");
            if (cursor == null) {
                blArray[83] = true;
            } else {
                blArray[84] = true;
                while (cursor.moveToNext()) {
                    void ctMessageDAO;
                    blArray[85] = true;
                    cTMessageDAO = new CTMessageDAO();
                    blArray[86] = true;
                    ctMessageDAO.setId(cursor.getString(cursor.getColumnIndex(_ID)));
                    blArray[87] = true;
                    ctMessageDAO.setJsonData(new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA))));
                    blArray[88] = true;
                    ctMessageDAO.setWzrkParams(new JSONObject(cursor.getString(cursor.getColumnIndex(WZRKPARAMS))));
                    blArray[89] = true;
                    ctMessageDAO.setDate(cursor.getLong(cursor.getColumnIndex(KEY_CREATED_AT)));
                    blArray[90] = true;
                    ctMessageDAO.setExpires(cursor.getLong(cursor.getColumnIndex(EXPIRES)));
                    blArray[91] = true;
                    ctMessageDAO.setRead(cursor.getInt(cursor.getColumnIndex(IS_READ)));
                    blArray[92] = true;
                    ctMessageDAO.setUserId(cursor.getString(cursor.getColumnIndex(USER_ID)));
                    blArray[93] = true;
                    ctMessageDAO.setTags(cursor.getString(cursor.getColumnIndex(TAGS)));
                    blArray[94] = true;
                    ctMessageDAO.setCampaignId(cursor.getString(cursor.getColumnIndex(CAMPAIGN)));
                    blArray[95] = true;
                    messageDAOArrayList.add(ctMessageDAO);
                    blArray[96] = true;
                }
                cursor.close();
                blArray[97] = true;
            }
            cTMessageDAO = messageDAOArrayList;
            blArray[98] = true;
        }
        catch (SQLiteException db) {
            void e2333332;
            blArray[100] = true;
            this.getConfigLogger().verbose("Error retrieving records from " + (String)tName, (Throwable)e2333332);
            ArrayList<CTMessageDAO> arrayList2 = null;
            blArray[101] = true;
            this.dbHelper.close();
            blArray[102] = true;
            return arrayList2;
        }
        catch (JSONException e2333332) {
            blArray[103] = true;
            this.getConfigLogger().verbose("Error retrieving records from " + (String)tName, e2333332.getMessage());
            ArrayList<CTMessageDAO> arrayList3 = null;
            blArray[104] = true;
            {
                catch (Throwable throwable) {
                    this.dbHelper.close();
                    blArray[106] = true;
                    throw throwable;
                }
            }
            this.dbHelper.close();
            blArray[105] = true;
            return arrayList3;
        }
        this.dbHelper.close();
        blArray[99] = true;
        return cTMessageDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    public synchronized boolean markReadMessageForId(String string, String string2) {
        boolean bl;
        void userId;
        void messageId;
        block8: {
            block7: {
                block6: {
                    boolean[] blArray = DBAdapter.$jacocoInit();
                    if (messageId != null) break block6;
                    blArray[107] = true;
                    break block7;
                }
                if (userId != null) break block8;
                blArray[108] = true;
            }
            blArray[109] = true;
            return false;
        }
        String string3 = Table.INBOX_MESSAGES.getName();
        try {
            void db;
            void cv;
            blArray[110] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[111] = true;
            ContentValues contentValues = new ContentValues();
            blArray[112] = true;
            cv.put(IS_READ, Integer.valueOf(1));
            blArray[113] = true;
            db.update(Table.INBOX_MESSAGES.getName(), (ContentValues)cv, "_id = ? AND messageUser = ?", new String[]{messageId, userId});
            bl = true;
            blArray[114] = true;
        }
        catch (SQLiteException db) {
            boolean bl2;
            try {
                void e;
                void tName;
                blArray[116] = true;
                this.getConfigLogger().verbose("Error removing stale records from " + (String)tName, (Throwable)e);
                bl2 = false;
                blArray[117] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[119] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[118] = true;
            return bl2;
        }
        this.dbHelper.close();
        blArray[115] = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void removeUserProfile(String string) {
        void tableName;
        void id2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (id2 == null) {
            blArray[120] = true;
            return;
        }
        String string2 = Table.USER_PROFILES.getName();
        try {
            void db;
            blArray[121] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[122] = true;
            db.delete((String)tableName, "_id = ?", new String[]{id2});
            blArray[123] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[125] = true;
                this.getConfigLogger().verbose("Error removing user profile from " + (String)tableName + " Recreating DB");
                blArray[126] = true;
                this.dbHelper.deleteDatabase();
                blArray[127] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[129] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[128] = true;
        }
        this.dbHelper.close();
        blArray[124] = true;
        blArray[130] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void storeUninstallTimestamp() {
        void tableName;
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (!this.belowMemThreshold()) {
            blArray[131] = true;
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            blArray[132] = true;
            return;
        }
        String string = Table.UNINSTALL_TS.getName();
        try {
            void db;
            void cv;
            blArray[133] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[134] = true;
            ContentValues contentValues = new ContentValues();
            blArray[135] = true;
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            blArray[136] = true;
            db.insert((String)tableName, null, (ContentValues)cv);
            blArray[137] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[139] = true;
                this.getConfigLogger().verbose("Error adding data to table " + (String)tableName + " Recreating DB");
                blArray[140] = true;
                this.dbHelper.deleteDatabase();
                blArray[141] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[143] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[142] = true;
        }
        this.dbHelper.close();
        blArray[138] = true;
        blArray[144] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    public synchronized long storeUserProfile(String string, JSONObject jSONObject) {
        long ret;
        void id2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (id2 == null) {
            blArray[145] = true;
            return -1L;
        }
        if (!this.belowMemThreshold()) {
            blArray[146] = true;
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            blArray[147] = true;
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getName();
        long l = -1L;
        try {
            void db;
            void obj;
            void cv;
            blArray[148] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[149] = true;
            ContentValues contentValues = new ContentValues();
            blArray[150] = true;
            cv.put(KEY_DATA, obj.toString());
            blArray[151] = true;
            cv.put(_ID, (String)id2);
            blArray[152] = true;
            ret = db.insertWithOnConflict(tableName, null, (ContentValues)cv, 5);
            blArray[153] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[155] = true;
                this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
                blArray[156] = true;
                this.dbHelper.deleteDatabase();
                blArray[157] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[159] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[158] = true;
        }
        this.dbHelper.close();
        blArray[154] = true;
        blArray[160] = true;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    public synchronized void upsertMessages(ArrayList<CTMessageDAO> arrayList) {
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (!this.belowMemThreshold()) {
            blArray[162] = true;
            Logger.v("There is not enough space left on the device to store data, data discarded");
            blArray[163] = true;
            return;
        }
        blArray[161] = true;
        try {
            void inboxMessages;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[164] = true;
            Iterator iterator = inboxMessages.iterator();
            blArray[165] = true;
            while (iterator.hasNext()) {
                void db;
                void messageDAO;
                void cv;
                CTMessageDAO cTMessageDAO = (CTMessageDAO)iterator.next();
                blArray[166] = true;
                ContentValues contentValues = new ContentValues();
                blArray[167] = true;
                cv.put(_ID, messageDAO.getId());
                blArray[168] = true;
                cv.put(KEY_DATA, messageDAO.getJsonData().toString());
                blArray[169] = true;
                cv.put(WZRKPARAMS, messageDAO.getWzrkParams().toString());
                blArray[170] = true;
                cv.put(CAMPAIGN, messageDAO.getCampaignId());
                blArray[171] = true;
                cv.put(TAGS, messageDAO.getTags());
                blArray[172] = true;
                cv.put(IS_READ, Integer.valueOf(messageDAO.isRead()));
                blArray[173] = true;
                cv.put(EXPIRES, Long.valueOf(messageDAO.getExpires()));
                blArray[174] = true;
                cv.put(KEY_CREATED_AT, Long.valueOf(messageDAO.getDate()));
                blArray[175] = true;
                cv.put(USER_ID, messageDAO.getUserId());
                blArray[176] = true;
                db.insertWithOnConflict(Table.INBOX_MESSAGES.getName(), null, (ContentValues)cv, 5);
                blArray[177] = true;
            }
        }
        catch (SQLiteException db) {
            try {
                blArray[179] = true;
                this.getConfigLogger().verbose("Error adding data to table " + Table.INBOX_MESSAGES.getName());
                blArray[180] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[182] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[181] = true;
        }
        this.dbHelper.close();
        blArray[178] = true;
        blArray[183] = true;
    }

    synchronized void cleanUpPushNotifications() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        this.cleanInternal(Table.PUSH_NOTIFICATIONS, 0L);
        blArray[184] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    synchronized void cleanupEventsFromLastId(String string, Table table) {
        void tName;
        void table2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        String string2 = table2.getName();
        try {
            void lastId;
            void db;
            blArray[185] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[186] = true;
            db.delete((String)tName, "_id <= " + (String)lastId, null);
            blArray[187] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[189] = true;
                this.getConfigLogger().verbose("Error removing sent data from table " + (String)tName + " Recreating DB");
                blArray[190] = true;
                this.deleteDB();
                blArray[191] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[193] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[192] = true;
        }
        this.dbHelper.close();
        blArray[188] = true;
        blArray[194] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void storePushNotificationId(String var1_1, long var2_2) {
        block6: {
            var4_3 = DBAdapter.$jacocoInit();
            if (id == null) {
                var4_3[195] = true;
                return;
            }
            if (!this.belowMemThreshold()) {
                var4_3[196] = true;
                this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
                var4_3[197] = true;
                return;
            }
            tableName = Table.PUSH_NOTIFICATIONS.getName();
            if (ttl <= 0L) break block6;
            var4_3[198] = true;
            ** GOTO lbl19
        }
        var4_3[199] = true;
        ttl = System.currentTimeMillis() + 345600000L;
        try {
            var4_3[200] = true;
lbl19:
            // 2 sources

            var6_5 = this.dbHelper.getWritableDatabase();
            var4_3[201] = true;
            var7_7 = new ContentValues();
            var4_3[202] = true;
            cv.put("data", (String)id);
            var4_3[203] = true;
            cv.put("created_at", Long.valueOf(ttl));
            var4_3[204] = true;
            cv.put("isRead", Integer.valueOf(0));
            var4_3[205] = true;
            db.insert(tableName, null, (ContentValues)cv);
            this.rtlDirtyFlag = true;
            var4_3[206] = true;
            Logger.v("Stored PN - " + (String)id + " with TTL - " + ttl);
            var4_3[207] = true;
        }
        catch (SQLiteException db) {
            try {
                var4_3[209] = true;
                this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
                var4_3[210] = true;
                this.dbHelper.deleteDatabase();
                var4_3[211] = true;
            }
            catch (Throwable var8_8) {
                this.dbHelper.close();
                var4_3[213] = true;
                throw var8_8;
            }
            this.dbHelper.close();
            var4_3[212] = true;
        }
        this.dbHelper.close();
        var4_3[208] = true;
        var4_3[214] = true;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void cleanupStaleEvents(Table table) {
        void table2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        this.cleanInternal((Table)table2, 432000000L);
        blArray[215] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized JSONObject fetchEvents(Table var1_1, int var2_2) {
        var3_3 = DBAdapter.$jacocoInit();
        tName = table.getName();
        cursor = null;
        var6_6 = null;
        var3_3[216] = true;
        var7_7 = new JSONArray();
        try {
            var3_3[217] = true;
            var8_8 = this.dbHelper.getReadableDatabase();
            var3_3[218] = true;
            cursor = db.query(tName, null, null, null, null, null, "created_at ASC", String.valueOf((int)limit));
            var3_3[219] = true;
            while (cursor.moveToNext()) {
                block17: {
                    var3_3[220] = true;
                    if (cursor.isLast()) break block17;
                    var3_3[221] = true;
                    ** GOTO lbl23
                }
                var3_3[222] = true;
                lastId = cursor.getString(cursor.getColumnIndex("_id"));
                try {
                    var3_3[223] = true;
lbl23:
                    // 2 sources

                    var9_11 = new JSONObject(cursor.getString(cursor.getColumnIndex("data")));
                    var3_3[224] = true;
                    events.put((Object)j);
                    var3_3[225] = true;
                }
                catch (JSONException var9_12) {
                    var3_3[226] = true;
                }
            }
        }
        catch (SQLiteException db) {
            try {
                var3_3[230] = true;
                this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", (Throwable)e);
                lastId = null;
                var3_3[231] = true;
            }
            catch (Throwable var10_13) {
                this.dbHelper.close();
                if (cursor == null) {
                    var3_3[235] = true;
                } else {
                    var3_3[236] = true;
                    cursor.close();
                    var3_3[237] = true;
                }
                var3_3[238] = true;
                throw var10_13;
            }
            this.dbHelper.close();
            if (cursor == null) {
                var3_3[232] = true;
            } else {
                var3_3[233] = true;
                cursor.close();
                var3_3[234] = true;
            }
        }
        this.dbHelper.close();
        if (cursor == null) {
            var3_3[227] = true;
        } else {
            var3_3[228] = true;
            cursor.close();
            var3_3[229] = true;
        }
        if (lastId == null) {
            var3_3[239] = true;
        } else {
            try {
                var3_3[240] = true;
                e = new JSONObject();
                var3_3[241] = true;
                ret.put(lastId, (Object)events);
                var3_3[242] = true;
                return ret;
            }
            catch (JSONException var8_10) {
                var3_3[243] = true;
            }
        }
        var3_3[244] = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    public synchronized void updatePushNotificationIds(String[] stringArray) {
        void ids;
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (((void)ids).length == 0) {
            blArray[245] = true;
            return;
        }
        if (!this.belowMemThreshold()) {
            blArray[247] = true;
            Logger.v("There is not enough space left on the device to store data, data discarded");
            blArray[248] = true;
            return;
        }
        blArray[246] = true;
        try {
            void db;
            void i;
            void questionMarksBuilder;
            void cv;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[249] = true;
            ContentValues contentValues = new ContentValues();
            blArray[250] = true;
            cv.put(IS_READ, Integer.valueOf(1));
            blArray[251] = true;
            StringBuilder stringBuilder = new StringBuilder();
            blArray[252] = true;
            questionMarksBuilder.append("?");
            boolean bl = false;
            blArray[253] = true;
            while (i < ((void)ids).length - 1) {
                blArray[254] = true;
                questionMarksBuilder.append(", ?");
                ++i;
                blArray[255] = true;
            }
            blArray[256] = true;
            blArray[257] = true;
            db.update(Table.PUSH_NOTIFICATIONS.getName(), (ContentValues)cv, "data IN ( " + questionMarksBuilder.toString() + " )", (String[])ids);
            this.rtlDirtyFlag = false;
            blArray[258] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[260] = true;
                blArray[261] = true;
                this.getConfigLogger().verbose("Error adding data to table " + Table.PUSH_NOTIFICATIONS.getName() + " Recreating DB");
                blArray[262] = true;
                this.dbHelper.deleteDatabase();
                blArray[263] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[265] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[264] = true;
        }
        this.dbHelper.close();
        blArray[259] = true;
        blArray[266] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    synchronized int storeObject(JSONObject jSONObject, Table table) {
        long count;
        void table2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (!this.belowMemThreshold()) {
            blArray[267] = true;
            Logger.v("There is not enough space left on the device to store data, data discarded");
            blArray[268] = true;
            return -2;
        }
        String tableName = table2.getName();
        long l = -1L;
        try {
            void statement;
            void sql;
            void db;
            void obj;
            void cv;
            blArray[269] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[270] = true;
            ContentValues contentValues = new ContentValues();
            blArray[271] = true;
            cv.put(KEY_DATA, obj.toString());
            blArray[272] = true;
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            blArray[273] = true;
            db.insert(tableName, null, (ContentValues)cv);
            blArray[274] = true;
            String string = "SELECT COUNT(*) FROM " + tableName;
            blArray[275] = true;
            SQLiteStatement sQLiteStatement = db.compileStatement((String)sql);
            blArray[276] = true;
            count = statement.simpleQueryForLong();
            blArray[277] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[279] = true;
                this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
                blArray[280] = true;
                this.dbHelper.deleteDatabase();
                blArray[281] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[283] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[282] = true;
        }
        this.dbHelper.close();
        blArray[278] = true;
        blArray[284] = true;
        return (int)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    synchronized void removeEvents(Table table) {
        void tName;
        void table2;
        boolean[] blArray = DBAdapter.$jacocoInit();
        String string = table2.getName();
        try {
            void db;
            blArray[285] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[286] = true;
            db.delete((String)tName, null, null);
            blArray[287] = true;
        }
        catch (SQLiteException db) {
            try {
                blArray[289] = true;
                this.getConfigLogger().verbose("Error removing all events from table " + (String)tName + " Recreating DB");
                blArray[290] = true;
                this.deleteDB();
                blArray[291] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[293] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[292] = true;
        }
        this.dbHelper.close();
        blArray[288] = true;
        blArray[294] = true;
    }

    @WorkerThread
    private boolean belowMemThreshold() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[295] = true;
        return this.dbHelper.belowMemThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void cleanInternal(Table table, long l) {
        void tName;
        void table2;
        void expiration;
        boolean[] blArray = DBAdapter.$jacocoInit();
        long l2 = (System.currentTimeMillis() - expiration) / 1000L;
        blArray[296] = true;
        String string = table2.getName();
        try {
            void time;
            void db;
            blArray[297] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            blArray[298] = true;
            db.delete((String)tName, "created_at <= " + (long)time, null);
            blArray[299] = true;
        }
        catch (SQLiteException db) {
            try {
                void e;
                blArray[301] = true;
                this.getConfigLogger().verbose("Error removing stale event records from " + (String)tName + ". Recreating DB.", (Throwable)e);
                blArray[302] = true;
                this.deleteDB();
                blArray[303] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                blArray[305] = true;
                throw throwable;
            }
            this.dbHelper.close();
            blArray[304] = true;
        }
        this.dbHelper.close();
        blArray[300] = true;
        blArray[306] = true;
    }

    private void deleteDB() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        this.dbHelper.deleteDatabase();
        blArray[307] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized String fetchPushNotificationId(String string) {
        String pushId;
        boolean[] blArray = DBAdapter.$jacocoInit();
        String tName = Table.PUSH_NOTIFICATIONS.getName();
        Cursor cursor = null;
        String string2 = "";
        try {
            void id2;
            void db;
            blArray[308] = true;
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getReadableDatabase();
            blArray[309] = true;
            cursor = db.query(tName, null, "data =?", new String[]{id2}, null, null, null);
            blArray[310] = true;
            if (cursor == null) {
                blArray[311] = true;
            } else if (!cursor.moveToFirst()) {
                blArray[312] = true;
            } else {
                blArray[313] = true;
                pushId = cursor.getString(cursor.getColumnIndex(KEY_DATA));
                blArray[314] = true;
            }
            Logger.v("Fetching PID for check - " + pushId);
            blArray[315] = true;
        }
        catch (SQLiteException db) {
            try {
                void e;
                blArray[319] = true;
                this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", (Throwable)e);
                blArray[320] = true;
            }
            catch (Throwable throwable) {
                this.dbHelper.close();
                if (cursor == null) {
                    blArray[324] = true;
                } else {
                    blArray[325] = true;
                    cursor.close();
                    blArray[326] = true;
                }
                blArray[327] = true;
                throw throwable;
            }
            this.dbHelper.close();
            if (cursor == null) {
                blArray[321] = true;
            } else {
                blArray[322] = true;
                cursor.close();
                blArray[323] = true;
            }
        }
        this.dbHelper.close();
        if (cursor == null) {
            blArray[316] = true;
        } else {
            blArray[317] = true;
            cursor.close();
            blArray[318] = true;
        }
        blArray[328] = true;
        return pushId;
    }

    private Logger getConfigLogger() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[329] = true;
        return this.config.getLogger();
    }

    private static String getDatabaseName(CleverTapInstanceConfig cleverTapInstanceConfig) {
        String string;
        CleverTapInstanceConfig config;
        boolean[] blArray = DBAdapter.$jacocoInit();
        if (config.isDefaultInstance()) {
            string = DATABASE_NAME;
            blArray[330] = true;
        } else {
            string = "clevertap_" + config.getAccountId();
            blArray[331] = true;
        }
        blArray[332] = true;
        return string;
    }

    static /* synthetic */ String access$000() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[333] = true;
        return CREATE_EVENTS_TABLE;
    }

    static /* synthetic */ String access$100() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[334] = true;
        return CREATE_PROFILE_EVENTS_TABLE;
    }

    static /* synthetic */ String access$200() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[335] = true;
        return CREATE_USER_PROFILES_TABLE;
    }

    static /* synthetic */ String access$300() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[336] = true;
        return CREATE_INBOX_MESSAGES_TABLE;
    }

    static /* synthetic */ String access$400() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[337] = true;
        return CREATE_PUSH_NOTIFICATIONS_TABLE;
    }

    static /* synthetic */ String access$500() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[338] = true;
        return CREATE_UNINSTALL_TS_TABLE;
    }

    static /* synthetic */ String access$600() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[339] = true;
        return CREATE_NOTIFICATION_VIEWED_TABLE;
    }

    static /* synthetic */ String access$700() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[340] = true;
        return EVENTS_TIME_INDEX;
    }

    static /* synthetic */ String access$800() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[341] = true;
        return PROFILE_EVENTS_TIME_INDEX;
    }

    static /* synthetic */ String access$900() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[342] = true;
        return UNINSTALL_TS_INDEX;
    }

    static /* synthetic */ String access$1000() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[343] = true;
        return PUSH_NOTIFICATIONS_TIME_INDEX;
    }

    static /* synthetic */ String access$1100() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[344] = true;
        return INBOX_MESSAGES_COMP_ID_USERID_INDEX;
    }

    static /* synthetic */ String access$1200() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[345] = true;
        return NOTIFICATION_VIEWED_INDEX;
    }

    static /* synthetic */ String access$1300() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[346] = true;
        return DROP_TABLE_UNINSTALL_TS;
    }

    static /* synthetic */ String access$1400() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[347] = true;
        return DROP_TABLE_INBOX_MESSAGES;
    }

    static /* synthetic */ String access$1500() {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[348] = true;
        return DROP_TABLE_PUSH_NOTIFICATION_VIEWED;
    }

    static {
        boolean[] blArray = DBAdapter.$jacocoInit();
        blArray[349] = true;
        CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL);";
        blArray[350] = true;
        blArray[351] = true;
        CREATE_PROFILE_EVENTS_TABLE = "CREATE TABLE " + Table.PROFILE_EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL);";
        blArray[352] = true;
        blArray[353] = true;
        CREATE_USER_PROFILES_TABLE = "CREATE TABLE " + Table.USER_PROFILES.getName() + " (_id STRING UNIQUE PRIMARY KEY, " + KEY_DATA + " STRING NOT NULL);";
        blArray[354] = true;
        blArray[355] = true;
        CREATE_INBOX_MESSAGES_TABLE = "CREATE TABLE " + Table.INBOX_MESSAGES.getName() + " (_id STRING NOT NULL, " + KEY_DATA + " TEXT NOT NULL, " + WZRKPARAMS + " TEXT NOT NULL, " + CAMPAIGN + " STRING NOT NULL, " + TAGS + " TEXT NOT NULL, " + IS_READ + " INTEGER NOT NULL DEFAULT 0, " + EXPIRES + " INTEGER NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL, " + USER_ID + " STRING NOT NULL);";
        blArray[356] = true;
        blArray[357] = true;
        INBOX_MESSAGES_COMP_ID_USERID_INDEX = "CREATE UNIQUE INDEX IF NOT EXISTS userid_id_idx ON " + Table.INBOX_MESSAGES.getName() + " (" + USER_ID + "," + _ID + ");";
        blArray[358] = true;
        blArray[359] = true;
        EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[360] = true;
        blArray[361] = true;
        PROFILE_EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PROFILE_EVENTS.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[362] = true;
        blArray[363] = true;
        CREATE_PUSH_NOTIFICATIONS_TABLE = "CREATE TABLE " + Table.PUSH_NOTIFICATIONS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL," + IS_READ + " INTEGER NOT NULL);";
        blArray[364] = true;
        blArray[365] = true;
        PUSH_NOTIFICATIONS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PUSH_NOTIFICATIONS.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[366] = true;
        blArray[367] = true;
        CREATE_UNINSTALL_TS_TABLE = "CREATE TABLE " + Table.UNINSTALL_TS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_CREATED_AT + " INTEGER NOT NULL);";
        blArray[368] = true;
        blArray[369] = true;
        UNINSTALL_TS_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.UNINSTALL_TS.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[370] = true;
        blArray[371] = true;
        CREATE_NOTIFICATION_VIEWED_TABLE = "CREATE TABLE " + Table.PUSH_NOTIFICATION_VIEWED.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL);";
        blArray[372] = true;
        blArray[373] = true;
        NOTIFICATION_VIEWED_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PUSH_NOTIFICATION_VIEWED.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[374] = true;
        blArray[375] = true;
        DROP_TABLE_UNINSTALL_TS = "DROP TABLE IF EXISTS " + Table.UNINSTALL_TS.getName();
        blArray[376] = true;
        blArray[377] = true;
        DROP_TABLE_INBOX_MESSAGES = "DROP TABLE IF EXISTS " + Table.INBOX_MESSAGES.getName();
        blArray[378] = true;
        blArray[379] = true;
        DROP_TABLE_PUSH_NOTIFICATION_VIEWED = "DROP TABLE IF EXISTS " + Table.PUSH_NOTIFICATION_VIEWED.getName();
        blArray[380] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)3057989661870781549L, (String)"com/clevertap/android/sdk/db/DBAdapter", (int)381);
        }
        return blArray;
    }

    public static final class Table
    extends Enum<Table> {
        public static final /* enum */ Table EVENTS;
        public static final /* enum */ Table PROFILE_EVENTS;
        public static final /* enum */ Table USER_PROFILES;
        public static final /* enum */ Table INBOX_MESSAGES;
        public static final /* enum */ Table PUSH_NOTIFICATIONS;
        public static final /* enum */ Table UNINSTALL_TS;
        public static final /* enum */ Table PUSH_NOTIFICATION_VIEWED;
        private final String tableName;
        private static final /* synthetic */ Table[] $VALUES;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public static Table[] values() {
            boolean[] blArray = Table.$jacocoInit();
            blArray[0] = true;
            return (Table[])$VALUES.clone();
        }

        public static Table valueOf(String string) {
            String name;
            boolean[] blArray = Table.$jacocoInit();
            blArray[1] = true;
            return Enum.valueOf(Table.class, name);
        }

        /*
         * WARNING - void declaration
         */
        private Table(String string2) {
            void name;
            boolean[] blArray = Table.$jacocoInit();
            this.tableName = name;
            blArray[2] = true;
        }

        public String getName() {
            boolean[] blArray = Table.$jacocoInit();
            blArray[3] = true;
            return this.tableName;
        }

        static {
            boolean[] blArray = Table.$jacocoInit();
            EVENTS = new Table("events");
            blArray[4] = true;
            PROFILE_EVENTS = new Table("profileEvents");
            blArray[5] = true;
            USER_PROFILES = new Table("userProfiles");
            blArray[6] = true;
            INBOX_MESSAGES = new Table("inboxMessages");
            blArray[7] = true;
            PUSH_NOTIFICATIONS = new Table("pushNotifications");
            blArray[8] = true;
            UNINSTALL_TS = new Table("uninstallTimestamp");
            blArray[9] = true;
            PUSH_NOTIFICATION_VIEWED = new Table("notificationViewed");
            $VALUES = new Table[]{EVENTS, PROFILE_EVENTS, USER_PROFILES, INBOX_MESSAGES, PUSH_NOTIFICATIONS, UNINSTALL_TS, PUSH_NOTIFICATION_VIEWED};
            blArray[10] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-2304591065878164390L, (String)"com/clevertap/android/sdk/db/DBAdapter$Table", (int)11);
            }
            return blArray;
        }
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private final int DB_LIMIT = 0x1400000;
        private final File databaseFile;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        DatabaseHelper(Context context, String string) {
            void dbName;
            void context2;
            boolean[] blArray = DatabaseHelper.$jacocoInit();
            super((Context)context2, (String)dbName, null, 3);
            this.DB_LIMIT = 0x1400000;
            blArray[0] = true;
            this.databaseFile = context2.getDatabasePath((String)dbName);
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"SQLiteString"})
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            SQLiteStatement sqLiteStatement;
            void db;
            boolean[] blArray = DatabaseHelper.$jacocoInit();
            Logger.v("Creating CleverTap DB");
            blArray[2] = true;
            SQLiteStatement sQLiteStatement = db.compileStatement(DBAdapter.access$000());
            blArray[3] = true;
            Logger.v("Executing - " + DBAdapter.access$000());
            blArray[4] = true;
            sqLiteStatement.execute();
            blArray[5] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$100());
            blArray[6] = true;
            Logger.v("Executing - " + DBAdapter.access$100());
            blArray[7] = true;
            sqLiteStatement.execute();
            blArray[8] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$200());
            blArray[9] = true;
            Logger.v("Executing - " + DBAdapter.access$200());
            blArray[10] = true;
            sqLiteStatement.execute();
            blArray[11] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$300());
            blArray[12] = true;
            Logger.v("Executing - " + DBAdapter.access$300());
            blArray[13] = true;
            sqLiteStatement.execute();
            blArray[14] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$400());
            blArray[15] = true;
            Logger.v("Executing - " + DBAdapter.access$400());
            blArray[16] = true;
            sqLiteStatement.execute();
            blArray[17] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$500());
            blArray[18] = true;
            Logger.v("Executing - " + DBAdapter.access$500());
            blArray[19] = true;
            sqLiteStatement.execute();
            blArray[20] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$600());
            blArray[21] = true;
            Logger.v("Executing - " + DBAdapter.access$600());
            blArray[22] = true;
            sqLiteStatement.execute();
            blArray[23] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$700());
            blArray[24] = true;
            Logger.v("Executing - " + DBAdapter.access$700());
            blArray[25] = true;
            sqLiteStatement.execute();
            blArray[26] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$800());
            blArray[27] = true;
            Logger.v("Executing - " + DBAdapter.access$800());
            blArray[28] = true;
            sqLiteStatement.execute();
            blArray[29] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$900());
            blArray[30] = true;
            Logger.v("Executing - " + DBAdapter.access$900());
            blArray[31] = true;
            sqLiteStatement.execute();
            blArray[32] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$1000());
            blArray[33] = true;
            Logger.v("Executing - " + DBAdapter.access$1000());
            blArray[34] = true;
            sqLiteStatement.execute();
            blArray[35] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$1100());
            blArray[36] = true;
            Logger.v("Executing - " + DBAdapter.access$1100());
            blArray[37] = true;
            sqLiteStatement.execute();
            blArray[38] = true;
            sqLiteStatement = db.compileStatement(DBAdapter.access$1200());
            blArray[39] = true;
            Logger.v("Executing - " + DBAdapter.access$1200());
            blArray[40] = true;
            sqLiteStatement.execute();
            blArray[41] = true;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"SQLiteString"})
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            void oldVersion;
            void newVersion;
            boolean[] blArray = DatabaseHelper.$jacocoInit();
            Logger.v("Upgrading CleverTap DB to version " + (int)newVersion);
            switch (oldVersion) {
                default: {
                    blArray[42] = true;
                    break;
                }
                case 1: {
                    SQLiteStatement sqLiteStatement;
                    void db;
                    SQLiteStatement sQLiteStatement = db.compileStatement(DBAdapter.access$1300());
                    blArray[43] = true;
                    Logger.v("Executing - " + DBAdapter.access$1300());
                    blArray[44] = true;
                    sqLiteStatement.execute();
                    blArray[45] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$1400());
                    blArray[46] = true;
                    Logger.v("Executing - " + DBAdapter.access$1400());
                    blArray[47] = true;
                    sqLiteStatement.execute();
                    blArray[48] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$1500());
                    blArray[49] = true;
                    Logger.v("Executing - " + DBAdapter.access$1500());
                    blArray[50] = true;
                    sqLiteStatement.execute();
                    blArray[51] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$300());
                    blArray[52] = true;
                    Logger.v("Executing - " + DBAdapter.access$300());
                    blArray[53] = true;
                    sqLiteStatement.execute();
                    blArray[54] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$400());
                    blArray[55] = true;
                    Logger.v("Executing - " + DBAdapter.access$400());
                    blArray[56] = true;
                    sqLiteStatement.execute();
                    blArray[57] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$500());
                    blArray[58] = true;
                    Logger.v("Executing - " + DBAdapter.access$500());
                    blArray[59] = true;
                    sqLiteStatement.execute();
                    blArray[60] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$600());
                    blArray[61] = true;
                    Logger.v("Executing - " + DBAdapter.access$600());
                    blArray[62] = true;
                    sqLiteStatement.execute();
                    blArray[63] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$900());
                    blArray[64] = true;
                    Logger.v("Executing - " + DBAdapter.access$900());
                    blArray[65] = true;
                    sqLiteStatement.execute();
                    blArray[66] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$1000());
                    blArray[67] = true;
                    Logger.v("Executing - " + DBAdapter.access$1000());
                    blArray[68] = true;
                    sqLiteStatement.execute();
                    blArray[69] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$1100());
                    blArray[70] = true;
                    Logger.v("Executing - " + DBAdapter.access$1100());
                    blArray[71] = true;
                    sqLiteStatement.execute();
                    blArray[72] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$1200());
                    blArray[73] = true;
                    Logger.v("Executing - " + DBAdapter.access$1200());
                    blArray[74] = true;
                    sqLiteStatement.execute();
                    blArray[75] = true;
                    break;
                }
                case 2: {
                    void db;
                    SQLiteStatement sqLiteStatement = db.compileStatement(DBAdapter.access$1500());
                    blArray[76] = true;
                    Logger.v("Executing - " + DBAdapter.access$1500());
                    blArray[77] = true;
                    sqLiteStatement.execute();
                    blArray[78] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$600());
                    blArray[79] = true;
                    Logger.v("Executing - " + DBAdapter.access$600());
                    blArray[80] = true;
                    sqLiteStatement.execute();
                    blArray[81] = true;
                    sqLiteStatement = db.compileStatement(DBAdapter.access$1200());
                    blArray[82] = true;
                    Logger.v("Executing - " + DBAdapter.access$1200());
                    blArray[83] = true;
                    sqLiteStatement.execute();
                    blArray[84] = true;
                }
            }
            blArray[85] = true;
        }

        @SuppressLint(value={"UsableSpace"})
        boolean belowMemThreshold() {
            boolean[] blArray = DatabaseHelper.$jacocoInit();
            if (this.databaseFile.exists()) {
                boolean bl;
                blArray[86] = true;
                if (Math.max(this.databaseFile.getUsableSpace(), 0x1400000L) >= this.databaseFile.length()) {
                    bl = blArray[87] = true;
                } else {
                    bl = false;
                    blArray[88] = true;
                }
                blArray[89] = true;
                return bl;
            }
            blArray[90] = true;
            return true;
        }

        void deleteDatabase() {
            boolean[] blArray = DatabaseHelper.$jacocoInit();
            this.close();
            blArray[91] = true;
            this.databaseFile.delete();
            blArray[92] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)4764227572868712859L, (String)"com/clevertap/android/sdk/db/DBAdapter$DatabaseHelper", (int)93);
            }
            return blArray;
        }
    }
}

