/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.customviews;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxBaseMessageViewHolder;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import org.jacoco.agent.rt.internal_28bab1d.Offline;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MediaPlayerRecyclerView
extends RecyclerView {
    SimpleExoPlayer player;
    private Context appContext;
    private CTInboxBaseMessageViewHolder playingHolder;
    private PlayerView videoSurfaceView;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public MediaPlayerRecyclerView(Context context) {
        void context2;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        super((Context)context2);
        blArray[0] = true;
        this.initialize((Context)context2);
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    public MediaPlayerRecyclerView(Context context, AttributeSet attributeSet) {
        void attrs;
        void context2;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        super((Context)context2, (AttributeSet)attrs);
        blArray[2] = true;
        this.initialize((Context)context2);
        blArray[3] = true;
    }

    /*
     * WARNING - void declaration
     */
    public MediaPlayerRecyclerView(Context context, AttributeSet attributeSet, int n) {
        void defStyleAttr;
        void attrs;
        void context2;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        super((Context)context2, (AttributeSet)attrs, (int)defStyleAttr);
        blArray[4] = true;
        this.initialize((Context)context2);
        blArray[5] = true;
    }

    public void onPausePlayer() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.player == null) {
            blArray[6] = true;
        } else {
            blArray[7] = true;
            this.player.setPlayWhenReady(false);
            blArray[8] = true;
        }
        blArray[9] = true;
    }

    public void onRestartPlayer() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.videoSurfaceView != null) {
            blArray[10] = true;
        } else {
            blArray[11] = true;
            this.initialize(this.appContext);
            blArray[12] = true;
            this.playVideo();
            blArray[13] = true;
        }
        blArray[14] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void playVideo() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.videoSurfaceView == null) {
            blArray[15] = true;
            return;
        }
        CTInboxBaseMessageViewHolder targetHolder = this.findBestVisibleMediaHolder();
        if (targetHolder == null) {
            blArray[16] = true;
            this.stop();
            blArray[17] = true;
            this.removeVideoView();
            blArray[18] = true;
            return;
        }
        if (this.playingHolder == null) {
            blArray[19] = true;
        } else if (!this.playingHolder.itemView.equals(targetHolder.itemView)) {
            blArray[20] = true;
        } else {
            int n;
            void measured;
            void rect;
            blArray[21] = true;
            Rect rect2 = new Rect();
            blArray[22] = true;
            boolean bl = this.playingHolder.itemView.getGlobalVisibleRect((Rect)rect);
            blArray[23] = true;
            if (measured != false) {
                n = rect.height();
                blArray[24] = true;
            } else {
                n = 0;
                blArray[25] = true;
            }
            int visibleHeight = n;
            if (this.player == null) {
                blArray[26] = true;
            } else {
                boolean bl2;
                if (visibleHeight >= 400) {
                    bl2 = blArray[27] = true;
                } else {
                    bl2 = false;
                    blArray[28] = true;
                }
                boolean play = bl2;
                if (play) {
                    blArray[29] = true;
                    if (!this.playingHolder.shouldAutoPlay()) {
                        blArray[30] = true;
                    } else {
                        blArray[31] = true;
                        this.player.setPlayWhenReady(true);
                        blArray[32] = true;
                    }
                } else {
                    this.player.setPlayWhenReady(false);
                    blArray[33] = true;
                }
            }
            blArray[34] = true;
            return;
        }
        this.removeVideoView();
        blArray[35] = true;
        boolean addedVideo = targetHolder.addMediaPlayer(this.videoSurfaceView);
        if (!addedVideo) {
            blArray[36] = true;
        } else {
            this.playingHolder = targetHolder;
            blArray[37] = true;
        }
        blArray[38] = true;
    }

    public void release() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.player == null) {
            blArray[39] = true;
        } else {
            blArray[40] = true;
            this.player.stop();
            blArray[41] = true;
            this.player.release();
            this.player = null;
            blArray[42] = true;
        }
        this.playingHolder = null;
        this.videoSurfaceView = null;
        blArray[43] = true;
    }

    public void removePlayer() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.videoSurfaceView == null) {
            blArray[44] = true;
        } else {
            blArray[45] = true;
            this.removeVideoView();
            this.videoSurfaceView = null;
            blArray[46] = true;
        }
        blArray[47] = true;
    }

    public void stop() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.player == null) {
            blArray[48] = true;
        } else {
            blArray[49] = true;
            this.player.stop();
            blArray[50] = true;
        }
        this.playingHolder = null;
        blArray[51] = true;
    }

    /*
     * WARNING - void declaration
     */
    private CTInboxBaseMessageViewHolder findBestVisibleMediaHolder() {
        CTInboxBaseMessageViewHolder bestHolder;
        void i;
        void startPosition;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        Object var2_2 = null;
        blArray[52] = true;
        int n = ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        blArray[53] = true;
        int endPosition = ((LinearLayoutManager)this.getLayoutManager()).findLastVisibleItemPosition();
        int bestHeight = 0;
        void var6_6 = startPosition;
        blArray[54] = true;
        while (i <= endPosition) {
            void pos;
            void var7_7 = i - startPosition;
            blArray[55] = true;
            View child = this.getChildAt((int)pos);
            if (child == null) {
                blArray[56] = true;
            } else {
                CTInboxBaseMessageViewHolder holder = (CTInboxBaseMessageViewHolder)((Object)child.getTag());
                if (holder == null) {
                    blArray[57] = true;
                } else {
                    blArray[58] = true;
                    if (!holder.needsMediaPlayer()) {
                        blArray[59] = true;
                    } else {
                        int n2;
                        void measured;
                        void rect;
                        Rect rect2 = new Rect();
                        blArray[60] = true;
                        boolean bl = holder.itemView.getGlobalVisibleRect((Rect)rect);
                        blArray[61] = true;
                        if (measured != false) {
                            n2 = rect.height();
                            blArray[62] = true;
                        } else {
                            n2 = 0;
                            blArray[63] = true;
                        }
                        int height = n2;
                        if (height <= bestHeight) {
                            blArray[64] = true;
                        } else {
                            bestHeight = height;
                            bestHolder = holder;
                            blArray[65] = true;
                        }
                    }
                }
            }
            ++i;
            blArray[66] = true;
        }
        blArray[67] = true;
        return bestHolder;
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(Context context) {
        void trackSelector;
        void videoTrackSelectionFactory;
        void artwork;
        void context2;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        this.appContext = context2.getApplicationContext();
        blArray[68] = true;
        this.videoSurfaceView = new PlayerView(this.appContext);
        blArray[69] = true;
        this.videoSurfaceView.setBackgroundColor(0);
        if (CTInboxActivity.orientation == 2) {
            blArray[70] = true;
            this.videoSurfaceView.setResizeMode(3);
            blArray[71] = true;
        } else {
            this.videoSurfaceView.setResizeMode(0);
            blArray[72] = true;
        }
        this.videoSurfaceView.setUseArtwork(true);
        blArray[73] = true;
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)context2.getResources(), (int)R.drawable.ct_audio, null);
        blArray[74] = true;
        this.videoSurfaceView.setDefaultArtwork((Drawable)artwork);
        blArray[75] = true;
        AdaptiveTrackSelection.Factory factory = new AdaptiveTrackSelection.Factory();
        blArray[76] = true;
        DefaultTrackSelector defaultTrackSelector = new DefaultTrackSelector(this.appContext, (ExoTrackSelection.Factory)videoTrackSelectionFactory);
        blArray[77] = true;
        this.player = new SimpleExoPlayer.Builder((Context)context2).setTrackSelector((TrackSelector)trackSelector).build();
        blArray[78] = true;
        this.player.setVolume(0.0f);
        blArray[79] = true;
        this.videoSurfaceView.setUseController(true);
        blArray[80] = true;
        this.videoSurfaceView.setControllerAutoShow(false);
        blArray[81] = true;
        this.videoSurfaceView.setPlayer((Player)this.player);
        blArray[82] = true;
        this.addOnScrollListener(new RecyclerView.OnScrollListener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int n) {
                void newState;
                void recyclerView2;
                boolean[] blArray = 1.$jacocoInit();
                super.onScrollStateChanged((RecyclerView)recyclerView2, (int)newState);
                if (newState != false) {
                    blArray[1] = true;
                } else {
                    blArray[2] = true;
                    this.this$0.playVideo();
                    blArray[3] = true;
                }
                blArray[4] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onScrolled(@NonNull RecyclerView recyclerView, int n, int n2) {
                void dy;
                void dx;
                void recyclerView2;
                boolean[] blArray = 1.$jacocoInit();
                super.onScrolled((RecyclerView)recyclerView2, (int)dx, (int)dy);
                blArray[5] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-4272040060433173685L, (String)"com/clevertap/android/sdk/customviews/MediaPlayerRecyclerView$1", (int)6);
                }
                return blArray;
            }
        });
        blArray[83] = true;
        this.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            public void onChildViewAttachedToWindow(@NonNull View view) {
                boolean[] blArray = 2.$jacocoInit();
                blArray[1] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onChildViewDetachedFromWindow(@NonNull View view) {
                void view2;
                boolean[] blArray = 2.$jacocoInit();
                if (MediaPlayerRecyclerView.access$000(this.this$0) == null) {
                    blArray[2] = true;
                } else if (!MediaPlayerRecyclerView.access$000((MediaPlayerRecyclerView)this.this$0).itemView.equals(view2)) {
                    blArray[3] = true;
                } else {
                    blArray[4] = true;
                    this.this$0.stop();
                    blArray[5] = true;
                }
                blArray[6] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)3553449687608482976L, (String)"com/clevertap/android/sdk/customviews/MediaPlayerRecyclerView$2", (int)7);
                }
                return blArray;
            }
        });
        blArray[84] = true;
        this.player.addListener(new Player.Listener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 3.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onPlaybackStateChanged(int n) {
                void playbackState;
                boolean[] blArray = 3.$jacocoInit();
                switch (playbackState) {
                    default: {
                        blArray[1] = true;
                        break;
                    }
                    case 2: {
                        if (MediaPlayerRecyclerView.access$000(this.this$0) == null) {
                            blArray[2] = true;
                            break;
                        }
                        blArray[3] = true;
                        MediaPlayerRecyclerView.access$000(this.this$0).playerBuffering();
                        blArray[4] = true;
                        break;
                    }
                    case 4: {
                        if (this.this$0.player == null) {
                            blArray[5] = true;
                            break;
                        }
                        blArray[6] = true;
                        this.this$0.player.seekTo(0L);
                        blArray[7] = true;
                        this.this$0.player.setPlayWhenReady(false);
                        blArray[8] = true;
                        if (MediaPlayerRecyclerView.access$100(this.this$0) == null) {
                            blArray[9] = true;
                            break;
                        }
                        blArray[10] = true;
                        MediaPlayerRecyclerView.access$100(this.this$0).showController();
                        blArray[11] = true;
                        break;
                    }
                    case 3: {
                        if (MediaPlayerRecyclerView.access$000(this.this$0) == null) {
                            blArray[12] = true;
                            break;
                        }
                        blArray[13] = true;
                        MediaPlayerRecyclerView.access$000(this.this$0).playerReady();
                        blArray[14] = true;
                        break;
                    }
                }
                blArray[15] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)2744631980155315796L, (String)"com/clevertap/android/sdk/customviews/MediaPlayerRecyclerView$3", (int)16);
                }
                return blArray;
            }
        });
        blArray[85] = true;
    }

    private void removeVideoView() {
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        if (this.videoSurfaceView == null) {
            blArray[86] = true;
            return;
        }
        ViewGroup parent = (ViewGroup)this.videoSurfaceView.getParent();
        if (parent == null) {
            blArray[87] = true;
            return;
        }
        int index = parent.indexOfChild((View)this.videoSurfaceView);
        if (index < 0) {
            blArray[88] = true;
        } else {
            blArray[89] = true;
            parent.removeViewAt(index);
            if (this.player == null) {
                blArray[90] = true;
            } else {
                blArray[91] = true;
                this.player.stop();
                blArray[92] = true;
            }
            if (this.playingHolder == null) {
                blArray[93] = true;
            } else {
                blArray[94] = true;
                this.playingHolder.playerRemoved();
                this.playingHolder = null;
                blArray[95] = true;
            }
        }
        blArray[96] = true;
    }

    static /* synthetic */ CTInboxBaseMessageViewHolder access$000(MediaPlayerRecyclerView mediaPlayerRecyclerView) {
        MediaPlayerRecyclerView x0;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        blArray[97] = true;
        return x0.playingHolder;
    }

    static /* synthetic */ PlayerView access$100(MediaPlayerRecyclerView mediaPlayerRecyclerView) {
        MediaPlayerRecyclerView x0;
        boolean[] blArray = MediaPlayerRecyclerView.$jacocoInit();
        blArray[98] = true;
        return x0.videoSurfaceView;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)3141339927780425347L, (String)"com/clevertap/android/sdk/customviews/MediaPlayerRecyclerView", (int)99);
        }
        return blArray;
    }
}

