/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.app.usage.UsageStatsManager;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Insets;
import android.net.ConnectivityManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationManagerCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.OnSuccessListener;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DeviceInfo {
    private static final String GUID_PREFIX = "__";
    private static final String OS_NAME = "Android";
    static final int SMART_PHONE = 1;
    static final int TABLET = 2;
    static final int TV = 3;
    static final int UNKNOWN = 0;
    static final int NULL = -1;
    static int sDeviceType;
    private final Object adIDLock;
    private boolean adIdRun;
    private DeviceCachedInfo cachedInfo;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final Object deviceIDLock;
    private boolean enableNetworkInfoReporting;
    private String googleAdID;
    private String library;
    private boolean limitAdTracking;
    private final CoreMetaData mCoreMetaData;
    private final ArrayList<ValidationResult> validationResults;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public static int getAppIconAsIntId(Context context) {
        Context context2;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        ApplicationInfo ai = context2.getApplicationInfo();
        blArray[0] = true;
        return ai.icon;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getDeviceType(Context var0) {
        block11: {
            var1_1 = DeviceInfo.$jacocoInit();
            if (DeviceInfo.sDeviceType != -1) {
                var1_1[1] = true;
            } else {
                block10: {
                    try {
                        var1_1[2] = true;
                        var2_2 = (UiModeManager)context.getSystemService("uimode");
                        var1_1[3] = true;
                        if (uiModeManager.getCurrentModeType() == 4) {
                            var1_1[4] = true;
                            DeviceInfo.sDeviceType = 3;
                            return DeviceInfo.sDeviceType;
                        }
                    }
                    catch (Exception uiModeManager) {
                        var1_1[6] = true;
                        Logger.d("Failed to decide whether device is a TV!");
                        var1_1[7] = true;
                        e.printStackTrace();
                        try {
                            var1_1[8] = true;
lbl21:
                            // 2 sources

                            while (true) {
                                if (context.getResources().getBoolean(R.bool.ctIsTablet)) {
                                    v0 = 2;
                                    var1_1[9] = true;
                                } else {
                                    v0 = var1_1[10] = 1;
                                }
                                DeviceInfo.sDeviceType = v0;
                                break block10;
                                break;
                            }
                        }
                        catch (Exception e) {
                            var1_1[12] = true;
                            Logger.d("Failed to decide whether device is a smart phone or tablet!");
                            var1_1[13] = true;
                            e.printStackTrace();
                            DeviceInfo.sDeviceType = 0;
                            var1_1[14] = true;
                            break block11;
                        }
                    }
                    var1_1[5] = true;
                    ** continue;
                }
                var1_1[11] = true;
            }
        }
        var1_1[15] = true;
        return DeviceInfo.sDeviceType;
    }

    /*
     * WARNING - void declaration
     */
    DeviceInfo(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, String string, CoreMetaData coreMetaData) {
        void cleverTapID;
        void coreMetaData2;
        void config;
        void context2;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[16] = true;
        this.adIDLock = new Object();
        this.adIdRun = false;
        blArray[17] = true;
        this.deviceIDLock = new Object();
        this.enableNetworkInfoReporting = false;
        this.googleAdID = null;
        this.limitAdTracking = false;
        blArray[18] = true;
        this.validationResults = new ArrayList();
        this.context = context2;
        this.config = config;
        this.library = null;
        this.mCoreMetaData = coreMetaData2;
        blArray[19] = true;
        this.onInitDeviceInfo((String)cleverTapID);
        blArray[20] = true;
        this.getConfigLogger().verbose(config.getAccountId() + ":async_deviceID", "DeviceInfo() called");
        blArray[21] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void forceNewDeviceID() {
        void deviceID;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        String string = this.generateGUID();
        blArray[22] = true;
        this.forceUpdateDeviceId((String)deviceID);
        blArray[23] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void forceUpdateCustomCleverTapID(String string) {
        void cleverTapID;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        if (Utils.validateCTID((String)cleverTapID)) {
            blArray[24] = true;
            blArray[25] = true;
            this.getConfigLogger().info(this.config.getAccountId(), "Setting CleverTap ID to custom CleverTap ID : " + (String)cleverTapID);
            blArray[26] = true;
            this.forceUpdateDeviceId("__h" + (String)cleverTapID);
            blArray[27] = true;
        } else {
            void error;
            this.setOrGenerateFallbackDeviceID();
            blArray[28] = true;
            this.removeDeviceID();
            blArray[29] = true;
            String string2 = this.recordDeviceError(21, new String[]{cleverTapID, this.getFallBackDeviceID()});
            blArray[30] = true;
            this.getConfigLogger().info(this.config.getAccountId(), (String)error);
            blArray[31] = true;
        }
        blArray[32] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressLint(value={"CommitPrefEdits"})
    public void forceUpdateDeviceId(String string) {
        void id2;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        this.getConfigLogger().verbose(this.config.getAccountId(), "Force updating the device ID to " + (String)id2);
        Object object = this.deviceIDLock;
        synchronized (object) {
            try {
                blArray[33] = true;
                StorageHelper.putString(this.context, this.getDeviceIdStorageKey(), (String)id2);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[34] = true;
                throw throwable;
            }
        }
        blArray[35] = true;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getAppLaunchedFields() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        try {
            void appLaunchFields;
            boolean deviceIsMultiUser;
            boolean bl = false;
            blArray[36] = true;
            if (this.getGoogleAdID() == null) {
                blArray[37] = true;
            } else {
                blArray[38] = true;
                deviceIsMultiUser = new LoginInfoProvider(this.context, this.config, this).deviceIsMultiUser();
                blArray[39] = true;
            }
            JSONObject jSONObject = CTJsonConverter.from(this, this.mCoreMetaData.getLocationFromUser(), this.enableNetworkInfoReporting, deviceIsMultiUser);
            blArray[40] = true;
            if (this.mCoreMetaData.getDirectCallSDKVersion() == 0) {
                blArray[41] = true;
            } else {
                blArray[42] = true;
                appLaunchFields.put("dcv", this.mCoreMetaData.getDirectCallSDKVersion());
                blArray[43] = true;
            }
            blArray[44] = true;
            return appLaunchFields;
        }
        catch (Throwable deviceIsMultiUser) {
            void t;
            blArray[45] = true;
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to construct App Launched event", (Throwable)t);
            blArray[46] = true;
            blArray[47] = true;
            return new JSONObject();
        }
    }

    public String getBluetoothVersion() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[48] = true;
        return DeviceCachedInfo.access$100(this.getDeviceCachedInfo());
    }

    public int getBuild() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[49] = true;
        return DeviceCachedInfo.access$200(this.getDeviceCachedInfo());
    }

    public String getCarrier() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[50] = true;
        return DeviceCachedInfo.access$300(this.getDeviceCachedInfo());
    }

    public Context getContext() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[51] = true;
        return this.context;
    }

    public String getCountryCode() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[52] = true;
        return DeviceCachedInfo.access$400(this.getDeviceCachedInfo());
    }

    public int getDPI() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[53] = true;
        return DeviceCachedInfo.access$500(this.getDeviceCachedInfo());
    }

    public String getDeviceID() {
        String string;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        if (this._getDeviceID() != null) {
            string = this._getDeviceID();
            blArray[54] = true;
        } else {
            string = this.getFallBackDeviceID();
            blArray[55] = true;
        }
        blArray[56] = true;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGoogleAdID() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        Object object = this.adIDLock;
        synchronized (object) {
            try {
                blArray[57] = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[58] = true;
                return this.googleAdID;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[59] = true;
                throw throwable;
            }
        }
    }

    public double getHeight() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[60] = true;
        return DeviceCachedInfo.access$600(this.getDeviceCachedInfo());
    }

    public String getLibrary() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[61] = true;
        return this.library;
    }

    /*
     * WARNING - void declaration
     */
    void setLibrary(String string) {
        void library;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        this.library = library;
        blArray[62] = true;
    }

    public String getManufacturer() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[63] = true;
        return DeviceCachedInfo.access$700(this.getDeviceCachedInfo());
    }

    public String getAppBucket() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[64] = true;
        return DeviceCachedInfo.access$800(this.getDeviceCachedInfo());
    }

    public String getModel() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[65] = true;
        return DeviceCachedInfo.access$900(this.getDeviceCachedInfo());
    }

    public String getNetworkType() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[66] = true;
        return DeviceCachedInfo.access$1000(this.getDeviceCachedInfo());
    }

    public boolean getNotificationsEnabledForUser() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[67] = true;
        return DeviceCachedInfo.access$1100(this.getDeviceCachedInfo());
    }

    public String getOsName() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[68] = true;
        return DeviceCachedInfo.access$1200(this.getDeviceCachedInfo());
    }

    public String getOsVersion() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[69] = true;
        return DeviceCachedInfo.access$1300(this.getDeviceCachedInfo());
    }

    public int getSdkVersion() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[70] = true;
        return DeviceCachedInfo.access$1400(this.getDeviceCachedInfo());
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<ValidationResult> getValidationResults() {
        void tempValidationResults;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        ArrayList arrayList = (ArrayList)this.validationResults.clone();
        blArray[71] = true;
        this.validationResults.clear();
        blArray[72] = true;
        return tempValidationResults;
    }

    public String getVersionName() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[73] = true;
        return DeviceCachedInfo.access$1500(this.getDeviceCachedInfo());
    }

    public double getWidth() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[74] = true;
        return DeviceCachedInfo.access$1600(this.getDeviceCachedInfo());
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"MissingPermission"})
    public Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        Object var2_2 = null;
        try {
            void pm;
            blArray[75] = true;
            PackageManager packageManager = this.context.getPackageManager();
            blArray[76] = true;
            int hasBluetoothPermission = pm.checkPermission("android.permission.BLUETOOTH", this.context.getPackageName());
            if (hasBluetoothPermission != 0) {
                blArray[77] = true;
            } else {
                blArray[78] = true;
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (bluetoothAdapter == null) {
                    blArray[79] = true;
                } else {
                    blArray[80] = true;
                    isBluetoothEnabled = bluetoothAdapter.isEnabled();
                    blArray[81] = true;
                }
            }
            blArray[82] = true;
        }
        catch (Throwable throwable) {
            blArray[83] = true;
        }
        blArray[84] = true;
        return isBluetoothEnabled;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isErrorDeviceId() {
        block2: {
            var1_1 = DeviceInfo.$jacocoInit();
            if (this.getDeviceID() != null) break block2;
            var1_1[85] = true;
            ** GOTO lbl10
        }
        if (this.getDeviceID().startsWith("__i")) {
            v0 = var1_1[87] = true;
        } else {
            var1_1[86] = true;
lbl10:
            // 2 sources

            v0 = false;
            var1_1[88] = true;
        }
        var1_1[89] = true;
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLimitAdTrackingEnabled() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        Object object = this.adIDLock;
        synchronized (object) {
            try {
                blArray[90] = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[91] = true;
                return this.limitAdTracking;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[92] = true;
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Boolean isWifiConnected() {
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            var1_1 = DeviceInfo.$jacocoInit();
                            ret = null;
                            var1_1[93] = true;
                            if (0 == this.context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) break block2;
                            var1_1[94] = true;
                            break block3;
                        }
                        var1_1[95] = true;
                        connManager = (ConnectivityManager)this.context.getSystemService("connectivity");
                        if (connManager != null) break block4;
                        var1_1[96] = true;
                        break block3;
                    }
                    var1_1[97] = true;
                    var4_4 = connManager.getActiveNetworkInfo();
                    var1_1[98] = true;
                    if (networkInfo != null) break block5;
                    var1_1[99] = true;
                    ** GOTO lbl30
                }
                if (networkInfo.getType() == 1) break block6;
                var1_1[100] = true;
                ** GOTO lbl30
            }
            var1_1[101] = true;
            if (networkInfo.isConnected()) {
                v0 = var1_1[103] = true;
            } else {
                var1_1[102] = true;
lbl30:
                // 3 sources

                v0 = false;
                var1_1[104] = true;
            }
            ret = v0;
            var1_1[105] = true;
        }
        var1_1[106] = true;
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentUserOptOutStateFromStorage() {
        void storedOptOut;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        String key = this.optOutKey();
        if (key == null) {
            blArray[107] = true;
            this.config.getLogger().verbose(this.config.getAccountId(), "Unable to set current user OptOut state from storage: storage key is null");
            blArray[108] = true;
            return;
        }
        boolean bl = StorageHelper.getBooleanFromPrefs(this.context, this.config, key);
        blArray[109] = true;
        this.mCoreMetaData.setCurrentUserOptedOut((boolean)storedOptOut);
        blArray[110] = true;
        this.config.getLogger().verbose(this.config.getAccountId(), "Set current user OptOut state from storage to: " + (boolean)storedOptOut + " for key: " + key);
        blArray[111] = true;
    }

    /*
     * WARNING - void declaration
     */
    void enableDeviceNetworkInfoReporting(boolean bl) {
        void value;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        this.enableNetworkInfoReporting = value;
        blArray[112] = true;
        StorageHelper.putBoolean(this.context, StorageHelper.storageKeyWithSuffix(this.config, "NetworkInfo"), this.enableNetworkInfoReporting);
        blArray[113] = true;
        blArray[114] = true;
        this.config.getLogger().verbose(this.config.getAccountId(), "Device Network Information reporting set to " + this.enableNetworkInfoReporting);
        blArray[115] = true;
    }

    String getAttributionID() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[116] = true;
        return this.getDeviceID();
    }

    int getHeightPixels() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[117] = true;
        return DeviceCachedInfo.access$1700(this.getDeviceCachedInfo());
    }

    int getWidthPixels() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[118] = true;
        return DeviceCachedInfo.access$1800(this.getDeviceCachedInfo());
    }

    /*
     * WARNING - void declaration
     */
    void onInitDeviceInfo(String string) {
        void cleverTapID;
        void task;
        void taskDeviceCachedInfo;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[119] = true;
        taskDeviceCachedInfo.execute("getDeviceCachedInfo", new Callable<Void>(this){
            final /* synthetic */ DeviceInfo this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public Void call() throws Exception {
                boolean[] blArray = 1.$jacocoInit();
                DeviceInfo.access$1900(this.this$0);
                blArray[1] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-7793269732645088752L, (String)"com/clevertap/android/sdk/DeviceInfo$1", (int)3);
                }
                return blArray;
            }
        });
        blArray[120] = true;
        Task task3 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[121] = true;
        task.addOnSuccessListener(new OnSuccessListener<Void>(this){
            final /* synthetic */ DeviceInfo this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void onSuccess(Void void_) {
                boolean[] blArray = 2.$jacocoInit();
                blArray[1] = true;
                blArray[2] = true;
                DeviceInfo.access$2100(this.this$0).verbose(DeviceInfo.access$2000(this.this$0).getAccountId() + ":async_deviceID", "DeviceID initialized successfully!" + Thread.currentThread());
                blArray[3] = true;
                CleverTapAPI.instanceWithConfig(DeviceInfo.access$000(this.this$0), DeviceInfo.access$2000(this.this$0)).deviceIDCreated(this.this$0.getDeviceID());
                blArray[4] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-1858710230767100999L, (String)"com/clevertap/android/sdk/DeviceInfo$2", (int)6);
                }
                return blArray;
            }
        });
        blArray[122] = true;
        task.execute("initDeviceID", new Callable<Void>(this, (String)cleverTapID){
            final /* synthetic */ String val$cleverTapID;
            final /* synthetic */ DeviceInfo this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 3.$jacocoInit();
                this.this$0 = this$0;
                this.val$cleverTapID = string;
                blArray[0] = true;
            }

            @Override
            public Void call() throws Exception {
                boolean[] blArray = 3.$jacocoInit();
                DeviceInfo.access$2200(this.this$0, this.val$cleverTapID);
                blArray[1] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)7258053978754422325L, (String)"com/clevertap/android/sdk/DeviceInfo$3", (int)3);
                }
                return blArray;
            }
        });
        blArray[123] = true;
    }

    String optOutKey() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        String guid = this.getDeviceID();
        if (guid == null) {
            blArray[124] = true;
            return null;
        }
        blArray[125] = true;
        return "OptOut:" + guid;
    }

    /*
     * WARNING - void declaration
     */
    void setDeviceNetworkInfoReportingFromStorage() {
        void enabled;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        boolean bl = StorageHelper.getBooleanFromPrefs(this.context, this.config, "NetworkInfo");
        blArray[126] = true;
        blArray[127] = true;
        this.config.getLogger().verbose(this.config.getAccountId(), "Setting device network info reporting state from storage to " + (boolean)enabled);
        this.enableNetworkInfoReporting = enabled;
        blArray[128] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String _getDeviceID() {
        block7: {
            String string;
            boolean[] blArray = DeviceInfo.$jacocoInit();
            Object object = this.deviceIDLock;
            // MONITORENTER : object
            try {
                void _new;
                blArray[129] = true;
                if (!this.config.isDefaultInstance()) {
                    blArray[130] = true;
                    break block7;
                }
                blArray[131] = true;
                String string2 = StorageHelper.getString(this.context, this.getDeviceIdStorageKey(), null);
                blArray[132] = true;
                if (_new != null) {
                    string = _new;
                    blArray[133] = true;
                } else {
                    string = StorageHelper.getString(this.context, "deviceId", null);
                    blArray[134] = true;
                }
                // MONITOREXIT : object
                blArray[135] = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT : object
                blArray[137] = true;
                throw throwable;
            }
            return string;
        }
        // MONITOREXIT : object
        blArray[136] = true;
        return StorageHelper.getString(this.context, this.getDeviceIdStorageKey(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void fetchGoogleAdID() {
        block23: {
            block21: {
                block24: {
                    block22: {
                        var1_1 = DeviceInfo.$jacocoInit();
                        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "fetchGoogleAdID() called!");
                        var1_1[138] = true;
                        if (this.getGoogleAdID() == null) break block22;
                        var1_1[139] = true;
                        break block23;
                    }
                    if (!this.adIdRun) break block24;
                    var1_1[140] = true;
                    break block23;
                }
                var2_2 = null;
                try {
                    var1_1[141] = true;
                    this.adIdRun = true;
                    var1_1[142] = true;
                    var3_3 = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                    var1_1[143] = true;
                    var4_5 = adIdClient.getMethod("getAdvertisingIdInfo", new Class[]{Context.class});
                    var1_1[144] = true;
                    var5_6 = getAdInfo.invoke(null, new Object[]{this.context});
                    var1_1[145] = true;
                    var6_7 = adInfo.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
                    var1_1[146] = true;
                    limitedAdTracking = (Boolean)isLimitAdTracking.invoke((Object)adInfo, new Object[0]);
                    var8_9 = this.adIDLock;
                    synchronized (var8_9) {
                        try {
                            block25: {
                                var1_1[147] = true;
                                if (limitedAdTracking != null) break block25;
                                var1_1[148] = true;
                                ** GOTO lbl38
                            }
                            if (limitedAdTracking.booleanValue()) {
                                v0 = var1_1[150] = true;
                            } else {
                                var1_1[149] = true;
lbl38:
                                // 2 sources

                                v0 = false;
                                var1_1[151] = true;
                            }
                            this.limitAdTracking = v0;
                            var1_1[152] = true;
                            this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "limitAdTracking = " + this.limitAdTracking);
                            if (this.limitAdTracking) {
                                var1_1[154] = true;
                                this.getConfigLogger().debug(this.config.getAccountId(), "Device user has opted out of sharing Advertising ID, falling back to random UUID for CleverTap ID generation");
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 14] lbl43 : MonitorExitStatement: MONITOREXIT : var8_9
                                var1_1[155] = true;
                                return;
                            }
                            var1_1[153] = true;
                        }
                        catch (Throwable var9_10) {
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 8] lbl49 : MonitorExitStatement: MONITOREXIT : var8_9
                            var1_1[156] = true;
                            throw var9_10;
                        }
                    }
                }
                catch (Throwable adIdClient) {
                    var1_1[159] = true;
                    if (t.getCause() != null) {
                        var1_1[160] = true;
                        var1_1[161] = true;
                        var1_1[162] = true;
                        this.getConfigLogger().verbose(this.config.getAccountId(), "Failed to get Advertising ID: " + t.toString() + t.getCause().toString());
                        var1_1[163] = true;
                        break block21;
                    } else {
                        this.getConfigLogger().verbose(this.config.getAccountId(), "Failed to get Advertising ID: " + t.toString());
                        var1_1[164] = true;
                    }
                    break block21;
                }
                var8_9 = adInfo.getClass().getMethod("getId", new Class[0]);
                var1_1[157] = true;
                advertisingID = (String)getAdId.invoke((Object)adInfo, new Object[0]);
                var1_1[158] = true;
            }
            if (advertisingID == null) {
                var1_1[165] = true;
            } else if (advertisingID.trim().length() <= 2) {
                var1_1[166] = true;
            } else {
                var3_3 = this.adIDLock;
                synchronized (var3_3) {
                    try {
                        var1_1[167] = true;
                        if (advertisingID.contains("00000000")) {
                            var1_1[169] = true;
                            this.getConfigLogger().debug(this.config.getAccountId(), "Device user has opted out of sharing Advertising ID, falling back to random UUID for CleverTap ID generation");
                            // MONITOREXIT @DISABLED, blocks:[17, 19, 4, 6, 11] lbl82 : MonitorExitStatement: MONITOREXIT : var3_3
                            var1_1[170] = true;
                            return;
                        }
                        var1_1[168] = true;
                    }
                    catch (Throwable var10_11) {
                        // MONITOREXIT @DISABLED, blocks:[17, 19, 6, 10] lbl88 : MonitorExitStatement: MONITOREXIT : var3_3
                        var1_1[172] = true;
                        throw var10_11;
                    }
                    {
                        this.googleAdID = advertisingID.replace("-", "");
                        // MONITOREXIT @DISABLED, blocks:[17, 19, 5, 6] lbl92 : MonitorExitStatement: MONITOREXIT : var3_3
                        var1_1[171] = true;
                    }
                }
            }
            this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "fetchGoogleAdID() done executing!");
            var1_1[173] = true;
        }
        var1_1[174] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generateDeviceID() {
        String generatedDeviceID;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "generateDeviceID() called!");
        blArray[175] = true;
        String adId = this.getGoogleAdID();
        if (adId != null) {
            blArray[176] = true;
            generatedDeviceID = "__g" + adId;
            blArray[177] = true;
        } else {
            Object object = this.deviceIDLock;
            synchronized (object) {
                try {
                    blArray[178] = true;
                    generatedDeviceID = this.generateGUID();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                    blArray[179] = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 3] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                    blArray[180] = true;
                    throw throwable;
                }
            }
        }
        this.forceUpdateDeviceId(generatedDeviceID);
        blArray[181] = true;
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "generateDeviceID() done executing!");
        blArray[182] = true;
    }

    private String generateGUID() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[183] = true;
        return GUID_PREFIX + UUID.randomUUID().toString().replace("-", "");
    }

    private Logger getConfigLogger() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[184] = true;
        return this.config.getLogger();
    }

    private DeviceCachedInfo getDeviceCachedInfo() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        if (this.cachedInfo != null) {
            blArray[185] = true;
        } else {
            blArray[186] = true;
            this.cachedInfo = new DeviceCachedInfo(this);
            blArray[187] = true;
        }
        blArray[188] = true;
        return this.cachedInfo;
    }

    private String getDeviceIdStorageKey() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[189] = true;
        return "deviceId:" + this.config.getAccountId();
    }

    private String getFallBackDeviceID() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[190] = true;
        return StorageHelper.getString(this.context, this.getFallbackIdStorageKey(), null);
    }

    private String getFallbackIdStorageKey() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[191] = true;
        return "fallbackId:" + this.config.getAccountId();
    }

    /*
     * WARNING - void declaration
     */
    private void initDeviceID(String string) {
        void deviceID;
        String error;
        void cleverTapID;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "Called initDeviceID()");
        blArray[192] = true;
        if (this.config.getEnableCustomCleverTapId()) {
            if (cleverTapID != null) {
                blArray[193] = true;
            } else {
                blArray[194] = true;
                String string2 = this.recordDeviceError(18, new String[0]);
                blArray[195] = true;
                this.config.getLogger().info(error);
                blArray[196] = true;
            }
        } else if (cleverTapID == null) {
            blArray[197] = true;
        } else {
            blArray[198] = true;
            error = this.recordDeviceError(19, new String[0]);
            blArray[199] = true;
            this.config.getLogger().info(error);
            blArray[200] = true;
        }
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "Calling _getDeviceID");
        blArray[201] = true;
        error = this._getDeviceID();
        blArray[202] = true;
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "Called _getDeviceID");
        blArray[203] = true;
        if (deviceID == null) {
            blArray[204] = true;
        } else if (deviceID.trim().length() <= 2) {
            blArray[205] = true;
        } else {
            blArray[206] = true;
            this.getConfigLogger().verbose(this.config.getAccountId(), "CleverTap ID already present for profile");
            if (cleverTapID == null) {
                blArray[207] = true;
            } else {
                void error2;
                blArray[208] = true;
                String string3 = this.recordDeviceError(20, new String[]{deviceID, cleverTapID});
                blArray[209] = true;
                this.getConfigLogger().info(this.config.getAccountId(), (String)error2);
                blArray[210] = true;
            }
            blArray[211] = true;
            return;
        }
        if (this.config.getEnableCustomCleverTapId()) {
            blArray[212] = true;
            this.forceUpdateCustomCleverTapID((String)cleverTapID);
            blArray[213] = true;
            return;
        }
        if (!this.config.isUseGoogleAdId()) {
            blArray[214] = true;
            this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "Calling generateDeviceID()");
            blArray[215] = true;
            this.generateDeviceID();
            blArray[216] = true;
            this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "Called generateDeviceID()");
            blArray[217] = true;
            return;
        }
        this.fetchGoogleAdID();
        blArray[218] = true;
        this.generateDeviceID();
        blArray[219] = true;
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "initDeviceID() done executing!");
        blArray[220] = true;
    }

    /*
     * WARNING - void declaration
     */
    private String recordDeviceError(int n, String ... stringArray) {
        void validationResult;
        void varargs;
        void messageCode;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        ValidationResult validationResult2 = ValidationResultFactory.create(514, (int)messageCode, (String[])varargs);
        blArray[221] = true;
        this.validationResults.add((ValidationResult)validationResult);
        blArray[222] = true;
        blArray[223] = true;
        return validationResult.getErrorDesc();
    }

    private void removeDeviceID() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        StorageHelper.remove(this.context, this.getDeviceIdStorageKey());
        blArray[224] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized void setOrGenerateFallbackDeviceID() {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        if (this.getFallBackDeviceID() != null) {
            blArray[225] = true;
        } else {
            Object object = this.deviceIDLock;
            synchronized (object) {
                try {
                    void fallbackDeviceID;
                    blArray[226] = true;
                    blArray[227] = true;
                    String string = "__i" + UUID.randomUUID().toString().replace("-", "");
                    blArray[228] = true;
                    if (fallbackDeviceID.trim().length() > 2) {
                        blArray[229] = true;
                        this.updateFallbackID((String)fallbackDeviceID);
                        blArray[230] = true;
                    } else {
                        blArray[231] = true;
                        this.getConfigLogger().verbose(this.config.getAccountId(), "Unable to generate fallback error device ID");
                        blArray[232] = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[233] = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 5] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[234] = true;
                    throw throwable;
                }
            }
        }
        blArray[235] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void updateFallbackID(String string) {
        void fallbackId;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        this.getConfigLogger().verbose(this.config.getAccountId(), "Updating the fallback id - " + (String)fallbackId);
        blArray[236] = true;
        StorageHelper.putString(this.context, this.getFallbackIdStorageKey(), (String)fallbackId);
        blArray[237] = true;
    }

    static /* synthetic */ Context access$000(DeviceInfo deviceInfo) {
        DeviceInfo x0;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[238] = true;
        return x0.context;
    }

    static /* synthetic */ DeviceCachedInfo access$1900(DeviceInfo deviceInfo) {
        DeviceInfo x0;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[239] = true;
        return x0.getDeviceCachedInfo();
    }

    static /* synthetic */ CleverTapInstanceConfig access$2000(DeviceInfo deviceInfo) {
        DeviceInfo x0;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[240] = true;
        return x0.config;
    }

    static /* synthetic */ Logger access$2100(DeviceInfo deviceInfo) {
        DeviceInfo x0;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        blArray[241] = true;
        return x0.getConfigLogger();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2200(DeviceInfo deviceInfo, String string) {
        void x1;
        DeviceInfo x0;
        boolean[] blArray = DeviceInfo.$jacocoInit();
        x0.initDeviceID((String)x1);
        blArray[242] = true;
    }

    static {
        boolean[] blArray = DeviceInfo.$jacocoInit();
        sDeviceType = -1;
        blArray[243] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-8558328894375321788L, (String)"com/clevertap/android/sdk/DeviceInfo", (int)244);
        }
        return blArray;
    }

    private class DeviceCachedInfo {
        private static final String STANDBY_BUCKET_ACTIVE = "active";
        private static final String STANDBY_BUCKET_FREQUENT = "frequent";
        private static final String STANDBY_BUCKET_RARE = "rare";
        private static final String STANDBY_BUCKET_RESTRICTED = "restricted";
        private static final String STANDBY_BUCKET_WORKING_SET = "working_set";
        private final String bluetoothVersion;
        private final int build;
        private final String carrier;
        private final String countryCode;
        private final int dpi;
        private final double height;
        private final int heightPixels;
        private final String manufacturer;
        private final String model;
        private final String networkType;
        private final boolean notificationsEnabled;
        private final String osName;
        private final String osVersion;
        private final int sdkVersion;
        private final String versionName;
        private final double width;
        private final int widthPixels;
        private String appBucket;
        final /* synthetic */ DeviceInfo this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        DeviceCachedInfo(DeviceInfo deviceInfo) {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            this.this$0 = deviceInfo;
            blArray[0] = true;
            this.versionName = this.getVersionName();
            blArray[1] = true;
            this.osName = this.getOsName();
            blArray[2] = true;
            this.osVersion = this.getOsVersion();
            blArray[3] = true;
            this.manufacturer = this.getManufacturer();
            blArray[4] = true;
            this.model = this.getModel();
            blArray[5] = true;
            this.carrier = this.getCarrier();
            blArray[6] = true;
            this.build = this.getBuild();
            blArray[7] = true;
            this.networkType = this.getNetworkType();
            blArray[8] = true;
            this.bluetoothVersion = this.getBluetoothVersion();
            blArray[9] = true;
            this.countryCode = this.getCountryCode();
            blArray[10] = true;
            this.sdkVersion = this.getSdkVersion();
            blArray[11] = true;
            this.height = this.getHeight();
            blArray[12] = true;
            this.heightPixels = this.getHeightPixels();
            blArray[13] = true;
            this.width = this.getWidth();
            blArray[14] = true;
            this.widthPixels = this.getWidthPixels();
            blArray[15] = true;
            this.dpi = this.getDPI();
            blArray[16] = true;
            this.notificationsEnabled = this.getNotificationEnabledForUser();
            if (Build.VERSION.SDK_INT < 28) {
                blArray[17] = true;
            } else {
                blArray[18] = true;
                this.appBucket = this.getAppBucket();
                blArray[19] = true;
            }
            blArray[20] = true;
        }

        /*
         * Unable to fully structure code
         */
        private String getBluetoothVersion() {
            block4: {
                var1_1 = DeviceCachedInfo.$jacocoInit();
                bluetoothVersion = "none";
                if (Build.VERSION.SDK_INT >= 18) break block4;
                var1_1[21] = true;
                ** GOTO lbl13
            }
            var1_1[22] = true;
            if (DeviceInfo.access$000(this.this$0).getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                bluetoothVersion = "ble";
                var1_1[24] = true;
            } else {
                var1_1[23] = true;
lbl13:
                // 2 sources

                if (!DeviceInfo.access$000(this.this$0).getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                    var1_1[25] = true;
                } else {
                    bluetoothVersion = "classic";
                    var1_1[26] = true;
                }
            }
            var1_1[27] = true;
            return bluetoothVersion;
        }

        private int getBuild() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            try {
                PackageInfo packageInfo = DeviceInfo.access$000(this.this$0).getPackageManager().getPackageInfo(DeviceInfo.access$000(this.this$0).getPackageName(), 0);
                blArray[28] = true;
                return packageInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                blArray[29] = true;
                Logger.d("Unable to get app build");
                blArray[30] = true;
                return 0;
            }
        }

        private String getCarrier() {
            block2: {
                boolean[] blArray = DeviceCachedInfo.$jacocoInit();
                try {
                    blArray[31] = true;
                    TelephonyManager manager = (TelephonyManager)DeviceInfo.access$000(this.this$0).getSystemService("phone");
                    if (manager == null) break block2;
                    blArray[32] = true;
                    blArray[33] = true;
                    return manager.getNetworkOperatorName();
                }
                catch (Exception exception) {
                    blArray[35] = true;
                }
            }
            blArray[34] = true;
            blArray[36] = true;
            return null;
        }

        private String getCountryCode() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            try {
                TelephonyManager tm = (TelephonyManager)DeviceInfo.access$000(this.this$0).getSystemService("phone");
                if (tm != null) {
                    blArray[37] = true;
                    blArray[38] = true;
                    return tm.getSimCountryIso();
                }
            }
            catch (Throwable ignore) {
                blArray[39] = true;
                return "";
            }
            blArray[40] = true;
            return "";
        }

        /*
         * WARNING - void declaration
         */
        private int getDPI() {
            void dm;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            WindowManager wm = (WindowManager)DeviceInfo.access$000(this.this$0).getSystemService("window");
            if (wm == null) {
                blArray[41] = true;
                return 0;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                blArray[42] = true;
                Configuration configuration = DeviceInfo.access$000(this.this$0).getResources().getConfiguration();
                blArray[43] = true;
                return configuration.densityDpi;
            }
            DisplayMetrics configuration = new DisplayMetrics();
            blArray[44] = true;
            wm.getDefaultDisplay().getMetrics((DisplayMetrics)dm);
            blArray[45] = true;
            return dm.densityDpi;
        }

        /*
         * WARNING - void declaration
         */
        private double getHeight() {
            void rHeight;
            float dpi;
            int height;
            DisplayMetrics windowMetrics;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            WindowManager wm = (WindowManager)DeviceInfo.access$000(this.this$0).getSystemService("window");
            if (wm == null) {
                blArray[46] = true;
                return 0.0;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                void configuration;
                void insets;
                blArray[47] = true;
                WindowMetrics windowMetrics2 = wm.getCurrentWindowMetrics();
                blArray[48] = true;
                Configuration configuration2 = DeviceInfo.access$000(this.this$0).getResources().getConfiguration();
                blArray[49] = true;
                blArray[50] = true;
                Insets insets2 = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemGestures());
                blArray[51] = true;
                height = windowMetrics.getBounds().height() - insets.top - insets.bottom;
                dpi = configuration.densityDpi;
                blArray[52] = true;
            } else {
                void dm;
                windowMetrics = new DisplayMetrics();
                blArray[53] = true;
                wm.getDefaultDisplay().getMetrics((DisplayMetrics)dm);
                height = dm.heightPixels;
                dpi = dm.ydpi;
                blArray[54] = true;
            }
            double dm = (float)height / dpi;
            blArray[55] = true;
            blArray[56] = true;
            return this.toTwoPlaces((double)rHeight);
        }

        /*
         * WARNING - void declaration
         */
        private int getHeightPixels() {
            void dm;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            WindowManager wm = (WindowManager)DeviceInfo.access$000(this.this$0).getSystemService("window");
            if (wm == null) {
                blArray[57] = true;
                return 0;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                void insets;
                void windowMetrics;
                blArray[58] = true;
                WindowMetrics windowMetrics2 = wm.getCurrentWindowMetrics();
                blArray[59] = true;
                blArray[60] = true;
                Insets insets2 = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemGestures());
                blArray[61] = true;
                int heightInPixel = windowMetrics.getBounds().height() - insets.top - insets.bottom;
                blArray[62] = true;
                return heightInPixel;
            }
            DisplayMetrics windowMetrics = new DisplayMetrics();
            blArray[63] = true;
            wm.getDefaultDisplay().getMetrics((DisplayMetrics)dm);
            blArray[64] = true;
            return dm.heightPixels;
        }

        private String getManufacturer() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[65] = true;
            return Build.MANUFACTURER;
        }

        /*
         * WARNING - void declaration
         */
        @RequiresApi(api=28)
        private String getAppBucket() {
            void usm;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            UsageStatsManager usageStatsManager = (UsageStatsManager)DeviceInfo.access$000(this.this$0).getSystemService("usagestats");
            blArray[66] = true;
            switch (usm.getAppStandbyBucket()) {
                case 10: {
                    blArray[67] = true;
                    return STANDBY_BUCKET_ACTIVE;
                }
                case 30: {
                    blArray[68] = true;
                    return STANDBY_BUCKET_FREQUENT;
                }
                case 40: {
                    blArray[69] = true;
                    return STANDBY_BUCKET_RARE;
                }
                case 45: {
                    blArray[70] = true;
                    return STANDBY_BUCKET_RESTRICTED;
                }
                case 20: {
                    blArray[71] = true;
                    return STANDBY_BUCKET_WORKING_SET;
                }
            }
            blArray[72] = true;
            return "";
        }

        private String getModel() {
            String model;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            String string = Build.MODEL;
            blArray[73] = true;
            model = model.replace(this.getManufacturer(), "");
            blArray[74] = true;
            return model;
        }

        @SuppressLint(value={"MissingPermission"})
        private String getNetworkType() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[75] = true;
            return Utils.getDeviceNetworkType(DeviceInfo.access$000(this.this$0));
        }

        /*
         * WARNING - void declaration
         */
        private boolean getNotificationEnabledForUser() {
            boolean isNotificationEnabled;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            boolean bl = true;
            try {
                blArray[76] = true;
                isNotificationEnabled = NotificationManagerCompat.from((Context)DeviceInfo.access$000(this.this$0)).areNotificationsEnabled();
            }
            catch (RuntimeException runtimeException) {
                void rte;
                blArray[78] = true;
                Logger.d("Runtime exception caused when checking whether notification are enabled or not");
                blArray[79] = true;
                rte.printStackTrace();
                blArray[80] = true;
            }
            blArray[77] = true;
            blArray[81] = true;
            return isNotificationEnabled;
        }

        private String getOsName() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[82] = true;
            return DeviceInfo.OS_NAME;
        }

        private String getOsVersion() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[83] = true;
            return Build.VERSION.RELEASE;
        }

        private int getSdkVersion() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[84] = true;
            return 40500;
        }

        private String getVersionName() {
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            try {
                PackageInfo packageInfo = DeviceInfo.access$000(this.this$0).getPackageManager().getPackageInfo(DeviceInfo.access$000(this.this$0).getPackageName(), 0);
                blArray[85] = true;
                return packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                blArray[86] = true;
                Logger.d("Unable to get app version");
                blArray[87] = true;
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private double getWidth() {
            void rWidth;
            float dpi;
            int width;
            DisplayMetrics windowMetrics;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            WindowManager wm = (WindowManager)DeviceInfo.access$000(this.this$0).getSystemService("window");
            if (wm == null) {
                blArray[88] = true;
                return 0.0;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                void configuration;
                void insets;
                blArray[89] = true;
                WindowMetrics windowMetrics2 = wm.getCurrentWindowMetrics();
                blArray[90] = true;
                Configuration configuration2 = DeviceInfo.access$000(this.this$0).getResources().getConfiguration();
                blArray[91] = true;
                blArray[92] = true;
                Insets insets2 = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemGestures());
                blArray[93] = true;
                width = windowMetrics.getBounds().width() - insets.right - insets.left;
                dpi = configuration.densityDpi;
                blArray[94] = true;
            } else {
                void dm;
                windowMetrics = new DisplayMetrics();
                blArray[95] = true;
                wm.getDefaultDisplay().getMetrics((DisplayMetrics)dm);
                width = dm.widthPixels;
                dpi = dm.xdpi;
                blArray[96] = true;
            }
            double dm = (float)width / dpi;
            blArray[97] = true;
            blArray[98] = true;
            return this.toTwoPlaces((double)rWidth);
        }

        /*
         * WARNING - void declaration
         */
        private int getWidthPixels() {
            void dm;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            WindowManager wm = (WindowManager)DeviceInfo.access$000(this.this$0).getSystemService("window");
            if (wm == null) {
                blArray[99] = true;
                return 0;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                void insets;
                void windowMetrics;
                blArray[100] = true;
                WindowMetrics windowMetrics2 = wm.getCurrentWindowMetrics();
                blArray[101] = true;
                blArray[102] = true;
                Insets insets2 = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemGestures());
                blArray[103] = true;
                int widthInPixel = windowMetrics.getBounds().width() - insets.right - insets.left;
                blArray[104] = true;
                return widthInPixel;
            }
            DisplayMetrics windowMetrics = new DisplayMetrics();
            blArray[105] = true;
            wm.getDefaultDisplay().getMetrics((DisplayMetrics)dm);
            blArray[106] = true;
            return dm.widthPixels;
        }

        /*
         * WARNING - void declaration
         */
        private double toTwoPlaces(double d) {
            double result;
            void n;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            void var4_3 = n * 100.0;
            blArray[107] = true;
            result = Math.round(result);
            blArray[108] = true;
            return result /= 100.0;
        }

        static /* synthetic */ String access$100(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[109] = true;
            return x0.bluetoothVersion;
        }

        static /* synthetic */ int access$200(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[110] = true;
            return x0.build;
        }

        static /* synthetic */ String access$300(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[111] = true;
            return x0.carrier;
        }

        static /* synthetic */ String access$400(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[112] = true;
            return x0.countryCode;
        }

        static /* synthetic */ int access$500(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[113] = true;
            return x0.dpi;
        }

        static /* synthetic */ double access$600(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[114] = true;
            return x0.height;
        }

        static /* synthetic */ String access$700(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[115] = true;
            return x0.manufacturer;
        }

        static /* synthetic */ String access$800(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[116] = true;
            return x0.appBucket;
        }

        static /* synthetic */ String access$900(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[117] = true;
            return x0.model;
        }

        static /* synthetic */ String access$1000(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[118] = true;
            return x0.networkType;
        }

        static /* synthetic */ boolean access$1100(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[119] = true;
            return x0.notificationsEnabled;
        }

        static /* synthetic */ String access$1200(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[120] = true;
            return x0.osName;
        }

        static /* synthetic */ String access$1300(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[121] = true;
            return x0.osVersion;
        }

        static /* synthetic */ int access$1400(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[122] = true;
            return x0.sdkVersion;
        }

        static /* synthetic */ String access$1500(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[123] = true;
            return x0.versionName;
        }

        static /* synthetic */ double access$1600(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[124] = true;
            return x0.width;
        }

        static /* synthetic */ int access$1700(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[125] = true;
            return x0.heightPixels;
        }

        static /* synthetic */ int access$1800(DeviceCachedInfo deviceCachedInfo) {
            DeviceCachedInfo x0;
            boolean[] blArray = DeviceCachedInfo.$jacocoInit();
            blArray[126] = true;
            return x0.widthPixels;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)731242916468563633L, (String)"com/clevertap/android/sdk/DeviceInfo$DeviceCachedInfo", (int)127);
            }
            return blArray;
        }
    }
}

