/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInAppNotificationButton
implements Parcelable {
    public static final Parcelable.Creator<CTInAppNotificationButton> CREATOR = new Parcelable.Creator<CTInAppNotificationButton>(){

        public CTInAppNotificationButton createFromParcel(Parcel in) {
            return new CTInAppNotificationButton(in);
        }

        public CTInAppNotificationButton[] newArray(int size) {
            return new CTInAppNotificationButton[size];
        }
    };
    private String actionUrl;
    private String backgroundColor;
    private String borderColor;
    private String borderRadius;
    private String error;
    private JSONObject jsonDescription;
    private HashMap<String, String> keyValues;
    private String text;
    private String textColor;

    CTInAppNotificationButton() {
    }

    protected CTInAppNotificationButton(Parcel in) {
        this.text = in.readString();
        this.textColor = in.readString();
        this.backgroundColor = in.readString();
        this.actionUrl = in.readString();
        this.borderColor = in.readString();
        this.borderRadius = in.readString();
        try {
            this.jsonDescription = in.readByte() == 0 ? null : new JSONObject(in.readString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.error = in.readString();
        this.keyValues = in.readHashMap(null);
    }

    public int describeContents() {
        return 0;
    }

    public HashMap<String, String> getKeyValues() {
        return this.keyValues;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.text);
        dest.writeString(this.textColor);
        dest.writeString(this.backgroundColor);
        dest.writeString(this.actionUrl);
        dest.writeString(this.borderColor);
        dest.writeString(this.borderRadius);
        if (this.jsonDescription == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.jsonDescription.toString());
        }
        dest.writeString(this.error);
        dest.writeMap(this.keyValues);
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    String getBackgroundColor() {
        return this.backgroundColor;
    }

    void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    String getBorderColor() {
        return this.borderColor;
    }

    void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    String getBorderRadius() {
        return this.borderRadius;
    }

    void setBorderRadius(String borderRadius) {
        this.borderRadius = borderRadius;
    }

    String getError() {
        return this.error;
    }

    void setError(String error) {
        this.error = error;
    }

    JSONObject getJsonDescription() {
        return this.jsonDescription;
    }

    void setJsonDescription(JSONObject jsonDescription) {
        this.jsonDescription = jsonDescription;
    }

    public String getText() {
        return this.text;
    }

    void setText(String text) {
        this.text = text;
    }

    String getTextColor() {
        return this.textColor;
    }

    void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    CTInAppNotificationButton initWithJSON(JSONObject jsonObject) {
        try {
            Iterator keys;
            JSONObject keyValues;
            JSONObject actions;
            this.jsonDescription = jsonObject;
            this.text = jsonObject.has("text") ? jsonObject.getString("text") : "";
            this.textColor = jsonObject.has("color") ? jsonObject.getString("color") : "#0000FF";
            this.backgroundColor = jsonObject.has("bg") ? jsonObject.getString("bg") : "#FFFFFF";
            this.borderColor = jsonObject.has("border") ? jsonObject.getString("border") : "#FFFFFF";
            this.borderRadius = jsonObject.has("radius") ? jsonObject.getString("radius") : "";
            JSONObject jSONObject = actions = jsonObject.has("actions") ? jsonObject.getJSONObject("actions") : null;
            if (actions != null) {
                String action;
                String string = action = actions.has("android") ? actions.getString("android") : "";
                if (!action.isEmpty()) {
                    this.actionUrl = action;
                }
            }
            if (this.isKVAction(actions) && (keyValues = actions.getJSONObject("kv")) != null && (keys = keyValues.keys()) != null) {
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = keyValues.getString(key);
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    if (this.keyValues == null) {
                        this.keyValues = new HashMap();
                    }
                    this.keyValues.put(key, value);
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON";
        }
        return this;
    }

    private boolean isKVAction(JSONObject actions) throws JSONException {
        return actions != null && actions.has("type") && "kv".equalsIgnoreCase(actions.getString("type")) && actions.has("kv");
    }
}

