/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeatureFlagResponse
extends CleverTapResponseDecorator {
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final Logger logger;
    private final ControllerManager controllerManager;

    public FeatureFlagResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig config, ControllerManager controllerManager) {
        this.cleverTapResponse = cleverTapResponse;
        this.config = config;
        this.logger = this.config.getLogger();
        this.controllerManager = controllerManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        this.logger.verbose(this.config.getAccountId(), "Processing Feature Flags response...");
        if (this.config.isAnalyticsOnly()) {
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing Feature Flags response");
            this.cleverTapResponse.processResponse(response, stringBody, context);
            return;
        }
        if (response == null) {
            this.logger.verbose(this.config.getAccountId(), "Feature Flag : Can't parse Feature Flags Response, JSON response object is null");
            return;
        }
        if (!response.has("ff_notifs")) {
            this.logger.verbose(this.config.getAccountId(), "Feature Flag : JSON object doesn't contain the Feature Flags key");
            this.cleverTapResponse.processResponse(response, stringBody, context);
            return;
        }
        try {
            this.logger.verbose(this.config.getAccountId(), "Feature Flag : Processing Feature Flags response");
            this.parseFeatureFlags(response.getJSONObject("ff_notifs"));
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Feature Flag : Failed to parse response", t);
        }
        this.cleverTapResponse.processResponse(response, stringBody, context);
    }

    private void parseFeatureFlags(JSONObject responseKV) throws JSONException {
        JSONArray kvArray = responseKV.getJSONArray("kv");
        if (kvArray != null && this.controllerManager.getCTFeatureFlagsController() != null) {
            this.controllerManager.getCTFeatureFlagsController().updateFeatureFlags(responseKV);
        }
    }
}

