/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationManagerCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DeviceInfo {
    private static final String GUID_PREFIX = "__";
    private static final String OS_NAME = "Android";
    static final int SMART_PHONE = 1;
    static final int TABLET = 2;
    static final int TV = 3;
    static final int UNKNOWN = 0;
    static final int NULL = -1;
    static int sDeviceType = -1;
    private final Object adIDLock = new Object();
    private boolean adIdRun = false;
    private DeviceCachedInfo cachedInfo;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final Object deviceIDLock = new Object();
    private String googleAdID = null;
    private String library;
    private boolean limitAdTracking = false;
    private final ArrayList<ValidationResult> validationResults = new ArrayList();
    private boolean enableNetworkInfoReporting = false;
    private final CoreMetaData mCoreMetaData;

    DeviceInfo(Context context, CleverTapInstanceConfig config, String cleverTapID, CoreMetaData coreMetaData) {
        this.context = context;
        this.config = config;
        this.library = null;
        this.mCoreMetaData = coreMetaData;
        this.onInitDeviceInfo(cleverTapID);
    }

    void onInitDeviceInfo(String cleverTapID) {
        Thread deviceInfoCacheThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceInfo.this.getDeviceCachedInfo();
            }
        });
        deviceInfoCacheThread.start();
        this.initDeviceID(cleverTapID);
    }

    public boolean isErrorDeviceId() {
        return this.getDeviceID() != null && this.getDeviceID().startsWith("__i");
    }

    public void forceNewDeviceID() {
        String deviceID = this.generateGUID();
        this.forceUpdateDeviceId(deviceID);
    }

    public void forceUpdateCustomCleverTapID(String cleverTapID) {
        if (Utils.validateCTID(cleverTapID)) {
            this.getConfigLogger().info(this.config.getAccountId(), "Setting CleverTap ID to custom CleverTap ID : " + cleverTapID);
            this.forceUpdateDeviceId("__h" + cleverTapID);
        } else {
            this.setOrGenerateFallbackDeviceID();
            this.removeDeviceID();
            String error = this.recordDeviceError(21, cleverTapID, this.getFallBackDeviceID());
            this.getConfigLogger().info(this.config.getAccountId(), error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    public void forceUpdateDeviceId(String id2) {
        this.getConfigLogger().verbose(this.config.getAccountId(), "Force updating the device ID to " + id2);
        Object object = this.deviceIDLock;
        synchronized (object) {
            StorageHelper.putString(this.context, this.getDeviceIdStorageKey(), id2);
        }
    }

    String getAttributionID() {
        return this.getDeviceID();
    }

    public static int getDeviceType(Context context) {
        if (sDeviceType == -1) {
            try {
                UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
                if (uiModeManager.getCurrentModeType() == 4) {
                    sDeviceType = 3;
                    return sDeviceType;
                }
            }
            catch (Exception e) {
                Logger.d("Failed to decide whether device is a TV!");
                e.printStackTrace();
            }
            try {
                sDeviceType = context.getResources().getBoolean(R.bool.ctIsTablet) ? 2 : 1;
            }
            catch (Exception e) {
                Logger.d("Failed to decide whether device is a smart phone or tablet!");
                e.printStackTrace();
                sDeviceType = 0;
            }
        }
        return sDeviceType;
    }

    public JSONObject getAppLaunchedFields() {
        try {
            boolean deviceIsMultiUser = false;
            if (this.getGoogleAdID() != null) {
                deviceIsMultiUser = new LoginInfoProvider(this.context, this.config, this).deviceIsMultiUser();
            }
            return CTJsonConverter.from(this, this.mCoreMetaData.getLocationFromUser(), this.enableNetworkInfoReporting, deviceIsMultiUser);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to construct App Launched event", t);
            return new JSONObject();
        }
    }

    public String getBluetoothVersion() {
        return this.getDeviceCachedInfo().bluetoothVersion;
    }

    public int getBuild() {
        return this.getDeviceCachedInfo().build;
    }

    public String getCarrier() {
        return this.getDeviceCachedInfo().carrier;
    }

    public Context getContext() {
        return this.context;
    }

    public String getDeviceID() {
        return this._getDeviceID() != null ? this._getDeviceID() : this.getFallBackDeviceID();
    }

    public String getCountryCode() {
        return this.getDeviceCachedInfo().countryCode;
    }

    public int getDPI() {
        return this.getDeviceCachedInfo().dpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGoogleAdID() {
        Object object = this.adIDLock;
        synchronized (object) {
            return this.googleAdID;
        }
    }

    public double getHeight() {
        return this.getDeviceCachedInfo().height;
    }

    public String getLibrary() {
        return this.library;
    }

    void setLibrary(String library) {
        this.library = library;
    }

    public String getManufacturer() {
        return this.getDeviceCachedInfo().manufacturer;
    }

    public String getModel() {
        return this.getDeviceCachedInfo().model;
    }

    public String getNetworkType() {
        return this.getDeviceCachedInfo().networkType;
    }

    public boolean getNotificationsEnabledForUser() {
        return this.getDeviceCachedInfo().notificationsEnabled;
    }

    public String getOsName() {
        return this.getDeviceCachedInfo().osName;
    }

    public String getOsVersion() {
        return this.getDeviceCachedInfo().osVersion;
    }

    public ArrayList<ValidationResult> getValidationResults() {
        ArrayList tempValidationResults = (ArrayList)this.validationResults.clone();
        this.validationResults.clear();
        return tempValidationResults;
    }

    public int getSdkVersion() {
        return this.getDeviceCachedInfo().sdkVersion;
    }

    public String getVersionName() {
        return this.getDeviceCachedInfo().versionName;
    }

    public double getWidth() {
        return this.getDeviceCachedInfo().width;
    }

    @SuppressLint(value={"MissingPermission"})
    public Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled = null;
        try {
            BluetoothAdapter bluetoothAdapter;
            PackageManager pm = this.context.getPackageManager();
            int hasBluetoothPermission = pm.checkPermission("android.permission.BLUETOOTH", this.context.getPackageName());
            if (hasBluetoothPermission == 0 && (bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) != null) {
                isBluetoothEnabled = bluetoothAdapter.isEnabled();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isBluetoothEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLimitAdTrackingEnabled() {
        Object object = this.adIDLock;
        synchronized (object) {
            return this.limitAdTracking;
        }
    }

    public Boolean isWifiConnected() {
        ConnectivityManager connManager;
        Boolean ret = null;
        if (0 == this.context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") && (connManager = (ConnectivityManager)this.context.getSystemService("connectivity")) != null) {
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            ret = networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getDeviceID() {
        Object object = this.deviceIDLock;
        synchronized (object) {
            if (this.config.isDefaultInstance()) {
                String _new = StorageHelper.getString(this.context, this.getDeviceIdStorageKey(), null);
                String string = _new != null ? _new : StorageHelper.getString(this.context, "deviceId", null);
                return string;
            }
            return StorageHelper.getString(this.context, this.getDeviceIdStorageKey(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fetchGoogleAdID() {
        if (this.getGoogleAdID() == null && !this.adIdRun) {
            String advertisingID = null;
            try {
                this.adIdRun = true;
                Class<?> adIdClient = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                Method getAdInfo = adIdClient.getMethod("getAdvertisingIdInfo", Context.class);
                Object adInfo = getAdInfo.invoke(null, this.context);
                Method isLimitAdTracking = adInfo.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
                Boolean limitedAdTracking = (Boolean)isLimitAdTracking.invoke(adInfo, new Object[0]);
                Object object = this.adIDLock;
                synchronized (object) {
                    boolean bl = this.limitAdTracking = limitedAdTracking != null && limitedAdTracking != false;
                    if (this.limitAdTracking) {
                        return;
                    }
                }
                Method getAdId = adInfo.getClass().getMethod("getId", new Class[0]);
                advertisingID = (String)getAdId.invoke(adInfo, new Object[0]);
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    this.getConfigLogger().verbose(this.config.getAccountId(), "Failed to get Advertising ID: " + t.toString() + t.getCause().toString());
                }
                this.getConfigLogger().verbose(this.config.getAccountId(), "Failed to get Advertising ID: " + t.toString());
            }
            if (advertisingID != null && advertisingID.trim().length() > 2) {
                Object object = this.adIDLock;
                synchronized (object) {
                    this.googleAdID = advertisingID.replace("-", "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generateDeviceID() {
        String generatedDeviceID;
        String adId = this.getGoogleAdID();
        if (adId != null) {
            generatedDeviceID = "__g" + adId;
        } else {
            Object object = this.deviceIDLock;
            synchronized (object) {
                generatedDeviceID = this.generateGUID();
            }
        }
        this.forceUpdateDeviceId(generatedDeviceID);
    }

    private String generateGUID() {
        return GUID_PREFIX + UUID.randomUUID().toString().replace("-", "");
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private DeviceCachedInfo getDeviceCachedInfo() {
        if (this.cachedInfo == null) {
            this.cachedInfo = new DeviceCachedInfo();
        }
        return this.cachedInfo;
    }

    private String getDeviceIdStorageKey() {
        return "deviceId:" + this.config.getAccountId();
    }

    private String getFallBackDeviceID() {
        return StorageHelper.getString(this.context, this.getFallbackIdStorageKey(), null);
    }

    private String getFallbackIdStorageKey() {
        return "fallbackId:" + this.config.getAccountId();
    }

    private void initDeviceID(String cleverTapID) {
        String deviceID;
        String error;
        if (this.config.getEnableCustomCleverTapId()) {
            if (cleverTapID == null) {
                error = this.recordDeviceError(18, new String[0]);
                this.config.getLogger().info(error);
            }
        } else if (cleverTapID != null) {
            error = this.recordDeviceError(19, new String[0]);
            this.config.getLogger().info(error);
        }
        if ((deviceID = this._getDeviceID()) != null && deviceID.trim().length() > 2) {
            this.getConfigLogger().verbose(this.config.getAccountId(), "CleverTap ID already present for profile");
            if (cleverTapID != null) {
                String error2 = this.recordDeviceError(20, deviceID, cleverTapID);
                this.getConfigLogger().info(this.config.getAccountId(), error2);
            }
            return;
        }
        if (this.config.getEnableCustomCleverTapId()) {
            this.forceUpdateCustomCleverTapID(cleverTapID);
            return;
        }
        if (!this.config.isUseGoogleAdId()) {
            this.generateDeviceID();
            return;
        }
        Thread generateGUIDFromAdIDThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceInfo.this.fetchGoogleAdID();
                DeviceInfo.this.generateDeviceID();
                CleverTapAPI.instanceWithConfig(DeviceInfo.this.context, DeviceInfo.this.config).deviceIDCreated(DeviceInfo.this.getDeviceID());
            }
        });
        generateGUIDFromAdIDThread.start();
    }

    private String recordDeviceError(int messageCode, String ... varargs) {
        ValidationResult validationResult = ValidationResultFactory.create(514, messageCode, varargs);
        this.validationResults.add(validationResult);
        return validationResult.getErrorDesc();
    }

    private void removeDeviceID() {
        StorageHelper.remove(this.context, this.getDeviceIdStorageKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setOrGenerateFallbackDeviceID() {
        if (this.getFallBackDeviceID() == null) {
            Object object = this.deviceIDLock;
            synchronized (object) {
                String fallbackDeviceID = "__i" + UUID.randomUUID().toString().replace("-", "");
                if (fallbackDeviceID.trim().length() > 2) {
                    this.updateFallbackID(fallbackDeviceID);
                } else {
                    this.getConfigLogger().verbose(this.config.getAccountId(), "Unable to generate fallback error device ID");
                }
            }
        }
    }

    private void updateFallbackID(String fallbackId) {
        this.getConfigLogger().verbose(this.config.getAccountId(), "Updating the fallback id - " + fallbackId);
        StorageHelper.putString(this.context, this.getFallbackIdStorageKey(), fallbackId);
    }

    public static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }

    int getHeightPixels() {
        return this.getDeviceCachedInfo().heightPixels;
    }

    void enableDeviceNetworkInfoReporting(boolean value) {
        this.enableNetworkInfoReporting = value;
        StorageHelper.putBoolean(this.context, StorageHelper.storageKeyWithSuffix(this.config, "NetworkInfo"), this.enableNetworkInfoReporting);
        this.config.getLogger().verbose(this.config.getAccountId(), "Device Network Information reporting set to " + this.enableNetworkInfoReporting);
    }

    void setDeviceNetworkInfoReportingFromStorage() {
        boolean enabled = StorageHelper.getBooleanFromPrefs(this.context, this.config, "NetworkInfo");
        this.config.getLogger().verbose(this.config.getAccountId(), "Setting device network info reporting state from storage to " + enabled);
        this.enableNetworkInfoReporting = enabled;
    }

    int getWidthPixels() {
        return this.getDeviceCachedInfo().widthPixels;
    }

    public void setCurrentUserOptOutStateFromStorage() {
        String key = this.optOutKey();
        if (key == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Unable to set current user OptOut state from storage: storage key is null");
            return;
        }
        boolean storedOptOut = StorageHelper.getBooleanFromPrefs(this.context, this.config, key);
        this.mCoreMetaData.setCurrentUserOptedOut(storedOptOut);
        this.config.getLogger().verbose(this.config.getAccountId(), "Set current user OptOut state from storage to: " + storedOptOut + " for key: " + key);
    }

    String optOutKey() {
        String guid = this.getDeviceID();
        if (guid == null) {
            return null;
        }
        return "OptOut:" + guid;
    }

    private class DeviceCachedInfo {
        private final String bluetoothVersion;
        private final int build;
        private final String carrier;
        private final String countryCode;
        private final int dpi;
        private final double height;
        private final int heightPixels;
        private final String manufacturer;
        private final String model;
        private final String networkType;
        private final boolean notificationsEnabled;
        private final String osName;
        private final String osVersion;
        private final int sdkVersion;
        private final String versionName = this.getVersionName();
        private final double width;
        private final int widthPixels;

        DeviceCachedInfo() {
            this.osName = this.getOsName();
            this.osVersion = this.getOsVersion();
            this.manufacturer = this.getManufacturer();
            this.model = this.getModel();
            this.carrier = this.getCarrier();
            this.build = this.getBuild();
            this.networkType = this.getNetworkType();
            this.bluetoothVersion = this.getBluetoothVersion();
            this.countryCode = this.getCountryCode();
            this.sdkVersion = this.getSdkVersion();
            this.height = this.getHeight();
            this.heightPixels = this.getHeightPixels();
            this.width = this.getWidth();
            this.widthPixels = this.getWidthPixels();
            this.dpi = this.getDPI();
            this.notificationsEnabled = this.getNotificationEnabledForUser();
        }

        private String getBluetoothVersion() {
            String bluetoothVersion = "none";
            if (Build.VERSION.SDK_INT >= 18 && DeviceInfo.this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                bluetoothVersion = "ble";
            } else if (DeviceInfo.this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                bluetoothVersion = "classic";
            }
            return bluetoothVersion;
        }

        private int getBuild() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                return packageInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.d("Unable to get app build");
                return 0;
            }
        }

        private String getCarrier() {
            try {
                TelephonyManager manager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                if (manager != null) {
                    return manager.getNetworkOperatorName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private String getCountryCode() {
            try {
                TelephonyManager tm = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                if (tm != null) {
                    return tm.getSimCountryIso();
                }
            }
            finally {
                return "";
            }
            {
            }
        }

        private int getDPI() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            return dm.densityDpi;
        }

        private double getHeight() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0.0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            double rHeight = (float)dm.heightPixels / dm.ydpi;
            return this.toTwoPlaces(rHeight);
        }

        private int getHeightPixels() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            return dm.heightPixels;
        }

        private String getManufacturer() {
            return Build.MANUFACTURER;
        }

        private String getModel() {
            String model = Build.MODEL;
            model = model.replace(this.getManufacturer(), "");
            return model;
        }

        @SuppressLint(value={"MissingPermission"})
        private String getNetworkType() {
            return Utils.getDeviceNetworkType(DeviceInfo.this.context);
        }

        private boolean getNotificationEnabledForUser() {
            return NotificationManagerCompat.from((Context)DeviceInfo.this.context).areNotificationsEnabled();
        }

        private String getOsName() {
            return DeviceInfo.OS_NAME;
        }

        private String getOsVersion() {
            return Build.VERSION.RELEASE;
        }

        private int getSdkVersion() {
            return 40100;
        }

        private String getVersionName() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                return packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.d("Unable to get app version");
                return null;
            }
        }

        private double getWidth() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0.0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            double rWidth = (float)dm.widthPixels / dm.xdpi;
            return this.toTwoPlaces(rWidth);
        }

        private int getWidthPixels() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            return dm.widthPixels;
        }

        private double toTwoPlaces(double n) {
            double result = n * 100.0;
            result = Math.round(result);
            return result /= 100.0;
        }
    }
}

