/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ab_testing.CTABTestListener;
import com.clevertap.android.sdk.ab_testing.CTVar;
import com.clevertap.android.sdk.ab_testing.CTVarCache;
import com.clevertap.android.sdk.ab_testing.gesture.ConnectionGesture;
import com.clevertap.android.sdk.ab_testing.models.CTABVariant;
import com.clevertap.android.sdk.ab_testing.uieditor.UIEditor;
import com.clevertap.android.sdk.java_websocket.client.WebSocketClient;
import com.clevertap.android.sdk.java_websocket.drafts.Draft_6455;
import com.clevertap.android.sdk.java_websocket.enums.Opcode;
import com.clevertap.android.sdk.java_websocket.exceptions.NotSendableException;
import com.clevertap.android.sdk.java_websocket.exceptions.WebsocketNotConnectedException;
import com.clevertap.android.sdk.java_websocket.handshake.ServerHandshake;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(api=19)
public class CTABTestController {
    private static final ByteBuffer EMPTY_BYTE_BUFFER;
    private static final int EMULATOR_CONNECT_ATTEMPT_INTERVAL_MILLIS = 30000;
    private static final String DASHBOARD_URL = "dashboard.clevertap.com";
    private static final String DEFAULT_REGION = "eu1";
    private static final String MESSAGE_TYPE_HANDSHAKE = "handshake";
    private static final String MESSAGE_TYPE_CLEAR_REQUEST = "clear_request";
    private static final String MESSAGE_TYPE_CHANGE_REQUEST = "change_request";
    private static final String MESSAGE_TYPE_DEVICE_INFO_REQUEST = "device_info_request";
    private static final String MESSAGE_TYPE_DEVICE_INFO_RESPONSE = "device_info_response";
    private static final String MESSAGE_TYPE_SNAPSHOT_REQUEST = "snapshot_request";
    private static final String MESSAGE_TYPE_SNAPSHOT_RESPONSE = "snapshot_response";
    private static final String MESSAGE_TYPE_VARS_REQUEST = "vars_request";
    private static final String MESSAGE_TYPE_VARS_RESPONSE = "vars_response";
    private static final String MESSAGE_TYPE_LAYOUT_ERROR = "layout_error";
    private static final String MESSAGE_TYPE_GENERIC_ERROR = "error";
    private static final String MESSAGE_TYPE_VARS_TEST = "test_vars";
    private static final String MESSAGE_TYPE_MATCHED = "matched";
    private static final String MESSAGE_TYPE_DISCONNECT = "disconnect";
    private static final String DATA_KEY = "data";
    private static final String TYPE_KEY = "type";
    private static SSLSocketFactory SSLSocketFactory;
    private JSONObject cachedDeviceInfo;
    private CleverTapInstanceConfig config;
    private boolean enableEditor;
    private ExecutionThreadHandler executionThreadHandler;
    private String guid;
    private WeakReference<CTABTestListener> listenerWeakReference;
    private UIEditor uiEditor;
    private CTVarCache varCache;

    public CTABTestController(Context context, CleverTapInstanceConfig config, String guid, CTABTestListener listener) {
        try {
            this.varCache = new CTVarCache();
            this.enableEditor = config.isUIEditorEnabled();
            this.config = config;
            this.guid = guid;
            this.setListener(listener);
            this.uiEditor = new UIEditor(context, config);
            HandlerThread thread = new HandlerThread(CTABTestController.class.getCanonicalName());
            thread.setPriority(10);
            thread.start();
            this.executionThreadHandler = new ExecutionThreadHandler(context, config, thread.getLooper());
            this.executionThreadHandler.start();
            if (this.enableEditor) {
                Application app = (Application)context.getApplicationContext();
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
            } else {
                config.getLogger().debug(config.getAccountId(), "UIEditor connection is disabled");
            }
            this.applyStoredExperiments();
        }
        catch (Throwable t) {
            config.setEnableABTesting(false);
            config.setEnableUIEditor(false);
            config.getLogger().debug(config.getAccountId(), t);
        }
    }

    public Boolean getBooleanVariable(String name, Boolean defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.booleanValue() != null) {
                return var.booleanValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public Double getDoubleVariable(String name, Double defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.doubleValue() != null) {
                return var.doubleValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public Integer getIntegerVariable(String name, Integer defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.integerValue() != null) {
                return var.integerValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public List<Boolean> getListOfBooleanVariable(String name, List<Boolean> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.listValue() != null) {
                return var.listValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public List<Double> getListOfDoubleVariable(String name, List<Double> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.listValue() != null) {
                return var.listValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public List<Integer> getListOfIntegerVariable(String name, List<Integer> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.listValue() != null) {
                return var.listValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public List<String> getListOfStringVariable(String name, List<String> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.listValue() != null) {
                return var.listValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public Map<String, Boolean> getMapOfBooleanVariable(String name, Map<String, Boolean> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.mapValue() != null) {
                return var.mapValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public Map<String, Double> getMapOfDoubleVariable(String name, Map<String, Double> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.mapValue() != null) {
                return var.mapValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public Map<String, Integer> getMapOfIntegerVariable(String name, Map<String, Integer> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.mapValue() != null) {
                return var.mapValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public Map<String, String> getMapOfStringVariable(String name, Map<String, String> defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.mapValue() != null) {
                return var.mapValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public String getStringVariable(String name, String defaultValue) {
        CTVar var = this.varCache.getVar(name);
        try {
            if (var != null && var.stringValue() != null) {
                return var.stringValue();
            }
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Error getting variable with name: " + name, t);
            return defaultValue;
        }
        return defaultValue;
    }

    public void registerBooleanVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeBool, null);
    }

    public void registerDoubleVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeDouble, null);
    }

    public void registerIntegerVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeInteger, null);
    }

    public void registerListOfBooleanVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeListOfBool, null);
    }

    public void registerListOfDoubleVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeListOfDouble, null);
    }

    public void registerListOfIntegerVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeListOfInteger, null);
    }

    public void registerListOfStringVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeListOfString, null);
    }

    public void registerMapOfBooleanVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeMapOfBool, null);
    }

    public void registerMapOfDoubleVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeMapOfDouble, null);
    }

    public void registerMapOfIntegerVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeMapOfInteger, null);
    }

    public void registerMapOfStringVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeMapOfString, null);
    }

    public void registerStringVariable(String name) {
        this._registerVar(name, CTVar.CTVarType.CTVarTypeString, null);
    }

    public void resetWithGuid(String guid) {
        this.guid = guid;
        this.varCache.reset();
        this.uiEditor.stopVariants();
        this.applyStoredExperiments();
    }

    public void updateExperiments(JSONArray experiments) {
        if (experiments != null) {
            Message message = this.executionThreadHandler.obtainMessage(6);
            message.obj = experiments;
            this.executionThreadHandler.sendMessage(message);
        }
    }

    private void _registerVar(String name, CTVar.CTVarType type, Object value) {
        this.varCache.registerVar(name, type, value);
        this.config.getLogger().verbose(this.config.getAccountId(), "Registered Var with name: " + name + " type: " + type.toString() + " and value: " + (value != null ? value.toString() : "null"));
    }

    private void applyStoredExperiments() {
        this.executionThreadHandler.sendMessage(this.executionThreadHandler.obtainMessage(0));
    }

    private CTABTestListener getListener() {
        CTABTestListener listener = null;
        try {
            listener = (CTABTestListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "CTABTestListener is null in CTABTestController");
        }
        return listener;
    }

    private void setListener(CTABTestListener listener) {
        this.listenerWeakReference = new WeakReference<CTABTestListener>(listener);
    }

    private void handleDashboardMessage(JSONObject msg) {
        JSONObject messageObject;
        String type = msg.optString(TYPE_KEY, "unknown");
        int messageCode = -1;
        switch (type) {
            case "change_request": {
                messageCode = 3;
                break;
            }
            case "clear_request": {
                messageCode = 7;
                break;
            }
            case "device_info_request": {
                messageCode = 4;
                break;
            }
            case "snapshot_request": {
                messageCode = 2;
                break;
            }
            case "vars_request": {
                messageCode = 11;
                break;
            }
            case "test_vars": {
                messageCode = 12;
                break;
            }
            case "matched": {
                messageCode = 13;
                break;
            }
            case "disconnect": {
                messageCode = 5;
            }
        }
        Message m = this.executionThreadHandler.obtainMessage(messageCode);
        try {
            messageObject = msg.getJSONObject(DATA_KEY);
        }
        catch (Throwable t) {
            messageObject = new JSONObject();
        }
        m.obj = messageObject;
        this.executionThreadHandler.sendMessage(m);
    }

    static {
        SSLSocketFactory found;
        EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            found = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            Logger.d("No SSL support. ABTest editor not available", e.getLocalizedMessage());
            found = null;
        }
        SSLSocketFactory = found;
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    ConnectionGesture.OnGestureListener {
        private EmulatorConnectRunnable emulatorConnectRunnable;
        private ConnectionGesture gesture = new ConnectionGesture(this);

        private LifecycleCallbacks() {
            this.emulatorConnectRunnable = new EmulatorConnectRunnable();
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
            CTABTestController.this.uiEditor.removeActivity(activity);
            this.deregisterConnectionTrigger(activity);
        }

        public void onActivityResumed(Activity activity) {
            this.registerConnectionTrigger(activity);
            CTABTestController.this.uiEditor.addActivity(activity);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        @Override
        public void onGesture() {
            Message message = CTABTestController.this.executionThreadHandler.obtainMessage(1);
            CTABTestController.this.executionThreadHandler.sendMessage(message);
        }

        private void deregisterConnectionTrigger(Activity activity) {
            if (!CTABTestController.this.enableEditor) {
                CTABTestController.this.config.getLogger().debug(CTABTestController.this.config.getAccountId(), "UIEditor is disabled");
                return;
            }
            if (this.inEmulator()) {
                this.emulatorConnectRunnable.stop();
            } else {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                if (sensorManager != null) {
                    sensorManager.unregisterListener((SensorEventListener)this.gesture);
                }
            }
        }

        private boolean inEmulator() {
            if (!Build.HARDWARE.toLowerCase().equals("goldfish") && !Build.HARDWARE.toLowerCase().equals("ranchu")) {
                return false;
            }
            if (!(Build.BRAND.toLowerCase().startsWith("generic") || Build.BRAND.toLowerCase().equals("android") || Build.BRAND.toLowerCase().equals("google"))) {
                return false;
            }
            if (!Build.DEVICE.toLowerCase().startsWith("generic")) {
                return false;
            }
            if (!Build.PRODUCT.toLowerCase().contains("sdk")) {
                return false;
            }
            return Build.MODEL.toLowerCase(Locale.US).contains("sdk");
        }

        private void registerConnectionTrigger(Activity activity) {
            if (!CTABTestController.this.enableEditor) {
                CTABTestController.this.config.getLogger().debug(CTABTestController.this.config.getAccountId(), "UIEditor is disabled");
                return;
            }
            if (this.inEmulator()) {
                this.emulatorConnectRunnable.start();
            } else {
                try {
                    SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                    Sensor accelerometer = sensorManager.getDefaultSensor(1);
                    sensorManager.registerListener((SensorEventListener)this.gesture, accelerometer, 3);
                }
                catch (Throwable t) {
                    CTABTestController.this.config.getLogger().debug(CTABTestController.this.config.getAccountId(), "Unable to register UIEditor connection gesture");
                }
            }
        }
    }

    private class EmulatorConnectRunnable
    implements Runnable {
        private volatile boolean stopped = true;

        EmulatorConnectRunnable() {
        }

        @Override
        public void run() {
            if (!this.stopped) {
                Message message = CTABTestController.this.executionThreadHandler.obtainMessage(1);
                CTABTestController.this.executionThreadHandler.sendMessage(message);
            }
            CTABTestController.this.executionThreadHandler.postDelayed(this, 30000L);
        }

        void start() {
            this.stopped = false;
            CTABTestController.this.executionThreadHandler.post(this);
        }

        void stop() {
            this.stopped = true;
            CTABTestController.this.executionThreadHandler.removeCallbacks(this);
        }
    }

    private class ExecutionThreadHandler
    extends Handler {
        static final int MESSAGE_UNKNOWN = -1;
        static final int MESSAGE_INITIALIZE_EXPERIMENTS = 0;
        static final int MESSAGE_CONNECT_TO_EDITOR = 1;
        static final int MESSAGE_SEND_SNAPSHOT = 2;
        static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
        static final int MESSAGE_SEND_DEVICE_INFO = 4;
        static final int MESSAGE_HANDLE_DISCONNECT = 5;
        static final int MESSAGE_EXPERIMENTS_RECEIVED = 6;
        static final int MESSAGE_HANDLE_EDITOR_CHANGES_CLEARED = 7;
        static final int MESSAGE_HANDLE_EDITOR_VARS_RECEIVED = 8;
        static final int MESSAGE_SEND_LAYOUT_ERROR = 9;
        static final int MESSAGE_PERSIST_EXPERIMENTS = 10;
        static final int MESSAGE_SEND_VARS = 11;
        static final int MESSAGE_TEST_VARS = 12;
        static final int MESSAGE_MATCHED = 13;
        private static final String EXPERIMENTS_KEY = "experiments";
        private static final int CONNECT_TIMEOUT = 5000;
        private CleverTapInstanceConfig config;
        private Context context;
        private CTABVariant editorSessionVariant;
        private HashSet<CTABVariant> editorSessionVariantSet;
        private final Lock lock;
        private Set<CTABVariant> variants;
        private DashboardClient wsClient;

        ExecutionThreadHandler(Context context, CleverTapInstanceConfig config, Looper looper) {
            super(looper);
            this.lock = new ReentrantLock();
            this.config = config;
            this.context = context;
            this.variants = new HashSet<CTABVariant>();
            this.lock.lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            this.lock.lock();
            try {
                int what = msg.what;
                Object data = msg.obj;
                switch (what) {
                    case 0: {
                        this.loadStoredExperiments();
                        return;
                    }
                    case 1: {
                        this.createConnection();
                        return;
                    }
                    case 13: {
                        this.handleMatched();
                        return;
                    }
                    case 5: {
                        this.handleDashboardDisconnect();
                        return;
                    }
                    case 4: {
                        this.sendDeviceInfo();
                        return;
                    }
                    case 2: {
                        this.sendSnapshot((JSONObject)data);
                        return;
                    }
                    case 9: {
                        this.sendLayoutError((LayoutErrorMessage)msg.obj);
                        return;
                    }
                    case 6: {
                        this.applyExperiments((JSONArray)data, true);
                        return;
                    }
                    case 3: {
                        this.handleEditorChangesReceived((JSONObject)data);
                        return;
                    }
                    case 7: {
                        this.handleEditorChangesCleared((JSONObject)data);
                        return;
                    }
                    case 8: 
                    case 12: {
                        this.handleEditorVarsReceived((JSONObject)data);
                        return;
                    }
                    case 10: {
                        this.persistExperiments((JSONArray)data);
                        return;
                    }
                    case 11: {
                        this.sendVars();
                        return;
                    }
                }
                return;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void start() {
            this.lock.unlock();
        }

        void handleMatched() {
            CTABTestController.this.varCache.reset();
            this.stopVariants();
        }

        boolean isConnected() {
            return this.wsClient != null && this.wsClient.isOpen();
        }

        private void applyExperiments(JSONArray experiments, boolean areNew) {
            this.loadVariants(experiments);
            this.applyVariants();
            if (areNew) {
                this.persistExperiments(experiments);
            }
            this.notifyExperimentsUpdated();
        }

        private void applyVariants() {
            for (CTABVariant variant : this.variants) {
                this.applyVars(variant.getVars());
            }
            CTABTestController.this.uiEditor.applyVariants(this.variants, false);
        }

        private void applyVars(JSONArray vars) {
            try {
                for (int i = 0; i < vars.length(); ++i) {
                    JSONObject var = vars.getJSONObject(i);
                    CTABTestController.this._registerVar(var.getString("name"), CTVar.CTVarType.fromString(var.getString(CTABTestController.TYPE_KEY)), var.get("value"));
                }
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to apply Vars - " + t);
            }
        }

        private void closeConnection() {
            if (this.connectionIsValid()) {
                try {
                    this.getConfigLogger().verbose(this.getAccountId(), "disconnecting from dashboard");
                    this.wsClient.closeBlocking();
                }
                catch (Exception e) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Unable to close dashboard connection", e);
                }
            }
        }

        private boolean connectionIsValid() {
            return this.wsClient != null && !this.wsClient.isClosed() && !this.wsClient.isClosing() && !this.wsClient.isFlushAndClose();
        }

        private void createConnection() {
            this.getConfigLogger().verbose(this.getAccountId(), "connecting to dashboard");
            if (this.isConnected() && this.connectionIsValid()) {
                this.getConfigLogger().verbose(this.getAccountId(), "There is already a valid dashboard connection.");
                return;
            }
            if (SSLSocketFactory == null) {
                this.getConfigLogger().verbose(this.getAccountId(), "SSL is not available on this device, dashboard connection is not available.");
                return;
            }
            String protocol = "wss";
            String region = this.config.getAccountRegion() != null ? this.config.getAccountRegion() : CTABTestController.DEFAULT_REGION;
            region = this.config.isBeta() ? region + "-dashboard-beta" : region;
            String domain = region + "." + CTABTestController.DASHBOARD_URL;
            String url = "wss://" + domain + "/" + this.getAccountId() + "/websocket/screenab/sdk?tk=" + this.config.getAccountToken();
            this.getConfigLogger().verbose(this.getAccountId(), "Websocket URL - " + url);
            try {
                this.wsClient = new DashboardClient(new URI(url), 5000);
                this.wsClient.connectBlocking();
            }
            catch (Exception e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Unable to connect to dashboard", e);
            }
        }

        private String getAccountId() {
            return this.config.getAccountId();
        }

        private BufferedOutputStream getBufferedOutputStream() {
            return new BufferedOutputStream(new WebSocketOutputStream());
        }

        private Logger getConfigLogger() {
            return this.config.getLogger();
        }

        private JSONObject getDeviceInfo() {
            if (CTABTestController.this.cachedDeviceInfo == null) {
                JSONObject data = new JSONObject();
                try {
                    Map<String, String> deviceInfo = CleverTapAPI.instanceWithConfig(this.context, this.config).getDeviceInfo();
                    for (Map.Entry<String, String> entry : deviceInfo.entrySet()) {
                        data.put(entry.getKey(), (Object)entry.getValue());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CTABTestController.this.cachedDeviceInfo = data;
            }
            return CTABTestController.this.cachedDeviceInfo;
        }

        private CTABVariant getEditorSessionVariant() {
            if (this.editorSessionVariant == null) {
                try {
                    JSONObject variant = new JSONObject();
                    variant.put("id", (Object)"0");
                    variant.put("experiment_id", (Object)"0");
                    this.editorSessionVariant = CTABVariant.initWithJSON(variant);
                    this.editorSessionVariantSet = new HashSet();
                    this.editorSessionVariantSet.add(this.editorSessionVariant);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Error creating editor session variant", t);
                }
            }
            return this.editorSessionVariant;
        }

        private SharedPreferences getSharedPreferences() {
            return this.context.getSharedPreferences(this.getSharedPrefsName(), 0);
        }

        private String getSharedPrefsName() {
            return "clevertap.abtesting." + this.getAccountId() + "." + CTABTestController.this.guid;
        }

        private void handleDashboardDisconnect() {
            this.stopVariants();
            this.closeConnection();
        }

        private void handleEditorChangesCleared(JSONObject request) {
            try {
                JSONArray changes = request.optJSONArray("actions");
                if (changes == null || changes.length() <= 0) {
                    this.getEditorSessionVariant().clearActions();
                } else {
                    this.getEditorSessionVariant().removeActionsByName(changes);
                }
                CTABTestController.this.uiEditor.applyVariants(this.editorSessionVariantSet, true);
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to clear dashboard changes - " + t);
            }
        }

        private void handleEditorChangesReceived(JSONObject request) {
            try {
                JSONArray changes = request.optJSONArray("actions");
                if (changes == null || changes.length() <= 0) {
                    this.getConfigLogger().debug(this.getAccountId(), "No changes received from dashboard");
                    return;
                }
                this.getEditorSessionVariant().addActions(changes);
                CTABTestController.this.uiEditor.applyVariants(this.editorSessionVariantSet, true);
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to handle dashboard changes received - " + t);
            }
        }

        private void handleEditorVarsReceived(JSONObject request) {
            try {
                JSONArray vars = request.optJSONArray("vars");
                if (vars == null || vars.length() <= 0) {
                    this.getConfigLogger().debug(this.getAccountId(), "No Vars received from dashboard");
                    return;
                }
                this.applyVars(vars);
                this.notifyExperimentsUpdated();
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to handle dashboard Vars received - " + t);
            }
        }

        private void handleOnClose() {
            this.getConfigLogger().verbose(this.getAccountId(), "handle websocket on close");
            this.stopVariants();
            this.getEditorSessionVariant().clearActions();
            CTABTestController.this.varCache.reset();
            this.applyVariants();
        }

        private void handleOnOpen() {
            this.sendHandshake();
        }

        private void loadStoredExperiments() {
            SharedPreferences preferences = this.getSharedPreferences();
            String storedExperiments = preferences.getString(EXPERIMENTS_KEY, null);
            if (storedExperiments != null) {
                try {
                    this.getConfigLogger().debug(this.getAccountId(), "Loading Stored Experiments: " + storedExperiments + " for key: " + this.getSharedPrefsName());
                    JSONArray _experiments = new JSONArray(storedExperiments);
                    this.applyExperiments(_experiments, false);
                }
                catch (JSONException e) {
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove(EXPERIMENTS_KEY);
                    editor.apply();
                }
            } else {
                this.getConfigLogger().debug(this.getAccountId(), "No Stored Experiments for key: " + this.getSharedPrefsName());
            }
        }

        private void loadVariants(JSONArray experiments) {
            if (experiments == null) {
                return;
            }
            try {
                HashSet<CTABVariant> toRemove = new HashSet<CTABVariant>(this.variants);
                HashSet<CTABVariant> allVariants = new HashSet<CTABVariant>(this.variants);
                int experimentsLength = experiments.length();
                for (int i = 0; i < experimentsLength; ++i) {
                    boolean added;
                    JSONObject nextVariant = experiments.getJSONObject(i);
                    CTABVariant variant = CTABVariant.initWithJSON(nextVariant);
                    if (variant == null || !(added = allVariants.add(variant))) continue;
                    toRemove.remove(variant);
                }
                if (!allVariants.containsAll(toRemove) && toRemove.size() > 0) {
                    for (CTABVariant v : toRemove) {
                        v.cleanup();
                        allVariants.remove(v);
                    }
                }
                if (experiments.length() == 0) {
                    allVariants.clear();
                }
                this.variants = allVariants;
            }
            catch (JSONException e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Error loading variants, clearing all running variants", e);
                this.variants.clear();
            }
        }

        private void notifyExperimentsUpdated() {
            CTABTestListener listener = CTABTestController.this.getListener();
            if (listener != null) {
                listener.ABExperimentsUpdated();
            }
        }

        private void persistExperiments(JSONArray experiments) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(EXPERIMENTS_KEY, experiments.toString());
            editor.apply();
        }

        private void sendDeviceInfo() {
            try {
                JSONObject payload = new JSONObject();
                payload.put(CTABTestController.TYPE_KEY, (Object)CTABTestController.MESSAGE_TYPE_DEVICE_INFO_RESPONSE);
                payload.put(CTABTestController.DATA_KEY, (Object)this.getDeviceInfo());
                this.sendMessage(payload.toString());
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to create deviceInfo message", t);
            }
        }

        private void sendError(String errorMessage) {
            try {
                JSONObject data = new JSONObject();
                data.put(CTABTestController.MESSAGE_TYPE_GENERIC_ERROR, (Object)errorMessage);
                JSONObject payload = new JSONObject();
                payload.put(CTABTestController.TYPE_KEY, (Object)CTABTestController.MESSAGE_TYPE_GENERIC_ERROR);
                payload.put(CTABTestController.DATA_KEY, (Object)data);
                this.sendMessage(payload.toString());
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to create error message", t);
            }
        }

        private void sendHandshake() {
            try {
                JSONObject deviceInfo = this.getDeviceInfo();
                JSONObject data = new JSONObject();
                data.put("id", (Object)CTABTestController.this.guid);
                data.put("os", (Object)deviceInfo.getString("osName"));
                data.put("name", (Object)(deviceInfo.getString("manufacturer") + " " + deviceInfo.getString("model")));
                if (deviceInfo.has("library")) {
                    data.put("library", (Object)deviceInfo.getString("library"));
                }
                JSONObject payload = new JSONObject();
                payload.put(CTABTestController.TYPE_KEY, (Object)CTABTestController.MESSAGE_TYPE_HANDSHAKE);
                payload.put(CTABTestController.DATA_KEY, (Object)data);
                this.sendMessage(payload.toString());
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to create handshake message", t);
            }
        }

        private void sendLayoutError(LayoutErrorMessage errorMessage) {
            try {
                JSONObject data = new JSONObject();
                data.put(CTABTestController.TYPE_KEY, (Object)errorMessage.getType());
                data.put("name", (Object)errorMessage.getName());
                JSONObject payload = new JSONObject();
                payload.put(CTABTestController.TYPE_KEY, (Object)CTABTestController.MESSAGE_TYPE_LAYOUT_ERROR);
                payload.put(CTABTestController.DATA_KEY, (Object)data);
                this.sendMessage(payload.toString());
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to create error message", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(String message) {
            if (!this.connectionIsValid()) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to send websocket message: " + message + " connection is invalid");
                return;
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.getBufferedOutputStream());
            this.getConfigLogger().verbose("Sending message to dashboard - " + message);
            try {
                writer.write(message);
            }
            catch (IOException e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Can't message to editor", e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Could not close output writer to editor", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSnapshot(JSONObject data) {
            long startSnapshot = System.currentTimeMillis();
            boolean isValidSnapshot = CTABTestController.this.uiEditor.loadSnapshotConfig(data);
            if (!isValidSnapshot) {
                String err = "Missing or invalid snapshot configuration.";
                this.sendError(err);
                this.getConfigLogger().debug(this.getAccountId(), err);
                return;
            }
            BufferedOutputStream out = this.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{");
                writer.write("\"type\": \"snapshot_response\",");
                writer.write("\"data\": {");
                writer.write("\"activities\":");
                writer.flush();
                CTABTestController.this.uiEditor.writeSnapshot(out);
                long snapshotTime = System.currentTimeMillis() - startSnapshot;
                writer.write(",\"snapshot_time_millis\": ");
                writer.write(Long.toString(snapshotTime));
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failure sending snapshot", e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Failure closing json writer", e);
                }
            }
        }

        private void sendVars() {
            try {
                JSONObject data = new JSONObject();
                data.put("vars", (Object)CTABTestController.this.varCache.serializeVars());
                JSONObject payload = new JSONObject();
                payload.put(CTABTestController.TYPE_KEY, (Object)CTABTestController.MESSAGE_TYPE_VARS_RESPONSE);
                payload.put(CTABTestController.DATA_KEY, (Object)data);
                this.sendMessage(payload.toString());
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "Unable to create vars message", t);
            }
        }

        private void stopVariants() {
            CTABTestController.this.uiEditor.stopVariants();
        }

        private class WebSocketOutputStream
        extends OutputStream {
            private WebSocketOutputStream() {
            }

            @Override
            public void close() {
                try {
                    ExecutionThreadHandler.this.wsClient.sendFragmentedFrame(Opcode.TEXT, EMPTY_BYTE_BUFFER, true);
                }
                catch (WebsocketNotConnectedException e) {
                    ExecutionThreadHandler.this.getConfigLogger().debug(ExecutionThreadHandler.this.getAccountId(), "Web socket not connected", e);
                }
                catch (NotSendableException e) {
                    ExecutionThreadHandler.this.getConfigLogger().debug(ExecutionThreadHandler.this.getAccountId(), "Unable to send data to web socket", e);
                }
            }

            @Override
            public void write(@NonNull byte[] b) {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(@NonNull byte[] b, int off, int len) {
                ByteBuffer message = ByteBuffer.wrap(b, off, len);
                try {
                    ExecutionThreadHandler.this.wsClient.sendFragmentedFrame(Opcode.TEXT, message, false);
                }
                catch (WebsocketNotConnectedException e) {
                    ExecutionThreadHandler.this.getConfigLogger().debug(ExecutionThreadHandler.this.getAccountId(), "Web socket not connected", e);
                }
                catch (NotSendableException e) {
                    ExecutionThreadHandler.this.getConfigLogger().debug(ExecutionThreadHandler.this.getAccountId(), "Unable to send data to web socket", e);
                }
            }

            @Override
            public void write(int b) {
                byte[] oneByte = new byte[]{(byte)b};
                this.write(oneByte, 0, 1);
            }
        }

        private class DashboardClient
        extends WebSocketClient {
            private URI dashboardURI;

            private DashboardClient(URI uri, int connectTimeout) {
                super(uri, new Draft_6455(), null, connectTimeout);
                this.dashboardURI = uri;
                this.setSocketFactory(SSLSocketFactory);
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "WebSocket closed. Code: " + code + ", reason: " + reason + "\nURI: " + this.dashboardURI);
                ExecutionThreadHandler.this.handleOnClose();
            }

            @Override
            public void onError(Exception ex) {
                if (ex != null && ex.getMessage() != null) {
                    ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "Websocket Error: " + ex.getMessage());
                } else {
                    ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "Unknown websocket error");
                }
            }

            @Override
            public void onMessage(String message) {
                try {
                    JSONObject messageJson = new JSONObject(message);
                    if (messageJson.has(CTABTestController.DATA_KEY) && messageJson.getJSONObject(CTABTestController.DATA_KEY).keys().hasNext()) {
                        ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "Received message from dashboard:\n" + message);
                    }
                    if (!ExecutionThreadHandler.this.connectionIsValid()) {
                        ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "Dashboard connection is stale, dropping message: " + message);
                        return;
                    }
                    CTABTestController.this.handleDashboardMessage(messageJson);
                }
                catch (JSONException e) {
                    ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "Bad JSON message received:" + message, e);
                }
            }

            @Override
            public void onOpen(ServerHandshake handshakedata) {
                ExecutionThreadHandler.this.getConfigLogger().verbose(ExecutionThreadHandler.this.getAccountId(), "Websocket connected");
                ExecutionThreadHandler.this.handleOnOpen();
            }
        }
    }

    public static class LayoutErrorMessage {
        private final String errorName;
        private final String errorType;

        public LayoutErrorMessage(String type, String name) {
            this.errorType = type;
            this.errorName = name;
        }

        public String getName() {
            return this.errorName;
        }

        public String getType() {
            return this.errorType;
        }
    }
}

