/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.webkit.JavascriptInterface;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import java.lang.ref.WeakReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTWebInterface {
    private WeakReference<CleverTapAPI> weakReference;

    public CTWebInterface(CleverTapAPI instance) {
        this.weakReference = new WeakReference<CleverTapAPI>(instance);
    }

    @JavascriptInterface
    public void addMultiValueForKey(String key, String value) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            cleverTapAPI.addMultiValueForKey(key, value);
        }
    }

    @JavascriptInterface
    public void addMultiValuesForKey(String key, String values) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (values != null) {
                try {
                    JSONArray valuesArray = new JSONArray(values);
                    cleverTapAPI.addMultiValuesForKey(key, Utils.convertJSONArrayToArrayList(valuesArray));
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse values from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("values passed to CTWebInterface is null");
            }
        }
    }

    @JavascriptInterface
    public void pushEvent(String eventName) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            cleverTapAPI.pushEvent(eventName);
        }
    }

    @JavascriptInterface
    public void pushEvent(String eventName, String eventActions) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else if (eventActions != null) {
            try {
                JSONObject eventActionsObject = new JSONObject(eventActions);
                cleverTapAPI.pushEvent(eventName, Utils.convertJSONObjectToHashMap(eventActionsObject));
            }
            catch (JSONException e) {
                Logger.v("Unable to parse eventActions from WebView " + e.getLocalizedMessage());
            }
        } else {
            Logger.v("eventActions passed to CTWebInterface is null");
        }
    }

    @JavascriptInterface
    public void pushProfile(String profile) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else if (profile != null) {
            try {
                JSONObject profileObject = new JSONObject(profile);
                cleverTapAPI.pushProfile(Utils.convertJSONObjectToHashMap(profileObject));
            }
            catch (JSONException e) {
                Logger.v("Unable to parse profile from WebView " + e.getLocalizedMessage());
            }
        } else {
            Logger.v("profile passed to CTWebInterface is null");
        }
    }

    @JavascriptInterface
    public void removeMultiValueForKey(String key, String value) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (value == null) {
                Logger.v("Value passed to CTWebInterface is null");
                return;
            }
            cleverTapAPI.removeMultiValueForKey(key, value);
        }
    }

    @JavascriptInterface
    public void removeMultiValuesForKey(String key, String values) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (values != null) {
                try {
                    JSONArray valuesArray = new JSONArray(values);
                    cleverTapAPI.removeMultiValuesForKey(key, Utils.convertJSONArrayToArrayList(valuesArray));
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse values from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("values passed to CTWebInterface is null");
            }
        }
    }

    @JavascriptInterface
    public void removeValueForKey(String key) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            cleverTapAPI.removeValueForKey(key);
        }
    }

    @JavascriptInterface
    public void setMultiValueForKey(String key, String values) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.weakReference.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (values != null) {
                try {
                    JSONArray valuesArray = new JSONArray(values);
                    cleverTapAPI.setMultiValuesForKey(key, Utils.convertJSONArrayToArrayList(valuesArray));
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse values from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("values passed to CTWebInterface is null");
            }
        }
    }
}

