/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.uieditor;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ab_testing.uieditor.ViewCaller;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class ViewEdit {
    private final List<PathElement> path;
    private final Pathfinder pathFinder;
    private final ViewCaller mutator;
    private final ViewCaller accessor;
    private final WeakHashMap<View, Object> originalValues;
    private final Object[] originalValueHolder;
    private Context context;

    ViewEdit(List<PathElement> path, ViewCaller mutator, ViewCaller accessor, Context context) {
        this.path = path;
        this.pathFinder = new Pathfinder();
        this.mutator = mutator;
        this.accessor = accessor;
        this.originalValueHolder = new Object[1];
        this.originalValues = new WeakHashMap();
        this.context = context;
    }

    private List<PathElement> getPath() {
        return this.path;
    }

    void run(View rootView) {
        this.pathFinder.findTargetsInRoot(rootView, this.getPath(), this);
    }

    void cleanup() {
        for (Map.Entry<View, Object> original : this.originalValues.entrySet()) {
            View changedView = original.getKey();
            Object originalValue = original.getValue();
            if (originalValue == null) continue;
            this.originalValueHolder[0] = originalValue instanceof ColorStateList ? Integer.valueOf(((ColorStateList)originalValue).getDefaultColor()) : originalValue;
            this.mutator.invokeMethodWithArgs(changedView, this.originalValueHolder);
        }
    }

    private void apply(View targetView) {
        Object[] args;
        if (this.accessor != null && (args = this.mutator.getArgs()).length == 1) {
            Object targetValue = args[0];
            Object currentValue = this.accessor.invokeMethod(targetView);
            if (this.accessor.getMethodName().equals("getTextSize")) {
                currentValue = Float.valueOf(((Float)currentValue).floatValue() / this.context.getResources().getDisplayMetrics().scaledDensity);
            }
            if (targetValue == currentValue) {
                return;
            }
            if (targetValue != null) {
                if (targetValue instanceof Bitmap && currentValue instanceof Bitmap) {
                    Bitmap targetBitmap = (Bitmap)targetValue;
                    Bitmap currentBitmap = (Bitmap)currentValue;
                    if (targetBitmap.sameAs(currentBitmap)) {
                        return;
                    }
                } else if (targetValue instanceof BitmapDrawable && currentValue instanceof BitmapDrawable) {
                    Bitmap targetBitmap = ((BitmapDrawable)targetValue).getBitmap();
                    Bitmap currentBitmap = ((BitmapDrawable)currentValue).getBitmap();
                    if (targetBitmap != null && targetBitmap.sameAs(currentBitmap)) {
                        return;
                    }
                } else if (targetValue.equals(currentValue)) {
                    return;
                }
            }
            if (!this.originalValues.containsKey(targetView)) {
                this.originalValueHolder[0] = currentValue;
                if (this.mutator.argsAreApplicable(this.originalValueHolder)) {
                    this.originalValues.put(targetView, currentValue);
                } else {
                    this.originalValues.put(targetView, null);
                }
            }
        }
        this.mutator.invokeMethod(targetView);
    }

    protected String name() {
        return "Property Mutator";
    }

    private class Pathfinder {
        private final IntStack indexStack = new IntStack();

        Pathfinder() {
        }

        void findTargetsInRoot(View givenRootView, List<PathElement> path, ViewEdit viewEdit) {
            if (path.isEmpty()) {
                return;
            }
            if (this.indexStack.isFull()) {
                Logger.v("There appears to be a concurrency issue in the pathfinding code. Path will not be matched.");
                return;
            }
            PathElement rootPathElement = path.get(0);
            List<PathElement> childPath = path.subList(1, path.size());
            int indexKey = this.indexStack.allocate();
            View rootView = this.findMatch(rootPathElement, givenRootView, indexKey);
            this.indexStack.free();
            if (rootView != null) {
                this.findTargetsInMatchedView(rootView, childPath, viewEdit);
            }
        }

        private void findTargetsInMatchedView(View alreadyMatched, List<PathElement> remainingPath, ViewEdit viewEdit) {
            if (remainingPath.isEmpty()) {
                viewEdit.apply(alreadyMatched);
                return;
            }
            if (!(alreadyMatched instanceof ViewGroup)) {
                return;
            }
            if (this.indexStack.isFull()) {
                Logger.v("Path too deep, will not match");
                return;
            }
            ViewGroup parent = (ViewGroup)alreadyMatched;
            PathElement pathElement = remainingPath.get(0);
            List<PathElement> next = remainingPath.subList(1, remainingPath.size());
            int childCount = parent.getChildCount();
            int indexKey = this.indexStack.allocate();
            for (int i = 0; i < childCount; ++i) {
                View givenChild = parent.getChildAt(i);
                View child = this.findMatch(pathElement, givenChild, indexKey);
                if (child != null) {
                    this.findTargetsInMatchedView(child, next, viewEdit);
                }
                if (pathElement.index >= 0 && this.indexStack.read(indexKey) > pathElement.index) break;
            }
            this.indexStack.free();
        }

        private View findMatch(PathElement pathElement, View target, int indexKey) {
            int currentIndex = this.indexStack.read(indexKey);
            if (this.matches(pathElement, target)) {
                this.indexStack.increment(indexKey);
                if (pathElement.index == -1 || pathElement.index == currentIndex) {
                    return target;
                }
            }
            if (pathElement.prefix == 1 && target instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)target;
                int childCount = group.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    View child = group.getChildAt(i);
                    View result = this.findMatch(pathElement, child, indexKey);
                    if (null == result) continue;
                    return result;
                }
            }
            return null;
        }

        private boolean matches(PathElement pathElement, View target) {
            if (pathElement.viewClassName != null && !this.hasClassName(target, pathElement.viewClassName)) {
                return false;
            }
            if (pathElement.viewId != -1 && target.getId() != pathElement.viewId) {
                return false;
            }
            if (pathElement.contentDescription != null && !pathElement.contentDescription.contentEquals(target.getContentDescription())) {
                return false;
            }
            String matchTag = pathElement.tag;
            if (pathElement.tag != null) {
                Object targetTag = target.getTag();
                return targetTag != null && matchTag.equals(target.getTag().toString());
            }
            return true;
        }

        private boolean hasClassName(Object o, String className) {
            Class<?> klass = o.getClass();
            String klassCanonicalName = klass.getCanonicalName();
            return klassCanonicalName != null && klassCanonicalName.equals(className);
        }

        private class IntStack {
            private final int[] stack = new int[256];
            private int stackSize = 0;
            private static final int MAX_SIZE = 256;

            IntStack() {
            }

            boolean isFull() {
                return this.stack.length == this.stackSize;
            }

            int allocate() {
                int index = this.stackSize++;
                this.stack[index] = 0;
                return index;
            }

            public int read(int index) {
                return this.stack[index];
            }

            void increment(int index) {
                int n = index;
                this.stack[n] = this.stack[n] + 1;
            }

            public void free() {
                --this.stackSize;
                if (this.stackSize < 0) {
                    throw new ArrayIndexOutOfBoundsException(this.stackSize);
                }
            }
        }
    }

    static class PathElement {
        final int prefix;
        final String viewClassName;
        public final int index;
        final int viewId;
        final String contentDescription;
        final String tag;
        static final int ZERO_LENGTH_PREFIX = 0;
        static final int SHORTEST_PREFIX = 1;

        PathElement(int usePrefix, String className, int idx, int id2, String cDesc, String vTag) {
            this.prefix = usePrefix;
            this.viewClassName = className;
            this.index = idx;
            this.viewId = id2;
            this.contentDescription = cDesc;
            this.tag = vTag;
        }

        @NonNull
        public String toString() {
            try {
                JSONObject s = new JSONObject();
                if (this.prefix == 1) {
                    s.put("prefix", (Object)"shortest");
                }
                if (null != this.viewClassName) {
                    s.put("view_class", (Object)this.viewClassName);
                }
                if (this.index > -1) {
                    s.put("index", this.index);
                }
                if (this.viewId > -1) {
                    s.put("id", this.viewId);
                }
                if (null != this.contentDescription) {
                    s.put("contentDescription", (Object)this.contentDescription);
                }
                if (null != this.tag) {
                    s.put("tag", (Object)this.tag);
                }
                return s.toString();
            }
            catch (JSONException e) {
                throw new RuntimeException("Can't serialize PathElement to String", e);
            }
        }
    }
}

