/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.featureFlags;

import android.content.Context;
import android.text.TextUtils;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.FileUtils;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.TaskManager;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.featureFlags.FeatureFlagListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTFeatureFlagsController {
    private String guid;
    private final CleverTapInstanceConfig config;
    private HashMap<String, Boolean> store;
    private boolean isInitialized = false;
    private final WeakReference<FeatureFlagListener> listenerWeakReference;
    private final Context mContext;

    public CTFeatureFlagsController(Context context, String guid, CleverTapInstanceConfig config, FeatureFlagListener listener) {
        this.guid = guid;
        this.config = config;
        this.store = new HashMap();
        this.listenerWeakReference = new WeakReference<FeatureFlagListener>(listener);
        this.mContext = context.getApplicationContext();
        this.init();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Boolean get(String key, boolean defaultValue) {
        if (!this.isInitialized) {
            this.getConfigLogger().verbose(this.getLogTag(), "Controller not initialized, returning default value - " + defaultValue);
            return defaultValue;
        }
        this.getConfigLogger().verbose(this.getLogTag(), "Getting feature flag with key - " + key + " and default value - " + defaultValue);
        Boolean value = this.store.get(key);
        if (value != null) {
            return this.store.get(key);
        }
        this.getConfigLogger().verbose(this.getLogTag(), "Feature flag not found, returning default value - " + defaultValue);
        return defaultValue;
    }

    public void setGuidAndInit(String cleverTapID) {
        this.guid = cleverTapID;
        this.init();
    }

    public void updateFeatureFlags(JSONObject jsonObject) throws JSONException {
        JSONArray featureFlagList = jsonObject.getJSONArray("kv");
        try {
            for (int i = 0; i < featureFlagList.length(); ++i) {
                JSONObject ff = featureFlagList.getJSONObject(i);
                this.store.put(ff.getString("n"), ff.getBoolean("v"));
            }
            this.getConfigLogger().verbose(this.getLogTag(), "Updating feature flags..." + this.store);
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getLogTag(), "Error parsing Feature Flag array " + e.getLocalizedMessage());
        }
        this.archiveData(jsonObject);
        this.notifyFeatureFlagUpdate();
    }

    private void notifyFeatureFlagUpdate() {
        if (this.listenerWeakReference != null && this.listenerWeakReference.get() != null) {
            Utils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (CTFeatureFlagsController.this.listenerWeakReference.get() != null) {
                            ((FeatureFlagListener)CTFeatureFlagsController.this.listenerWeakReference.get()).featureFlagsDidUpdate();
                        }
                    }
                    catch (Exception e) {
                        CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), e.getLocalizedMessage());
                    }
                }
            });
        }
    }

    public void fetchFeatureFlags() {
        if (this.listenerWeakReference != null && this.listenerWeakReference.get() != null) {
            Utils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (CTFeatureFlagsController.this.listenerWeakReference.get() != null) {
                            ((FeatureFlagListener)CTFeatureFlagsController.this.listenerWeakReference.get()).fetchFeatureFlags();
                        }
                    }
                    catch (Exception e) {
                        CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), e.getLocalizedMessage());
                    }
                }
            });
        }
    }

    private synchronized void archiveData(JSONObject featureFlagRespObj) {
        if (featureFlagRespObj != null) {
            try {
                FileUtils.writeJsonToFile(this.mContext, this.config, this.getCachedDirName(), this.getCachedFileName(), featureFlagRespObj);
                this.getConfigLogger().verbose(this.getLogTag(), "Feature flags saved into file-[" + this.getCachedFullPath() + "]" + this.store);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getConfigLogger().verbose(this.getLogTag(), "ArchiveData failed - " + e.getLocalizedMessage());
            }
        }
    }

    private synchronized void init() {
        if (TextUtils.isEmpty((CharSequence)this.guid)) {
            return;
        }
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Boolean>(){

            @Override
            public Boolean doInBackground(Void aVoid) {
                CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "Feature flags init is called");
                String fileName = CTFeatureFlagsController.this.getCachedFullPath();
                try {
                    CTFeatureFlagsController.this.store.clear();
                    String content = FileUtils.readFromFile(CTFeatureFlagsController.this.mContext, CTFeatureFlagsController.this.config, fileName);
                    if (!TextUtils.isEmpty((CharSequence)content)) {
                        JSONObject jsonObject = new JSONObject(content);
                        JSONArray kvArray = jsonObject.getJSONArray("kv");
                        if (kvArray != null && kvArray.length() > 0) {
                            for (int i = 0; i < kvArray.length(); ++i) {
                                JSONObject object = (JSONObject)kvArray.get(i);
                                if (object == null) continue;
                                String Key2 = object.getString("n");
                                String Value = object.getString("v");
                                if (TextUtils.isEmpty((CharSequence)Key2)) continue;
                                CTFeatureFlagsController.this.store.put(Key2, Boolean.parseBoolean(Value));
                            }
                        }
                        CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "Feature flags initialized from file " + fileName + " with configs  " + CTFeatureFlagsController.this.store);
                        CTFeatureFlagsController.this.isInitialized = true;
                    } else {
                        CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "Feature flags file is empty-" + fileName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "UnArchiveData failed file- " + fileName + " " + e.getLocalizedMessage());
                    return false;
                }
                return true;
            }

            @Override
            public void onPostExecute(Boolean aBoolean) {
            }
        });
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    public void resetWithGuid(String guid) {
        this.guid = guid;
        this.init();
    }

    private String getCachedFileName() {
        return "ff_cache.json";
    }

    private String getCachedDirName() {
        return "Feature_Flag_" + this.config.getAccountId() + "_" + this.guid;
    }

    private String getCachedFullPath() {
        return this.getCachedDirName() + "/" + this.getCachedFileName();
    }

    private String getLogTag() {
        return this.config.getAccountId() + "[Feature Flag]";
    }
}

