/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.product_config;

import android.content.Context;
import android.text.TextUtils;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.FileUtils;
import com.clevertap.android.sdk.TaskManager;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.product_config.CTProductConfigConstants;
import com.clevertap.android.sdk.product_config.CTProductConfigControllerListener;
import com.clevertap.android.sdk.product_config.DefaultXmlParser;
import com.clevertap.android.sdk.product_config.ProductConfigSettings;
import com.clevertap.android.sdk.product_config.ProductConfigUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class CTProductConfigController {
    private String guid;
    private boolean isInitialized = false;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private HashMap<String, String> defaultConfig = new HashMap();
    private final HashMap<String, String> activatedConfig = new HashMap();
    private final HashMap<String, String> waitingTobeActivatedConfig = new HashMap();
    private final CTProductConfigControllerListener listener;
    private boolean isFetchAndActivating = false;
    private final ProductConfigSettings settings;

    public CTProductConfigController(Context context, String guid, CleverTapInstanceConfig config, CTProductConfigControllerListener listener) {
        this.context = context;
        this.guid = guid;
        this.config = config;
        this.listener = listener;
        this.settings = new ProductConfigSettings(context, guid, config);
        this.initAsync();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setDefaults(final int resourceID) {
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Void>(){

            @Override
            public Void doInBackground(Void aVoid) {
                CTProductConfigController.this.defaultConfig.putAll(DefaultXmlParser.getDefaultsFromXml(CTProductConfigController.this.context, resourceID));
                return null;
            }

            @Override
            public void onPostExecute(Void aVoid) {
                CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: setDefaults Completed with: " + CTProductConfigController.this.defaultConfig);
                CTProductConfigController.this.initAsync();
            }
        });
    }

    public void setDefaults(final HashMap<String, Object> map) {
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Void>(){

            @Override
            public Void doInBackground(Void aVoid) {
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (entry == null) continue;
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        try {
                            if (TextUtils.isEmpty((CharSequence)key) || !ProductConfigUtil.isSupportedDataType(value)) continue;
                            CTProductConfigController.this.defaultConfig.put(key, String.valueOf(value));
                        }
                        catch (Exception e) {
                            CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: setDefaults Failed for Key: " + key + " with Error: " + e.getLocalizedMessage());
                        }
                    }
                }
                return null;
            }

            @Override
            public void onPostExecute(Void aVoid) {
                CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: setDefaults Completed with: " + CTProductConfigController.this.defaultConfig);
                CTProductConfigController.this.initAsync();
            }
        });
    }

    public void fetch() {
        this.fetch(this.settings.getNextFetchIntervalInSeconds());
    }

    public void fetch(long minimumFetchIntervalInSeconds) {
        if (this.canRequest(minimumFetchIntervalInSeconds)) {
            this.listener.fetchProductConfig();
        }
    }

    public void activate() {
        if (TextUtils.isEmpty((CharSequence)this.guid)) {
            return;
        }
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void doInBackground(Void params) {
                3 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        HashMap toWriteValues = new HashMap();
                        if (!CTProductConfigController.this.waitingTobeActivatedConfig.isEmpty()) {
                            toWriteValues.putAll(CTProductConfigController.this.waitingTobeActivatedConfig);
                            CTProductConfigController.this.waitingTobeActivatedConfig.clear();
                        } else {
                            toWriteValues = CTProductConfigController.this.getStoredValues(CTProductConfigController.this.getActivatedFullPath());
                        }
                        CTProductConfigController.this.activatedConfig.clear();
                        if (CTProductConfigController.this.defaultConfig != null && !CTProductConfigController.this.defaultConfig.isEmpty()) {
                            CTProductConfigController.this.activatedConfig.putAll(CTProductConfigController.this.defaultConfig);
                        }
                        CTProductConfigController.this.activatedConfig.putAll(toWriteValues);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Activate failed: " + e.getLocalizedMessage());
                    }
                    return null;
                }
            }

            @Override
            public void onPostExecute(Void isSuccess) {
                CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Activated successfully with configs: " + CTProductConfigController.this.activatedConfig);
                CTProductConfigController.this.sendCallback(PROCESSING_STATE.ACTIVATED);
                CTProductConfigController.this.isFetchAndActivating = false;
            }
        });
    }

    public void fetchAndActivate() {
        this.fetch();
        this.isFetchAndActivating = true;
    }

    public void setMinimumFetchIntervalInSeconds(long fetchIntervalInSeconds) {
        this.settings.setMinimumFetchIntervalInSeconds(fetchIntervalInSeconds);
    }

    public long getLastFetchTimeStampInMillis() {
        return this.settings.getLastFetchTimeStampInMillis();
    }

    public String getString(String Key) {
        String value;
        if (this.isInitialized && !TextUtils.isEmpty((CharSequence)Key) && !TextUtils.isEmpty((CharSequence)(value = this.activatedConfig.get(Key)))) {
            return value;
        }
        return "";
    }

    public Boolean getBoolean(String Key) {
        String value;
        if (this.isInitialized && !TextUtils.isEmpty((CharSequence)Key) && !TextUtils.isEmpty((CharSequence)(value = this.activatedConfig.get(Key)))) {
            return Boolean.parseBoolean(value);
        }
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_BOOLEAN;
    }

    public Long getLong(String Key) {
        if (this.isInitialized && !TextUtils.isEmpty((CharSequence)Key)) {
            try {
                String value = this.activatedConfig.get(Key);
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    return Long.parseLong(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Error getting Long for Key-" + Key + " " + e.getLocalizedMessage());
            }
        }
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_LONG;
    }

    public Double getDouble(String Key) {
        if (this.isInitialized && !TextUtils.isEmpty((CharSequence)Key)) {
            try {
                String value = this.activatedConfig.get(Key);
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    return Double.parseDouble(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Error getting Double for Key-" + Key + " " + e.getLocalizedMessage());
            }
        }
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_DOUBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        CTProductConfigController cTProductConfigController = this;
        synchronized (cTProductConfigController) {
            if (null != this.defaultConfig) {
                this.defaultConfig.clear();
            }
            this.activatedConfig.clear();
            TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Void>(){

                @Override
                public Void doInBackground(Void aVoid) {
                    try {
                        String dirName = CTProductConfigController.this.getProductConfigDirName();
                        FileUtils.deleteDirectory(CTProductConfigController.this.context, CTProductConfigController.this.config, dirName);
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Reset Deleted Dir: " + dirName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Reset failed: " + e.getLocalizedMessage());
                    }
                    return null;
                }

                @Override
                public void onPostExecute(Void aVoid) {
                }
            });
            this.settings.initDefaults();
        }
    }

    private void initAsync() {
        if (TextUtils.isEmpty((CharSequence)this.guid)) {
            return;
        }
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doInBackground(Void params) {
                5 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        HashMap storedConfig;
                        if (!CTProductConfigController.this.defaultConfig.isEmpty()) {
                            CTProductConfigController.this.activatedConfig.putAll(CTProductConfigController.this.defaultConfig);
                        }
                        if (!(storedConfig = CTProductConfigController.this.getStoredValues(CTProductConfigController.this.getActivatedFullPath())).isEmpty()) {
                            CTProductConfigController.this.waitingTobeActivatedConfig.putAll(storedConfig);
                        }
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Loaded configs ready to be applied: " + CTProductConfigController.this.waitingTobeActivatedConfig);
                        CTProductConfigController.this.settings.loadSettings();
                        CTProductConfigController.this.isInitialized = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "InitAsync failed - " + e.getLocalizedMessage());
                        return false;
                    }
                    return true;
                }
            }

            @Override
            public void onPostExecute(Boolean isInitSuccess) {
                CTProductConfigController.this.sendCallback(PROCESSING_STATE.INIT);
            }
        });
    }

    private HashMap<String, String> getStoredValues(String fullFilePath) {
        String content;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            content = FileUtils.readFromFile(this.context, this.config, fullFilePath);
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues reading file success:[ " + fullFilePath + "]--[Content]" + content);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues reading file failed: " + e.getLocalizedMessage());
            return map;
        }
        if (!TextUtils.isEmpty((CharSequence)content)) {
            JSONObject jsonObject;
            try {
                jsonObject = new JSONObject(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues failed due to malformed json: " + e.getLocalizedMessage());
                return map;
            }
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String value;
                String key = (String)iterator.next();
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                try {
                    value = String.valueOf(jsonObject.get(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues for key " + key + " while parsing json: " + e.getLocalizedMessage());
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    private boolean canRequest(long minimumFetchIntervalInSeconds) {
        boolean isTimeExpired;
        boolean validGuid;
        boolean bl = validGuid = !TextUtils.isEmpty((CharSequence)this.guid);
        if (!validGuid) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: Throttled due to empty Guid");
            return false;
        }
        long lastRequestTime = this.settings.getLastFetchTimeStampInMillis();
        long timeDifference = System.currentTimeMillis() - lastRequestTime - TimeUnit.SECONDS.toMillis(minimumFetchIntervalInSeconds);
        boolean bl2 = isTimeExpired = timeDifference > 0L;
        if (!isTimeExpired) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Throttled since you made frequent request- [Last Request Time-" + new Date(lastRequestTime) + "], Try again in " + -timeDifference / 1000L + " seconds");
            return false;
        }
        return true;
    }

    public void onFetchFailed() {
        this.isFetchAndActivating = false;
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Fetch Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchSuccess(JSONObject kvResponse) {
        if (TextUtils.isEmpty((CharSequence)this.guid)) {
            return;
        }
        CTProductConfigController cTProductConfigController = this;
        synchronized (cTProductConfigController) {
            if (kvResponse != null) {
                try {
                    this.parseFetchedResponse(kvResponse);
                    FileUtils.writeJsonToFile(this.context, this.config, this.getProductConfigDirName(), "activated.json", new JSONObject(this.waitingTobeActivatedConfig));
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Fetch file-[" + this.getActivatedFullPath() + "] write success: " + this.waitingTobeActivatedConfig);
                    Utils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: fetch Success");
                            CTProductConfigController.this.sendCallback(PROCESSING_STATE.FETCHED);
                        }
                    });
                    if (this.isFetchAndActivating) {
                        this.activate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: fetch Failed");
                    this.sendCallback(PROCESSING_STATE.FETCHED);
                    this.isFetchAndActivating = false;
                }
            }
        }
    }

    private void parseFetchedResponse(JSONObject jsonObject) {
        HashMap<String, String> map = this.convertServerJsonToMap(jsonObject);
        this.waitingTobeActivatedConfig.clear();
        this.waitingTobeActivatedConfig.putAll(map);
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: Fetched response:" + jsonObject);
        Integer timestamp = null;
        try {
            timestamp = (Integer)jsonObject.get("ts");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ParseFetchedResponse failed: " + e.getLocalizedMessage());
        }
        if (timestamp != null) {
            this.settings.setLastFetchTimeStampInMillis((long)timestamp.intValue() * 1000L);
        }
    }

    private HashMap<String, String> convertServerJsonToMap(JSONObject jsonObject) {
        JSONArray kvArray;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            kvArray = jsonObject.getJSONArray("kv");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ConvertServerJsonToMap failed - " + e.getLocalizedMessage());
            return map;
        }
        if (kvArray != null && kvArray.length() > 0) {
            for (int i = 0; i < kvArray.length(); ++i) {
                try {
                    JSONObject object = (JSONObject)kvArray.get(i);
                    if (object == null) continue;
                    String Key = object.getString("n");
                    String Value = object.getString("v");
                    if (TextUtils.isEmpty((CharSequence)Key)) continue;
                    map.put(Key, String.valueOf(Value));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ConvertServerJsonToMap failed: " + e.getLocalizedMessage());
                }
            }
        }
        return map;
    }

    public void setGuidAndInit(String cleverTapID) {
        if (TextUtils.isEmpty((CharSequence)this.guid)) {
            return;
        }
        this.guid = cleverTapID;
        this.initAsync();
    }

    private String getProductConfigDirName() {
        return "Product_Config_" + this.config.getAccountId() + "_" + this.guid;
    }

    private String getActivatedFullPath() {
        return this.getProductConfigDirName() + "/" + "activated.json";
    }

    public void setArpValue(JSONObject arp) {
        this.settings.setARPValue(arp);
    }

    private void sendCallback(PROCESSING_STATE state) {
        if (state != null) {
            switch (state) {
                case INIT: {
                    this.listener.onInit();
                    break;
                }
                case FETCHED: {
                    this.listener.onFetched();
                    break;
                }
                case ACTIVATED: {
                    this.listener.onActivated();
                }
            }
        }
    }

    public void resetSettings() {
        this.settings.reset();
    }

    private static enum PROCESSING_STATE {
        INIT,
        FETCHED,
        ACTIVATED;

    }
}

