/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.UUID;

class DeviceInfo {
    private Context context;
    private CleverTapInstanceConfig config;
    private String library;
    private static final String GUID_PREFIX = "__";
    private final Object deviceIDLock = new Object();
    private final Object adIDLock = new Object();
    private String googleAdID = null;
    private boolean limitAdTracking = false;
    private boolean adIdRun = false;
    private static final String OS_NAME = "Android";
    private DeviceCachedInfo cachedInfo;
    private ArrayList<ValidationResult> validationResults = new ArrayList();
    private static ArrayList<PushType> enabledPushTypes = null;
    private static Boolean isFirebasePresent = null;
    private static Boolean isXiaomiPresent = null;
    private static Boolean isBaiduPresent = null;
    private static Boolean isHuaweiPresent = null;
    private static final String FIREBASE_CLASS_NAME = "com.google.firebase.messaging.FirebaseMessaging";
    private static final String XIAOMI_CLASS_NAME = "com.xiaomi.mipush.sdk.MiPushClient";
    private static final String BAIDU_CLASS_NAME = "com.baidu.android.pushservice.PushMessageReceiver";
    private static final String HUAWEI_CLASS_NAME = "com.huawei.hms.push.HmsMessaging";

    ArrayList<ValidationResult> getValidationResults() {
        ArrayList tempValidationResults = (ArrayList)this.validationResults.clone();
        this.validationResults.clear();
        return tempValidationResults;
    }

    DeviceInfo(Context context, CleverTapInstanceConfig config, String cleverTapID) {
        this.context = context;
        this.config = config;
        this.library = null;
        Thread deviceInfoCacheThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceInfo.this.getDeviceCachedInfo();
            }
        });
        deviceInfoCacheThread.start();
        this.initDeviceID(cleverTapID);
    }

    String getLibrary() {
        return this.library;
    }

    void setLibrary(String library) {
        this.library = library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getGoogleAdID() {
        Object object = this.adIDLock;
        synchronized (object) {
            return this.googleAdID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLimitAdTrackingEnabled() {
        Object object = this.adIDLock;
        synchronized (object) {
            return this.limitAdTracking;
        }
    }

    private DeviceCachedInfo getDeviceCachedInfo() {
        if (this.cachedInfo == null) {
            this.cachedInfo = new DeviceCachedInfo();
        }
        return this.cachedInfo;
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private void initDeviceID(String cleverTapID) {
        String deviceID;
        if (this.config.getEnableCustomCleverTapId()) {
            if (cleverTapID == null) {
                this.config.getLogger().info("CLEVERTAP_USE_CUSTOM_ID has been specified in the AndroidManifest.xml/Instance Configuration. CleverTap SDK will create a fallback device ID");
                this.recordDeviceError("CLEVERTAP_USE_CUSTOM_ID has been specified in the AndroidManifest.xml/Instance Configuration. CleverTap SDK will create a fallback device ID");
            }
        } else if (cleverTapID != null) {
            this.config.getLogger().info("CLEVERTAP_USE_CUSTOM_ID has not been specified in the AndroidManifest.xml. Custom CleverTap ID passed will not be used.");
            this.recordDeviceError("CLEVERTAP_USE_CUSTOM_ID has not been specified in the AndroidManifest.xml. Custom CleverTap ID passed will not be used.");
        }
        if ((deviceID = this._getDeviceID()) != null && deviceID.trim().length() > 2) {
            this.getConfigLogger().verbose(this.config.getAccountId(), "CleverTap ID already present for profile");
            if (cleverTapID != null) {
                this.getConfigLogger().info(this.config.getAccountId(), "CleverTap ID - " + deviceID + " already exists. Unable to set custom CleverTap ID - " + cleverTapID);
                this.recordDeviceError("CleverTap ID - " + deviceID + " already exists. Unable to set custom CleverTap ID - " + cleverTapID);
            }
            return;
        }
        if (this.config.getEnableCustomCleverTapId()) {
            this.forceUpdateCustomCleverTapID(cleverTapID);
            return;
        }
        if (!this.config.isUseGoogleAdId()) {
            this.generateDeviceID();
            return;
        }
        Thread generateGUIDFromAdIDThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceInfo.this.fetchGoogleAdID();
                DeviceInfo.this.generateDeviceID();
                CleverTapAPI.instanceWithConfig(DeviceInfo.this.context, DeviceInfo.this.config).deviceIDCreated(DeviceInfo.this.getDeviceID());
            }
        });
        generateGUIDFromAdIDThread.start();
    }

    void forceUpdateCustomCleverTapID(String cleverTapID) {
        if (Utils.validateCTID(cleverTapID)) {
            this.getConfigLogger().info(this.config.getAccountId(), "Setting CleverTap ID to custom CleverTap ID : " + cleverTapID);
            this.forceUpdateDeviceId("__h" + cleverTapID);
        } else {
            this.setOrGenerateFallbackDeviceID();
            this.removeDeviceID();
            this.getConfigLogger().info(this.config.getAccountId(), "Attempted to set invalid custom CleverTap ID - " + cleverTapID + ", falling back to default error CleverTap ID - " + this.getFallBackDeviceID());
            this.recordDeviceError("Attempted to set invalid custom CleverTap ID - " + cleverTapID + ", falling back to default error CleverTap ID - " + this.getFallBackDeviceID());
        }
    }

    private void recordDeviceError(String errorDescription) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.setErrorCode(514);
        validationResult.setErrorDesc(errorDescription);
        this.validationResults.add(validationResult);
    }

    boolean isErrorDeviceId() {
        return this.getDeviceID() != null && this.getDeviceID().startsWith("__i");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fetchGoogleAdID() {
        if (this.getGoogleAdID() == null && !this.adIdRun) {
            String advertisingID = null;
            try {
                this.adIdRun = true;
                Class<?> adIdClient = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                Method getAdInfo = adIdClient.getMethod("getAdvertisingIdInfo", Context.class);
                Object adInfo = getAdInfo.invoke(null, this.context);
                Method isLimitAdTracking = adInfo.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
                Boolean limitedAdTracking = (Boolean)isLimitAdTracking.invoke(adInfo, new Object[0]);
                Object object = this.adIDLock;
                synchronized (object) {
                    boolean bl = this.limitAdTracking = limitedAdTracking != null && limitedAdTracking != false;
                    if (this.limitAdTracking) {
                        return;
                    }
                }
                Method getAdId = adInfo.getClass().getMethod("getId", new Class[0]);
                advertisingID = (String)getAdId.invoke(adInfo, new Object[0]);
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    this.getConfigLogger().verbose(this.config.getAccountId(), "Failed to get Advertising ID: " + t.toString() + t.getCause().toString());
                }
                this.getConfigLogger().verbose(this.config.getAccountId(), "Failed to get Advertising ID: " + t.toString());
            }
            if (advertisingID != null && advertisingID.trim().length() > 2) {
                Object object = this.adIDLock;
                synchronized (object) {
                    this.googleAdID = advertisingID.replace("-", "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setOrGenerateFallbackDeviceID() {
        if (this.getFallBackDeviceID() == null) {
            Object object = this.deviceIDLock;
            synchronized (object) {
                String fallbackDeviceID = "__i" + UUID.randomUUID().toString().replace("-", "");
                if (fallbackDeviceID.trim().length() > 2) {
                    this.updateFallbackID(fallbackDeviceID);
                } else {
                    this.getConfigLogger().verbose(this.config.getAccountId(), "Unable to generate fallback error device ID");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generateDeviceID() {
        String generatedDeviceID;
        String adId = this.getGoogleAdID();
        if (adId != null) {
            generatedDeviceID = "__g" + adId;
        } else {
            Object object = this.deviceIDLock;
            synchronized (object) {
                generatedDeviceID = this.generateGUID();
            }
        }
        this.forceUpdateDeviceId(generatedDeviceID);
    }

    String getAttributionID() {
        return this.getDeviceID();
    }

    String getDeviceID() {
        return this._getDeviceID() != null ? this._getDeviceID() : this.getFallBackDeviceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getDeviceID() {
        Object object = this.deviceIDLock;
        synchronized (object) {
            if (this.config.isDefaultInstance()) {
                String _new = StorageHelper.getString(this.context, this.getDeviceIdStorageKey(), null);
                String string = _new != null ? _new : StorageHelper.getString(this.context, "deviceId", null);
                return string;
            }
            return StorageHelper.getString(this.context, this.getDeviceIdStorageKey(), null);
        }
    }

    private void removeDeviceID() {
        StorageHelper.removeString(this.context, this.getDeviceIdStorageKey());
    }

    private String getFallBackDeviceID() {
        return StorageHelper.getString(this.context, this.getFallbackIdStorageKey(), null);
    }

    private String generateGUID() {
        return GUID_PREFIX + UUID.randomUUID().toString().replace("-", "");
    }

    void forceNewDeviceID() {
        String deviceID = this.generateGUID();
        this.forceUpdateDeviceId(deviceID);
    }

    private String getDeviceIdStorageKey() {
        return "deviceId:" + this.config.getAccountId();
    }

    private String getFallbackIdStorageKey() {
        return "fallbackId:" + this.config.getAccountId();
    }

    private void updateFallbackID(String fallbackId) {
        this.getConfigLogger().verbose(this.config.getAccountId(), "Updating the fallback id - " + fallbackId);
        StorageHelper.putString(this.context, this.getFallbackIdStorageKey(), fallbackId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    void forceUpdateDeviceId(String id2) {
        this.getConfigLogger().verbose(this.config.getAccountId(), "Force updating the device ID to " + id2);
        Object object = this.deviceIDLock;
        synchronized (object) {
            StorageHelper.putString(this.context, this.getDeviceIdStorageKey(), id2);
        }
    }

    boolean testPermission(Context context, String permission2) {
        this.context = context;
        return DeviceInfo.hasPermission(context, permission2);
    }

    static boolean hasPermission(Context context, String permission2) {
        try {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }

    private boolean isFCMAvailable() {
        if (isFirebasePresent == null) {
            try {
                Class.forName(FIREBASE_CLASS_NAME);
                isFirebasePresent = true;
                this.getConfigLogger().verbose("FCM installed");
            }
            catch (ClassNotFoundException e) {
                isFirebasePresent = false;
                Logger.d("FCM unavailable, will be unable to request FCM token");
            }
        }
        return isFirebasePresent;
    }

    private boolean isXiaomiAvailable() {
        if (isXiaomiPresent == null) {
            try {
                Class.forName(XIAOMI_CLASS_NAME);
                isXiaomiPresent = true;
                this.getConfigLogger().verbose("Xiaomi Push installed");
            }
            catch (ClassNotFoundException e) {
                isXiaomiPresent = false;
                Logger.d("Xiaomi Push unavailable, will be unable to request Xiaomi Push token");
            }
        }
        return isXiaomiPresent;
    }

    private boolean isBaiduAvailable() {
        if (isBaiduPresent == null) {
            try {
                Class.forName(BAIDU_CLASS_NAME);
                isBaiduPresent = true;
                this.getConfigLogger().verbose("Baidu Push installed");
            }
            catch (ClassNotFoundException e) {
                isBaiduPresent = false;
                Logger.d("Baidu Push unavailable, will be unable to request Baidu Push token");
            }
        }
        return isBaiduPresent;
    }

    private boolean isHuaweiAvailable() {
        if (isHuaweiPresent == null) {
            try {
                Class.forName(HUAWEI_CLASS_NAME);
                isHuaweiPresent = true;
                this.getConfigLogger().verbose("Huawei Push installed");
            }
            catch (ClassNotFoundException e) {
                isHuaweiPresent = false;
                Logger.d("Huawei Push unavailable, will be unable to request Huawei Push token");
            }
        }
        return isHuaweiPresent;
    }

    ArrayList<PushType> getEnabledPushTypes() {
        if (enabledPushTypes == null) {
            boolean huaweiAvail;
            boolean baiduAvail;
            boolean xiaomiAvail;
            enabledPushTypes = new ArrayList();
            boolean fcmAvail = this.isFCMAvailable();
            if (fcmAvail) {
                enabledPushTypes.add(PushType.FCM);
            }
            if (xiaomiAvail = this.isXiaomiAvailable()) {
                enabledPushTypes.add(PushType.XPS);
            }
            if (baiduAvail = this.isBaiduAvailable()) {
                enabledPushTypes.add(PushType.BPS);
            }
            if (huaweiAvail = this.isHuaweiAvailable()) {
                enabledPushTypes.add(PushType.HPS);
            }
        }
        return enabledPushTypes;
    }

    String getFCMSenderID() {
        return ManifestInfo.getInstance(this.context).getFCMSenderId();
    }

    Boolean isWifiConnected() {
        ConnectivityManager connManager;
        Boolean ret = null;
        if (0 == this.context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") && (connManager = (ConnectivityManager)this.context.getSystemService("connectivity")) != null) {
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            ret = networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return ret;
    }

    @SuppressLint(value={"MissingPermission"})
    Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled = null;
        try {
            BluetoothAdapter bluetoothAdapter;
            PackageManager pm = this.context.getPackageManager();
            int hasBluetoothPermission = pm.checkPermission("android.permission.BLUETOOTH", this.context.getPackageName());
            if (hasBluetoothPermission == 0 && (bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) != null) {
                isBluetoothEnabled = bluetoothAdapter.isEnabled();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isBluetoothEnabled;
    }

    String getVersionName() {
        return this.getDeviceCachedInfo().versionName;
    }

    int getBuild() {
        return this.getDeviceCachedInfo().build;
    }

    String getOsName() {
        return this.getDeviceCachedInfo().osName;
    }

    String getOsVersion() {
        return this.getDeviceCachedInfo().osVersion;
    }

    String getManufacturer() {
        return this.getDeviceCachedInfo().manufacturer;
    }

    String getModel() {
        return this.getDeviceCachedInfo().model;
    }

    String getCarrier() {
        return this.getDeviceCachedInfo().carrier;
    }

    String getNetworkType() {
        return this.getDeviceCachedInfo().networkType;
    }

    String getBluetoothVersion() {
        return this.getDeviceCachedInfo().bluetoothVersion;
    }

    String getCountryCode() {
        return this.getDeviceCachedInfo().countryCode;
    }

    int getSdkVersion() {
        return this.getDeviceCachedInfo().sdkVersion;
    }

    double getHeight() {
        return this.getDeviceCachedInfo().height;
    }

    double getWidth() {
        return this.getDeviceCachedInfo().width;
    }

    int getDPI() {
        return this.getDeviceCachedInfo().dpi;
    }

    int getHeightPixels() {
        return this.getDeviceCachedInfo().heightPixels;
    }

    int getWidthPixels() {
        return this.getDeviceCachedInfo().widthPixels;
    }

    boolean getNotificationsEnabledForUser() {
        return this.getDeviceCachedInfo().notificationsEnabled;
    }

    private class DeviceCachedInfo {
        private int build;
        private String versionName = this.getVersionName();
        private String osName = this.getOsName();
        private String osVersion = this.getOsVersion();
        private String manufacturer = this.getManufacturer();
        private String model = this.getModel();
        private String carrier = this.getCarrier();
        private String networkType;
        private String bluetoothVersion;
        private String countryCode;
        private int sdkVersion;
        private double height;
        private int heightPixels;
        private double width;
        private int widthPixels;
        private int dpi;
        private boolean notificationsEnabled;

        DeviceCachedInfo() {
            this.build = this.getBuild();
            this.networkType = this.getNetworkType();
            this.bluetoothVersion = this.getBluetoothVersion();
            this.countryCode = this.getCountryCode();
            this.sdkVersion = this.getSdkVersion();
            this.height = this.getHeight();
            this.heightPixels = this.getHeightPixels();
            this.width = this.getWidth();
            this.widthPixels = this.getWidthPixels();
            this.dpi = this.getDPI();
            this.notificationsEnabled = this.getNotificationEnabledForUser();
        }

        private String getVersionName() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                return packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.d("Unable to get app version");
                return null;
            }
        }

        private String getOsName() {
            return DeviceInfo.OS_NAME;
        }

        private String getOsVersion() {
            return Build.VERSION.RELEASE;
        }

        private String getManufacturer() {
            return Build.MANUFACTURER;
        }

        private String getModel() {
            String model = Build.MODEL;
            model = model.replace(this.getManufacturer(), "");
            return model;
        }

        private String getCarrier() {
            try {
                TelephonyManager manager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                if (manager != null) {
                    return manager.getNetworkOperatorName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private int getBuild() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                return packageInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.d("Unable to get app build");
                return 0;
            }
        }

        private String getNetworkType() {
            TelephonyManager mTelephonyManager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
            if (mTelephonyManager == null) {
                return null;
            }
            int networkType = mTelephonyManager.getNetworkType();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return null;
        }

        private String getBluetoothVersion() {
            String bluetoothVersion = "none";
            if (Build.VERSION.SDK_INT >= 18 && DeviceInfo.this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                bluetoothVersion = "ble";
            } else if (DeviceInfo.this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                bluetoothVersion = "classic";
            }
            return bluetoothVersion;
        }

        private String getCountryCode() {
            try {
                TelephonyManager tm = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                if (tm != null) {
                    return tm.getSimCountryIso();
                }
            }
            finally {
                return "";
            }
            {
            }
        }

        private int getSdkVersion() {
            return 30801;
        }

        private int getHeightPixels() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            return dm.heightPixels;
        }

        private double getHeight() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0.0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            double rHeight = (float)dm.heightPixels / dm.ydpi;
            return this.toTwoPlaces(rHeight);
        }

        private int getWidthPixels() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            return dm.widthPixels;
        }

        private double getWidth() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0.0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            double rWidth = (float)dm.widthPixels / dm.xdpi;
            return this.toTwoPlaces(rWidth);
        }

        private int getDPI() {
            WindowManager wm = (WindowManager)DeviceInfo.this.context.getSystemService("window");
            if (wm == null) {
                return 0;
            }
            DisplayMetrics dm = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(dm);
            return dm.densityDpi;
        }

        private double toTwoPlaces(double n) {
            double result = n * 100.0;
            result = Math.round(result);
            return result /= 100.0;
        }

        private boolean getNotificationEnabledForUser() {
            return NotificationManagerCompat.from((Context)DeviceInfo.this.context).areNotificationsEnabled();
        }
    }
}

