/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.clevertap.android.sdk.CTCarouselViewPager;
import com.clevertap.android.sdk.CTCarouselViewPagerAdapter;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.CTInboxButtonClickListener;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.CTInboxMessageType;
import com.clevertap.android.sdk.R;

class CTCarouselMessageViewHolder
extends CTInboxBaseMessageViewHolder {
    private CTCarouselViewPager imageViewPager;
    private LinearLayout sliderDots;
    private TextView title;
    private TextView message;
    private TextView timestamp;
    private TextView carouselTimestamp;
    private ImageView readDot;
    private ImageView carouselReadDot;
    private RelativeLayout clickLayout;

    CTCarouselMessageViewHolder(@NonNull View itemView) {
        super(itemView);
        this.imageViewPager = (CTCarouselViewPager)itemView.findViewById(R.id.image_carousel_viewpager);
        this.sliderDots = (LinearLayout)itemView.findViewById(R.id.sliderDots);
        this.title = (TextView)itemView.findViewById(R.id.messageTitle);
        this.message = (TextView)itemView.findViewById(R.id.messageText);
        this.timestamp = (TextView)itemView.findViewById(R.id.timestamp);
        this.readDot = (ImageView)itemView.findViewById(R.id.read_circle);
        this.clickLayout = (RelativeLayout)itemView.findViewById(R.id.body_linear_layout);
    }

    @Override
    void configureWithMessage(final CTInboxMessage inboxMessage, final CTInboxListViewFragment parent, final int position) {
        super.configureWithMessage(inboxMessage, parent, position);
        final CTInboxListViewFragment parentWeak = this.getParent();
        Context appContext = parent.getActivity().getApplicationContext();
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.title.setVisibility(0);
        this.message.setVisibility(0);
        this.title.setText((CharSequence)content.getTitle());
        this.title.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.message.setText((CharSequence)content.getMessage());
        this.message.setTextColor(Color.parseColor((String)content.getMessageColor()));
        if (inboxMessage.isRead()) {
            this.readDot.setVisibility(8);
        } else {
            this.readDot.setVisibility(0);
        }
        this.timestamp.setVisibility(0);
        String carouselDisplayTimestamp = this.calculateDisplayTimestamp(inboxMessage.getDate());
        this.timestamp.setText((CharSequence)carouselDisplayTimestamp);
        this.timestamp.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.clickLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.imageViewPager.getLayoutParams();
        CTCarouselViewPagerAdapter carouselViewPagerAdapter = new CTCarouselViewPagerAdapter(appContext, parent, inboxMessage, layoutParams, position);
        this.imageViewPager.setAdapter(carouselViewPagerAdapter);
        int dotsCount = inboxMessage.getInboxMessageContents().size();
        if (this.sliderDots.getChildCount() > 0) {
            this.sliderDots.removeAllViews();
        }
        ImageView[] dots = new ImageView[dotsCount];
        for (int k = 0; k < dotsCount; ++k) {
            dots[k] = new ImageView((Context)parent.getActivity());
            dots[k].setVisibility(0);
            dots[k].setImageDrawable(appContext.getResources().getDrawable(R.drawable.ct_unselected_dot));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(8, 6, 4, 6);
            params.gravity = 17;
            if (this.sliderDots.getChildCount() >= dotsCount) continue;
            this.sliderDots.addView((View)dots[k], (ViewGroup.LayoutParams)params);
        }
        dots[0].setImageDrawable(parent.getActivity().getApplicationContext().getResources().getDrawable(R.drawable.ct_selected_dot));
        CarouselPageChangeListener carouselPageChangeListener = new CarouselPageChangeListener(parent.getActivity().getApplicationContext(), this, dots, inboxMessage);
        this.imageViewPager.addOnPageChangeListener(carouselPageChangeListener);
        this.clickLayout.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, null, parentWeak, this.imageViewPager));
        Runnable carouselRunnable = new Runnable(){

            @Override
            public void run() {
                FragmentActivity activity = parent.getActivity();
                if (activity == null) {
                    return;
                }
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (inboxMessage.getType() == CTInboxMessageType.CarouselImageMessage) {
                            if (CTCarouselMessageViewHolder.this.carouselReadDot.getVisibility() == 0 && parentWeak != null) {
                                parentWeak.didShow(null, position);
                            }
                            CTCarouselMessageViewHolder.this.carouselReadDot.setVisibility(8);
                        } else {
                            if (CTCarouselMessageViewHolder.this.readDot.getVisibility() == 0 && parentWeak != null) {
                                parentWeak.didShow(null, position);
                            }
                            CTCarouselMessageViewHolder.this.readDot.setVisibility(8);
                        }
                    }
                });
            }
        };
        Handler carouselHandler = new Handler();
        carouselHandler.postDelayed(carouselRunnable, 2000L);
    }

    class CarouselPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private CTCarouselMessageViewHolder viewHolder;
        private ImageView[] dots;
        private CTInboxMessage inboxMessage;
        private Context context;

        CarouselPageChangeListener(Context context, CTCarouselMessageViewHolder viewHolder, ImageView[] dots, CTInboxMessage inboxMessage) {
            this.context = context;
            this.viewHolder = viewHolder;
            this.dots = dots;
            this.inboxMessage = inboxMessage;
            this.dots[0].setImageDrawable(context.getResources().getDrawable(R.drawable.ct_selected_dot));
        }

        public void onPageScrolled(int i, float v, int i1) {
        }

        public void onPageSelected(int position) {
            for (ImageView dot : this.dots) {
                dot.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ct_unselected_dot));
            }
            this.dots[position].setImageDrawable(this.context.getResources().getDrawable(R.drawable.ct_selected_dot));
            this.viewHolder.title.setText((CharSequence)this.inboxMessage.getInboxMessageContents().get(position).getTitle());
            this.viewHolder.title.setTextColor(Color.parseColor((String)this.inboxMessage.getInboxMessageContents().get(position).getTitleColor()));
            this.viewHolder.message.setText((CharSequence)this.inboxMessage.getInboxMessageContents().get(position).getMessage());
            this.viewHolder.message.setTextColor(Color.parseColor((String)this.inboxMessage.getInboxMessageContents().get(position).getMessageColor()));
        }

        public void onPageScrollStateChanged(int i) {
        }
    }
}

