/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.uieditor;

import android.view.View;
import com.clevertap.android.sdk.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ViewCaller {
    private final Class<?> targetClass;
    private final Method targetMethod;
    private final String methodName;
    private final Object[] methodArgs;
    private final Class<?> methodResultType;

    ViewCaller(Class<?> targetClass, String methodName, Object[] methodArgs, Class<?> resultType) throws NoSuchMethodException {
        this.methodName = methodName;
        this.methodArgs = methodArgs;
        this.methodResultType = resultType;
        this.targetMethod = this.findMethod(targetClass);
        if (null == this.targetMethod) {
            throw new NoSuchMethodException("Method " + targetClass.getName() + "." + methodName + " doesn't exit");
        }
        this.targetClass = this.targetMethod.getDeclaringClass();
    }

    String getMethodName() {
        return this.methodName;
    }

    Object invokeMethod(View target) {
        return this.invokeMethodWithArgs(target, this.methodArgs);
    }

    Object invokeMethodWithArgs(View target, Object[] arguments) {
        Class<?> klass = target.getClass();
        if (this.targetClass.isAssignableFrom(klass)) {
            try {
                return this.targetMethod.invoke((Object)target, arguments);
            }
            catch (IllegalAccessException e) {
                Logger.v("Method " + this.targetMethod.getName() + " appears not to be public", e);
            }
            catch (IllegalArgumentException e) {
                Logger.v("Method " + this.targetMethod.getName() + " called with arguments of the wrong type", e);
            }
            catch (InvocationTargetException e) {
                Logger.v("Method " + this.targetMethod.getName() + " threw an exception", e);
            }
        }
        return null;
    }

    private Method findMethod(Class<?> klass) {
        Class[] argumentTypes = new Class[this.methodArgs.length];
        for (int i = 0; i < this.methodArgs.length; ++i) {
            argumentTypes[i] = this.methodArgs[i].getClass();
        }
        for (Method method : klass.getMethods()) {
            Class<?> resultType;
            Class<?> assignType;
            String foundName = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!foundName.equals(this.methodName) || params.length != this.methodArgs.length || !(assignType = ViewCaller.assignableArgType(this.methodResultType)).isAssignableFrom(resultType = ViewCaller.assignableArgType(method.getReturnType()))) continue;
            boolean assignable = true;
            for (int i = 0; i < params.length && assignable; ++i) {
                Class<?> argumentType = ViewCaller.assignableArgType(argumentTypes[i]);
                Class<?> paramType = ViewCaller.assignableArgType(params[i]);
                assignable = paramType.isAssignableFrom(argumentType);
            }
            if (!assignable) continue;
            return method;
        }
        return null;
    }

    private static Class<?> assignableArgType(Class<?> type) {
        if (type == Byte.class) {
            type = Byte.TYPE;
        } else if (type == Short.class) {
            type = Short.TYPE;
        } else if (type == Integer.class) {
            type = Integer.TYPE;
        } else if (type == Long.class) {
            type = Long.TYPE;
        } else if (type == Float.class) {
            type = Float.TYPE;
        } else if (type == Double.class) {
            type = Double.TYPE;
        } else if (type == Boolean.class) {
            type = Boolean.TYPE;
        } else if (type == Character.class) {
            type = Character.TYPE;
        }
        return type;
    }

    Object[] getArgs() {
        return this.methodArgs;
    }

    boolean argsAreApplicable(Object[] proposedArgs) {
        Class<?>[] paramTypes = this.targetMethod.getParameterTypes();
        if (proposedArgs.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < proposedArgs.length; ++i) {
            Class<?> argumentType;
            Class<?> paramType = ViewCaller.assignableArgType(paramTypes[i]);
            if (!(proposedArgs[i] == null ? paramType == Byte.TYPE || paramType == Short.TYPE || paramType == Integer.TYPE || paramType == Long.TYPE || paramType == Float.TYPE || paramType == Double.TYPE || paramType == Boolean.TYPE || paramType == Character.TYPE : ((argumentType = ViewCaller.assignableArgType(proposedArgs[i].getClass())).getCanonicalName() == null || !argumentType.getCanonicalName().equals("android.content.res.ColorStateList") && !argumentType.getCanonicalName().equals("android.graphics.drawable.ColorDrawable") && !argumentType.getCanonicalName().equals("android.graphics.drawable.RippleDrawable")) && !paramType.isAssignableFrom(argumentType))) continue;
            return false;
        }
        return true;
    }
}

