/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.clevertap.android.sdk.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class StorageHelper {
    private static long EXECUTOR_THREAD_ID = 0L;
    private static ExecutorService es;

    StorageHelper() {
    }

    static void putString(Context context, String key, String value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(key, value);
        StorageHelper.persist(editor);
    }

    static void removeString(Context context, String key) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().remove(key);
        StorageHelper.persist(editor);
    }

    static String getString(Context context, String key, String defaultValue) {
        return StorageHelper.getPreferences(context).getString(key, defaultValue);
    }

    static String getString(Context context, String nameSpace, String key, String defaultValue) {
        return StorageHelper.getPreferences(context, nameSpace).getString(key, defaultValue);
    }

    static void putLong(Context context, String key, long value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putLong(key, value);
        StorageHelper.persist(editor);
    }

    static long getLong(Context context, String key, long defaultValue) {
        return StorageHelper.getPreferences(context).getLong(key, defaultValue);
    }

    static long getLong(Context context, String nameSpace, String key, long defaultValue) {
        return StorageHelper.getPreferences(context, nameSpace).getLong(key, defaultValue);
    }

    static void putInt(Context context, String key, int value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putInt(key, value);
        StorageHelper.persist(editor);
    }

    static int getInt(Context context, String key, int defaultValue) {
        return StorageHelper.getPreferences(context).getInt(key, defaultValue);
    }

    static void putBoolean(Context context, String key, boolean value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putBoolean(key, value);
        StorageHelper.persist(editor);
    }

    static boolean getBoolean(Context context, String key, boolean defaultValue) {
        return StorageHelper.getPreferences(context).getBoolean(key, defaultValue);
    }

    static SharedPreferences getPreferences(Context context, String namespace) {
        String path = "WizRocket";
        if (namespace != null) {
            path = path + "_" + namespace;
        }
        return context.getSharedPreferences(path, 0);
    }

    static SharedPreferences getPreferences(Context context) {
        return StorageHelper.getPreferences(context, null);
    }

    static void persist(final SharedPreferences.Editor editor) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                editor.apply();
            } else {
                StorageHelper.postAsyncSafely(new Runnable(){

                    @Override
                    public void run() {
                        editor.commit();
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("CRITICAL: Failed to persist shared preferences!", t);
        }
    }

    private static void postAsyncSafely(final Runnable runnable) {
        try {
            boolean executeSync;
            if (es == null) {
                es = Executors.newFixedThreadPool(1);
            }
            boolean bl = executeSync = Thread.currentThread().getId() == EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            Logger.v("Executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failed to submit task to the executor service", t);
        }
    }
}

