/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.models;

import android.support.annotation.NonNull;
import com.clevertap.android.sdk.ImageCache;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class CTABVariant {
    private String id;
    private String variantId;
    private String experimentId;
    private int version;
    private ArrayList<CTVariantAction> actions = new ArrayList();
    private JSONArray vars;
    private final Object actionsLock = new Object();
    private ArrayList<String> imageUrls;

    public static CTABVariant initWithJSON(JSONObject json) {
        try {
            String experimentId = json.optString("exp_id", "0");
            String variantId = json.optString("var_id", "0");
            int version = json.optInt("version", 0);
            JSONArray actions = json.optJSONArray("actions");
            JSONArray vars = json.optJSONArray("vars");
            CTABVariant variant = new CTABVariant(experimentId, variantId, version, actions, vars);
            Logger.v("Created CTABVariant:  " + variant.toString());
            return variant;
        }
        catch (Throwable t) {
            Logger.v("Error creating variant", t);
            return null;
        }
    }

    private CTABVariant(String experimentId, String variantId, int version, JSONArray actions, JSONArray vars) {
        this.experimentId = experimentId;
        this.variantId = variantId;
        this.id = variantId + ":" + experimentId;
        this.version = version;
        this.imageUrls = new ArrayList();
        this.addActions(actions);
        this.vars = vars == null ? new JSONArray() : vars;
    }

    public String getId() {
        return this.id;
    }

    String getVariantId() {
        return this.variantId;
    }

    String getExperimentId() {
        return this.experimentId;
    }

    public boolean equals(Object o) {
        if (o instanceof CTABVariant) {
            CTABVariant other = (CTABVariant)o;
            return this.getId().equals(other.getId()) && this.getVersion() == other.getVersion();
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @NonNull
    public String toString() {
        return "< id: " + this.getId() + ", version: " + this.getVersion() + ", actions count: " + this.actions.size() + ", vars count: " + this.getVars().length() + " >";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActions(JSONArray actions) {
        Object object = this.actionsLock;
        synchronized (object) {
            if (actions == null || actions.length() <= 0) {
                return;
            }
            int actionsLength = actions.length();
            try {
                for (int j = 0; j < actionsLength; ++j) {
                    JSONObject change = actions.getJSONObject(j);
                    if (change == null) continue;
                    String targetActivity = Utils.optionalStringKey(change, "target_activity");
                    String name = change.getString("name");
                    boolean exists = false;
                    CTVariantAction existingAction = null;
                    for (CTVariantAction action : this.actions) {
                        if (!action.getName().equals(name)) continue;
                        exists = true;
                        existingAction = action;
                        break;
                    }
                    if (exists) {
                        this.actions.remove(existingAction);
                    }
                    CTVariantAction action = new CTVariantAction(name, targetActivity, change);
                    this.actions.add(action);
                }
            }
            catch (Throwable t) {
                Logger.v("Error adding variant actions", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionsByName(JSONArray names) {
        if (names == null || names.length() <= 0) {
            return;
        }
        Object object = this.actionsLock;
        synchronized (object) {
            ArrayList<String> _names = new ArrayList<String>();
            for (int i = 0; i < names.length(); ++i) {
                try {
                    _names.add(names.getString(i));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ArrayList<CTVariantAction> newActions = new ArrayList<CTVariantAction>();
            for (CTVariantAction action : this.actions) {
                if (_names.contains(action.getName())) continue;
                newActions.add(action);
            }
            this.actions = newActions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActions() {
        Object object = this.actionsLock;
        synchronized (object) {
            this.actions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTVariantAction> getActions() {
        Object object = this.actionsLock;
        synchronized (object) {
            return this.actions;
        }
    }

    public JSONArray getVars() {
        return this.vars;
    }

    public int getVersion() {
        return this.version;
    }

    public void addImageUrls(List<String> urls) {
        if (urls == null) {
            return;
        }
        this.imageUrls.addAll(urls);
    }

    public void cleanup() {
        for (String url : this.imageUrls) {
            ImageCache.removeBitmap(url, true);
        }
    }

    public final class CTVariantAction {
        private String name;
        private String activityName;
        private JSONObject change;

        CTVariantAction(String name, String activityName, JSONObject change) {
            this.name = name;
            this.activityName = activityName;
            this.change = change;
        }

        public String getName() {
            return this.name;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public JSONObject getChange() {
            return this.change;
        }
    }
}

