/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.clevertap.android.sdk.CTCarouselViewPager;
import com.clevertap.android.sdk.CTCarouselViewPagerAdapter;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.CTInboxButtonClickListener;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.R;

class CTCarouselImageViewHolder
extends CTInboxBaseMessageViewHolder {
    private CTCarouselViewPager imageViewPager;
    private LinearLayout sliderDots;
    private TextView carouselTimestamp;
    private ImageView carouselReadDot;
    private RelativeLayout clickLayout;

    CTCarouselImageViewHolder(@NonNull View itemView) {
        super(itemView);
        this.imageViewPager = (CTCarouselViewPager)itemView.findViewById(R.id.image_carousel_viewpager);
        this.sliderDots = (LinearLayout)itemView.findViewById(R.id.sliderDots);
        this.carouselTimestamp = (TextView)itemView.findViewById(R.id.carousel_timestamp);
        this.carouselReadDot = (ImageView)itemView.findViewById(R.id.carousel_read_circle);
        this.clickLayout = (RelativeLayout)itemView.findViewById(R.id.body_linear_layout);
    }

    @Override
    void configureWithMessage(CTInboxMessage inboxMessage, final CTInboxListViewFragment parent, final int position) {
        super.configureWithMessage(inboxMessage, parent, position);
        final CTInboxListViewFragment parentWeak = this.getParent();
        Context appContext = parent.getActivity().getApplicationContext();
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.carouselTimestamp.setVisibility(0);
        if (inboxMessage.isRead()) {
            this.carouselReadDot.setVisibility(8);
        } else {
            this.carouselReadDot.setVisibility(0);
        }
        String carouselImageDisplayTimestamp = this.calculateDisplayTimestamp(inboxMessage.getDate());
        this.carouselTimestamp.setText((CharSequence)carouselImageDisplayTimestamp);
        this.carouselTimestamp.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.clickLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.imageViewPager.getLayoutParams();
        CTCarouselViewPagerAdapter carouselViewPagerAdapter = new CTCarouselViewPagerAdapter(appContext, parent, inboxMessage, layoutParams, position);
        this.imageViewPager.setAdapter(carouselViewPagerAdapter);
        int dotsCount = inboxMessage.getInboxMessageContents().size();
        if (this.sliderDots.getChildCount() > 0) {
            this.sliderDots.removeAllViews();
        }
        ImageView[] dots = new ImageView[dotsCount];
        for (int k = 0; k < dotsCount; ++k) {
            dots[k] = new ImageView((Context)parent.getActivity());
            dots[k].setVisibility(0);
            dots[k].setImageDrawable(appContext.getResources().getDrawable(R.drawable.ct_unselected_dot));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(8, 6, 4, 6);
            params.gravity = 17;
            if (this.sliderDots.getChildCount() >= dotsCount) continue;
            this.sliderDots.addView((View)dots[k], (ViewGroup.LayoutParams)params);
        }
        dots[0].setImageDrawable(parent.getActivity().getApplicationContext().getResources().getDrawable(R.drawable.ct_selected_dot));
        CarouselPageChangeListener carouselPageChangeListener = new CarouselPageChangeListener(parent.getActivity().getApplicationContext(), this, dots, inboxMessage);
        this.imageViewPager.addOnPageChangeListener(carouselPageChangeListener);
        this.clickLayout.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, null, parentWeak, this.imageViewPager));
        Runnable carouselRunnable = new Runnable(){

            @Override
            public void run() {
                FragmentActivity activity = parent.getActivity();
                if (activity == null) {
                    return;
                }
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (CTCarouselImageViewHolder.this.carouselReadDot.getVisibility() == 0 && parentWeak != null) {
                            parentWeak.didShow(null, position);
                        }
                        CTCarouselImageViewHolder.this.carouselReadDot.setVisibility(8);
                    }
                });
            }
        };
        Handler carouselHandler = new Handler();
        carouselHandler.postDelayed(carouselRunnable, 2000L);
    }

    class CarouselPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private CTCarouselImageViewHolder viewHolder;
        private ImageView[] dots;
        private CTInboxMessage inboxMessage;
        private Context context;

        CarouselPageChangeListener(Context context, CTCarouselImageViewHolder viewHolder, ImageView[] dots, CTInboxMessage inboxMessage) {
            this.context = context;
            this.viewHolder = viewHolder;
            this.dots = dots;
            this.inboxMessage = inboxMessage;
            this.dots[0].setImageDrawable(context.getResources().getDrawable(R.drawable.ct_selected_dot));
        }

        public void onPageScrolled(int i, float v, int i1) {
        }

        public void onPageSelected(int position) {
            for (ImageView dot : this.dots) {
                dot.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ct_unselected_dot));
            }
            this.dots[position].setImageDrawable(this.context.getResources().getDrawable(R.drawable.ct_selected_dot));
        }

        public void onPageScrollStateChanged(int i) {
        }
    }
}

