/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import com.clevertap.android.sdk.Logger;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class CTInAppNotificationMedia
implements Parcelable {
    String mediaUrl;
    String contentType;
    String cacheKey;
    int orientation;
    public static final Parcelable.Creator<CTInAppNotificationMedia> CREATOR = new Parcelable.Creator<CTInAppNotificationMedia>(){

        public CTInAppNotificationMedia createFromParcel(Parcel in) {
            return new CTInAppNotificationMedia(in);
        }

        public CTInAppNotificationMedia[] newArray(int size) {
            return new CTInAppNotificationMedia[size];
        }
    };

    CTInAppNotificationMedia() {
    }

    CTInAppNotificationMedia initWithJSON(JSONObject mediaObject, int orientation) {
        this.orientation = orientation;
        try {
            String mediaUrl;
            this.contentType = mediaObject.has("content_type") ? mediaObject.getString("content_type") : "";
            String string = mediaUrl = mediaObject.has("url") ? mediaObject.getString("url") : "";
            if (!mediaUrl.isEmpty()) {
                if (this.contentType.startsWith("image")) {
                    this.mediaUrl = mediaUrl;
                    this.cacheKey = mediaObject.has("key") ? UUID.randomUUID().toString() + mediaObject.getString("key") : UUID.randomUUID().toString();
                } else {
                    this.mediaUrl = mediaUrl;
                }
            }
        }
        catch (JSONException e) {
            Logger.v("Error parsing Media JSONObject - " + e.getLocalizedMessage());
        }
        if (this.contentType.isEmpty()) {
            return null;
        }
        return this;
    }

    String getMediaUrl() {
        return this.mediaUrl;
    }

    String getContentType() {
        return this.contentType;
    }

    String getCacheKey() {
        return this.cacheKey;
    }

    void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public int getOrientation() {
        return this.orientation;
    }

    boolean isImage() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("image") && !contentType.equals("image/gif");
    }

    boolean isGIF() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.equals("image/gif");
    }

    boolean isVideo() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("video");
    }

    boolean isAudio() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("audio");
    }

    private CTInAppNotificationMedia(Parcel in) {
        this.mediaUrl = in.readString();
        this.contentType = in.readString();
        this.cacheKey = in.readString();
        this.orientation = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mediaUrl);
        dest.writeString(this.contentType);
        dest.writeString(this.cacheKey);
        dest.writeInt(this.orientation);
    }
}

