/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;

@SuppressLint(value={"ViewConstructor"})
public class MediaRecyclerView
extends RecyclerView {
    private int videoSurfaceDefaultHeight = 0;
    private int screenDefaultHeight = 0;
    int targetPosition;
    private boolean muted = true;
    private CTInboxBaseMessageViewHolder currentlyPlayingHolder;

    MediaRecyclerView(Context context) {
        super(context);
        this.initialize();
    }

    private void initialize() {
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        this.videoSurfaceDefaultHeight = point.x;
        this.screenDefaultHeight = point.y;
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    MediaRecyclerView.this.playVideo();
                }
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
            }
        });
    }

    void holderStartedPlaying(CTInboxBaseMessageViewHolder holder) {
        if (this.currentlyPlayingHolder != null && holder == this.currentlyPlayingHolder) {
            return;
        }
        if (this.currentlyPlayingHolder != null) {
            this.currentlyPlayingHolder.pause();
        }
        this.currentlyPlayingHolder = holder;
    }

    void holderStoppedPlaying(CTInboxBaseMessageViewHolder holder) {
        if (this.currentlyPlayingHolder != null && holder == this.currentlyPlayingHolder) {
            this.currentlyPlayingHolder = null;
        }
    }

    void holderMuteChanged(CTInboxBaseMessageViewHolder holder, boolean muted) {
        this.muted = muted;
    }

    void stop() {
        if (this.currentlyPlayingHolder != null) {
            this.currentlyPlayingHolder.pause();
            this.currentlyPlayingHolder = null;
        }
    }

    void playVideo() {
        int endPositionVideoHeight;
        int startPositionVideoHeight;
        int startPosition = ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        int endPosition = ((LinearLayoutManager)this.getLayoutManager()).findLastVisibleItemPosition();
        if (endPosition - startPosition > 1) {
            endPosition = startPosition + 1;
        }
        if (startPosition < 0 || endPosition < 0) {
            return;
        }
        this.targetPosition = startPosition != endPosition ? ((startPositionVideoHeight = this.getVisibleVideoSurfaceHeight(startPosition)) > (endPositionVideoHeight = this.getVisibleVideoSurfaceHeight(endPosition)) ? startPosition : endPosition) : startPosition;
        int at = this.targetPosition - ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        View child = this.getChildAt(at);
        if (child == null) {
            return;
        }
        CTInboxBaseMessageViewHolder holder = (CTInboxBaseMessageViewHolder)((Object)child.getTag());
        if (holder == null) {
            return;
        }
        if (holder == this.currentlyPlayingHolder) {
            return;
        }
        if (this.currentlyPlayingHolder != null) {
            this.currentlyPlayingHolder.pause();
        }
        if (holder.shouldAutoPlay()) {
            holder.play(this.muted);
            this.currentlyPlayingHolder = holder;
        }
    }

    private int getVisibleVideoSurfaceHeight(int playPosition) {
        int at = playPosition - ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        View child = this.getChildAt(at);
        if (child == null) {
            return 0;
        }
        int[] location01 = new int[2];
        child.getLocationInWindow(location01);
        if (location01[1] < 0) {
            return location01[1] + this.videoSurfaceDefaultHeight;
        }
        return this.screenDefaultHeight - location01[1];
    }
}

