/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;

class CTInboxBaseMessageViewHolder
extends RecyclerView.ViewHolder {
    private PlayerView videoSurfaceView;
    RelativeLayout relativeLayout;
    RelativeLayout clickLayout;
    RelativeLayout bodyRelativeLayout;
    LinearLayout ctaLinearLayout;
    FrameLayout frameLayout;
    private boolean hasVideo;
    private float currentVolume;
    private ImageView muteIcon;
    private Context context;
    private Player.EventListener playerListener;
    private WeakReference<CTInboxListViewFragment> parentWeakReference;

    CTInboxListViewFragment getParent() {
        return (CTInboxListViewFragment)((Object)this.parentWeakReference.get());
    }

    CTInboxBaseMessageViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, int position) {
        this.hasVideo = false;
        this.parentWeakReference = new WeakReference<CTInboxListViewFragment>(parent);
    }

    private void setMute(boolean mute) {
        if (this.videoSurfaceView != null && this.videoSurfaceView.getPlayer() != null) {
            SimpleExoPlayer player = (SimpleExoPlayer)this.videoSurfaceView.getPlayer();
            float currentVolume = player.getVolume();
            boolean currentlyMuted = currentVolume <= 0.0f;
            boolean updateIcon = false;
            if (mute && !currentlyMuted) {
                player.setVolume(0.0f);
                this.currentVolume = currentVolume;
                updateIcon = true;
            } else if (!mute && currentlyMuted) {
                float volume = this.currentVolume > 0.0f ? this.currentVolume : 1.0f;
                player.setVolume(volume);
                updateIcon = true;
            }
            if (updateIcon && this.muteIcon != null) {
                FragmentActivity activity;
                final int imageId = mute ? R.drawable.volume_off : R.drawable.volume_on;
                CTInboxListViewFragment parent = this.getParent();
                if (parent != null && (activity = parent.getActivity()) != null) {
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CTInboxBaseMessageViewHolder.this.muteIcon.setImageDrawable(CTInboxBaseMessageViewHolder.this.context.getResources().getDrawable(imageId));
                        }
                    });
                }
            }
        }
    }

    void play(boolean muted) {
        if (this.videoSurfaceView != null && this.videoSurfaceView.getPlayer() != null) {
            this.setMute(muted);
            this.videoSurfaceView.getPlayer().setPlayWhenReady(true);
        }
    }

    void pause() {
        if (this.videoSurfaceView != null && this.videoSurfaceView.getPlayer() != null) {
            this.videoSurfaceView.getPlayer().setPlayWhenReady(false);
        }
    }

    boolean shouldAutoPlay() {
        return this.hasVideo;
    }

    void cleanUp() {
        this.cleanUpVideoView();
    }

    String calculateDisplayTimestamp(long time) {
        long now = System.currentTimeMillis() / 1000L;
        long diff = now - time;
        if (diff < 60L) {
            return "Just Now";
        }
        if (diff > 60L && diff < 3540L) {
            return diff / 60L + " mins ago";
        }
        if (diff > 3540L && diff < 81420L) {
            return diff / 3600L > 1L ? diff / 3600L + " hours ago" : diff / 3600L + " hour ago";
        }
        if (diff > 86400L && diff < 172800L) {
            return "Yesterday";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM");
        return sdf.format(new Date(time));
    }

    void hideTwoButtons(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        secondaryButton.setVisibility(8);
        tertiaryButton.setVisibility(8);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams(0, -1, 6.0f);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        LinearLayout.LayoutParams secondaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)secondaryLayoutParams);
        LinearLayout.LayoutParams tertiaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)tertiaryLayoutParams);
    }

    void hideOneButton(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        tertiaryButton.setVisibility(8);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams(0, -1, 3.0f);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        LinearLayout.LayoutParams secondaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 3.0f);
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)secondaryLayoutParams);
        LinearLayout.LayoutParams tertiaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)tertiaryLayoutParams);
    }

    private SimpleExoPlayer createAndConfigurePlayer(Context context, String mediaUrl) {
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        final SimpleExoPlayer player = ExoPlayerFactory.newSimpleInstance((Context)context, (TrackSelector)trackSelector);
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(context, Util.getUserAgent((Context)context, (String)context.getPackageName()), (TransferListener)bandwidthMeter);
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)mediaUrl));
        player.prepare((MediaSource)hlsMediaSource);
        player.setRepeatMode(1);
        player.setPlayWhenReady(false);
        final WeakReference<CTInboxBaseMessageViewHolder> thisWeak = new WeakReference<CTInboxBaseMessageViewHolder>(this);
        this.playerListener = new Player.EventListener(){

            public void onTimelineChanged(Timeline timeline, Object manifest, int reason) {
            }

            public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            }

            public void onLoadingChanged(boolean isLoading) {
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                switch (playbackState) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        player.seekTo(0L);
                        if (thisWeak.get() == null) break;
                        ((CTInboxBaseMessageViewHolder)((Object)thisWeak.get())).notifyStopped();
                        break;
                    }
                    case 1: {
                        if (thisWeak.get() == null) break;
                        ((CTInboxBaseMessageViewHolder)((Object)thisWeak.get())).notifyStopped();
                        break;
                    }
                    case 3: {
                        if (thisWeak.get() == null) break;
                        ((CTInboxBaseMessageViewHolder)((Object)thisWeak.get())).notifyPlaying();
                        break;
                    }
                }
            }

            public void onRepeatModeChanged(int repeatMode) {
            }

            public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            }

            public void onPlayerError(ExoPlaybackException error) {
            }

            public void onPositionDiscontinuity(int reason) {
            }

            public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            }

            public void onSeekProcessed() {
            }
        };
        player.addListener(this.playerListener);
        return player;
    }

    private void notifyPlaying() {
        CTInboxListViewFragment parent = this.getParent();
        if (parent != null) {
            parent.mediaRecyclerView.holderStartedPlaying(this);
        }
    }

    private void notifyStopped() {
        CTInboxListViewFragment parent = this.getParent();
        if (parent != null) {
            parent.mediaRecyclerView.holderStoppedPlaying(this);
        }
    }

    private void notifyMuteChanged(boolean muted) {
        CTInboxListViewFragment parent = this.getParent();
        if (parent != null) {
            parent.mediaRecyclerView.holderMuteChanged(this, muted);
        }
    }

    void addMediaPlayerView(CTInboxMessage inboxMessage) {
        int width;
        Context appContext;
        CTInboxListViewFragment parent = this.getParent();
        this.context = appContext = parent.getContext().getApplicationContext();
        this.videoSurfaceView = new PlayerView(appContext);
        this.videoSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.videoSurfaceView.setUseArtwork(true);
        this.videoSurfaceView.setControllerAutoShow(false);
        this.videoSurfaceView.setResizeMode(4);
        String mediaUrl = inboxMessage.getInboxMessageContents().get(0).getMedia();
        final SimpleExoPlayer player = this.createAndConfigurePlayer(appContext, mediaUrl);
        this.videoSurfaceView.requestFocus();
        this.videoSurfaceView.setVisibility(0);
        this.videoSurfaceView.setPlayer((Player)player);
        this.videoSurfaceView.setUseArtwork(true);
        Drawable artwork = this.context.getResources().getDrawable(R.drawable.ct_audio);
        if (Build.VERSION.SDK_INT >= 23) {
            this.videoSurfaceView.setDefaultArtwork(Utils.drawableToBitmap(artwork));
        } else {
            this.videoSurfaceView.setDefaultArtwork(Utils.drawableToBitmap(artwork));
        }
        if (inboxMessage.getOrientation().equalsIgnoreCase("l")) {
            width = this.context.getResources().getDisplayMetrics().widthPixels;
            int height = Math.round((float)width * 0.5625f);
            this.videoSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
        } else if (inboxMessage.getOrientation().equalsIgnoreCase("p")) {
            width = this.context.getResources().getDisplayMetrics().widthPixels;
            this.videoSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, width));
            this.videoSurfaceView.setResizeMode(0);
        }
        this.frameLayout.addView((View)this.videoSurfaceView);
        this.frameLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        this.frameLayout.setVisibility(0);
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.hasVideo = content.mediaIsVideo();
        if (content.mediaIsVideo()) {
            this.muteIcon = new ImageView(appContext);
            this.muteIcon.setImageDrawable(appContext.getResources().getDrawable(R.drawable.volume_off));
            int iconWidth = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
            int iconHeight = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(iconWidth, iconHeight);
            int iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
            int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
            layoutParams.setMargins(0, iconTop, iconRight, 0);
            layoutParams.gravity = 0x800005;
            this.muteIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.muteIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    boolean mute = player.getVolume() > 0.0f;
                    CTInboxBaseMessageViewHolder.this.setMute(mute);
                    CTInboxBaseMessageViewHolder.this.notifyMuteChanged(mute);
                }
            });
            this.frameLayout.addView((View)this.muteIcon);
        }
    }

    private void cleanUpVideoView() {
        if (this.videoSurfaceView != null) {
            int index;
            ViewGroup parent;
            Player player = this.videoSurfaceView.getPlayer();
            if (player != null) {
                if (this.playerListener != null) {
                    player.removeListener(this.playerListener);
                    this.playerListener = null;
                }
                player.release();
                this.videoSurfaceView.setPlayer(null);
            }
            if ((parent = (ViewGroup)this.videoSurfaceView.getParent()) != null && (index = parent.indexOfChild((View)this.videoSurfaceView)) >= 0) {
                parent.removeViewAt(index);
            }
            this.videoSurfaceView = null;
        }
    }

    void removeVideoView() {
        this.frameLayout.setVisibility(8);
        this.cleanUpVideoView();
    }
}

