/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LruCache;
import com.clevertap.android.sdk.CTInAppNotificationButton;
import com.clevertap.android.sdk.CTInAppType;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CTInAppNotification
implements Parcelable {
    private String id;
    private String campaignId;
    private String type;
    private CTInAppType inAppType;
    private String html;
    private boolean excludeFromCaps;
    private boolean showClose;
    private boolean darkenScreen;
    private int maxPerSession;
    private int totalLifetimeCount;
    private int totalDailyCount;
    private char position;
    private int height;
    private int heightPercentage;
    private int width;
    private int widthPercentage;
    private String imageUrl;
    private String _imageCacheKey;
    private String contentType;
    private String mediaUrl;
    private String title;
    private String titleColor;
    private String message;
    private String messageColor;
    private String backgroundColor;
    private boolean hideCloseButton;
    private ArrayList<CTInAppNotificationButton> buttons = new ArrayList();
    private int buttonCount;
    private JSONObject jsonDescription;
    private String error;
    private JSONObject customExtras;
    private JSONObject actionExtras;
    CTInAppNotificationListener listener;
    private boolean isTablet;
    public static final Parcelable.Creator<CTInAppNotification> CREATOR = new Parcelable.Creator<CTInAppNotification>(){

        public CTInAppNotification createFromParcel(Parcel in) {
            return new CTInAppNotification(in);
        }

        public CTInAppNotification[] newArray(int size) {
            return new CTInAppNotification[size];
        }
    };

    CTInAppNotification() {
    }

    CTInAppNotification initWithJSON(JSONObject jsonObject) {
        this.jsonDescription = jsonObject;
        try {
            String string = this.type = jsonObject.has("type") ? jsonObject.getString("type") : null;
            if (this.type == null || this.type.equals("custom-html")) {
                this.legacyConfigureWithJson(jsonObject);
            } else {
                this.configureWithJson(jsonObject);
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON : " + e.getLocalizedMessage();
        }
        return this;
    }

    private void legacyConfigureWithJson(JSONObject jsonObject) {
        Bundle b = CTInAppNotification.getBundleFromJsonObject(jsonObject);
        if (!this.validateNotifBundle(b)) {
            this.error = "Invalid JSON";
            return;
        }
        try {
            JSONObject data;
            this.id = jsonObject.has("ti") ? jsonObject.getString("ti") : "";
            this.campaignId = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "";
            this.excludeFromCaps = jsonObject.has("efc") && jsonObject.getInt("efc") == 1;
            this.totalLifetimeCount = jsonObject.has("tlc") ? jsonObject.getInt("tlc") : -1;
            this.totalDailyCount = jsonObject.has("tdc") ? jsonObject.getInt("tdc") : -1;
            JSONObject jSONObject = data = jsonObject.has("d") ? jsonObject.getJSONObject("d") : null;
            if (data != null) {
                JSONObject displayParams;
                this.html = data.getString("html");
                JSONObject jSONObject2 = this.customExtras = data.has("kv") ? data.getJSONObject("kv") : null;
                if (this.customExtras == null) {
                    this.customExtras = new JSONObject();
                }
                if ((displayParams = jsonObject.getJSONObject("w")) != null) {
                    this.darkenScreen = displayParams.getBoolean("dk");
                    this.showClose = displayParams.getBoolean("sc");
                    this.position = displayParams.getString("pos").charAt(0);
                    this.width = displayParams.has("xdp") ? displayParams.getInt("xdp") : 0;
                    this.widthPercentage = displayParams.has("xp") ? displayParams.getInt("xp") : 0;
                    this.height = displayParams.has("ydp") ? displayParams.getInt("ydp") : 0;
                    this.heightPercentage = displayParams.has("yp") ? displayParams.getInt("yp") : 0;
                    int n = this.maxPerSession = displayParams.has("mdc") ? displayParams.getInt("mdc") : -1;
                }
                if (this.html != null) {
                    if (this.position == 't' && this.widthPercentage == 100 && this.heightPercentage == 30) {
                        this.inAppType = CTInAppType.CTInAppTypeHeaderHTML;
                    } else if (this.position == 'b' && this.widthPercentage == 100 && this.heightPercentage == 30) {
                        this.inAppType = CTInAppType.CTInAppTypeFooterHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 90 && this.heightPercentage == 85) {
                        this.inAppType = CTInAppType.CTInAppTypeInterstitialHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 100 && this.heightPercentage == 100) {
                        this.inAppType = CTInAppType.CTInAppTypeCoverHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 90 && this.heightPercentage == 50) {
                        this.inAppType = CTInAppType.CTInAppTypeHalfInterstitialHTML;
                    }
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON";
        }
    }

    private void configureWithJson(JSONObject jsonObject) {
        try {
            JSONArray buttonArray;
            JSONObject media;
            JSONObject msgObject;
            JSONObject titleObject;
            this.id = jsonObject.has("ti") ? jsonObject.getString("ti") : "";
            this.campaignId = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "";
            this.type = jsonObject.getString("type");
            this.excludeFromCaps = jsonObject.has("efc") && jsonObject.getInt("efc") == 1;
            this.totalLifetimeCount = jsonObject.has("tlc") ? jsonObject.getInt("tlc") : -1;
            this.totalDailyCount = jsonObject.has("tdc") ? jsonObject.getInt("tdc") : -1;
            this.inAppType = CTInAppType.fromString(this.type);
            this.isTablet = jsonObject.has("tablet") ? jsonObject.getBoolean("tablet") : false;
            this.backgroundColor = jsonObject.has("bg") ? jsonObject.getString("bg") : "";
            JSONObject jSONObject = titleObject = jsonObject.has("title") ? jsonObject.getJSONObject("title") : null;
            if (titleObject != null) {
                this.title = titleObject.has("text") ? titleObject.getString("text") : "";
                this.titleColor = titleObject.has("color") ? titleObject.getString("color") : "";
            }
            JSONObject jSONObject2 = msgObject = jsonObject.has("message") ? jsonObject.getJSONObject("message") : null;
            if (msgObject != null) {
                this.message = msgObject.has("text") ? msgObject.getString("text") : "";
                this.messageColor = msgObject.has("color") ? msgObject.getString("color") : "";
            }
            this.hideCloseButton = jsonObject.has("close") ? jsonObject.getBoolean("close") : false;
            JSONObject jSONObject3 = media = jsonObject.has("media") ? jsonObject.getJSONObject("media") : null;
            if (media != null) {
                String mediaUrl;
                this.contentType = media.has("content_type") ? media.getString("content_type") : "";
                String string = mediaUrl = media.has("url") ? media.getString("url") : "";
                if (!mediaUrl.isEmpty()) {
                    if (this.contentType.startsWith("image")) {
                        this.imageUrl = mediaUrl;
                        this._imageCacheKey = media.has("key") ? UUID.randomUUID().toString() + media.getString("key") : UUID.randomUUID().toString();
                    } else {
                        this.mediaUrl = mediaUrl;
                    }
                }
            }
            JSONArray jSONArray = buttonArray = jsonObject.has("buttons") ? jsonObject.getJSONArray("buttons") : null;
            if (buttonArray != null) {
                for (int i = 0; i < buttonArray.length(); ++i) {
                    CTInAppNotificationButton inAppNotificationButton = new CTInAppNotificationButton().initWithJSON(buttonArray.getJSONObject(i));
                    if (inAppNotificationButton == null || inAppNotificationButton.getError() != null) continue;
                    this.buttons.add(inAppNotificationButton);
                    ++this.buttonCount;
                }
            }
            switch (this.inAppType) {
                case CTInAppTypeFooter: 
                case CTInAppTypeHeader: {
                    if (!this.mediaIsGIF() && !this.mediaIsAudio() && !this.mediaIsVideo()) break;
                    this.imageUrl = null;
                    Logger.d("Unable to download to media. Wrong media type for template");
                    break;
                }
                case CTInAppTypeCover: 
                case CTInAppTypeHalfInterstitial: {
                    if (!this.mediaIsGIF() && !this.mediaIsAudio() && !this.mediaIsVideo()) break;
                    this.imageUrl = null;
                    Logger.d("Unable to download to media. Wrong media type for template");
                    break;
                }
                case CTInAppTypeCoverImageOnly: 
                case CTInAppTypeHalfInterstitialImageOnly: 
                case CTInAppTypeInterstitialImageOnly: {
                    if (!this.mediaIsGIF() && !this.mediaIsAudio() && !this.mediaIsVideo() && this.mediaIsImage()) break;
                    this.error = "Wrong media type for template";
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON" + e.getLocalizedMessage();
        }
    }

    void prepareForDisplay() {
        if (this.mediaIsGIF()) {
            GifCache.init();
            if (this.getGifByteArray() != null) {
                this.listener.notificationReady(this);
                return;
            }
            Logger.v("CTInAppNotification: downloading GIF :" + this.imageUrl);
            byte[] gifByteArray = Utils.getByteArrayFromImageURL(this.imageUrl);
            if (gifByteArray != null) {
                Logger.v("GIF Downloaded from url: " + this.imageUrl);
                if (!GifCache.addByteArray(this.getImageCacheKey(), gifByteArray)) {
                    this.error = "Error processing GIF";
                }
                this.listener.notificationReady(this);
            }
        } else if (this.mediaIsImage()) {
            ImageCache.init();
            if (this.getImage() != null) {
                this.listener.notificationReady(this);
                return;
            }
            Logger.v("CTInAppNotification: downloading Image :" + this.imageUrl);
            Bitmap imageBitmap = Utils.getBitmapFromURL(this.imageUrl);
            if (imageBitmap != null) {
                Logger.v("Image Downloaded from url: " + this.imageUrl);
                if (!ImageCache.addBitmap(this.getImageCacheKey(), imageBitmap)) {
                    this.error = "Error processing image";
                }
                this.listener.notificationReady(this);
            }
        } else if (this.mediaIsVideo() || this.mediaIsAudio()) {
            Class<?> className = null;
            try {
                className = Class.forName("com.google.android.exoplayer2.ExoPlayerFactory");
                className = Class.forName("com.google.android.exoplayer2.source.hls.HlsMediaSource");
                className = Class.forName("com.google.android.exoplayer2.ui.PlayerView");
            }
            catch (Throwable t) {
                Logger.d("ExoPlayer library files are missing!!!");
                Logger.d("Please add ExoPlayer dependencies to render In-App notifications playing audio/video. For more information checkout CleverTap documentation.");
                this.error = className != null ? "ExoPlayer classes not found " + className.getName() : "ExoPlayer classes not found";
            }
            this.listener.notificationReady(this);
        } else {
            this.listener.notificationReady(this);
        }
    }

    private boolean validateNotifBundle(Bundle notif) {
        try {
            Bundle w = notif.getBundle("w");
            Bundle d = notif.getBundle("d");
            if (w == null || d == null) {
                return false;
            }
            if (!this.isKeyValid(w, "xdp", Integer.class) && !this.isKeyValid(w, "xp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "ydp", Integer.class) && !this.isKeyValid(w, "yp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "dk", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "sc", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(d, "html", String.class)) {
                return false;
            }
            if (this.isKeyValid(w, "pos", String.class)) {
                char pos = w.getString("pos").charAt(0);
                switch (pos) {
                    case 't': {
                        break;
                    }
                    case 'r': {
                        break;
                    }
                    case 'b': {
                        break;
                    }
                    case 'l': {
                        break;
                    }
                    case 'c': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            Logger.v("Failed to parse in-app notification!", t);
            return false;
        }
    }

    private boolean isKeyValid(Bundle b, String key, Class<?> type) {
        return b.containsKey(key) && b.get(key).getClass().equals(type);
    }

    private static Bundle getBundleFromJsonObject(JSONObject notif) {
        Bundle b = new Bundle();
        Iterator iterator = notif.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value = notif.get(key);
                if (value instanceof String) {
                    b.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Character) {
                    b.putChar(key, ((Character)value).charValue());
                    continue;
                }
                if (value instanceof Integer) {
                    b.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Float) {
                    b.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    b.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Long) {
                    b.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    b.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                b.putBundle(key, CTInAppNotification.getBundleFromJsonObject((JSONObject)value));
            }
            catch (JSONException e) {
                Logger.v("Key had unknown object. Discarding");
            }
        }
        return b;
    }

    String getId() {
        return this.id;
    }

    String getCampaignId() {
        return this.campaignId;
    }

    public CTInAppType getInAppType() {
        return this.inAppType;
    }

    String getHtml() {
        return this.html;
    }

    boolean isExcludeFromCaps() {
        return this.excludeFromCaps;
    }

    boolean isShowClose() {
        return this.showClose;
    }

    boolean isDarkenScreen() {
        return this.darkenScreen;
    }

    int getMaxPerSession() {
        return this.maxPerSession;
    }

    int getTotalLifetimeCount() {
        return this.totalLifetimeCount;
    }

    int getTotalDailyCount() {
        return this.totalDailyCount;
    }

    char getPosition() {
        return this.position;
    }

    int getHeight() {
        return this.height;
    }

    int getHeightPercentage() {
        return this.heightPercentage;
    }

    int getWidth() {
        return this.width;
    }

    int getWidthPercentage() {
        return this.widthPercentage;
    }

    JSONObject getJsonDescription() {
        return this.jsonDescription;
    }

    String getError() {
        return this.error;
    }

    JSONObject getCustomExtras() {
        return this.customExtras;
    }

    public JSONObject getActionExtras() {
        return this.actionExtras;
    }

    String getType() {
        return this.type;
    }

    String getMediaUrl() {
        return this.mediaUrl;
    }

    String getTitle() {
        return this.title;
    }

    String getTitleColor() {
        return this.titleColor;
    }

    String getMessage() {
        return this.message;
    }

    String getMessageColor() {
        return this.messageColor;
    }

    String getContentType() {
        return this.contentType;
    }

    String getBackgroundColor() {
        return this.backgroundColor;
    }

    boolean isTablet() {
        return this.isTablet;
    }

    ArrayList<CTInAppNotificationButton> getButtons() {
        return this.buttons;
    }

    Bitmap getImage() {
        return ImageCache.getBitmap(this.getImageCacheKey());
    }

    byte[] getGifByteArray() {
        return GifCache.getByteArray(this.getImageCacheKey());
    }

    private String getImageCacheKey() {
        return this._imageCacheKey;
    }

    void didDismiss() {
        this.removeImageOrGif();
    }

    private void removeImageOrGif() {
        if (this.imageUrl != null) {
            if (!this.contentType.equals("image/gif")) {
                ImageCache.removeBitmap(this.getImageCacheKey());
            } else {
                GifCache.removeByteArray(this.getImageCacheKey());
            }
        }
    }

    String getImageUrl() {
        return this.imageUrl;
    }

    boolean isHideCloseButton() {
        return this.hideCloseButton;
    }

    int getButtonCount() {
        return this.buttonCount;
    }

    boolean mediaIsImage() {
        String contentType = this.getContentType();
        return contentType != null && this.imageUrl != null && contentType.startsWith("image") && !contentType.equals("image/gif");
    }

    boolean mediaIsGIF() {
        String contentType = this.getContentType();
        return contentType != null && this.imageUrl != null && contentType.equals("image/gif");
    }

    boolean mediaIsVideo() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("video");
    }

    boolean mediaIsAudio() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("audio");
    }

    private CTInAppNotification(Parcel in) {
        try {
            this.id = in.readString();
            this.campaignId = in.readString();
            this.inAppType = (CTInAppType)((Object)in.readValue(CTInAppType.class.getClassLoader()));
            this.html = in.readString();
            this.excludeFromCaps = in.readByte() != 0;
            this.showClose = in.readByte() != 0;
            this.darkenScreen = in.readByte() != 0;
            this.maxPerSession = in.readInt();
            this.totalLifetimeCount = in.readInt();
            this.totalDailyCount = in.readInt();
            this.position = ((Character)in.readValue(Character.TYPE.getClassLoader())).charValue();
            this.height = in.readInt();
            this.heightPercentage = in.readInt();
            this.width = in.readInt();
            this.widthPercentage = in.readInt();
            this.jsonDescription = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.error = in.readString();
            this.customExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.actionExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.type = in.readString();
            this.contentType = in.readString();
            this.imageUrl = in.readString();
            this._imageCacheKey = in.readString();
            this.mediaUrl = in.readString();
            this.title = in.readString();
            this.titleColor = in.readString();
            this.backgroundColor = in.readString();
            this.message = in.readString();
            this.messageColor = in.readString();
            try {
                this.buttons = in.createTypedArrayList(CTInAppNotificationButton.CREATOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.hideCloseButton = in.readByte() != 0;
            this.buttonCount = in.readInt();
            this.isTablet = in.readByte() != 0;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.campaignId);
        dest.writeValue((Object)this.inAppType);
        dest.writeString(this.html);
        dest.writeByte((byte)(this.excludeFromCaps ? 1 : 0));
        dest.writeByte((byte)(this.showClose ? 1 : 0));
        dest.writeByte((byte)(this.darkenScreen ? 1 : 0));
        dest.writeInt(this.maxPerSession);
        dest.writeInt(this.totalLifetimeCount);
        dest.writeInt(this.totalDailyCount);
        dest.writeValue((Object)Character.valueOf(this.position));
        dest.writeInt(this.height);
        dest.writeInt(this.heightPercentage);
        dest.writeInt(this.width);
        dest.writeInt(this.widthPercentage);
        if (this.jsonDescription == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.jsonDescription.toString());
        }
        dest.writeString(this.error);
        if (this.customExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.customExtras.toString());
        }
        if (this.actionExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.actionExtras.toString());
        }
        dest.writeString(this.type);
        dest.writeString(this.contentType);
        dest.writeString(this.imageUrl);
        dest.writeString(this._imageCacheKey);
        dest.writeString(this.mediaUrl);
        dest.writeString(this.title);
        dest.writeString(this.titleColor);
        dest.writeString(this.backgroundColor);
        dest.writeString(this.message);
        dest.writeString(this.messageColor);
        dest.writeTypedList(this.buttons);
        dest.writeByte((byte)(this.hideCloseButton ? 1 : 0));
        dest.writeInt(this.buttonCount);
        dest.writeByte((byte)(this.isTablet ? 1 : 0));
    }

    private static class GifCache {
        private static final int MIN_CACHE_SIZE = 5120;
        private static final int maxMemory = (int)Runtime.getRuntime().maxMemory() / 1024;
        private static final int cacheSize = Math.max(maxMemory / 32, 5120);
        private static LruCache<String, byte[]> mMemoryCache;

        private GifCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void init() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                if (mMemoryCache == null) {
                    Logger.v("CTInAppNotification.GifCache: init with max device memory: " + String.valueOf(maxMemory) + "KB and allocated cache size: " + String.valueOf(cacheSize) + "KB");
                    try {
                        mMemoryCache = new LruCache<String, byte[]>(cacheSize){

                            protected int sizeOf(String key, byte[] byteArray) {
                                int size = GifCache.getByteArraySizeInKB(byteArray);
                                Logger.v("CTInAppNotification.GifCache: have gif of size: " + size + "KB for key: " + key);
                                return size;
                            }
                        };
                    }
                    catch (Throwable t) {
                        Logger.v("CTInAppNotification.GifCache: unable to initialize cache: ", t.getCause());
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private static int getByteArraySizeInKB(byte[] byteArray) {
            return byteArray.length / 1024;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getAvailableMemory() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mMemoryCache == null ? 0 : cacheSize - mMemoryCache.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isEmpty() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mMemoryCache.size() <= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void cleanup() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                if (GifCache.isEmpty()) {
                    Logger.v("CTInAppNotification.GifCache: cache is empty, removing it");
                    mMemoryCache = null;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean addByteArray(String key, byte[] byteArray) {
            if (mMemoryCache == null) {
                return false;
            }
            if (GifCache.getByteArray(key) != null) return true;
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                int arraySize = GifCache.getByteArraySizeInKB(byteArray);
                int available = GifCache.getAvailableMemory();
                Logger.v("CTInAppNotification.GifCache: gif size: " + arraySize + "KB. Available mem: " + available + "KB.");
                if (arraySize > GifCache.getAvailableMemory()) {
                    Logger.v("CTInAppNotification.GifCache: insufficient memory to add gif: " + key);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                mMemoryCache.put((Object)key, (Object)byteArray);
                Logger.v("CTInAppNotification.GifCache: added gif for key: " + key);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static byte[] getByteArray(String key) {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mMemoryCache == null ? null : (byte[])mMemoryCache.get((Object)key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeByteArray(String key) {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                if (mMemoryCache == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                mMemoryCache.remove((Object)key);
                Logger.v("CTInAppNotification.GifCache: removed gif for key: " + key);
                GifCache.cleanup();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static class ImageCache {
        private static final int MIN_CACHE_SIZE = 3072;
        private static final int maxMemory = (int)Runtime.getRuntime().maxMemory() / 1024;
        private static final int cacheSize = Math.max(maxMemory / 32, 3072);
        private static LruCache<String, Bitmap> mMemoryCache;

        private ImageCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void init() {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                if (mMemoryCache == null) {
                    Logger.v("CTInAppNotification.ImageCache: init with max device memory: " + String.valueOf(maxMemory) + "KB and allocated cache size: " + String.valueOf(cacheSize) + "KB");
                    try {
                        mMemoryCache = new LruCache<String, Bitmap>(cacheSize){

                            protected int sizeOf(String key, Bitmap bitmap) {
                                int size = ImageCache.getImageSizeInKB(bitmap);
                                Logger.v("CTInAppNotification.ImageCache: have image of size: " + size + "KB for key: " + key);
                                return size;
                            }
                        };
                    }
                    catch (Throwable t) {
                        Logger.v("CTInAppNotification.ImageCache: unable to initialize cache: ", t.getCause());
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private static int getImageSizeInKB(Bitmap bitmap) {
            return bitmap.getByteCount() / 1024;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getAvailableMemory() {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mMemoryCache == null ? 0 : cacheSize - mMemoryCache.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isEmpty() {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mMemoryCache.size() <= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void cleanup() {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                if (ImageCache.isEmpty()) {
                    Logger.v("CTInAppNotification.ImageCache: cache is empty, removing it");
                    mMemoryCache = null;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean addBitmap(String key, Bitmap bitmap) {
            if (mMemoryCache == null) {
                return false;
            }
            if (ImageCache.getBitmap(key) != null) return true;
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                int imageSize = ImageCache.getImageSizeInKB(bitmap);
                int available = ImageCache.getAvailableMemory();
                Logger.v("CTInAppNotification.ImageCache: image size: " + imageSize + "KB. Available mem: " + available + "KB.");
                if (imageSize > ImageCache.getAvailableMemory()) {
                    Logger.v("CTInAppNotification.ImageCache: insufficient memory to add image: " + key);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                mMemoryCache.put((Object)key, (Object)bitmap);
                Logger.v("CTInAppNotification.ImageCache: added image for key: " + key);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Bitmap getBitmap(String key) {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                if (key != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return mMemoryCache == null ? null : (Bitmap)mMemoryCache.get((Object)key);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeBitmap(String key) {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                if (mMemoryCache == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                mMemoryCache.remove((Object)key);
                Logger.v("CTInAppNotification.LruImageCache: removed image for key: " + key);
                ImageCache.cleanup();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    static interface CTInAppNotificationListener {
        public void notificationReady(CTInAppNotification var1);
    }
}

