/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import com.clevertap.android.sdk.CTInAppBaseFragment;
import com.clevertap.android.sdk.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.CTInAppHtmlCoverFragment;
import com.clevertap.android.sdk.CTInAppHtmlHalfInterstitialFragment;
import com.clevertap.android.sdk.CTInAppHtmlInterstitialFragment;
import com.clevertap.android.sdk.CTInAppNativeCoverFragment;
import com.clevertap.android.sdk.CTInAppNativeCoverImageFragment;
import com.clevertap.android.sdk.CTInAppNativeHalfInterstitialFragment;
import com.clevertap.android.sdk.CTInAppNativeHalfInterstitialImageFragment;
import com.clevertap.android.sdk.CTInAppNativeInterstitialFragment;
import com.clevertap.android.sdk.CTInAppNativeInterstitialImageFragment;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CTInAppType;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import java.lang.ref.WeakReference;

public final class InAppNotificationActivity
extends FragmentActivity
implements CTInAppBaseFragment.InAppListener {
    private CTInAppNotification inAppNotification;
    private CleverTapInstanceConfig config;
    private WeakReference<InAppActivityListener> listenerWeakReference;

    void setListener(InAppActivityListener listener) {
        this.listenerWeakReference = new WeakReference<InAppActivityListener>(listener);
    }

    InAppActivityListener getListener() {
        InAppActivityListener listener = null;
        try {
            listener = (InAppActivityListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppActivityListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    public void setTheme(int resid) {
        super.setTheme(0x1030010);
    }

    private String getFragmentTag() {
        return this.config.getAccountId() + ":CT_INAPP_CONTENT_FRAGMENT";
    }

    public void onCreate(Bundle savedInstanceState) {
        CTInAppBaseFullFragment contentFragment;
        super.onCreate(savedInstanceState);
        try {
            Bundle notif = this.getIntent().getExtras();
            if (notif == null) {
                throw new IllegalArgumentException();
            }
            this.inAppNotification = (CTInAppNotification)notif.getParcelable("inApp");
            this.config = (CleverTapInstanceConfig)notif.getParcelable("config");
            this.setListener(CleverTapAPI.instanceWithConfig(this.getApplicationContext(), this.config));
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification bundle to show!", t);
            return;
        }
        if (savedInstanceState == null && (contentFragment = this.createContentFragment()) != null) {
            Bundle bundle = new Bundle();
            bundle.putParcelable("inApp", (Parcelable)this.inAppNotification);
            bundle.putParcelable("config", (Parcelable)this.config);
            contentFragment.setArguments(bundle);
            this.getFragmentManager().beginTransaction().setCustomAnimations(0x10B0000, 0x10B0001).add(0x1020002, (Fragment)contentFragment, this.getFragmentTag()).commit();
        }
    }

    private CTInAppBaseFullFragment createContentFragment() {
        CTInAppType type = this.inAppNotification.getInAppType();
        CTInAppBaseFullFragment viewFragment = null;
        switch (type) {
            case CTInAppTypeCoverHTML: {
                viewFragment = new CTInAppHtmlCoverFragment();
                break;
            }
            case CTInAppTypeInterstitialHTML: {
                viewFragment = new CTInAppHtmlInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialHTML: {
                viewFragment = new CTInAppHtmlHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCover: {
                viewFragment = new CTInAppNativeCoverFragment();
                break;
            }
            case CTInAppTypeInterstitial: {
                viewFragment = new CTInAppNativeInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitial: {
                viewFragment = new CTInAppNativeHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCoverImageOnly: {
                viewFragment = new CTInAppNativeCoverImageFragment();
                break;
            }
            case CTInAppTypeInterstitialImageOnly: {
                viewFragment = new CTInAppNativeInterstitialImageFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialImageOnly: {
                viewFragment = new CTInAppNativeHalfInterstitialImageFragment();
                break;
            }
            case CTInAppTypeAlert: {
                AlertDialog alertDialog = null;
                if (this.inAppNotification.getButtons().size() > 0) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        alertDialog = new AlertDialog.Builder((Context)this, 16974394).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)this.inAppNotification.getButtons().get(0).getText(), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Bundle data = new Bundle();
                                data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getText());
                                InAppNotificationActivity.this.didClick(data);
                                String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getActionUrl();
                                if (actionUrl != null) {
                                    InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                    return;
                                }
                                InAppNotificationActivity.this.didDismiss(data);
                            }
                        }).create();
                        if (this.inAppNotification.getButtons().size() == 2) {
                            alertDialog.setButton(-2, (CharSequence)this.inAppNotification.getButtons().get(1).getText(), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    Bundle data = new Bundle();
                                    data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                    data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getText());
                                    InAppNotificationActivity.this.didClick(data);
                                    String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getActionUrl();
                                    if (actionUrl != null) {
                                        InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                        return;
                                    }
                                    InAppNotificationActivity.this.didDismiss(data);
                                }
                            });
                        }
                    } else {
                        alertDialog = new AlertDialog.Builder((Context)this).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)this.inAppNotification.getButtons().get(0).getText(), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Bundle data = new Bundle();
                                data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getText());
                                InAppNotificationActivity.this.didClick(data);
                                String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getActionUrl();
                                if (actionUrl != null) {
                                    InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                    return;
                                }
                                InAppNotificationActivity.this.didDismiss(data);
                            }
                        }).create();
                        if (this.inAppNotification.getButtons().size() == 2) {
                            alertDialog.setButton(-2, (CharSequence)this.inAppNotification.getButtons().get(1).getText(), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    Bundle data = new Bundle();
                                    data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                    data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getText());
                                    InAppNotificationActivity.this.didClick(data);
                                    String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getActionUrl();
                                    if (actionUrl != null) {
                                        InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                        return;
                                    }
                                    InAppNotificationActivity.this.didDismiss(data);
                                }
                            });
                        }
                    }
                    if (this.inAppNotification.getButtons().size() > 2) {
                        alertDialog.setButton(-3, (CharSequence)this.inAppNotification.getButtons().get(2).getText(), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Bundle data = new Bundle();
                                data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(2).getText());
                                InAppNotificationActivity.this.didClick(data);
                                String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(2).getActionUrl();
                                if (actionUrl != null) {
                                    InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                    return;
                                }
                                InAppNotificationActivity.this.didDismiss(data);
                            }
                        });
                    }
                }
                alertDialog.show();
                this.didShow(null);
                break;
            }
            default: {
                this.config.getLogger().verbose("InAppNotificationActivity: Unhandled InApp Type: " + (Object)((Object)type));
            }
        }
        return viewFragment;
    }

    void didClick(Bundle data) {
        InAppActivityListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidClick(this.getBaseContext(), this.inAppNotification, data);
        }
    }

    void didShow(Bundle data) {
        InAppActivityListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.getBaseContext(), this.inAppNotification, data);
        }
    }

    void didDismiss(Bundle data) {
        this.finish();
        InAppActivityListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidDismiss(this.getBaseContext(), this.inAppNotification, data);
        }
    }

    public void onBackPressed() {
        this.finish();
        this.didDismiss(null);
    }

    @Override
    public void inAppNotificationDidShow(Context context, CTInAppNotification inAppNotification, Bundle formData) {
        this.didShow(formData);
    }

    @Override
    public void inAppNotificationDidClick(Context context, CTInAppNotification inAppNotification, Bundle formData) {
        this.didClick(formData);
    }

    @Override
    public void inAppNotificationDidDismiss(Context context, CTInAppNotification inAppNotification, Bundle formData) {
        this.didDismiss(formData);
    }

    void fireUrlThroughIntent(String url, Bundle formData) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.didDismiss(formData);
    }

    static interface InAppActivityListener {
        public void inAppNotificationDidShow(Context var1, CTInAppNotification var2, Bundle var3);

        public void inAppNotificationDidClick(Context var1, CTInAppNotification var2, Bundle var3);

        public void inAppNotificationDidDismiss(Context var1, CTInAppNotification var2, Bundle var3);
    }
}

