/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.GifFrame;
import com.clevertap.android.sdk.GifHeader;
import com.clevertap.android.sdk.Logger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifHeaderParser {
    public static final String TAG = "GifHeaderParser";
    static final int MIN_FRAME_DELAY = 2;
    static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    private final byte[] block = new byte[256];
    private ByteBuffer rawData;
    private GifHeader header;
    private int blockSize = 0;

    public GifHeaderParser setData(ByteBuffer data) {
        this.reset();
        this.rawData = data.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public GifHeaderParser setData(byte[] data) {
        if (data != null) {
            this.setData(ByteBuffer.wrap(data));
        } else {
            this.rawData = null;
            this.header.status = 2;
        }
        return this;
    }

    public void clear() {
        this.rawData = null;
        this.header = null;
    }

    private void reset() {
        this.rawData = null;
        Arrays.fill(this.block, (byte)0);
        this.header = new GifHeader();
        this.blockSize = 0;
    }

    public GifHeader parseHeader() {
        if (this.rawData == null) {
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            return this.header;
        }
        this.readHeader();
        if (!this.err()) {
            this.readContents();
            if (this.header.frameCount < 0) {
                this.header.status = 1;
            }
        }
        return this.header;
    }

    public boolean isAnimated() {
        this.readHeader();
        if (!this.err()) {
            this.readContents(2);
        }
        return this.header.frameCount > 1;
    }

    private void readContents() {
        this.readContents(Integer.MAX_VALUE);
    }

    private void readContents(int maxFrames) {
        boolean done = false;
        block11: while (!done && !this.err() && this.header.frameCount <= maxFrames) {
            int code = this.read();
            switch (code) {
                case 44: {
                    if (this.header.currentFrame == null) {
                        this.header.currentFrame = new GifFrame();
                    }
                    this.readBitmap();
                    continue block11;
                }
                case 33: {
                    code = this.read();
                    switch (code) {
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            this.readGraphicControlExt();
                            continue block11;
                        }
                        case 255: {
                            this.readBlock();
                            String app = "";
                            for (int i = 0; i < 11; ++i) {
                                app = app + (char)this.block[i];
                            }
                            if (app.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block11;
                            }
                            this.skip();
                            continue block11;
                        }
                        case 254: {
                            this.skip();
                            continue block11;
                        }
                        case 1: {
                            this.skip();
                            continue block11;
                        }
                    }
                    this.skip();
                    continue block11;
                }
                case 59: {
                    done = true;
                    continue block11;
                }
            }
            this.header.status = 1;
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.header.currentFrame.dispose = (packed & 0x1C) >> 2;
        if (this.header.currentFrame.dispose == 0) {
            this.header.currentFrame.dispose = 1;
        }
        this.header.currentFrame.transparency = (packed & 1) != 0;
        int delayInHundredthsOfASecond = this.readShort();
        if (delayInHundredthsOfASecond < 2) {
            delayInHundredthsOfASecond = 10;
        }
        this.header.currentFrame.delay = delayInHundredthsOfASecond * 10;
        this.header.currentFrame.transIndex = this.read();
        this.read();
    }

    private void readBitmap() {
        this.header.currentFrame.ix = this.readShort();
        this.header.currentFrame.iy = this.readShort();
        this.header.currentFrame.iw = this.readShort();
        this.header.currentFrame.ih = this.readShort();
        int packed = this.read();
        boolean lctFlag = (packed & 0x80) != 0;
        int lctSize = (int)Math.pow(2.0, (packed & 7) + 1);
        this.header.currentFrame.interlace = (packed & 0x40) != 0;
        this.header.currentFrame.lct = (int[])(lctFlag ? this.readColorTable(lctSize) : null);
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        this.skipImageData();
        if (this.err()) {
            return;
        }
        ++this.header.frameCount;
        this.header.frames.add(this.header.currentFrame);
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.header.loopCount = b2 << 8 | b1;
            if (this.header.loopCount != 0) continue;
            this.header.loopCount = -1;
        } while (this.blockSize > 0 && !this.err());
    }

    private void readHeader() {
        String id2 = "";
        for (int i = 0; i < 6; ++i) {
            id2 = id2 + (char)this.read();
        }
        if (!id2.startsWith("GIF")) {
            this.header.status = 1;
            return;
        }
        this.readLSD();
        if (this.header.gctFlag && !this.err()) {
            this.header.gct = this.readColorTable(this.header.gctSize);
            this.header.bgColor = this.header.gct[this.header.bgIndex];
        }
    }

    private void readLSD() {
        this.header.width = this.readShort();
        this.header.height = this.readShort();
        int packed = this.read();
        this.header.gctFlag = (packed & 0x80) != 0;
        this.header.gctSize = 2 << (packed & 7);
        this.header.bgIndex = this.read();
        this.header.pixelAspect = this.read();
    }

    private int[] readColorTable(int ncolors) {
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        try {
            this.rawData.get(c);
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < ncolors) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        catch (BufferUnderflowException e) {
            Logger.d(TAG, "Format Error Reading Color Table", e);
            this.header.status = 1;
        }
        return tab;
    }

    private void skipImageData() {
        this.read();
        this.skip();
    }

    private void skip() {
        try {
            int blockSize;
            do {
                blockSize = this.read();
                this.rawData.position(this.rawData.position() + blockSize);
            } while (blockSize > 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            int count = 0;
            try {
                for (n = 0; n < this.blockSize; n += count) {
                    count = this.blockSize - n;
                    this.rawData.get(this.block, n, count);
                }
            }
            catch (Exception e) {
                this.header.status = 1;
            }
        }
        return n;
    }

    private int read() {
        int curByte = 0;
        try {
            curByte = this.rawData.get() & 0xFF;
        }
        catch (Exception e) {
            this.header.status = 1;
        }
        return curByte;
    }

    private int readShort() {
        return this.rawData.getShort();
    }

    private boolean err() {
        return this.header.status != 0;
    }
}

