/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CloseImageView;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.UriHelper;
import java.net.URLDecoder;

public final class InAppNotificationActivity
extends Activity
implements View.OnTouchListener,
View.OnLongClickListener {
    private CTInAppNotification inAppNotification;
    private InAppWebView webView;
    private CloseImageView closeImageView = null;
    private final Point dim = new Point();
    private final GestureDetector gd = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener());
    private CleverTapAPI cleverTapAPI;
    private boolean isDismissed;

    public void setTheme(int resid) {
        super.setTheme(0x1030010);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void onCreate(Bundle savedInstanceState) {
        Bundle notif;
        super.onCreate(savedInstanceState);
        try {
            notif = this.getIntent().getExtras();
            if (notif == null) {
                throw new IllegalArgumentException();
            }
            this.inAppNotification = (CTInAppNotification)notif.getParcelable("inApp");
            CleverTapInstanceConfig config = (CleverTapInstanceConfig)notif.getParcelable("config");
            if (config == null) {
                throw new IllegalArgumentException();
            }
            this.cleverTapAPI = CleverTapAPI.instanceWithConfig(this.getApplicationContext(), config);
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification bundle to show!", t);
            return;
        }
        if (!notif.getBoolean("wzrk_animated", false)) {
            notif.putBoolean("wzrk_animated", true);
            Intent i = new Intent((Context)this, InAppNotificationActivity.class);
            i.putExtras(notif);
            this.startActivity(i);
            this.overridePendingTransition(0x10A0000, 0x10A0001);
            this.finish();
            return;
        }
        RelativeLayout rl = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams webViewLp = new RelativeLayout.LayoutParams(-2, -2);
        webViewLp.addRule(13);
        this.initWebViewLayoutParams(webViewLp);
        this.webView = new InAppWebView((Context)this);
        InAppWebViewClient webViewClient = new InAppWebViewClient();
        this.webView.setWebViewClient(webViewClient);
        if (this.isDarkenEnabled()) {
            rl.setBackgroundDrawable((Drawable)new ColorDrawable(-1157627904));
        } else {
            rl.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        rl.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLp);
        if (this.isCloseButtonEnabled()) {
            this.closeImageView = new CloseImageView((Context)this);
            RelativeLayout.LayoutParams closeIvLp = new RelativeLayout.LayoutParams(-1, -1);
            closeIvLp.addRule(2, this.webView.getId());
            closeIvLp.addRule(1, this.webView.getId());
            int sub = this.getScaledPixels(40) / 2;
            closeIvLp.setMargins(-sub, 0, 0, -sub);
            this.closeImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InAppNotificationActivity.this.finish();
                    InAppNotificationActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                    InAppNotificationActivity.this.notifyDismissed(null);
                }
            });
            rl.addView((View)this.closeImageView, (ViewGroup.LayoutParams)closeIvLp);
        }
        this.setContentView((View)rl);
        rl.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    InAppNotificationActivity.this.finish();
                    InAppNotificationActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                    InAppNotificationActivity.this.cleverTapAPI.notificationDidDismiss(InAppNotificationActivity.this.getApplicationContext(), InAppNotificationActivity.this.inAppNotification, null);
                    return true;
                }
                return false;
            }
        });
        this.reDrawInApp();
        this.cleverTapAPI.pushInAppNotificationStateEvent(false, this.inAppNotification, null);
    }

    private boolean isCloseButtonEnabled() {
        return this.inAppNotification.isShowClose();
    }

    private boolean isDarkenEnabled() {
        return this.inAppNotification.isDarkenScreen();
    }

    private void notifyDismissed(Bundle formData) {
        if (this.isDismissed) {
            return;
        }
        this.isDismissed = true;
        Logger.v("InAppNotificationActivity notifying dismiss for notification: " + this.inAppNotification.getCampaignId());
        this.cleverTapAPI.notificationDidDismiss(this.getApplicationContext(), this.inAppNotification, formData);
    }

    private void fireUrlThroughIntent(String url, Bundle formData) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.finish();
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        this.notifyDismissed(formData);
    }

    private void updateDimension() {
        DisplayMetrics metrics;
        if (this.inAppNotification.getWidth() != 0) {
            this.dim.x = (int)TypedValue.applyDimension((int)1, (float)this.inAppNotification.getWidth(), (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            metrics = this.getResources().getDisplayMetrics();
            this.dim.x = (int)((float)(metrics.widthPixels * this.inAppNotification.getWidthPercentage()) / 100.0f);
        }
        if (this.inAppNotification.getHeight() != 0) {
            this.dim.y = (int)TypedValue.applyDimension((int)1, (float)this.inAppNotification.getHeight(), (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            metrics = this.getResources().getDisplayMetrics();
            this.dim.y = (int)((float)(metrics.heightPixels * this.inAppNotification.getHeightPercentage()) / 100.0f);
        }
    }

    private void initWebViewLayoutParams(RelativeLayout.LayoutParams params) {
        char pos = this.inAppNotification.getPosition();
        switch (pos) {
            case 't': {
                params.addRule(10);
                break;
            }
            case 'l': {
                params.addRule(9);
                break;
            }
            case 'b': {
                params.addRule(12);
                break;
            }
            case 'r': {
                params.addRule(11);
                break;
            }
            case 'c': {
                params.addRule(13);
            }
        }
        params.setMargins(0, 0, 0, 0);
    }

    private int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private void reDrawInApp() {
        this.updateDimension();
        int mHeight = this.dim.y;
        int mWidth = this.dim.x;
        float d = this.getResources().getDisplayMetrics().density;
        mHeight = (int)((float)mHeight / d);
        mWidth = (int)((float)mWidth / d);
        String html = this.inAppNotification.getHtml();
        String style2 = "<style>body{width:" + mWidth + "px; height: " + mHeight + "px}</style>";
        html = html.replaceFirst("<head>", "<head>" + style2);
        Logger.v("Density appears to be " + d);
        this.webView.setInitialScale((int)(d * 100.0f));
        this.webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
    }

    public boolean onLongClick(View v) {
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        return this.gd.onTouchEvent(event) || event.getAction() == 2;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.reDrawInApp();
    }

    public void onBackPressed() {
        this.finish();
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        this.notifyDismissed(null);
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final int SWIPE_MIN_DISTANCE = 120;
        private final int SWIPE_THRESHOLD_VELOCITY = 200;

        private GestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (e1.getX() - e2.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                return this.remove(e1, e2, false);
            }
            if (e2.getX() - e1.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                return this.remove(e1, e2, true);
            }
            return false;
        }

        private boolean remove(MotionEvent e1, MotionEvent e2, boolean ltr) {
            AnimationSet animSet = new AnimationSet(true);
            TranslateAnimation anim2 = ltr ? new TranslateAnimation(0.0f, (float)InAppNotificationActivity.this.getScaledPixels(50), 0.0f, 0.0f) : new TranslateAnimation(0.0f, (float)(-InAppNotificationActivity.this.getScaledPixels(50)), 0.0f, 0.0f);
            animSet.addAnimation((Animation)anim2);
            animSet.addAnimation((Animation)new AlphaAnimation(1.0f, 0.0f));
            animSet.setDuration(300L);
            animSet.setFillAfter(true);
            animSet.setFillEnabled(true);
            animSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    InAppNotificationActivity.this.finish();
                    if (InAppNotificationActivity.this.isDarkenEnabled()) {
                        InAppNotificationActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                    }
                    InAppNotificationActivity.this.notifyDismissed(null);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            InAppNotificationActivity.this.webView.startAnimation((Animation)animSet);
            if (InAppNotificationActivity.this.closeImageView != null) {
                InAppNotificationActivity.this.closeImageView.startAnimation((Animation)animSet);
            }
            return true;
        }
    }

    private class InAppWebView
    extends WebView {
        @SuppressLint(value={"ResourceType"})
        public InAppWebView(Context context) {
            super(context);
            this.setHorizontalScrollBarEnabled(false);
            this.setVerticalScrollBarEnabled(false);
            this.setHorizontalFadingEdgeEnabled(false);
            this.setVerticalFadingEdgeEnabled(false);
            this.setOverScrollMode(2);
            this.setBackgroundColor(0);
            this.setOnTouchListener(InAppNotificationActivity.this);
            this.setOnLongClickListener(InAppNotificationActivity.this);
            this.setId(188293);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            InAppNotificationActivity.this.updateDimension();
            this.setMeasuredDimension(((InAppNotificationActivity)InAppNotificationActivity.this).dim.x, ((InAppNotificationActivity)InAppNotificationActivity.this).dim.y);
        }
    }

    private class InAppWebViewClient
    extends WebViewClient {
        InAppWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            try {
                String[] parts;
                String c2a;
                Bundle formData = UriHelper.getAllKeyValuePairs(url, false);
                if (formData != null && formData.containsKey("wzrk_c2a") && (c2a = formData.getString("wzrk_c2a")) != null && (parts = c2a.split("__dl__")).length == 2) {
                    formData.putString("wzrk_c2a", URLDecoder.decode(parts[0], "UTF-8"));
                    url = parts[1];
                }
                InAppNotificationActivity.this.cleverTapAPI.pushInAppNotificationStateEvent(true, InAppNotificationActivity.this.inAppNotification, formData);
                Logger.d("Executing call to action for in-app: " + url);
                InAppNotificationActivity.this.fireUrlThroughIntent(url, formData);
            }
            catch (Throwable t) {
                Logger.v("Error parsing the in-app notification action!", t);
            }
            return true;
        }
    }
}

