/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Application;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import com.clevertap.android.sdk.ActivityLifecycleCallback;
import com.clevertap.android.sdk.BuildInfo;
import com.clevertap.android.sdk.CTNotificationIntentService;
import com.clevertap.android.sdk.CTPushNotificationReceiver;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InstallReferrerBroadcastReceiver;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushType;
import java.util.ArrayList;

final class ManifestValidator {
    private static final String ourApplicationClassName = "com.clevertap.android.sdk.Application";

    ManifestValidator() {
    }

    static void validate(Context context) {
        ManifestValidator.checkSDKVersion();
        ManifestValidator.validationApplicationLifecyleCallback(context);
        ManifestValidator.checkReceiversServices(context);
    }

    private static void checkSDKVersion() {
        Logger.i("SDK Version Code is " + BuildInfo.SDK_VERSION);
    }

    private static void checkReceiversServices(Context context) {
        try {
            ManifestValidator.validateReceiverInManifest((Application)context.getApplicationContext(), CTPushNotificationReceiver.class.getName());
            ManifestValidator.validateReceiverInManifest((Application)context.getApplicationContext(), InstallReferrerBroadcastReceiver.class.getName());
            ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), CTNotificationIntentService.class.getName());
            ManifestValidator.validateActivityInManifest((Application)context.getApplicationContext(), InAppNotificationActivity.class);
        }
        catch (Exception e) {
            Logger.v("Receiver/Service issue : " + e.toString());
        }
        ArrayList<PushType> enabledPushTypes = DeviceInfo.getEnabledPushTypes();
        if (enabledPushTypes == null) {
            return;
        }
        for (PushType pushType : enabledPushTypes) {
            switch (pushType) {
                case GCM: {
                    try {
                        ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), "com.clevertap.android.sdk.GcmMessageListenerService");
                        ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), "com.clevertap.android.sdk.GcmTokenListenerService");
                    }
                    catch (Exception e) {
                        Logger.v("Receiver/Service issue : " + e.toString());
                    }
                    catch (Error error) {
                        Logger.v("FATAL : " + error.getMessage());
                    }
                    break;
                }
                case FCM: {
                    try {
                        ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), "com.clevertap.android.sdk.FcmMessageListenerService");
                        ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), "com.clevertap.android.sdk.FcmTokenListenerService");
                    }
                    catch (Exception e) {
                        Logger.v("Receiver/Service issue : " + e.toString());
                    }
                    catch (Error error) {
                        Logger.v("FATAL : " + error.getMessage());
                    }
                    break;
                }
            }
        }
    }

    private static boolean validateReceiverInManifest(Application application, String receiverClassName) throws PackageManager.NameNotFoundException {
        ActivityInfo[] receivers;
        PackageManager pm = application.getPackageManager();
        String packageName = application.getPackageName();
        PackageInfo packageInfo = pm.getPackageInfo(packageName, 2);
        for (ActivityInfo activityInfo : receivers = packageInfo.receivers) {
            if (!activityInfo.name.equals(receiverClassName)) continue;
            Logger.i(receiverClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
            return true;
        }
        Logger.i(receiverClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
        return false;
    }

    private static boolean validateServiceInManifest(Application application, String serviceClassName) throws PackageManager.NameNotFoundException {
        ServiceInfo[] services;
        PackageManager pm = application.getPackageManager();
        String packageName = application.getPackageName();
        PackageInfo packageInfo = pm.getPackageInfo(packageName, 4);
        for (ServiceInfo serviceInfo : services = packageInfo.services) {
            if (!serviceInfo.name.equals(serviceClassName)) continue;
            Logger.i(serviceClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
            return true;
        }
        Logger.i(serviceClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
        return false;
    }

    private static boolean validateActivityInManifest(Application application, Class activityClass) throws PackageManager.NameNotFoundException {
        PackageManager pm = application.getPackageManager();
        String packageName = application.getPackageName();
        PackageInfo packageInfo = pm.getPackageInfo(packageName, 1);
        ActivityInfo[] activities = packageInfo.activities;
        String activityClassName = activityClass.getName();
        for (ActivityInfo activityInfo : activities) {
            if (!activityInfo.name.equals(activityClassName)) continue;
            Logger.i(activityClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
            return true;
        }
        Logger.i(activityClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
        return false;
    }

    private static void validationApplicationLifecyleCallback(Context context) {
        if (!ActivityLifecycleCallback.registered && !CleverTapAPI.isAppForeground()) {
            Logger.i("Activity Lifecycle Callback not registered. Either set the android:name in your AndroidManifest.xml application tag to com.clevertap.android.sdk.Application, \n or, if you have a custom Application class, call ActivityLifecycleCallback.register(this); before super.onCreate() in your class");
            ManifestValidator.checkApplicationClass(context);
        }
    }

    private static void checkApplicationClass(Context context) {
        String appName = context.getApplicationInfo().className;
        if (appName == null || appName.isEmpty()) {
            Logger.i("Unable to determine Application Class");
        } else if (appName.equals(ourApplicationClassName)) {
            Logger.i("AndroidManfiest.xml uses the CleverTap Application class, be sure you have properly added the CleverTap Account ID and Token to your AndroidManifest.xml, \nor set them programmatically in the onCreate method of your custom application class prior to calling super.onCreate()");
        } else {
            Logger.i("Application Class is " + appName);
        }
    }
}

