/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import java.text.SimpleDateFormat;
import java.util.*;


/**
 * Contains various constant values used internally by the CleverTap SDK.
 */
final class Constants {
    static final boolean ENABLE_INAPP = true;
    static final String LABEL_ACCOUNT_ID = "CLEVERTAP_ACCOUNT_ID";
    static final String LABEL_TOKEN = "CLEVERTAP_TOKEN";
    static final String LABEL_PARSE = "CLEVERTAP_PARSE";
    static final String LABEL_NOTIFICATION_ICON = "CLEVERTAP_NOTIFICATION_ICON";
    static final String LABEL_INAPP_EXCLUDE = "CLEVERTAP_INAPP_EXCLUDE";
    static final String LABEL_REGION = "CLEVERTAP_REGION";
    static final String LABEL_DISABLE_APP_LAUNCH = "CLEVERTAP_DISABLE_APP_LAUNCHED";
    static final String CLEVERTAP_OPTOUT = "ct_optout";
    static final String CLEVERTAP_USE_GOOGLE_AD_ID = "CLEVERTAP_USE_GOOGLE_AD_ID";

    static final String CLEVERTAP_STORAGE_TAG = "WizRocket";
    static final String CLEVERTAP_LOG_TAG = "CleverTap";
    static final int SESSION_LENGTH_MINS = 20;
    static final String DEVICE_ID_TAG = "deviceId";
    static final SimpleDateFormat FB_DOB_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    static final SimpleDateFormat GP_DOB_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    static final int PAGE_EVENT = 1;
    static final int PING_EVENT = 2;
    static final int PROFILE_EVENT = 3;
    static final int RAISED_EVENT = 4;
    static final int DATA_EVENT = 5;
    static final int META_EVENT = 6;
    static final String ICON_BASE_URL = "http://static.wizrocket.com/android/ico/";
    static final String NOTIFICATION_CLICKED_EVENT_NAME = "Notification Clicked";
    static final String NOTIFICATION_VIEWED_EVENT_NAME = "Notification Viewed";
    static final String APP_LAUNCHED_EVENT = "App Launched";
    static final String ERROR_KEY = "wzrk_error";
    static final int PUSH_DELAY_MS = 1000;
    static final int PING_TICK_INTERVAL = 1000;
    static final String INAPP_PREVIEW_PUSH_PAYLOAD_KEY = "wzrk_inapp";
    static final String INAPP_DATA_TAG = "html";
    static final String INAPP_X_PERCENT = "xp";
    static final String INAPP_Y_PERCENT = "yp";
    static final String INAPP_X_DP = "xdp";
    static final String INAPP_Y_DP = "ydp";
    static final String INAPP_POSITION = "pos";
    static final char INAPP_POSITION_TOP = 't';
    static final char INAPP_POSITION_RIGHT = 'r';
    static final char INAPP_POSITION_BOTTOM = 'b';
    static final char INAPP_POSITION_LEFT = 'l';
    static final char INAPP_POSITION_CENTER = 'c';
    static final String INAPP_NOTIF_DARKEN_SCREEN = "dk";
    static final String INAPP_NOTIF_SHOW_CLOSE = "sc";
    static final String INAPP_JSON_RESPONSE_KEY = "inapp_notifs";
    static final String INAPP_MAX_DISPLAY_COUNT = "mdc";
    static final String INAPP_MAX_PER_SESSION = "imc";
    static final String INAPP_WINDOW = "w";
    static final String PREFS_INAPP_KEY = "inApp";
    static final int INAPP_CLOSE_IV_WIDTH = 40;
    static final String DEBUG_KEY = "d";
    static final String NOTIFICATION_ID_TAG = "wzrk_id";
    static final String DEEP_LINK_KEY = "wzrk_dl";
    static final String WZRK_PREFIX = "wzrk_";
    static final int DEBUG_FINEST = 1277182231;
    static final int PING_INTERVAL_IN_SECONDS = 50;
    static final int LOCATION_PING_INTERVAL_IN_SECONDS = 10;
    static final int NOTIFICATION_ID_TAG_INTERVAL = 5000;
    static final int NOTIFICATION_VIEWED_ID_TAG_INTERVAL = 2000;
    static final String ADVERTISER_ID = "adid";
    static final String SESSION_ID_LAST = "lastSessionId";
    static final String SESSION_LAST_PING_EPOCH = "sexe";
    static final String SESSION_LAST_ACTIVITY_TRAIL = "slat";
    static final String LABEL_SENDER_ID = "GCM_SENDER_ID";
    static final int MAX_KEY_LENGTH = 120;
    static final int MAX_VALUE_LENGTH = 1024;
    static final int MAX_MULTI_VALUE_ARRAY_LENGTH = 100;
    static final int MAX_MULTI_VALUE_LENGTH = 1024;
    static final String WZRK_FROM_KEY = "wzrk_from";
    static final String WZRK_FROM = "CTPushNotificationReceiver";
    static final String NETWORK_INFO = "NetworkInfo";

    /**
     * Profile command constants.
     */
    static final String COMMAND_SET = "$set";
    static final String COMMAND_ADD = "$add";
    static final String COMMAND_REMOVE = "$remove";

    static final String COMMAND_DELETE = "$delete";
    static final String GUID_PREFIX_GOOGLE_AD_ID = "__g";

    // valid profile identifier keys
    static final Set<String> PROFILE_IDENTIFIER_KEYS = new HashSet<String>(Arrays.asList(
            new String[]{"Identity", "Email", "FBID", "GPID"}
    ));
}