/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.google.android.gms.plus.model.people.Person;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ProfileHandler {
    private final Context context;

    private static void queueEvent(Context context, JSONObject event, int eventType) {
        QueueManager.queueEvent(context, event, eventType);
    }

    private static void postAsyncSafely(String name, Runnable runnable) {
        CleverTapAPI.postAsyncSafely(name, runnable);
    }

    ProfileHandler(Context context) {
        this.context = context;
    }

    public void setMultiValuesForKey(final String key, final ArrayList<String> values) {
        ProfileHandler.postAsyncSafely("setMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                ProfileHandler.this._handleMultiValues(values, key, "$set");
            }
        });
    }

    public void addMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        this.addMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void addMultiValuesForKey(final String key, final ArrayList<String> values) {
        ProfileHandler.postAsyncSafely("addMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                String command = LocalDataStore.getProfileValueForKey(key) != null ? "$add" : "$set";
                ProfileHandler.this._handleMultiValues(values, key, command);
            }
        });
    }

    public void removeMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        this.removeMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void removeMultiValuesForKey(final String key, final ArrayList<String> values) {
        ProfileHandler.postAsyncSafely("removeMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                ProfileHandler.this._handleMultiValues(values, key, "$remove");
            }
        });
    }

    public void removeValueForKey(final String key) {
        ProfileHandler.postAsyncSafely("removeValueForKey", new Runnable(){

            @Override
            public void run() {
                ProfileHandler.this._removeValueForKey(key);
            }
        });
    }

    private void _removeValueForKey(String key) {
        try {
            key = key == null ? "" : key;
            ValidationResult vr = Validator.cleanObjectKey(key);
            key = vr.getObject().toString();
            if (key.isEmpty()) {
                ValidationResult error = new ValidationResult();
                error.setErrorCode(512);
                error.setErrorDesc("Key is empty, profile removeValueForKey aborted.");
                this.pushValidationResult(error);
                Logger.d("Key is empty, profile removeValueForKey aborted");
                return;
            }
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            LocalDataStore.removeProfileField(this.context, key);
            JSONObject command = new JSONObject().put("$delete", true);
            JSONObject update = new JSONObject().put(key, (Object)command);
            this.pushBasicProfile(update);
            Logger.v("removing value for key " + key + " from user profile");
        }
        catch (Throwable t) {
            Logger.v("Failed to remove profile value for key " + key, t);
        }
    }

    public void push(final Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        ProfileHandler.postAsyncSafely("profilePush", new Runnable(){

            @Override
            public void run() {
                ProfileHandler.this._push(profile);
            }
        });
    }

    private void _push(Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        try {
            JSONObject customProfile = new JSONObject();
            JSONObject fieldsToUpdateLocally = new JSONObject();
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                ValidationResult vr = Validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                if (key == null || key.isEmpty()) {
                    ValidationResult keyError = new ValidationResult();
                    keyError.setErrorCode(512);
                    String keyErr = "Profile push key is empty";
                    keyError.setErrorDesc("Profile push key is empty");
                    this.pushValidationResult(keyError);
                    Logger.d("Profile push key is empty");
                    continue;
                }
                try {
                    vr = Validator.cleanObjectValue(value, Validator.ValidationContext.Profile);
                }
                catch (Throwable e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(512);
                    String err = "Object value wasn't a primitive (" + value + ") for profile field " + key;
                    error.setErrorDesc(err);
                    this.pushValidationResult(error);
                    Logger.d(err);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                if (key.equalsIgnoreCase("Phone")) {
                    try {
                        String _value;
                        value = value.toString();
                        String countryCode = DeviceInfo.getCountryCode();
                        if ((countryCode == null || countryCode.isEmpty()) && !(_value = (String)value).startsWith("+")) {
                            ValidationResult error = new ValidationResult();
                            error.setErrorCode(512);
                            String err = "Device country code not available and profile phone: " + value + " does not appear to start with country code";
                            error.setErrorDesc(err);
                            this.pushValidationResult(error);
                            Logger.d(err);
                        }
                        Logger.v("Profile phone is: " + value + " device country code is: " + (countryCode != null ? countryCode : "null"));
                    }
                    catch (Exception e) {
                        this.pushValidationResult(new ValidationResult(512, "Invalid phone number"));
                        Logger.d("Invalid phone number: " + e.getLocalizedMessage());
                        continue;
                    }
                }
                fieldsToUpdateLocally.put(key, value);
                customProfile.put(key, value);
            }
            Logger.v("Constructed custom profile: " + customProfile.toString());
            if (fieldsToUpdateLocally.length() > 0) {
                LocalDataStore.setProfileFields(this.context, fieldsToUpdateLocally);
            }
            this.pushBasicProfile(customProfile);
        }
        catch (Throwable t) {
            Logger.v("Failed to push profile", t);
        }
    }

    private String getGraphUserPropertySafely(JSONObject graphUser, String key, String def) {
        try {
            String prop = (String)graphUser.get(key);
            if (prop != null) {
                return prop;
            }
            return def;
        }
        catch (Throwable t) {
            return def;
        }
    }

    public void pushFacebookUser(final JSONObject graphUser) {
        ProfileHandler.postAsyncSafely("pushFacebookUser", new Runnable(){

            @Override
            public void run() {
                ProfileHandler.this._pushFacebookUser(graphUser);
            }
        });
    }

    private void _pushFacebookUser(JSONObject graphUser) {
        try {
            String education;
            String work;
            if (graphUser == null) {
                return;
            }
            String name = this.getGraphUserPropertySafely(graphUser, "name", "");
            try {
                ValidationResult vr = Validator.cleanObjectValue(name, Validator.ValidationContext.Profile);
                name = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
            }
            catch (IllegalArgumentException e) {
                name = "";
            }
            String gender = this.getGraphUserPropertySafely(graphUser, "gender", null);
            gender = gender != null ? (gender.toLowerCase().startsWith("m") ? "M" : (gender.toLowerCase().startsWith("f") ? "F" : "")) : null;
            String email = this.getGraphUserPropertySafely(graphUser, "email", "");
            String birthday = this.getGraphUserPropertySafely(graphUser, "birthday", null);
            if (birthday != null) {
                if (birthday.matches("^../..")) {
                    birthday = "";
                } else {
                    try {
                        Date date = Constants.FB_DOB_DATE_FORMAT.parse(birthday);
                        birthday = "$D_" + (int)(date.getTime() / 1000L);
                    }
                    catch (ParseException e) {
                        birthday = "";
                    }
                }
            }
            try {
                JSONArray workArray = graphUser.getJSONArray("work");
                work = workArray.length() > 0 ? "Y" : "N";
            }
            catch (Throwable t) {
                work = null;
            }
            try {
                JSONArray eduArray = graphUser.getJSONArray("education");
                String fbEdu = eduArray.getJSONObject(eduArray.length() - 1).getString("type");
                education = fbEdu.toLowerCase().contains("high school") ? "School" : (fbEdu.toLowerCase().contains("college") ? "College" : (fbEdu.toLowerCase().contains("graduate school") ? "Graduate" : ""));
            }
            catch (Throwable t) {
                education = null;
            }
            String id = this.getGraphUserPropertySafely(graphUser, "id", "");
            String married = this.getGraphUserPropertySafely(graphUser, "relationship_status", null);
            if (married != null) {
                married = married.equalsIgnoreCase("married") ? "Y" : "N";
            }
            JSONObject profile = new JSONObject();
            if (id != null && id.length() > 3) {
                profile.put("FBID", (Object)id);
            }
            if (name != null && name.length() > 3) {
                profile.put("Name", (Object)name);
            }
            if (email != null && email.length() > 3) {
                profile.put("Email", (Object)email);
            }
            if (gender != null && !gender.trim().equals("")) {
                profile.put("Gender", (Object)gender);
            }
            if (education != null && !education.trim().equals("")) {
                profile.put("Education", (Object)education);
            }
            if (work != null && !work.trim().equals("")) {
                profile.put("Employed", (Object)work);
            }
            if (birthday != null && birthday.length() > 3) {
                profile.put("DOB", (Object)birthday);
            }
            if (married != null && !married.trim().equals("")) {
                profile.put("Married", (Object)married);
            }
            this.pushBasicProfile(profile);
        }
        catch (Throwable t) {
            Logger.v("Failed to parse graph user object successfully", t);
        }
    }

    void pushBasicProfile(JSONObject baseProfile) {
        try {
            CleverTapAPI api = CleverTapAPI.getInstance(this.context);
            String guid = api.getCleverTapID();
            JSONObject profileEvent = new JSONObject();
            if (baseProfile != null && baseProfile.length() > 0) {
                Iterator i = baseProfile.keys();
                while (i.hasNext()) {
                    String next = i.next().toString();
                    Object value = null;
                    try {
                        value = baseProfile.getJSONObject(next);
                    }
                    catch (Throwable t) {
                        try {
                            value = baseProfile.get(next);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (value == null) continue;
                    profileEvent.put(next, value);
                    if (!Constants.PROFILE_IDENTIFIER_KEYS.contains(next)) continue;
                    try {
                        api.cacheGUIDForIdentifier(guid, next, value.toString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                String cc;
                String carrier = DeviceInfo.getCarrier();
                if (carrier != null && !carrier.equals("")) {
                    profileEvent.put("Carrier", (Object)carrier);
                }
                if ((cc = DeviceInfo.getCountryCode()) != null && !cc.equals("")) {
                    profileEvent.put("cc", (Object)cc);
                }
                profileEvent.put("tz", (Object)TimeZone.getDefault().getID());
                JSONObject event = new JSONObject();
                event.put("profile", (Object)profileEvent);
                ProfileHandler.queueEvent(this.context, event, 3);
            }
            catch (JSONException e) {
                Logger.v("FATAL: Creating basic profile update event failed!");
            }
        }
        catch (Throwable t) {
            Logger.v("Basic profile sync", t);
        }
    }

    @Deprecated
    public void pushEnum(String key, String value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(key, value);
        this.push(m);
    }

    public void pushGooglePlusPerson(final Person person) {
        ProfileHandler.postAsyncSafely("pushGooglePlusPerson", new Runnable(){

            @Override
            public void run() {
                ProfileHandler.this._pushGooglePlusPerson(person);
            }
        });
    }

    private void _pushGooglePlusPerson(Person person) {
        if (person == null) {
            return;
        }
        try {
            String name = "";
            if (person.hasDisplayName()) {
                try {
                    name = person.getDisplayName();
                    ValidationResult vr = Validator.cleanObjectValue(name, Validator.ValidationContext.Profile);
                    name = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        this.pushValidationResult(vr);
                    }
                }
                catch (Throwable t) {
                    name = "";
                }
            }
            String gender = null;
            if (person.hasGender()) {
                if (person.getGender() == 0) {
                    gender = "M";
                } else if (person.getGender() == 1) {
                    gender = "F";
                }
            }
            String birthday = null;
            if (person.hasBirthday()) {
                try {
                    Date date = Constants.GP_DOB_DATE_FORMAT.parse(person.getBirthday());
                    birthday = "$D_" + (int)(date.getTime() / 1000L);
                }
                finally {
                    String work = null;
                }
            }
        }
        catch (Throwable t) {
            Logger.v("FATAL: Creating G+ profile update event failed!");
        }
    }

    public Object getProperty(String name) {
        if (!LocalDataStore.isPersonalisationEnabled(this.context)) {
            return null;
        }
        return LocalDataStore.getProfileProperty(this.context, name);
    }

    private Object _getProfilePropertyIgnorePersonalizationFlag(String key) {
        return LocalDataStore.getProfileValueForKey(key);
    }

    private void _handleMultiValues(ArrayList<String> values, String key, String command) {
        Object _key;
        String cleanKey;
        if (key == null) {
            return;
        }
        if (values == null || values.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        ValidationResult vr = Validator.cleanMultiValuePropertyKey(key);
        if (vr.getErrorCode() != 0) {
            this.pushValidationResult(vr);
        }
        String string = cleanKey = (_key = vr.getObject()) != null ? vr.getObject().toString() : null;
        if (cleanKey == null || cleanKey.isEmpty()) {
            this._generateInvalidMultiValueKeyError(key);
            return;
        }
        key = cleanKey;
        try {
            JSONArray currentValues = this._constructExistingMultiValue(key, command);
            JSONArray newValues = this._cleanMultiValues(values, key);
            this._validateAndPushMultiValue(currentValues, newValues, values, key, command);
        }
        catch (Throwable t) {
            Logger.v("Error handling multi value operation for key " + key, t);
        }
    }

    private JSONArray _constructExistingMultiValue(String key, String command) {
        Boolean remove = command.equals("$remove");
        Boolean add = command.equals("$add");
        if (!remove.booleanValue() && !add.booleanValue()) {
            return new JSONArray();
        }
        Object existing = this._getProfilePropertyIgnorePersonalizationFlag(key);
        if (existing == null) {
            if (remove.booleanValue()) {
                return null;
            }
            return new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray _default = add != false ? new JSONArray() : null;
        String stringified = this._stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : _default;
    }

    private String _stringifyScalarProfilePropValue(Object value) {
        String val = null;
        try {
            val = value.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private String _stringifyAndCleanScalarProfilePropValue(Object value) {
        String val = this._stringifyScalarProfilePropValue(value);
        if (val != null) {
            Object _value;
            ValidationResult vr = Validator.cleanMultiValuePropertyValue(val);
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            val = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return val;
    }

    private JSONArray _cleanMultiValues(ArrayList<String> values, String key) {
        try {
            if (values == null || key == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            for (String value : values) {
                Object _value;
                value = value == null ? "" : value;
                ValidationResult vr = Validator.cleanMultiValuePropertyValue(value);
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                String string = value = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
                if (value == null || value.isEmpty()) {
                    this._generateEmptyMultiValueError(key);
                    return null;
                }
                cleanedValues.put((Object)value);
            }
            return cleanedValues;
        }
        catch (Throwable t) {
            Logger.v("Error cleaning multi values for key " + key, t);
            this._generateEmptyMultiValueError(key);
            return null;
        }
    }

    private void _validateAndPushMultiValue(JSONArray currentValues, JSONArray newValues, ArrayList<String> originalValues, String key, String command) {
        try {
            JSONArray localValues;
            if (currentValues == null || newValues == null || originalValues == null || key == null || command == null) {
                return;
            }
            String mergeOperation = command.equals("$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
            ValidationResult vr = Validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            if ((localValues = (JSONArray)vr.getObject()) == null || localValues.length() <= 0) {
                LocalDataStore.removeProfileField(this.context, key);
            } else {
                LocalDataStore.setProfileField(this.context, key, localValues);
            }
            JSONObject commandObj = new JSONObject();
            commandObj.put(command, (Object)new JSONArray(originalValues));
            JSONObject fields = new JSONObject();
            fields.put(key, (Object)commandObj);
            this.pushBasicProfile(fields);
            Logger.v("Constructed multi-value profile push: " + fields.toString());
        }
        catch (Throwable t) {
            Logger.v("Error pushing multiValue for key " + key, t);
        }
    }

    private void _generateEmptyMultiValueError(String key) {
        ValidationResult error = new ValidationResult();
        String msg = "Invalid multi value for key " + key + ", profile multi value operation aborted.";
        error.setErrorCode(512);
        error.setErrorDesc(msg);
        this.pushValidationResult(error);
        Logger.d(msg);
    }

    private void _generateInvalidMultiValueKeyError(String key) {
        ValidationResult error = new ValidationResult();
        error.setErrorCode(523);
        error.setErrorDesc("Invalid multi-value property key " + key);
        this.pushValidationResult(error);
        Logger.d("Invalid multi-value property key " + key + " profile multi value operation aborted");
    }

    private void pushValidationResult(ValidationResult vr) {
        CleverTapAPI.pushValidationResult(vr);
    }
}

