package com.clevertap.android.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;

import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;

/**
 * Created by darshanpania on 17/07/17.
 */

public class CTPushNotificationReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {

        try {
            Intent launchIntent;
            CleverTapAPI cleverTapAPI = CleverTapAPI.getInstance(context);

            Bundle extras = intent.getExtras();

            if(extras != null && extras.containsKey(Constants.DEEP_LINK_KEY)){
                launchIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(intent.getStringExtra(Constants.DEEP_LINK_KEY)));
            }else{
                launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }

            launchIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);

            launchIntent.putExtras(extras);

            context.startActivity(launchIntent);

            cleverTapAPI.event.pushNotificationEvent(extras);
            Logger.d("CTPushNotificationReceiver: handled notification: " + ((extras != null) ? extras.toString() : "NULL"));
        } catch (CleverTapMetaDataNotFoundException ignore) {
            // Ignore
        } catch (CleverTapPermissionsNotSatisfied ignore) {
            // Ignore
        } catch (Throwable t) {
            Logger.v("CTPushNotificationReceiver: error handling notification", t);
        }
    }
}
