/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;

public class CTPushNotificationReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        try {
            CleverTapAPI cleverTapAPI = CleverTapAPI.getInstance(context);
            Bundle extras = intent.getExtras();
            if (extras != null && extras.containsKey("wzrk_dl")) {
                Intent launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)intent.getStringExtra("wzrk_dl")));
                context.startActivity(launchIntent);
            } else {
                Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                context.startActivity(launchIntent);
            }
            cleverTapAPI.event.pushNotificationEvent(extras);
            Logger.d("CTPushNotificationReceiver: handled notification: " + (extras != null ? extras.toString() : "NULL"));
        }
        catch (CleverTapMetaDataNotFoundException launchIntent) {
        }
        catch (CleverTapPermissionsNotSatisfied launchIntent) {
        }
        catch (Throwable t) {
            Logger.v("CTPushNotificationReceiver: error handling notification", t);
        }
    }
}

