/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.UTMDetail;

public final class SessionHandler {
    private final Context context;
    private int lastVisitTime;
    private static String source = null;
    private static String medium = null;
    private static String campaign = null;

    static void setSource(String source) {
        SessionHandler.source = source;
    }

    static void setMedium(String medium) {
        SessionHandler.medium = medium;
    }

    static void setCampaign(String campaign) {
        SessionHandler.campaign = campaign;
    }

    SessionHandler(final Context context) {
        this.context = context;
        CleverTapAPI.postAsyncSafely("SessionHandler#setLastVisitTime", new Runnable(){

            @Override
            public void run() {
                SessionHandler.this.setLastVisitTime(context);
            }
        });
    }

    private void setLastVisitTime(Context context) {
        EventDetail ed = LocalDataStore.getEventDetail(context, "App Launched");
        this.lastVisitTime = ed == null ? -1 : ed.getLastTime();
    }

    public int getTotalVisits() {
        EventDetail ed = LocalDataStore.getEventDetail(this.context, "App Launched");
        if (ed != null) {
            return ed.getCount();
        }
        return 0;
    }

    public int getScreenCount() {
        return CleverTapAPI.activityCount;
    }

    public int getTimeElapsed() {
        int currentSession = SessionManager.getCurrentSession();
        if (currentSession == 0) {
            return -1;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - currentSession;
    }

    public int getPreviousVisitTime() {
        return this.lastVisitTime;
    }

    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(source);
        ud.setMedium(medium);
        ud.setCampaign(campaign);
        return ud;
    }
}

