package com.clevertap.android.sdk;

enum PushType {
    FCM("fcm"),
    GCM("gcm"),
    NONE("none");

    private final String type;

    PushType(String type) {
        this.type = type;
    }

    static PushType fromString(String type) {
        if ("fcm".equals(type)) {
            return PushType.FCM;
        } else if ("gcm".equals(type)) {
            return PushType.GCM;
        } else if ("none".equals(type)) {
            return PushType.NONE;
        } else {
            return null;
        }
    }

    @Override
    public String toString() {
        return type;
    }
}
