/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Bundle;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.Validator;
import java.net.URLDecoder;
import java.util.Set;
import org.json.JSONObject;

final class UriHelper {
    UriHelper() {
    }

    static JSONObject getUrchinFromUri(Uri uri) {
        JSONObject referrer = new JSONObject();
        try {
            UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
            sanitizer.setAllowUnregisteredParamaters(true);
            sanitizer.parseUrl(uri.toString());
            String source = UriHelper.getUtmOrWzrkValue("source", sanitizer);
            String medium = UriHelper.getUtmOrWzrkValue("medium", sanitizer);
            String campaign = UriHelper.getUtmOrWzrkValue("campaign", sanitizer);
            SessionHandler.setSource(source);
            SessionHandler.setMedium(medium);
            SessionHandler.setCampaign(campaign);
            referrer.put("us", (Object)source);
            referrer.put("um", (Object)medium);
            referrer.put("uc", (Object)campaign);
            String wm = UriHelper.getWzrkValueForKey("medium", sanitizer);
            if (wm != null && wm.matches("^email$|^social$|^search$")) {
                referrer.put("wm", (Object)wm);
            }
            Logger.logFine("Referrer data: " + referrer.toString(4));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return referrer;
    }

    private static String getUtmOrWzrkValue(String utmKey, UrlQuerySanitizer sanitizer) {
        String value = UriHelper.getUtmValueForKey(utmKey, sanitizer);
        if (value != null || (value = UriHelper.getWzrkValueForKey(utmKey, sanitizer)) != null) {
            return value;
        }
        return null;
    }

    private static String getWzrkValueForKey(String key, UrlQuerySanitizer sanitizer) {
        key = "wzrk_" + key;
        return UriHelper.getValueForKey(key, sanitizer, true);
    }

    private static String getUtmValueForKey(String key, UrlQuerySanitizer sanitizer) {
        key = "utm_" + key;
        return UriHelper.getValueForKey(key, sanitizer, true);
    }

    private static String getValueForKey(String key, UrlQuerySanitizer sanitizer, boolean truncate) {
        if (key == null || sanitizer == null) {
            return null;
        }
        try {
            String value = sanitizer.getValue(key);
            if (value == null) {
                return null;
            }
            if (truncate && value.getBytes("UTF-8").length > 120) {
                return Validator.fastTrim(value, 120);
            }
            return value;
        }
        catch (Throwable t) {
            Logger.logFine("Couldn't parse the URI", t);
            return null;
        }
    }

    static Bundle getAllKeyValuePairs(String url, boolean encodeValues) {
        if (url == null) {
            return new Bundle();
        }
        Bundle customPairs = new Bundle();
        try {
            UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
            sanitizer.setAllowUnregisteredParamaters(true);
            sanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
            sanitizer.parseUrl(url);
            Set queryParams = sanitizer.getParameterSet();
            for (String key : queryParams) {
                String value = UriHelper.getValueForKey(key, sanitizer, false);
                if (value == null) continue;
                if (encodeValues || key.equals("wzrk_c2a")) {
                    customPairs.putString(key, value);
                    continue;
                }
                customPairs.putString(key, URLDecoder.decode(value, "UTF-8"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return customPairs;
    }
}

