/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

final class ParseUtils {
    ParseUtils() {
    }

    public static String getParseInstallationId(Context context) {
        String installationId = null;
        try {
            File e = new File(context.getDir("Parse", 0), "installationId");
            installationId = ParseUtils.readFileToString(e, "UTF-8");
        }
        catch (FileNotFoundException var3) {
            Logger.logFine("Couldn't find existing installationId file.");
        }
        catch (IOException var4) {
            Logger.logFine("Unexpected exception reading installation id from disk", var4);
        }
        return installationId;
    }

    private static String readFileToString(File file, Charset encoding) throws IOException {
        return new String(ParseUtils.readFileToByteArray(file), encoding);
    }

    private static String readFileToString(File file, String encoding) throws IOException {
        return ParseUtils.readFileToString(file, Charset.forName(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFileToByteArray(File file) throws IOException {
        byte[] var2;
        FileInputStream in = null;
        try {
            in = ParseUtils.openInputStream(file);
            var2 = ParseUtils.toByteArray(in);
        }
        finally {
            ParseUtils.closeQuietly(in);
        }
        return var2;
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ParseUtils.copy(input, output);
        return output.toByteArray();
    }

    private static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
            return new FileInputStream(file);
        }
        throw new FileNotFoundException("File '" + file + "' does not exist");
    }

    private static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = ParseUtils.copyLarge(input, output, new byte[4096]);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n1;
        long count = 0L;
        while (-1 != (n1 = input.read(buffer))) {
            output.write(buffer, 0, n1);
            count += (long)n1;
        }
        return count;
    }
}

