/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CloseImageView;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.UriHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import java.net.URLDecoder;
import java.util.HashMap;

public final class InAppNotificationActivity
extends Activity
implements View.OnTouchListener,
View.OnLongClickListener {
    private Bundle notif;
    private Bundle windowGuide;
    private Bundle dataGuide;
    private InAppWebView webView;
    private CloseImageView closeImageView = null;
    private final GestureDetector gd = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener());
    private CleverTapAPI wr;
    private final Point dim = new Point();

    public void setTheme(int resid) {
        super.setTheme(0x1030010);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.wr = CleverTapAPI.getInstance(this.getApplicationContext());
        }
        catch (CleverTapMetaDataNotFoundException e) {
        }
        catch (CleverTapPermissionsNotSatisfied e) {
            // empty catch block
        }
        try {
            this.notif = this.getIntent().getExtras();
            this.windowGuide = this.notif.getBundle("w");
            this.dataGuide = this.notif.getBundle("d");
            if (this.notif == null) {
                throw new IllegalArgumentException();
            }
        }
        catch (Throwable t) {
            Logger.error("Cannot find a valid notification bundle to show!", t);
            return;
        }
        if (!this.notif.getBoolean("wzrk_animated", false)) {
            this.notif.putBoolean("wzrk_animated", true);
            Intent i = new Intent((Context)this, InAppNotificationActivity.class);
            i.putExtras(this.notif);
            this.startActivity(i);
            this.overridePendingTransition(0x10A0000, 0x10A0001);
            this.finish();
            return;
        }
        RelativeLayout rl = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams webViewLp = new RelativeLayout.LayoutParams(-2, -2);
        webViewLp.addRule(13);
        this.initWebViewLayoutParams(webViewLp);
        this.webView = new InAppWebView((Context)this);
        InAppWebViewClient webViewClient = new InAppWebViewClient();
        this.webView.setWebViewClient(webViewClient);
        if (this.isDarkenEnabled()) {
            rl.setBackgroundDrawable((Drawable)new ColorDrawable(-1157627904));
        } else {
            rl.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        rl.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLp);
        if (this.isCloseButtonEnabled()) {
            this.closeImageView = new CloseImageView((Context)this);
            RelativeLayout.LayoutParams closeIvLp = new RelativeLayout.LayoutParams(-1, -1);
            closeIvLp.addRule(2, this.webView.getId());
            closeIvLp.addRule(1, this.webView.getId());
            int sub = this.getScaledPixels(40) / 2;
            closeIvLp.setMargins(-sub, 0, 0, -sub);
            this.closeImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InAppFCManager.didDismiss(InAppNotificationActivity.this.getApplicationContext(), InAppNotificationActivity.this.notif);
                    InAppNotificationActivity.this.finish();
                    InAppNotificationActivity.this.updateListener(null, "close image view's on touch listener");
                    InAppNotificationActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                    CleverTapAPI.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            InAppManager.showNotificationIfAvailable(InAppNotificationActivity.this.getApplicationContext());
                        }
                    }, 1000L);
                }
            });
            rl.addView((View)this.closeImageView, (ViewGroup.LayoutParams)closeIvLp);
        }
        this.setContentView((View)rl);
        rl.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                InAppNotificationActivity.this.finish();
                InAppNotificationActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                return true;
            }
        });
        this.reDrawInApp();
        this.wr.event.pushInAppNotificationStateEvent(false, this.notif, null);
    }

    private void updateDimension() {
        DisplayMetrics metrics;
        if (this.windowGuide.containsKey("xdp")) {
            this.dim.x = (int)TypedValue.applyDimension((int)1, (float)this.windowGuide.getInt("xdp"), (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            metrics = this.getResources().getDisplayMetrics();
            this.dim.x = (int)((float)(metrics.widthPixels * this.windowGuide.getInt("xp")) / 100.0f);
        }
        if (this.windowGuide.containsKey("ydp")) {
            this.dim.y = (int)TypedValue.applyDimension((int)1, (float)this.windowGuide.getInt("ydp"), (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            metrics = this.getResources().getDisplayMetrics();
            this.dim.y = (int)((float)(metrics.heightPixels * this.windowGuide.getInt("yp")) / 100.0f);
        }
    }

    private boolean isDarkenEnabled() {
        return this.windowGuide.getBoolean("dk", true);
    }

    private void initWebViewLayoutParams(RelativeLayout.LayoutParams params) {
        char pos = this.windowGuide.getString("pos").charAt(0);
        switch (pos) {
            case 't': {
                params.addRule(10);
                break;
            }
            case 'l': {
                params.addRule(9);
                break;
            }
            case 'b': {
                params.addRule(12);
                break;
            }
            case 'r': {
                params.addRule(11);
                break;
            }
            case 'c': {
                params.addRule(13);
            }
        }
        params.setMargins(0, 0, 0, 0);
    }

    private boolean isCloseButtonEnabled() {
        return this.windowGuide.getBoolean("sc", true);
    }

    public boolean onTouch(View view, MotionEvent event) {
        return this.gd.onTouchEvent(event) || event.getAction() == 2;
    }

    public boolean onLongClick(View view) {
        return true;
    }

    private void fireUrlThroughIntent(String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.finish();
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(new Runnable(){

            @Override
            public void run() {
                InAppManager.showNotificationIfAvailable(InAppNotificationActivity.this.getApplicationContext());
            }
        }, 1000L);
    }

    public void onBackPressed() {
        this.finish();
        this.updateListener(null, "onBackPressed");
        this.overridePendingTransition(0x10A0000, 0x10A0001);
    }

    private void updateListener(Bundle formData, String source) {
        if (this.dataGuide == null) {
            return;
        }
        try {
            InAppNotificationListener listener = CleverTapAPI.getInstance(this.getApplicationContext()).getInAppNotificationListener();
            if (listener != null) {
                HashMap<String, Object> notifKVS = this.dataGuide.containsKey("kv") ? Utils.convertBundleObjectToHashMap(this.dataGuide.getBundle("kv")) : new HashMap();
                Logger.logExtraFine("Calling the in-app listener on behalf of " + source);
                if (formData != null) {
                    listener.onDismissed(notifKVS, Utils.convertBundleObjectToHashMap(formData));
                } else {
                    listener.onDismissed(notifKVS, null);
                }
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to call the in-app notification listener", t);
        }
    }

    private int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.reDrawInApp();
    }

    private void reDrawInApp() {
        this.updateDimension();
        int mHeight = this.dim.y;
        int mWidth = this.dim.x;
        float d = this.getResources().getDisplayMetrics().density;
        mHeight = (int)((float)mHeight / d);
        mWidth = (int)((float)mWidth / d);
        String html = this.dataGuide.getString("html");
        String style = "<style>body{width:" + mWidth + "px; height: " + mHeight + "px}</style>";
        html = html.replaceFirst("<head>", "<head>" + style);
        Logger.logFine("Density appears to be " + d);
        this.webView.setInitialScale((int)(d * 100.0f));
        this.webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final int SWIPE_MIN_DISTANCE = 120;
        private final int SWIPE_THRESHOLD_VELOCITY = 200;

        private GestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (e1.getX() - e2.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                return this.remove(e1, e2, false);
            }
            if (e2.getX() - e1.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                return this.remove(e1, e2, true);
            }
            return false;
        }

        private boolean remove(MotionEvent e1, MotionEvent e2, boolean ltr) {
            AnimationSet animSet = new AnimationSet(true);
            TranslateAnimation anim = ltr ? new TranslateAnimation(0.0f, (float)InAppNotificationActivity.this.getScaledPixels(50), 0.0f, 0.0f) : new TranslateAnimation(0.0f, (float)(-InAppNotificationActivity.this.getScaledPixels(50)), 0.0f, 0.0f);
            animSet.addAnimation((Animation)anim);
            animSet.addAnimation((Animation)new AlphaAnimation(1.0f, 0.0f));
            animSet.setDuration(300L);
            animSet.setFillAfter(true);
            animSet.setFillEnabled(true);
            animSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    InAppNotificationActivity.this.finish();
                    InAppNotificationActivity.this.updateListener(null, "onAnimationEnd");
                    if (InAppNotificationActivity.this.isDarkenEnabled()) {
                        InAppNotificationActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                    }
                    CleverTapAPI.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            InAppManager.showNotificationIfAvailable(InAppNotificationActivity.this.getApplicationContext());
                        }
                    }, 1000L);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            InAppNotificationActivity.this.webView.startAnimation((Animation)animSet);
            if (InAppNotificationActivity.this.closeImageView != null) {
                InAppNotificationActivity.this.closeImageView.startAnimation((Animation)animSet);
            }
            return true;
        }
    }

    private class InAppWebView
    extends WebView {
        public InAppWebView(Context context) {
            super(context);
            this.setHorizontalScrollBarEnabled(false);
            this.setVerticalScrollBarEnabled(false);
            this.setHorizontalFadingEdgeEnabled(false);
            this.setVerticalFadingEdgeEnabled(false);
            if (Build.VERSION.SDK_INT >= 9) {
                this.setOverScrollMode(2);
            }
            this.setBackgroundColor(0);
            this.setOnTouchListener(InAppNotificationActivity.this);
            this.setOnLongClickListener(InAppNotificationActivity.this);
            this.setId(188293);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            InAppNotificationActivity.this.updateDimension();
            this.setMeasuredDimension(((InAppNotificationActivity)InAppNotificationActivity.this).dim.x, ((InAppNotificationActivity)InAppNotificationActivity.this).dim.y);
        }
    }

    private class InAppWebViewClient
    extends WebViewClient {
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            try {
                String[] parts;
                String c2a;
                Bundle formData = UriHelper.getAllKeyValuePairs(url, false);
                if (formData != null && formData.containsKey("wzrk_c2a") && (c2a = formData.getString("wzrk_c2a")) != null && (parts = c2a.split("__dl__")).length == 2) {
                    formData.putString("wzrk_c2a", URLDecoder.decode(parts[0], "UTF-8"));
                    url = parts[1];
                }
                ((InAppNotificationActivity)InAppNotificationActivity.this).wr.event.pushInAppNotificationStateEvent(true, InAppNotificationActivity.this.notif, formData);
                InAppNotificationActivity.this.updateListener(formData, "notification clicked");
                Logger.log("Executing call to action for in-app: " + url);
                InAppNotificationActivity.this.fireUrlThroughIntent(url);
            }
            catch (Throwable t) {
                Logger.error("Error parsing the in-app notification action!", t);
            }
            return true;
        }
    }
}

