/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.clevertap.android.sdk.exceptions.InvalidEventNameException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class EventHandler {
    private final Context context;

    EventHandler(Context context) {
        this.context = context;
    }

    private static void queueEvent(Context context, JSONObject event, int eventType) {
        QueueManager.queueEvent(context, event, eventType);
    }

    private JSONObject getErrorObject(ValidationResult vr) {
        JSONObject error = new JSONObject();
        try {
            error.put("c", vr.getErrorCode());
            error.put("d", (Object)vr.getErrorDesc());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    private void pushValidationResult(ValidationResult vr) {
        CleverTapAPI.pushValidationResult(vr);
    }

    public void push(String eventName) {
        if (eventName == null || eventName.trim().equals("")) {
            return;
        }
        this.push(eventName, null);
    }

    public void push(String eventName, Map<String, Object> eventActions) {
        if (eventName == null || eventName.equals("")) {
            return;
        }
        if (Validator.isRestrictedEventName(eventName)) {
            return;
        }
        if (eventActions == null) {
            eventActions = new HashMap<String, Object>();
        }
        JSONObject event = new JSONObject();
        try {
            ValidationResult vr = Validator.cleanEventName(eventName);
            if (vr.getErrorCode() != 0) {
                event.put("wzrk_error", (Object)this.getErrorObject(vr));
            }
            eventName = vr.getObject().toString();
            JSONObject actions = new JSONObject();
            for (String key : eventActions.keySet()) {
                Object value = eventActions.get(key);
                vr = Validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                try {
                    vr = Validator.cleanObjectValue(value, false, false);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(512);
                    String err = "For event \"" + eventName + "\": Property value for property " + key + " wasn't a primitive (" + value + ")";
                    error.setErrorDesc(err);
                    Logger.error(err);
                    this.pushValidationResult(error);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                actions.put(key, value);
            }
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)actions);
            EventHandler.queueEvent(this.context, event, 4);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void push(String eventName, HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) throws InvalidEventNameException {
        if (eventName == null || eventName.equals("") || chargeDetails == null || items == null) {
            return;
        }
        if (Validator.isRestrictedEventName(eventName)) {
            return;
        }
        if (items.size() > 15) {
            ValidationResult error = new ValidationResult();
            error.setErrorCode(522);
            error.setErrorDesc("Charged event contained more than 15 items.");
            Logger.error("Charged event contained more than 15 items.");
            this.pushValidationResult(error);
        }
        JSONObject evtData = new JSONObject();
        JSONObject chargedEvent = new JSONObject();
        try {
            ValidationResult vr;
            if (!eventName.equals("Charged")) {
                throw new InvalidEventNameException("Not a charged event");
            }
            for (String key : chargeDetails.keySet()) {
                Object value = chargeDetails.get(key);
                vr = Validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                try {
                    vr = Validator.cleanObjectValue(value, false, false);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(511);
                    String err = "For event \"" + eventName + "\": Property value for property " + key + " wasn't a primitive (" + value + ")";
                    error.setErrorDesc(err);
                    this.pushValidationResult(error);
                    Logger.error(err);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                evtData.put(key, value);
            }
            JSONArray jsonItemsArray = new JSONArray();
            for (HashMap<String, Object> map : items) {
                JSONObject itemDetails = new JSONObject();
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    vr = Validator.cleanObjectKey(key);
                    key = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                    }
                    try {
                        vr = Validator.cleanObjectValue(value, false, false);
                    }
                    catch (IllegalArgumentException e) {
                        ValidationResult error = new ValidationResult();
                        error.setErrorCode(511);
                        String err = "An item's object value for key " + key + " wasn't a primitive (" + value + ")";
                        error.setErrorDesc(err);
                        Logger.error(err);
                        this.pushValidationResult(error);
                        continue;
                    }
                    value = vr.getObject();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                    }
                    itemDetails.put(key, value);
                }
                jsonItemsArray.put((Object)itemDetails);
            }
            evtData.put("Items", (Object)jsonItemsArray);
            chargedEvent.put("evtName", (Object)"Charged");
            chargedEvent.put("evtData", (Object)evtData);
            EventHandler.queueEvent(this.context, chargedEvent, 4);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void pushNotificationEvent(final Bundle extras) {
        if (extras != null && !extras.isEmpty() && extras.get("wzrk_pn") != null) {
            if (extras.containsKey("wzrk_inapp")) {
                CleverTapAPI.pendingInappRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Logger.logFine("Received in-app via push payload: " + extras.getString("wzrk_inapp"));
                            InAppFCManager.destroySession();
                            JSONObject r = new JSONObject();
                            JSONArray inappNotifs = new JSONArray();
                            r.put("inapp_notifs", (Object)inappNotifs);
                            inappNotifs.put((Object)new JSONObject(extras.getString("wzrk_inapp")));
                            InAppManager.processResponseAsync(r, EventHandler.this.context);
                        }
                        catch (Throwable t) {
                            Logger.error("Failed to display inapp notification from push notification payload", t);
                        }
                    }
                };
                return;
            }
            JSONObject event = new JSONObject();
            JSONObject notif = new JSONObject();
            try {
                for (String x : extras.keySet()) {
                    if (!x.startsWith("wzrk_")) continue;
                    Object value = extras.get(x);
                    notif.put(x, value);
                }
                long rts = extras.getLong("wzrk_rts", -1L);
                if (rts != -1L) {
                    long delta = System.currentTimeMillis() - rts;
                    notif.put("wzrk_dts", delta);
                }
                event.put("evtName", (Object)"Notification Clicked");
                event.put("evtData", (Object)notif);
                EventHandler.queueEvent(this.context, event, 4);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private static JSONObject getWzrkFields(Bundle root) throws JSONException {
        JSONObject fields = new JSONObject();
        for (String s : root.keySet()) {
            Object o = root.get(s);
            if (o instanceof Bundle) {
                JSONObject wzrkFields = EventHandler.getWzrkFields((Bundle)o);
                Iterator keys = wzrkFields.keys();
                while (keys.hasNext()) {
                    String k = (String)keys.next();
                    fields.put(k, wzrkFields.get(k));
                }
                continue;
            }
            if (!s.startsWith("wzrk_")) continue;
            fields.put(s, root.get(s));
        }
        return fields;
    }

    void pushInAppNotificationStateEvent(boolean clicked, Bundle data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = EventHandler.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            EventHandler.queueEvent(this.context, event, 4);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    void pushDeviceDetails() {
        this.pushDeviceDetailsWithExtras(null);
    }

    void pushDeviceDetailsWithExtras(JSONObject extras) {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        double rWidth = (float)dm.widthPixels / dm.xdpi;
        double rHeight = (float)dm.heightPixels / dm.ydpi;
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("OS", (Object)"Android");
            jsonObject.put("wdt", this.toTwoPlaces(rWidth));
            jsonObject.put("hgt", this.toTwoPlaces(rHeight));
            String cc = this.getCountryCode();
            if (cc != null && !cc.equals("")) {
                jsonObject.put("cc", (Object)cc);
            }
            if (extras != null && extras.length() > 0) {
                Iterator keys = extras.keys();
                while (keys.hasNext()) {
                    try {
                        String key = (String)keys.next();
                        jsonObject.put(key, (Object)extras.getString(key));
                    }
                    catch (ClassCastException ignore) {}
                }
            }
            EventHandler.queueEvent(this.context, jsonObject, 1);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private double toTwoPlaces(double n) {
        double result = n * 100.0;
        result = Math.round(result);
        return result /= 100.0;
    }

    private String getCountryCode() {
        try {
            TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
            return tm.getSimCountryIso();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    public EventDetail getDetails(String event) {
        return LocalDataStore.getEventDetail(this.context, event);
    }

    public Map<String, EventDetail> getHistory() {
        return LocalDataStore.getEventHistory(this.context);
    }

    public int getFirstTime(String event) {
        EventDetail eventDetail = LocalDataStore.getEventDetail(this.context, event);
        if (eventDetail != null) {
            return eventDetail.getFirstTime();
        }
        return -1;
    }

    public int getLastTime(String event) {
        EventDetail eventDetail = LocalDataStore.getEventDetail(this.context, event);
        if (eventDetail != null) {
            return eventDetail.getLastTime();
        }
        return -1;
    }

    public int getCount(String event) {
        EventDetail eventDetail = LocalDataStore.getEventDetail(this.context, event);
        if (eventDetail != null) {
            return eventDetail.getCount();
        }
        return -1;
    }

    public void pushError(String errorMessage, int errorCode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Error Message", errorMessage);
        props.put("Error Code", errorCode);
        try {
            String activityName = CleverTapAPI.getCurrentActivityName();
            if (activityName != null) {
                props.put("Location", activityName);
            } else {
                props.put("Location", "Unknown");
            }
        }
        catch (Throwable t) {
            props.put("Location", "Unknown");
        }
        this.push("Error Occurred", props);
    }
}

