/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.clevertap.android.sdk.Logger;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class DBAdapter {
    public static final String KEY_DATA = "data";
    public static final String KEY_CREATED_AT = "created_at";
    public static final int DB_UPDATE_ERROR = -1;
    public static final int DB_OUT_OF_MEMORY_ERROR = -2;
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String DATABASE_NAME = "clevertap";
    private static final int DATABASE_VERSION = 1;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_PROFILE_EVENTS_TABLE = "CREATE TABLE " + Table.PROFILE_EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_USER_PROFILES_TABLE = "CREATE TABLE " + Table.USER_PROFILES.getName() + " (_id STRING UNIQUE PRIMARY KEY, " + "data" + " STRING NOT NULL);";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + "created_at" + ");";
    private static final String PROFILE_EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PROFILE_EVENTS.getName() + " (" + "created_at" + ");";
    private final DatabaseHelper dbHelper;

    public DBAdapter(Context context) {
        this(context, DATABASE_NAME);
    }

    public DBAdapter(Context context, String dbName) {
        this.dbHelper = new DatabaseHelper(context, dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int storeObject(JSONObject obj, Table table) {
        if (!this.belowMemThreshold()) {
            Logger.logFine("There is not enough space left on the device to store data, data discarded");
            return -2;
        }
        String tableName = table.getName();
        Cursor cursor = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, obj.toString());
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(tableName, null, cv);
            cursor = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
            cursor.moveToFirst();
            count = cursor.getInt(0);
        }
        catch (SQLiteException e) {
            Logger.logFine("Error adding data to table " + tableName + " Recreating DB");
            if (cursor != null) {
                cursor.close();
                cursor = null;
            }
            this.dbHelper.deleteDatabase();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long storeUserProfile(String id, JSONObject obj) {
        if (id == null) {
            return -1L;
        }
        if (!this.belowMemThreshold()) {
            Logger.logFine("There is not enough space left on the device to store data, data discarded");
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getName();
        long ret = -1L;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, obj.toString());
            cv.put("_id", id);
            ret = db.insertWithOnConflict(tableName, null, cv, 5);
        }
        catch (SQLiteException e) {
            Logger.logFine("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserProfile(String id) {
        if (id == null) {
            return;
        }
        String tableName = Table.USER_PROFILES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tableName, "_id = ?", new String[]{id});
        }
        catch (SQLiteException e) {
            Logger.logFine("Error removing user profile from " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject fetchUserProfileById(String id) {
        if (id == null) {
            return null;
        }
        String tName = Table.USER_PROFILES.getName();
        JSONObject profile = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " WHERE _id = ?", new String[]{id});
            if (cursor != null && cursor.moveToFirst()) {
                try {
                    profile = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
        }
        catch (SQLiteException e) {
            Logger.logFine("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvents(Table table) {
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, null, null);
        }
        catch (SQLiteException e) {
            Logger.logFine("Error removing all events from table " + tName + " Recreating DB");
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEventsFromLastId(String lastId, Table table) {
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "_id <= " + lastId, null);
        }
        catch (SQLiteException e) {
            Logger.logFine("Error removing sent data from table " + tName + " Recreating DB");
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStaleEvents(Table table) {
        long DATA_EXPIRATION = 432000000L;
        long time = System.currentTimeMillis() - DATA_EXPIRATION;
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            Logger.logFine("Error removing stale event records from " + tName + ". Recreating DB.", e);
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public void deleteDB() {
        this.dbHelper.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject fetchEvents(Table table, int limit) {
        String tName = table.getName();
        Cursor cursor = null;
        String lastId = null;
        JSONArray events = new JSONArray();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " ORDER BY " + KEY_CREATED_AT + " ASC LIMIT " + limit, null);
            while (cursor.moveToNext()) {
                if (cursor.isLast()) {
                    lastId = cursor.getString(cursor.getColumnIndex("_id"));
                }
                try {
                    JSONObject j = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    events.put((Object)j);
                }
                catch (JSONException e) {}
            }
        }
        catch (SQLiteException e) {
            Logger.logFine("Could not fetch records out of database " + tName + ".", e);
            lastId = null;
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        if (lastId != null) {
            try {
                JSONObject ret = new JSONObject();
                ret.put(lastId, (Object)events);
                return ret;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean belowMemThreshold() {
        return this.dbHelper.belowMemThreshold();
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private final File databaseFile;
        private final int DB_LIMIT = 0x1400000;

        DatabaseHelper(Context context, String dbName) {
            super(context, dbName, null, 1);
            this.databaseFile = context.getDatabasePath(dbName);
        }

        public void deleteDatabase() {
            this.close();
            this.databaseFile.delete();
        }

        public void onCreate(SQLiteDatabase db) {
            Logger.logFine("Creating CleverTap DB");
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PROFILE_EVENTS_TABLE);
            db.execSQL(CREATE_USER_PROFILES_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PROFILE_EVENTS_TIME_INDEX);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Logger.logFine("Recreating CleverTap DB on upgrade");
            db.execSQL("DROP TABLE IF EXISTS " + Table.EVENTS.getName());
            db.execSQL("DROP TABLE IF EXISTS " + Table.PROFILE_EVENTS.getName());
            db.execSQL("DROP TABLE IF EXISTS " + Table.USER_PROFILES.getName());
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PROFILE_EVENTS_TABLE);
            db.execSQL(CREATE_USER_PROFILES_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PROFILE_EVENTS_TIME_INDEX);
        }

        public boolean belowMemThreshold() {
            if (this.databaseFile.exists()) {
                return Math.max(this.databaseFile.getUsableSpace(), 0x1400000L) >= this.databaseFile.length();
            }
            return true;
        }
    }

    public static enum Table {
        EVENTS("events"),
        PROFILE_EVENTS("profileEvents"),
        USER_PROFILES("userProfiles");

        private final String tableName;

        private Table(String name) {
            this.tableName = name;
        }

        public String getName() {
            return this.tableName;
        }
    }
}

