/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CommsManager;
import com.clevertap.android.sdk.DBAdapter;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class QueueManager {
    private static final Boolean lock = true;
    private static Runnable commsRunnable = null;
    private static DBAdapter dbAdapter;

    QueueManager() {
    }

    private static DBAdapter loadDBAdapter(Context context) {
        if (dbAdapter == null) {
            dbAdapter = new DBAdapter(context);
            dbAdapter.cleanupStaleEvents(DBAdapter.Table.EVENTS);
            dbAdapter.cleanupStaleEvents(DBAdapter.Table.PROFILE_EVENTS);
        }
        return dbAdapter;
    }

    static QueueCursor getQueuedEvents(Context context, int batchSize, QueueCursor previousCursor) {
        return QueueManager.getQueuedDBEvents(context, batchSize, previousCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueueCursor getQueuedDBEvents(Context context, int batchSize, QueueCursor previousCursor) {
        Boolean bl = lock;
        synchronized (bl) {
            DBAdapter.Table tableName;
            DBAdapter adapter = QueueManager.loadDBAdapter(context);
            DBAdapter.Table table = tableName = previousCursor != null ? previousCursor.tableName : DBAdapter.Table.EVENTS;
            if (previousCursor != null) {
                adapter.cleanupEventsFromLastId(previousCursor.lastId, previousCursor.tableName);
            }
            QueueCursor newCursor = new QueueCursor();
            newCursor.tableName = tableName;
            JSONObject queuedDBEvents = adapter.fetchEvents(tableName, batchSize);
            newCursor = QueueManager.updateCursorForDBObject(queuedDBEvents, newCursor);
            if (newCursor.isEmpty().booleanValue() && tableName.equals((Object)DBAdapter.Table.EVENTS)) {
                tableName = DBAdapter.Table.PROFILE_EVENTS;
                newCursor.resetForTableName(tableName);
                queuedDBEvents = adapter.fetchEvents(tableName, batchSize);
                newCursor = QueueManager.updateCursorForDBObject(queuedDBEvents, newCursor);
            }
            return newCursor.isEmpty() != false ? null : newCursor;
        }
    }

    private static QueueCursor updateCursorForDBObject(JSONObject dbObject, QueueCursor cursor) {
        if (dbObject == null) {
            return cursor;
        }
        Iterator keys = dbObject.keys();
        if (keys.hasNext()) {
            String key = (String)keys.next();
            cursor.lastId = key;
            try {
                cursor.data = dbObject.getJSONArray(key);
            }
            catch (JSONException e) {
                cursor.lastId = null;
                cursor.data = null;
            }
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void addToQueue(Context context, JSONObject event, int eventType) {
        Boolean bl = lock;
        synchronized (bl) {
            try {
                String type;
                String token;
                String accountId;
                String evtName;
                int session = SessionManager.getCurrentSession();
                if (session == 0) {
                    session = SessionManager.createSession(context);
                }
                if (CleverTapAPI.isAppForeground() && eventType == 4 && !SessionManager.isAppLaunchedBeenPushed() && !(evtName = event.getString("evtName")).equals("Notification Clicked")) {
                    CleverTapAPI wr = CleverTapAPI.getInstance(context);
                    wr.pushAppLaunchedEvent("Queue Manager - addToQueue");
                }
                try {
                    accountId = ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
                    token = ManifestMetaData.getMetaData(context, "CLEVERTAP_TOKEN");
                }
                catch (CleverTapMetaDataNotFoundException e) {
                    Logger.logFine("Account ID/token not found, will not add to queue");
                    return;
                }
                int activityCount = CleverTapAPI.activityCount;
                int n = activityCount = activityCount == 0 ? 1 : activityCount;
                if (eventType == 1) {
                    type = "page";
                } else if (eventType == 2) {
                    type = "ping";
                    QueueManager.attachMeta(event, context);
                } else {
                    type = eventType == 3 ? "profile" : (eventType == 5 ? "data" : "event");
                }
                event.put("id", (Object)accountId);
                String currentActivityName = CleverTapAPI.getInstance(context).getCurrentActivityName();
                if (currentActivityName != null) {
                    event.put("n", (Object)currentActivityName);
                }
                event.put("s", session);
                event.put("pg", activityCount);
                event.put("tk", (Object)token);
                event.put("type", (Object)type);
                event.put("ep", System.currentTimeMillis() / 1000L);
                event.put("f", SessionManager.isFirstSession());
                event.put("lsl", SessionManager.getLastSessionLength());
                QueueManager.attachLastSessionActivityTrailAndPackageNameIfRequired(context, event);
                ValidationResult vr = CleverTapAPI.popValidationResult();
                if (vr != null) {
                    event.put("wzrk_error", (Object)QueueManager.getErrorObject(vr));
                }
                LocalDataStore.setDataSyncFlag(context, event);
                QueueManager.queueEventToDBAsync(context, event, eventType);
                QueueManager.updateLocalStoreAsync(context, event, eventType);
                QueueManager.setupSend(context);
            }
            catch (Throwable e) {
                Logger.error("FATAL: Queuing events failed!", e);
            }
        }
    }

    private static void queueEventToDBAsync(final Context context, final JSONObject event, final int type) {
        CleverTapAPI.postAsyncSafely("QueueManager#queueEventToDBAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Boolean bl = lock;
                synchronized (bl) {
                    DBAdapter adapter = QueueManager.loadDBAdapter(context);
                    DBAdapter.Table table = type == 3 ? DBAdapter.Table.PROFILE_EVENTS : DBAdapter.Table.EVENTS;
                    int returnCode = adapter.storeObject(event, table);
                    if (returnCode > 0) {
                        Logger.logFine("Queued event to DB table " + (Object)((Object)table) + ": " + event.toString());
                    }
                }
            }
        });
    }

    private static void updateLocalStoreAsync(final Context context, final JSONObject event, final int type) {
        if (type == 4) {
            CleverTapAPI.postAsyncSafely("QueueManager#updateLocalStoreAsync", new Runnable(){

                @Override
                public void run() {
                    LocalDataStore.persistEvent(context, event, type);
                }
            });
        }
    }

    private static void setupSend(final Context context) {
        if (commsRunnable == null) {
            commsRunnable = new Runnable(){

                @Override
                public void run() {
                    new CommsManager().drainQueueAsync(context);
                }
            };
        }
        CleverTapAPI.getHandlerUsingMainLooper().removeCallbacks(commsRunnable);
        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(commsRunnable, 1000L);
        Logger.logFine("Posted delayed runnable to send queue");
    }

    private static JSONObject getErrorObject(ValidationResult vr) {
        JSONObject error = new JSONObject();
        try {
            error.put("c", vr.getErrorCode());
            error.put("d", (Object)vr.getErrorDesc());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    private static void attachMeta(JSONObject o, Context context) {
        try {
            o.put("mc", Utils.getMemoryConsumption());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            o.put("nt", (Object)Utils.getCurrentNetworkType(context));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void attachLastSessionActivityTrailAndPackageNameIfRequired(Context context, JSONObject event) {
        try {
            String type = event.getString("type");
            if ("event".equals(type) && "App Launched".equals(event.getString("evtName"))) {
                JSONArray lastSessionActivityTrail = SessionManager.getLastSessionActivityTrail();
                event.put("lsat", (Object)lastSessionActivityTrail);
                event.put("pai", (Object)context.getPackageName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static final class QueueCursor {
        private JSONArray data;
        private String lastId;
        private DBAdapter.Table tableName;

        QueueCursor() {
        }

        JSONArray getData() {
            return this.data;
        }

        Boolean isEmpty() {
            return this.lastId == null || this.data == null || this.data.length() <= 0;
        }

        private void resetForTableName(DBAdapter.Table tName) {
            this.tableName = tName;
            this.data = null;
            this.lastId = null;
        }

        public String toString() {
            return this.isEmpty() != false ? "tableName: " + (Object)((Object)this.tableName) + " | numItems: 0" : "tableName: " + (Object)((Object)this.tableName) + " | lastId: " + this.lastId + " | numItems: " + this.data.length() + " | items: " + this.data.toString();
        }
    }
}

