/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ProfileHandler;
import com.clevertap.android.sdk.ValidationResult;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;

final class Validator {
    private static final String[] eventNameCharsNotAllowed = new String[]{".", ":", "$", "'", "\"", "\\"};
    private static final String[] objectKeyCharsNotAllowed = new String[]{".", ":", "$", "'", "\"", "\\"};
    private static final String[] objectValueCharsNotAllowed = new String[]{"'", "\"", "\\"};
    private static final String[] restrictedNames = new String[]{"Stayed", "Notification Clicked", "Notification Viewed", "UTM Visited", "Notification Sent", "App Launched", "wzrk_d", "App Uninstalled", "Notification Bounced"};
    public static final String ADD_VALUES_OPERATION = "multiValuePropertyAddValues";
    public static final String REMOVE_VALUES_OPERATION = "multiValuePropertyRemoveValues";

    Validator() {
    }

    private static int getMaxNumberMultiValuePropertyValues() {
        return 100;
    }

    private static int getMaxMultiValuePropertyValueByteLength() {
        return 40;
    }

    static ValidationResult cleanEventName(String name) {
        ValidationResult vr = new ValidationResult();
        name = name.trim();
        for (String x : eventNameCharsNotAllowed) {
            name = name.replace(x, "");
        }
        if (name.length() > 32) {
            name = name.substring(0, 31);
            vr.setErrorDesc(name.trim() + "... exceeds the limit of 32 characters. Trimmed");
            vr.setErrorCode(510);
        }
        vr.setObject(name.trim());
        return vr;
    }

    static ValidationResult cleanObjectKey(String name) {
        ValidationResult vr = new ValidationResult();
        name = name.trim();
        for (String x : objectKeyCharsNotAllowed) {
            name = name.replace(x, "");
        }
        if (name.length() > 32) {
            name = name.substring(0, 31);
            vr.setErrorDesc(name.trim() + "... exceeds the limit of 32 characters. Trimmed");
            vr.setErrorCode(520);
        }
        vr.setObject(name.trim());
        return vr;
    }

    static ValidationResult cleanMultiValuePropertyKey(String name) {
        ValidationResult vr = Validator.cleanObjectKey(name);
        name = (String)vr.getObject();
        try {
            ProfileHandler.KnownFields kf = ProfileHandler.KnownFields.valueOf(name);
            if (kf != null) {
                vr.setErrorDesc(name + "... is a restricted key for multi-value properties. Operation aborted.");
                vr.setErrorCode(523);
                vr.setObject(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return vr;
    }

    static ValidationResult cleanMultiValuePropertyValue(String value) {
        ValidationResult vr = new ValidationResult();
        value = value.trim().toLowerCase();
        for (String x : objectValueCharsNotAllowed) {
            value = value.replace(x, "");
        }
        int maxLen = Validator.getMaxMultiValuePropertyValueByteLength();
        try {
            if (value.getBytes("UTF-8").length > maxLen) {
                value = Validator.fastTrim(value, maxLen);
                vr.setErrorDesc(value + "... exceeds the limit of " + maxLen + " bytes. Trimmed");
                vr.setErrorCode(521);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        vr.setObject(value);
        return vr;
    }

    static ValidationResult mergeMultiValuePropertyForKey(JSONArray currentValues, JSONArray newValues, String action, String key) {
        ValidationResult vr = new ValidationResult();
        Boolean remove = REMOVE_VALUES_OPERATION.equals(action);
        vr = Validator._mergeListInternalForKey(key, currentValues, newValues, remove, vr);
        return vr;
    }

    static ValidationResult cleanObjectValue(Object o, boolean useOldDate, boolean autoConvert) throws IllegalArgumentException {
        ValidationResult vr = new ValidationResult();
        if (o instanceof Integer || o instanceof Float || o instanceof Boolean || o instanceof Double) {
            if (o instanceof Double) {
                vr.setObject(Float.valueOf(((Double)o).floatValue()));
            } else {
                vr.setObject(o);
            }
            return vr;
        }
        if (o instanceof Long) {
            if (!autoConvert) {
                vr.setObject(o.toString());
            } else {
                vr.setObject(o);
            }
            return vr;
        }
        if (o instanceof String || o instanceof Character) {
            String value = o instanceof Character ? String.valueOf(o) : (String)o;
            value = value.trim();
            if (autoConvert) {
                try {
                    Long i = Long.parseLong(value);
                    if (i.toString().equals(value)) {
                        vr.setObject(i);
                        return vr;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                try {
                    Double d = Double.parseDouble(value);
                    vr.setObject(Float.valueOf(d.floatValue()));
                    return vr;
                }
                catch (NumberFormatException e) {
                    try {
                        if (value.equalsIgnoreCase("true")) {
                            vr.setObject(true);
                        } else if (value.equalsIgnoreCase("false")) {
                            vr.setObject(false);
                        } else {
                            throw new Exception();
                        }
                        return vr;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            for (String x : objectValueCharsNotAllowed) {
                value = value.replace(x, "");
            }
            try {
                if (value.getBytes("UTF-8").length > 120) {
                    value = Validator.fastTrim(value, 120);
                    vr.setErrorDesc(value.trim() + "... exceeds the limit of 120 bytes. Trimmed");
                    vr.setErrorCode(521);
                }
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
            vr.setObject(value.trim());
            return vr;
        }
        if (o instanceof Date) {
            String date = useOldDate ? "$D_" + Constants.DOB_DATE_FORMAT.format((Date)o) : "$D_" + ((Date)o).getTime() / 1000L;
            vr.setObject(date);
            return vr;
        }
        throw new IllegalArgumentException("Not a String, Boolean, Long, Integer, Float, Double, or Date");
    }

    static void validatePhone(String value) {
        try {
            if (value.length() >= 8) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Logger.error("Invalid phone number specified - " + value);
        throw new IllegalArgumentException("Invalid phone number");
    }

    static boolean isRestrictedEventName(String name) {
        if (name == null) {
            return false;
        }
        for (String x : restrictedNames) {
            if (!name.equalsIgnoreCase(x)) continue;
            ValidationResult error = new ValidationResult();
            error.setErrorCode(513);
            error.setErrorDesc(name + " is a restricted event name. Last event aborted.");
            CleverTapAPI.pushValidationResult(error);
            Logger.error(name + " is a restricted system event name. Last event aborted.");
            return true;
        }
        return false;
    }

    static String fastTrim(String input, int byteLen) {
        try {
            byte[] data = input.getBytes("UTF-8");
            if (data.length <= byteLen) {
                return input;
            }
            int total = 0;
            for (int i = 0; i < data.length; ++i) {
                int charc = 0;
                if (data[i] >= 0) {
                    charc = 1;
                } else {
                    int mask = data[i] & 0xFF;
                    if (mask >> 4 == 15) {
                        charc = 4;
                    } else if (mask >> 5 == 7) {
                        charc = 3;
                    } else if (mask >> 6 == 3) {
                        charc = 2;
                    }
                }
                if (total + charc > byteLen) break;
                total += charc;
            }
            if (total == data.length) {
                return input;
            }
            byte[] out = new byte[total];
            System.arraycopy(data, 0, out, 0, out.length);
            return new String(out, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    private static ValidationResult _mergeListInternalForKey(String key, JSONArray left, JSONArray right, boolean remove, ValidationResult vr) {
        int i;
        if (left == null) {
            vr.setObject(null);
            return vr;
        }
        if (right == null) {
            vr.setObject(left);
            return vr;
        }
        int maxValNum = Validator.getMaxNumberMultiValuePropertyValues();
        JSONArray mergedList = new JSONArray();
        HashSet<String> set = new HashSet<String>();
        int lsize = left.length();
        int rsize = right.length();
        BitSet dupSetForAdd = null;
        if (!remove) {
            dupSetForAdd = new BitSet(lsize + rsize);
        }
        int lidx = 0;
        int ridx = Validator.scan(right, set, dupSetForAdd, lsize);
        if (!remove && set.size() < maxValNum) {
            lidx = Validator.scan(left, set, dupSetForAdd, 0);
        }
        for (i = lidx; i < lsize; ++i) {
            try {
                if (remove) {
                    String _j = (String)left.get(i);
                    if (set.contains(_j)) continue;
                    mergedList.put((Object)_j);
                    continue;
                }
                if (dupSetForAdd.get(i)) continue;
                mergedList.put(left.get(i));
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!remove && mergedList.length() < maxValNum) {
            for (i = ridx; i < rsize; ++i) {
                try {
                    if (dupSetForAdd.get(i + lsize)) continue;
                    mergedList.put(right.get(i));
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (ridx > 0 || lidx > 0) {
            vr.setErrorDesc("Multi value property for key " + key + " exceeds the limit of " + maxValNum + " items. Trimmed");
            vr.setErrorCode(521);
        }
        vr.setObject(mergedList);
        return vr;
    }

    private static int scan(JSONArray list, Set<String> set, BitSet dupSetForAdd, int off) {
        if (list != null) {
            int maxValNum = Validator.getMaxNumberMultiValuePropertyValues();
            for (int i = list.length() - 1; i >= 0; --i) {
                try {
                    String n;
                    Object obj = list.get(i);
                    String string = n = obj != null ? obj.toString() : null;
                    if (dupSetForAdd == null) {
                        if (n != null) {
                            set.add(n);
                        }
                        continue;
                    }
                    if (n == null || set.contains(n)) {
                        dupSetForAdd.set(i + off, true);
                        continue;
                    }
                    set.add(n);
                    if (set.size() != maxValNum) continue;
                    return i;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return 0;
    }
}

