/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import android.content.Context;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Provides various methods to send arbitrary data to CleverTap.
 */
public final class DataHandler {

    private final Context context;

    DataHandler(Context context) {
        this.context = context;
    }

    /**
     * Sends the GCM registration ID to CleverTap.
     *
     * @param gcmId    The GCM registration ID
     * @param register Boolean indicating whether to register
     *                 or not for receiving push messages from CleverTap.
     *                 Set this to true to receive push messages from CleverTap,
     *                 and false to not receive any messages from CleverTap.
     */
    public void pushGcmRegistrationId(String gcmId, boolean register) {
        JSONObject event = new JSONObject();
        JSONObject gcmDetails = new JSONObject();
        try {
            gcmDetails.put("action", register ? "register" : "unregister");
            gcmDetails.put("id", gcmId);
            gcmDetails.put("type", "gcm");
            event.put("data", gcmDetails);
            QueueManager.addToQueue(context, event, Constants.DATA_EVENT);
            GcmManager.enableGcmPushNotifications(context, register);
        } catch (JSONException e) {
            // we won't get here
        }
    }
}
