/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.clevertap.android.sdk.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

final class Utils {
    private static int serviceCount = -1;
    private static int installedApps = -1;

    Utils() {
    }

    static long getMemoryConsumption() {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        return total - free;
    }

    static String getCurrentNetworkType(Context context) {
        try {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            if (mWifi.isConnected()) {
                return "WiFi";
            }
            TelephonyManager teleMan = (TelephonyManager)context.getSystemService("phone");
            int networkType = teleMan.getNetworkType();
            switch (networkType) {
                case 4: {
                    return "CDMA";
                }
                case 2: {
                    return "EDGE";
                }
                case 1: {
                    return "GPRS";
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "LTE";
                }
            }
            return "Unknown";
        }
        catch (Throwable t) {
            return "Unavailable";
        }
    }

    static int getServiceCount(Context context) {
        if (serviceCount == -1) {
            try {
                PackageManager pm = context.getPackageManager();
                ServiceInfo[] services = pm.getPackageInfo((String)context.getPackageName(), (int)4).services;
                serviceCount = services.length;
            }
            catch (Throwable t) {
                return 0;
            }
        }
        return serviceCount;
    }

    static int getInstalledAppsCount(Context context) {
        if (installedApps == -1) {
            PackageManager pm = context.getPackageManager();
            List packages = pm.getInstalledApplications(128);
            int count = 0;
            for (ApplicationInfo packageInfo : packages) {
                if (packageInfo.packageName.startsWith("com.google") || packageInfo.packageName.startsWith("com.android")) continue;
                ++count;
            }
            installedApps = count;
        }
        return installedApps;
    }

    static Bitmap getNotificationBitmap(String icoPath, boolean fallbackToAppIcon, Context context) throws NullPointerException, PackageManager.NameNotFoundException {
        Bitmap ic;
        if (icoPath == null || icoPath.equals("")) {
            return fallbackToAppIcon ? Utils.getAppIcon(context) : null;
        }
        if (!icoPath.startsWith("http")) {
            icoPath = "http://static.wizrocket.com/android/ico//" + icoPath;
        }
        return (ic = Utils.getBitmapFromURL(icoPath)) != null ? ic : (fallbackToAppIcon ? Utils.getAppIcon(context) : null);
    }

    static Bitmap getAppIcon(Context context) throws NullPointerException, PackageManager.NameNotFoundException {
        try {
            if (Build.VERSION.SDK_INT < 9) {
                throw new Exception("API level is < 9");
            }
            Drawable logo = context.getPackageManager().getApplicationLogo(context.getApplicationInfo());
            if (logo == null) {
                throw new Exception("Logo is null");
            }
            return Utils.drawableToBitmap(logo);
        }
        catch (Exception e) {
            return Utils.drawableToBitmap(context.getPackageManager().getApplicationIcon(context.getApplicationInfo()));
        }
    }

    static Bitmap drawableToBitmap(Drawable drawable) throws NullPointerException, PackageManager.NameNotFoundException {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bitmap getBitmapFromURL(String srcUrl) {
        srcUrl = srcUrl.replace("///", "/");
        srcUrl = srcUrl.replace("//", "/");
        srcUrl = srcUrl.replace("http:/", "http://");
        srcUrl = srcUrl.replace("https:/", "https://");
        HttpURLConnection connection = null;
        try {
            URL url = new URL(srcUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
            return bitmap;
        }
        catch (IOException e) {
            Logger.logFine("Couldn't download the notification icon. URL was: " + srcUrl);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable t) {
                Logger.error("Couldn't close connection!", t);
            }
        }
    }
}

