/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.telephony.TelephonyManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DataType;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.google.android.gms.plus.model.people.Person;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ProfileHandler {
    private final Context context;
    private static final String ENUM_PREFIX = "$E_";

    ProfileHandler(Context context) {
        this.context = context;
    }

    public void push(Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        try {
            JSONObject customProfile = new JSONObject();
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                ValidationResult vr = Validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    CleverTapAPI.pendingValidationResult = vr;
                }
                try {
                    vr = Validator.cleanObjectValue(value, true, true);
                }
                catch (Exception e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(512);
                    error.setErrorDesc("Object value wasn't a primitive. Last event aborted.");
                    CleverTapAPI.pendingValidationResult = error;
                    Logger.log("Object value isn't a primitive. Profile update aborted");
                    return;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    CleverTapAPI.pendingValidationResult = vr;
                }
                if (key.equalsIgnoreCase("Phone")) {
                    try {
                        Validator.validatePhone(value);
                        value = ((Number)value).longValue();
                    }
                    catch (Exception e) {
                        CleverTapAPI.pendingValidationResult = new ValidationResult(512, "Invalid phone number");
                        Logger.log("Invalid phone number");
                        continue;
                    }
                }
                if (key.equalsIgnoreCase("Age")) {
                    if (value instanceof Integer) {
                        int age = (Integer)value;
                        if (age <= 0 || age >= 120) {
                            Logger.log("Invalid age supplied");
                            CleverTapAPI.pendingValidationResult = new ValidationResult(512, "Invalid age");
                            continue;
                        }
                    } else {
                        Logger.log("Age looks to be of an unsupported data type");
                        CleverTapAPI.pendingValidationResult = new ValidationResult(512, "Invalid age (unknown data type)");
                        continue;
                    }
                }
                try {
                    KnownFields kf = KnownFields.valueOf(key);
                    if (kf == null) {
                        throw new Exception();
                    }
                    this.keepProperty(kf.storageValue, value);
                }
                catch (Throwable t) {
                    customProfile.put(key, value);
                }
            }
            Logger.logFine("Constructed custom profile: " + customProfile.toString());
            this.pushBasicProfile(customProfile);
        }
        catch (Throwable t) {
            Logger.error("Failed to push profile", t);
        }
    }

    private String getGraphUserPropertySafely(JSONObject graphUser, String key, String def) {
        try {
            String prop = (String)graphUser.get(key);
            if (prop != null) {
                return prop;
            }
            return def;
        }
        catch (Throwable t) {
            return def;
        }
    }

    public void pushFacebookUser(JSONObject graphUser) {
        try {
            String education;
            String work;
            if (graphUser == null) {
                return;
            }
            String name = this.getGraphUserPropertySafely(graphUser, "name", "");
            try {
                ValidationResult vr = Validator.cleanObjectValue(name, false, false);
                name = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    CleverTapAPI.pendingValidationResult = vr;
                }
            }
            catch (IllegalArgumentException e) {
                name = "";
            }
            String gender = this.getGraphUserPropertySafely(graphUser, "gender", null);
            gender = gender != null ? (gender.toLowerCase().startsWith("m") ? "M" : (gender.toLowerCase().startsWith("f") ? "F" : "")) : null;
            String email = this.getGraphUserPropertySafely(graphUser, "email", "");
            String birthday = this.getGraphUserPropertySafely(graphUser, "birthday", null);
            if (birthday != null) {
                if (birthday.matches("^../..")) {
                    birthday = "";
                } else {
                    try {
                        Date date = Constants.FB_DOB_DATE_FORMAT.parse(birthday);
                        birthday = "$D_" + Constants.DOB_DATE_FORMAT.format(date);
                    }
                    catch (ParseException e) {
                        birthday = "";
                    }
                }
            }
            try {
                JSONArray workArray = graphUser.getJSONArray("work");
                work = workArray.length() > 0 ? "Y" : "N";
            }
            catch (Throwable t) {
                work = "";
            }
            try {
                JSONArray eduArray = graphUser.getJSONArray("education");
                String fbEdu = eduArray.getJSONObject(eduArray.length() - 1).getString("type");
                education = fbEdu.toLowerCase().contains("high school") ? "School" : (fbEdu.toLowerCase().contains("college") ? "College" : (fbEdu.toLowerCase().contains("graduate school") ? "Graduate" : ""));
            }
            catch (Throwable t) {
                education = "";
            }
            String id = this.getGraphUserPropertySafely(graphUser, "id", "");
            String married = this.getGraphUserPropertySafely(graphUser, "relationship_status", null);
            if (married != null) {
                married = married.equalsIgnoreCase("married") ? "Y" : "N";
            }
            this.keepProperty("fbID", id);
            this.keepProperty("fbName", name);
            this.keepProperty("fbEmail", email);
            this.keepProperty("fbGender", gender);
            this.keepProperty("fbEducation", education);
            this.keepProperty("fbEmployed", work);
            this.keepProperty("fbDOB", birthday);
            this.keepProperty("fbRS", married);
            this.pushBasicProfile(null);
        }
        catch (Throwable t) {
            Logger.error("Failed to parse graph user object successfully", t);
        }
    }

    private void keepProperty(String key, Object value) {
        if (key == null || key.equals("") || value == null) {
            return;
        }
        if (value instanceof String) {
            StorageHelper.putString(this.context, key, (String)value);
        } else if (value instanceof Integer) {
            StorageHelper.putInt(this.context, key, (Integer)value);
        } else if (value instanceof Long) {
            StorageHelper.putLong(this.context, key, (Long)value);
        } else {
            Logger.log("Ignored value due to unsupported type: " + value.getClass().getName());
        }
    }

    void pushBasicProfile(JSONObject baseProfile) {
        try {
            JSONObject profileEvent = new JSONObject();
            if (baseProfile != null && baseProfile.length() > 0) {
                Iterator i = baseProfile.keys();
                while (i.hasNext()) {
                    String next = i.next().toString();
                    try {
                        profileEvent.put(next, baseProfile.get(next));
                    }
                    catch (JSONException e) {}
                }
            }
            try {
                String cc;
                String carrier;
                Account account = this.getGoogleAccount();
                if (account != null && account.name != null) {
                    try {
                        ValidationResult vr = Validator.cleanObjectValue(account.name, false, false);
                        this.keepProperty("systemEmail", vr.getObject().toString());
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if ((carrier = this.getCarrier()) != null && !carrier.equals("")) {
                    this.keepProperty("systemCarrier", carrier);
                }
                if ((cc = this.getCountryCode()) != null && !cc.equals("")) {
                    this.keepProperty("systemCountryCode", cc);
                }
                this.keepProperty("systemTimezone", TimeZone.getDefault().getID());
                this.addKeptProfileProperties(this.context, profileEvent);
                try {
                    JSONArray allAccounts = this.getAllAccounts();
                    if (allAccounts != null && allAccounts.length() > 0) {
                        profileEvent.put("Alternate Emails", (Object)allAccounts);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                JSONObject event = new JSONObject();
                event.put("profile", (Object)profileEvent);
                QueueManager.addToQueue(this.context, event, 3);
            }
            catch (JSONException e) {
                Logger.logFine("FATAL: Creating basic profile update event failed!");
            }
        }
        catch (Throwable t) {
            Logger.error("Basic profile sync", t);
        }
    }

    private void addPropertyFromStoreIfExists(Context context, String profileEventKey, JSONObject profile, DataType dataType, String ... preferenceKeys) {
        block13: for (String pk : preferenceKeys) {
            try {
                Object value;
                switch (dataType) {
                    case Integer: {
                        try {
                            value = StorageHelper.getInt(context, pk, Integer.MIN_VALUE);
                            if ((Integer)value != Integer.MIN_VALUE) break;
                        }
                        catch (ClassCastException c) {
                            value = StorageHelper.getLong(context, pk, Long.MIN_VALUE);
                            if ((Long)value != Long.MIN_VALUE) break;
                        }
                        continue block13;
                    }
                    case Long: {
                        try {
                            value = StorageHelper.getLong(context, pk, Long.MIN_VALUE);
                            if ((Long)value != Long.MIN_VALUE) break;
                        }
                        catch (ClassCastException c) {
                            value = StorageHelper.getInt(context, pk, Integer.MIN_VALUE);
                            if ((Integer)value != Integer.MIN_VALUE) break;
                        }
                        continue block13;
                    }
                    case String: {
                        value = StorageHelper.getString(context, pk, null);
                        if (value != null) break;
                        continue block13;
                    }
                    default: {
                        value = null;
                    }
                }
                if (value == null) continue;
                try {
                    profile.put(profileEventKey, value);
                    return;
                }
                catch (JSONException e) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addKeptProfileProperties(Context context, JSONObject profile) {
        this.addPropertyFromStoreIfExists(context, "Name", profile, DataType.String, "userName", "fbName", "gpName");
        this.addPropertyFromStoreIfExists(context, "Gender", profile, DataType.String, "userGender", "fbGender", "gpGender");
        this.addPropertyFromStoreIfExists(context, "Education", profile, DataType.String, "userEducation", "fbEducation");
        this.addPropertyFromStoreIfExists(context, "Employed", profile, DataType.String, "userEmployed", "fbEmployed", "gpEmployed");
        this.addPropertyFromStoreIfExists(context, "Married", profile, DataType.String, "userRS", "fbRS", "gpRS");
        this.addPropertyFromStoreIfExists(context, "DOB", profile, DataType.String, "userDOB", "fbDOB", "gpDOB");
        this.addPropertyFromStoreIfExists(context, "FBID", profile, DataType.String, "fbID");
        this.addPropertyFromStoreIfExists(context, "GPID", profile, DataType.String, "gpID");
        this.addPropertyFromStoreIfExists(context, "Phone", profile, DataType.Long, "userPhone");
        this.addPropertyFromStoreIfExists(context, "Age", profile, DataType.Integer, "userAge");
        this.addPropertyFromStoreIfExists(context, "Email", profile, DataType.String, "userEmail", "fbEmail", "systemEmail");
        this.addPropertyFromStoreIfExists(context, "tz", profile, DataType.String, "systemTimezone");
        this.addPropertyFromStoreIfExists(context, "Carrier", profile, DataType.String, "systemCarrier");
        this.addPropertyFromStoreIfExists(context, "cc", profile, DataType.String, "systemCountryCode");
        this.addSecondaryEmail(context, profile);
    }

    private void addSecondaryEmail(Context context, JSONObject profile) {
        try {
            String originalEmail = profile.getString("Email");
            if (originalEmail == null || originalEmail.equals("")) {
                this.addPropertyFromStoreIfExists(context, "Email", profile, DataType.String, "fbEmail");
            } else {
                String email2 = StorageHelper.getString(context, "fbEmail", "");
                if (email2 == null || email2.equals(originalEmail) || email2.equals("")) {
                    return;
                }
                profile.put("Email2", (Object)email2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Deprecated
    public void pushEnum(String key, String value) {
        JSONObject enumEvent = new JSONObject();
        try {
            ValidationResult vr = Validator.cleanObjectKey(key);
            key = vr.getObject().toString();
            if (key == null || key.equals("")) {
                return;
            }
            vr = Validator.cleanObjectValue(value, false, false);
            if ((value = vr.getObject().toString()) == null || value.equals("")) {
                return;
            }
            enumEvent.put(key, (Object)(ENUM_PREFIX + value));
            JSONObject event = new JSONObject();
            event.put("profile", (Object)enumEvent);
            QueueManager.addToQueue(this.context, event, 3);
        }
        catch (Throwable e) {
            Logger.logFine("FATAL: Creating enum for profile update event failed!");
        }
    }

    private String getCarrier() {
        try {
            TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
            String carrier = tm.getSimOperatorName();
            ValidationResult vr = Validator.cleanObjectValue(carrier, false, false);
            if (vr.getErrorCode() == 0) {
                return (String)vr.getObject();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private Account getGoogleAccount() {
        if (this.context == null) {
            return null;
        }
        try {
            String value = ManifestMetaData.getMetaData(this.context, "CLEVERTAP_PRIVACY_MODE");
            if (value.contains("DE")) {
                return null;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            AccountManager manager = AccountManager.get((Context)this.context);
            Account[] accounts = manager.getAccountsByType("com.google");
            if (accounts != null && accounts.length > 0) {
                return accounts[0];
            }
            return null;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private JSONArray getAllAccounts() {
        if (this.context == null) {
            return null;
        }
        try {
            String value = ManifestMetaData.getMetaData(this.context, "CLEVERTAP_PRIVACY_MODE");
            if (value.contains("DE")) {
                return null;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Account[] accounts;
            JSONArray all = new JSONArray();
            AccountManager am = AccountManager.get((Context)this.context);
            for (Account account : accounts = am.getAccounts()) {
                String name = account.name;
                if (name == null || !name.contains("@")) continue;
                all.put((Object)name);
            }
            return all;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String getCountryCode() {
        try {
            TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
            return tm.getSimCountryIso();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public void pushGooglePlusPerson(Person person) {
        if (person == null) {
            return;
        }
        try {
            block10: {
                name = "";
                if (!person.hasDisplayName()) break block10;
                try {
                    name = person.getDisplayName();
                    vr = Validator.cleanObjectValue(name, false, false);
                    name = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        CleverTapAPI.pendingValidationResult = vr;
                    }
                    ** break block11
                }
                finally {
                    gender = "";
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (Throwable t) {
            Logger.logFine("FATAL: Creating G+ profile update event failed!");
        }
    }

    public String getProperty(String name) {
        return LocalDataStore.getProfileProperty(this.context, name);
    }

    private static enum KnownFields {
        Name("userName"),
        Email("userEmail"),
        Education("userEducation"),
        Married("userRS"),
        DOB("userDOB"),
        Gender("userGender"),
        Phone("userPhone"),
        Age("userAge");

        private final String storageValue;

        private KnownFields(String storageValue) {
            this.storageValue = storageValue;
        }
    }
}

